/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vKernel.core.g0;

import jp.co.lattice.vKernel.core.c0.lvDouble;
import jp.co.lattice.vKernel.core.c0.lvEps;
import jp.co.lattice.vKernel.core.c0.lvGlobal;
import jp.co.lattice.vKernel.core.c0.lvRec;
import jp.co.lattice.vKernel.core.c0.lvRoot;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvType;
import jp.co.lattice.vKernel.core.c0.lvUVdt;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vKernel.core.g0.lvGeomGblElm;
import jp.co.lattice.vKernel.tex.a0.lvDivPolyUV;

public class lvDivPolyLow
extends lvRoot {
    private static final int maxNumFaceVtx = 256;

    private final Global Gbl() {
        return ((lvGeomGblElm)this.global.GGeom()).gDivPolyLow;
    }

    private final DownDivPoly DownDivPoly() {
        return this.Gbl().curDownDivPoly;
    }

    private final UpDivPoly UpDivPoly() {
        return this.Gbl().curUpDivPoly;
    }

    public lvDivPolyLow(lvGlobal lvGlobal2) {
        super(lvGlobal2);
    }

    public final void Exec(DownDivPoly downDivPoly, UpDivPoly upDivPoly) throws lvThrowable {
        this.Gbl().curDownDivPoly = downDivPoly;
        this.Gbl().curUpDivPoly = upDivPoly;
        this.NewProc(this.DownDivPoly().numVtxPos);
        this.Init();
        this.DivVtxToVtx();
        this.DivRadial();
        this.Finish();
    }

    private static final int GetNumVertex(int n) {
        if (n % 2 != 0) {
            return n + (n - 3) / 2;
        }
        return n + (n - 2) / 2;
    }

    private static final int GetNumTriIndex(int n) {
        if (n % 2 != 0) {
            return 2 * (n - 3) + 1;
        }
        return 2 * (n - 2);
    }

    private static final int GetNumFace(int n) {
        return n - 2;
    }

    private static final int GetNumFaceHalfSeq(int n) {
        return 3 * (n - 2);
    }

    private final void NewProc(int n) {
        this.NewUpVertex(n);
        this.NewUpTriIndex(n);
        this.NewUpVtxUV(n);
        this.NewTmp(n, this.Gbl().staticAll, this.Gbl().allDivPoly);
        this.NewTmp(n, this.Gbl().staticTmp, this.Gbl().tmpDivPoly);
        this.NewTmpOne(n, this.Gbl().staticSrc, this.Gbl().srcDivPoly);
        this.NewTmpOne(n, this.Gbl().staticDst0, this.Gbl().dstDivPoly0);
        this.NewTmpOne(n, this.Gbl().staticDst1, this.Gbl().dstDivPoly1);
    }

    private final void NewUpVertex(int n) {
        int n2 = lvDivPolyLow.GetNumVertex(n);
        int n3 = lvDivPolyLow.GetNumVertex(256);
        if (n > 256) {
            int n4;
            this.UpDivPoly().vertex = new lvRec.PosNorHi[n2];
            for (n4 = 0; n4 < n3; ++n4) {
                this.UpDivPoly().vertex[n4] = ((Global)this.Gbl()).staticUp.vertex[n4];
            }
            for (n4 = n3; n4 < n2; ++n4) {
                this.UpDivPoly().vertex[n4] = new lvRec.PosNorHi(this.global);
            }
        } else {
            this.UpDivPoly().vertex = ((Global)this.Gbl()).staticUp.vertex;
        }
    }

    private final void NewUpTriIndex(int n) {
        int n2 = lvDivPolyLow.GetNumTriIndex(n);
        int n3 = lvDivPolyLow.GetNumTriIndex(256);
        if (n > 256) {
            int n4;
            this.UpDivPoly().triIndex = new lvRec.TriIndex[n2];
            for (n4 = 0; n4 < n3; ++n4) {
                this.UpDivPoly().triIndex[n4] = ((Global)this.Gbl()).staticUp.triIndex[n4];
            }
            for (n4 = n3; n4 < n2; ++n4) {
                this.UpDivPoly().triIndex[n4] = new lvRec.TriIndex();
            }
        } else {
            this.UpDivPoly().triIndex = ((Global)this.Gbl()).staticUp.triIndex;
        }
    }

    private final void NewTmp(int n, TmpDivPoly tmpDivPoly, TmpDivPoly tmpDivPoly2) {
        this.NewTmpFace(n, tmpDivPoly, tmpDivPoly2);
        this.NewTmpFaceHalfSeq(n, tmpDivPoly, tmpDivPoly2);
    }

    private final void NewTmpFace(int n, TmpDivPoly tmpDivPoly, TmpDivPoly tmpDivPoly2) {
        int n2 = lvDivPolyLow.GetNumFace(n);
        int n3 = lvDivPolyLow.GetNumFace(256);
        if (n > 256) {
            int n4;
            TmpDivPoly.access$502(tmpDivPoly2, new TmpFace[n2]);
            for (n4 = 0; n4 < n3; ++n4) {
                ((TmpDivPoly)tmpDivPoly2).face[n4] = tmpDivPoly.face[n4];
            }
            for (n4 = n3; n4 < n2; ++n4) {
                ((TmpDivPoly)tmpDivPoly2).face[n4] = new TmpFace();
            }
        } else {
            TmpDivPoly.access$502(tmpDivPoly2, tmpDivPoly.face);
        }
    }

    private final void NewTmpFaceHalfSeq(int n, TmpDivPoly tmpDivPoly, TmpDivPoly tmpDivPoly2) {
        int n2 = lvDivPolyLow.GetNumFaceHalfSeq(n);
        if (n > 256) {
            TmpDivPoly.access$802(tmpDivPoly2, new int[n2]);
        } else {
            TmpDivPoly.access$802(tmpDivPoly2, tmpDivPoly.faceHalfSeq);
        }
    }

    private final void NewTmpOne(int n, TmpDivPolyOne tmpDivPolyOne, TmpDivPolyOne tmpDivPolyOne2) {
        if (n > 256) {
            TmpDivPolyOne.access$902(tmpDivPolyOne2, new int[n]);
        } else {
            TmpDivPolyOne.access$902(tmpDivPolyOne2, tmpDivPolyOne.faceHalfSeq);
        }
    }

    private final void Init() throws lvThrowable {
        this.Gbl().allDivPoly.numFace = 1;
        ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).allDivPoly).face[0]).info.start = 0;
        ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).allDivPoly).face[0]).info.num = this.DownDivPoly().numVtxPos;
        this.Gbl().allDivPoly.face[0].finish = false;
        for (int i = 0; i < this.DownDivPoly().numVtxPos; ++i) {
            ((TmpDivPoly)((Global)this.Gbl()).allDivPoly).faceHalfSeq[i] = i;
        }
        this.SetFaceNormal();
    }

    private final void SetFaceNormal() throws lvThrowable {
        this.Gbl().tmpDt.faceNormal.Normal(this.DownDivPoly().vtxPos, this.DownDivPoly().numVtxPos);
    }

    private final void DivVtxToVtx() throws lvThrowable {
        lvType.IntR intR = this.Gbl().tiDivVtxToVtx[0];
        while (!this.ChkAllFinish(intR)) {
            this.Gbl().tmpDt.curFaceNo = intR.val;
            this.SetSrcDivPoly();
            boolean bl = this.DivVtxToVtxMain();
            if (bl) {
                this.ConvAllDivPoly();
                continue;
            }
            this.Gbl().allDivPoly.face[this.Gbl().tmpDt.curFaceNo].finish = true;
        }
    }

    private final boolean ChkAllFinish(lvType.IntR intR) {
        boolean bl = true;
        for (int i = 0; i < this.Gbl().allDivPoly.numFace; ++i) {
            if (this.Gbl().allDivPoly.face[i].finish) continue;
            bl = false;
            intR.val = i;
            break;
        }
        return bl;
    }

    private final void SetSrcDivPoly() {
        lvRec.SeqPart seqPart = this.Gbl().allDivPoly.face[this.Gbl().tmpDt.curFaceNo].info;
        this.Gbl().srcDivPoly.numHalf = seqPart.num;
        for (int i = 0; i < seqPart.num; ++i) {
            ((TmpDivPolyOne)((Global)this.Gbl()).srcDivPoly).faceHalfSeq[i] = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
        }
    }

    private final boolean DivVtxToVtxMain() throws lvThrowable {
        if (this.Gbl().srcDivPoly.numHalf <= 3) {
            return false;
        }
        if (this.Gbl().srcDivPoly.numHalf == 4) {
            return this.DivVtxToVtx4();
        }
        return this.DivVtxToVtxOver4();
    }

    private final boolean DivVtxToVtx4() throws lvThrowable {
        int n;
        lvType.IntR intR = this.Gbl().tiDivVtxToVtx4[0];
        boolean bl = this.SearchConcave(intR);
        if (!bl) {
            return false;
        }
        this.Gbl().dstDivPoly0.numHalf = 3;
        this.Gbl().dstDivPoly1.numHalf = 3;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly0).faceHalfSeq[0] = n = intR.val;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly0).faceHalfSeq[1] = (n + 2) % 4;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly0).faceHalfSeq[2] = (n + 3) % 4;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly1).faceHalfSeq[0] = n;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly1).faceHalfSeq[1] = (n + 1) % 4;
        ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly1).faceHalfSeq[2] = (n + 2) % 4;
        return true;
    }

    private final boolean SearchConcave(lvType.IntR intR) throws lvThrowable {
        lvVector lvVector2 = this.Gbl().tvSearchConcave[0];
        lvVector lvVector3 = this.Gbl().tvSearchConcave[1];
        lvVector lvVector4 = this.Gbl().tvSearchConcave[2];
        boolean bl = false;
        for (int i = 0; i < this.Gbl().srcDivPoly.numHalf; ++i) {
            int n = (i + this.Gbl().srcDivPoly.numHalf - 1) % this.Gbl().srcDivPoly.numHalf;
            int n2 = (i + 1) % this.Gbl().srcDivPoly.numHalf;
            int n3 = this.Gbl().srcDivPoly.faceHalfSeq[i];
            int n4 = this.Gbl().srcDivPoly.faceHalfSeq[n];
            int n5 = this.Gbl().srcDivPoly.faceHalfSeq[n2];
            lvVector lvVector5 = this.DownDivPoly().vtxPos[n3];
            lvVector lvVector6 = this.DownDivPoly().vtxPos[n4];
            lvVector lvVector7 = this.DownDivPoly().vtxPos[n5];
            lvVector2.Assign(lvVector5.Sub(lvVector6).Unit());
            if (lvVector2.IsZero()) continue;
            lvVector3.Assign(lvVector7.Sub(lvVector5).Unit());
            if (lvVector3.IsZero() || lvVector5.AngleStatus(lvVector6, lvVector7, 0.001) == 2) continue;
            lvVector4.Assign(lvVector3.Cross(lvVector2).Neg().Unit());
            this.Eps();
            if (!lvEps.IsNega(this.Gbl().tmpDt.faceNormal.Dot(lvVector4), 1.0E-8)) continue;
            bl = true;
            intR.val = i;
            break;
        }
        return bl;
    }

    private final boolean DivVtxToVtxOver4() throws lvThrowable {
        lvType.IntR intR = this.Gbl().tiDivVtxToVtxOver4[0];
        lvType.IntR intR2 = this.Gbl().tiDivVtxToVtxOver4[1];
        boolean bl = this.SearchConcave(intR);
        if (!bl) {
            return false;
        }
        boolean bl2 = this.SearchMateVtx(intR.val, intR2);
        if (!bl2) {
            intR2.val = (intR.val + 2) % this.Gbl().srcDivPoly.numHalf;
        }
        this.Err().Assert(intR.val != intR2.val, "lvDivPolyLow.DivVtxToVtxOver4(0)");
        this.DivVtxToVtxOver4Dst0(intR.val, intR2.val);
        this.DivVtxToVtxOver4Dst1(intR.val, intR2.val);
        return true;
    }

    private final boolean SearchMateVtx(int n, lvType.IntR intR) throws lvThrowable {
        int n2;
        int n3 = (this.Gbl().srcDivPoly.numHalf - 3 + 1) / 2;
        boolean bl = false;
        if ((this.Gbl().srcDivPoly.numHalf - 3) % 2 != 0) {
            bl = true;
        }
        int n4 = 0;
        boolean bl2 = false;
        for (int i = 0; !(i >= n3 || (bl2 = this.SearchMateVtxMain(n, n4 = (n2 = n + i + 2) % this.Gbl().srcDivPoly.numHalf)) || i == n3 - 1 && bl || (bl2 = this.SearchMateVtxMain(n, n4 = ((n2 = n - i - 2) + this.Gbl().srcDivPoly.numHalf) % this.Gbl().srcDivPoly.numHalf))); ++i) {
        }
        if (bl2) {
            intR.val = n4;
        }
        return bl2;
    }

    private final boolean SearchMateVtxMain(int n, int n2) throws lvThrowable {
        int n3;
        int n4;
        int n5;
        lvRec.CoordSys coordSys = this.Gbl().tcSearchMateVtxMain[0];
        int n6 = this.Gbl().srcDivPoly.faceHalfSeq[n];
        int n7 = this.Gbl().srcDivPoly.faceHalfSeq[n2];
        this.MakeCoordSys(this.DownDivPoly().vtxPos[n6], this.DownDivPoly().vtxPos[n7], coordSys);
        if (n2 > n) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        boolean bl = false;
        for (n3 = 0; n3 < n5 - 2 && !(bl = this.SearchMateVtxOne(coordSys, this.DownDivPoly().vtxPos[n7], n3)); ++n3) {
        }
        if (!bl) {
            return true;
        }
        for (n3 = n5 + 1; n3 < n4 - 2 && !(bl = this.SearchMateVtxOne(coordSys, this.DownDivPoly().vtxPos[n7], n3)); ++n3) {
        }
        if (!bl) {
            return true;
        }
        for (n3 = n4 + 1; n3 < this.Gbl().srcDivPoly.numHalf && !(bl = this.SearchMateVtxOne(coordSys, this.DownDivPoly().vtxPos[n7], n3)); ++n3) {
        }
        return !bl;
    }

    private final void MakeCoordSys(lvVector lvVector2, lvVector lvVector3, lvRec.CoordSys coordSys) throws lvThrowable {
        lvVector lvVector4 = this.Gbl().tvMakeCoordSys[0];
        coordSys.org.Assign(lvVector2);
        lvVector4.Assign(lvVector3.Sub(coordSys.org));
        coordSys.yAxis.Assign(this.Gbl().tmpDt.faceNormal);
        coordSys.zAxis.Assign(lvVector4.Cross(coordSys.yAxis).Unit());
        coordSys.xAxis.Assign(coordSys.yAxis.Cross(coordSys.zAxis).Unit());
    }

    private final boolean SearchMateVtxOne(lvRec.CoordSys coordSys, lvVector lvVector2, int n) throws lvThrowable {
        lvVector lvVector3 = this.Gbl().tvSearchMateVtxOne[0];
        lvVector lvVector4 = this.Gbl().tvSearchMateVtxOne[1];
        lvVector lvVector5 = this.Gbl().tvSearchMateVtxOne[2];
        lvDouble lvDouble2 = this.Gbl().tdSearchMateVtxOne[0];
        double d = 1.0E-8;
        int n2 = (n + 1) % this.Gbl().srcDivPoly.numHalf;
        int n3 = this.Gbl().srcDivPoly.faceHalfSeq[n];
        int n4 = this.Gbl().srcDivPoly.faceHalfSeq[n2];
        lvVector3.Assign(this.DownDivPoly().vtxPos[n3]);
        lvVector4.Assign(this.DownDivPoly().vtxPos[n4]);
        int n5 = lvVector3.IntersecLinePlane(lvVector4, coordSys.org, coordSys.zAxis, lvVector5, lvDouble2);
        if (n5 == 2) {
            this.Eps();
            if (lvEps.IsPosiZero(lvDouble2.val, d)) {
                this.Eps();
                if (lvEps.IsNegaZero(lvDouble2.val - 1.0, d)) {
                    double d2 = coordSys.xAxis.Dot(lvVector5.Sub(coordSys.org));
                    this.Eps();
                    if (lvEps.IsPosiZero(d2, d)) {
                        d2 = coordSys.xAxis.Dot(lvVector5.Sub(lvVector2));
                        this.Eps();
                        if (lvEps.IsNegaZero(d2, d)) {
                            return true;
                        }
                    }
                }
            }
        } else if (n5 == 1) {
            double d3 = coordSys.xAxis.Dot(lvVector3.Sub(coordSys.org));
            this.Eps();
            if (lvEps.IsPosiZero(d3, d)) {
                d3 = coordSys.xAxis.Dot(lvVector3.Sub(lvVector2));
                this.Eps();
                if (lvEps.IsNegaZero(d3, d)) {
                    return true;
                }
            }
            d3 = coordSys.xAxis.Dot(lvVector4.Sub(coordSys.org));
            this.Eps();
            if (lvEps.IsPosiZero(d3, d)) {
                d3 = coordSys.xAxis.Dot(lvVector4.Sub(lvVector2));
                this.Eps();
                if (lvEps.IsNegaZero(d3, d)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final void DivVtxToVtxOver4Dst0(int n, int n2) {
        if (n2 > n) {
            this.Gbl().dstDivPoly0.numHalf = this.Gbl().srcDivPoly.numHalf - n2 + n + 1;
        } else {
            this.Gbl().dstDivPoly0.numHalf = n - n2 + 1;
        }
        int n3 = n2;
        for (int i = 0; i < this.Gbl().dstDivPoly0.numHalf; ++i) {
            int n4 = (i + n3) % this.Gbl().srcDivPoly.numHalf;
            ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly0).faceHalfSeq[i] = this.Gbl().srcDivPoly.faceHalfSeq[n4];
        }
    }

    private final void DivVtxToVtxOver4Dst1(int n, int n2) {
        if (n2 < n) {
            this.Gbl().dstDivPoly1.numHalf = this.Gbl().srcDivPoly.numHalf - n + n2 + 1;
        } else {
            this.Gbl().dstDivPoly1.numHalf = n2 - n + 1;
        }
        int n3 = n;
        for (int i = 0; i < this.Gbl().dstDivPoly1.numHalf; ++i) {
            int n4 = (i + n3) % this.Gbl().srcDivPoly.numHalf;
            ((TmpDivPolyOne)((Global)this.Gbl()).dstDivPoly1).faceHalfSeq[i] = this.Gbl().srcDivPoly.faceHalfSeq[n4];
        }
    }

    private final void ConvAllDivPoly() throws lvThrowable {
        this.DelCurFace();
        this.AppendTmpDivPoly(this.Gbl().dstDivPoly0);
        this.AppendTmpDivPoly(this.Gbl().dstDivPoly1);
        this.CopyTmpToAll();
    }

    private final void DelCurFace() throws lvThrowable {
        int n;
        this.Err().Assert(this.Gbl().allDivPoly.numFace >= 1, "lvDivPolyLow.DelCurFace(0)");
        int n2 = 0;
        for (n = 0; n < this.Gbl().allDivPoly.numFace; ++n) {
            if (n == this.Gbl().tmpDt.curFaceNo) continue;
            lvRec.SeqPart seqPart = this.Gbl().allDivPoly.face[n].info;
            for (int i = 0; i < seqPart.num; ++i) {
                ((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).faceHalfSeq[n2] = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
                ++n2;
            }
        }
        n2 = 0;
        for (n = 0; n < this.Gbl().allDivPoly.numFace; ++n) {
            if (n == this.Gbl().tmpDt.curFaceNo) continue;
            ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n2]).info.num = ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).allDivPoly).face[n]).info.num;
            this.Gbl().tmpDivPoly.face[n2].finish = this.Gbl().allDivPoly.face[n].finish;
            ++n2;
        }
        this.Gbl().tmpDivPoly.numFace = this.Gbl().allDivPoly.numFace - 1;
        n2 = 0;
        for (n = 0; n < this.Gbl().tmpDivPoly.numFace; ++n) {
            ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n]).info.start = n2;
            n2 += ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n]).info.num;
        }
    }

    private final void AppendTmpDivPoly(TmpDivPolyOne tmpDivPolyOne) throws lvThrowable {
        int n;
        this.Err().Assert(this.Gbl().tmpDivPoly.numFace + 1 <= this.Gbl().tmpDivPoly.face.length, "lvDivPolyLow.AppendTmpDivPoly(0)");
        int n2 = 0;
        for (n = 0; n < this.Gbl().tmpDivPoly.numFace; ++n) {
            n2 += ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n]).info.num;
        }
        n = this.Gbl().tmpDivPoly.numFace;
        this.Err().Assert(n2 + tmpDivPolyOne.numHalf <= this.Gbl().tmpDivPoly.faceHalfSeq.length, "lvDivPolyLow.AppendTmpDivPoly(1)");
        ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n]).info.start = n2;
        ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).face[n]).info.num = tmpDivPolyOne.numHalf;
        this.Gbl().tmpDivPoly.face[n].finish = false;
        for (int i = 0; i < tmpDivPolyOne.numHalf; ++i) {
            ((TmpDivPoly)((Global)this.Gbl()).tmpDivPoly).faceHalfSeq[n2 + i] = tmpDivPolyOne.faceHalfSeq[i];
        }
        this.Gbl().tmpDivPoly.numFace++;
    }

    private final void CopyTmpToAll() {
        int n;
        for (n = 0; n < this.Gbl().tmpDivPoly.numFace; ++n) {
            lvRec.SeqPart seqPart = this.Gbl().tmpDivPoly.face[n].info;
            for (int i = 0; i < seqPart.num; ++i) {
                ((TmpDivPoly)((Global)this.Gbl()).allDivPoly).faceHalfSeq[seqPart.start + i] = this.Gbl().tmpDivPoly.faceHalfSeq[seqPart.start + i];
            }
        }
        for (n = 0; n < this.Gbl().tmpDivPoly.numFace; ++n) {
            lvRec.SeqPart.Copy(this.Gbl().tmpDivPoly.face[n].info, this.Gbl().allDivPoly.face[n].info);
            this.Gbl().allDivPoly.face[n].finish = this.Gbl().tmpDivPoly.face[n].finish;
        }
        this.Gbl().allDivPoly.numFace = this.Gbl().tmpDivPoly.numFace;
    }

    private final void DivRadial() throws lvThrowable {
        this.UpDivPoly().numVertex = this.DownDivPoly().numVtxPos + this.NumNonTriangle();
        this.Err().Assert(this.UpDivPoly().numVertex <= this.UpDivPoly().vertex.length, "lvDivPolyLow.DivRadial(0)");
        this.DivRadialVtxPos();
        this.DivRadialIndex();
        this.DivRadialVtxNormal();
        this.DivRadialVtxUV();
    }

    private final int NumNonTriangle() throws lvThrowable {
        int n = 0;
        for (int i = 0; i < this.Gbl().allDivPoly.numFace; ++i) {
            int n2 = ((TmpFace)((TmpDivPoly)((Global)this.Gbl()).allDivPoly).face[i]).info.num;
            this.Err().Assert(n2 >= 3, "lvDivPolyLow.NumNotTriangle(0)");
            if (n2 < 4) continue;
            ++n;
        }
        return n;
    }

    private final void DivRadialVtxPos() throws lvThrowable {
        int n;
        for (n = 0; n < this.DownDivPoly().numVtxPos; ++n) {
            this.UpDivPoly().vertex[n].pos.Assign(this.DownDivPoly().vtxPos[n]);
        }
        n = this.DownDivPoly().numVtxPos;
        for (int i = 0; i < this.Gbl().allDivPoly.numFace; ++i) {
            lvRec.SeqPart seqPart = this.Gbl().allDivPoly.face[i].info;
            if (seqPart.num < 4) continue;
            this.GetCenterVtxPos(seqPart, this.UpDivPoly().vertex[n].pos);
            ++n;
        }
    }

    private final void GetCenterVtxPos(lvRec.SeqPart seqPart, lvVector lvVector2) throws lvThrowable {
        lvVector[] lvVectorArray = this.Gbl().NewGetCenterVtxPos(seqPart.num);
        for (int i = 0; i < seqPart.num; ++i) {
            int n = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
            lvVectorArray[i] = this.DownDivPoly().vtxPos[n];
        }
        lvVector2.Center(lvVectorArray, seqPart.num);
    }

    private final void DivRadialIndex() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.Gbl().allDivPoly.numFace; ++i) {
            lvRec.SeqPart seqPart = this.Gbl().allDivPoly.face[i].info;
            if (seqPart.num < 4) {
                this.DivRadialIndex3(seqPart, this.UpDivPoly().triIndex[n2]);
                ++n2;
                continue;
            }
            this.DivRadialIndexMain(seqPart, n2, n, this.UpDivPoly().triIndex);
            n2 += seqPart.num;
            ++n;
        }
        this.UpDivPoly().numTriIndex = n2;
    }

    private final void DivRadialIndex3(lvRec.SeqPart seqPart, lvRec.TriIndex triIndex) {
        for (int i = 0; i < 3; ++i) {
            triIndex.vtxNo[i] = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
        }
    }

    private final void DivRadialIndexMain(lvRec.SeqPart seqPart, int n, int n2, lvRec.TriIndex[] triIndexArray) {
        for (int i = 0; i < seqPart.num; ++i) {
            int n3 = (i + 1) % seqPart.num;
            triIndexArray[n + i].vtxNo[0] = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
            triIndexArray[n + i].vtxNo[1] = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + n3];
            triIndexArray[n + i].vtxNo[2] = this.DownDivPoly().numVtxPos + n2;
        }
    }

    private final void DivRadialVtxNormal() {
        for (int i = 0; i < this.UpDivPoly().numVertex; ++i) {
            this.UpDivPoly().vertex[i].normal.Assign(this.Gbl().tmpDt.faceNormal);
        }
    }

    private final void NewUpVtxUV(int n) {
        int n2;
        lvDivPolyUV.DownDivPolyUVone[] downDivPolyUVoneArray = this.DownDivPoly().divPolyUV.uvSpace;
        if (downDivPolyUVoneArray == null) {
            return;
        }
        int n3 = downDivPolyUVoneArray.length;
        if (n3 == 1) {
            this.UpDivPoly().divPolyUV.uvSpace = ((Global)this.Gbl()).staticUp.divPolyUV.uvSpace;
        } else {
            this.UpDivPoly().divPolyUV.uvSpace = new lvDivPolyUV.UpDivPolyUVone[n3];
            this.UpDivPoly().divPolyUV.uvSpace[0] = ((Global)this.Gbl()).staticUp.divPolyUV.uvSpace[0];
            for (n2 = 1; n2 < n3; ++n2) {
                this.UpDivPoly().divPolyUV.uvSpace[n2] = new lvDivPolyUV.UpDivPolyUVone();
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.NewUpVtxUVmain(n2, n);
        }
    }

    private final void NewUpVtxUVmain(int n, int n2) {
        int n3 = lvDivPolyLow.GetNumVertex(n2);
        int n4 = lvDivPolyLow.GetNumVertex(256);
        lvDivPolyUV.UpDivPolyUVone upDivPolyUVone = ((Global)this.Gbl()).staticUp.divPolyUV.uvSpace[n];
        lvDivPolyUV.UpDivPolyUVone upDivPolyUVone2 = this.UpDivPoly().divPolyUV.uvSpace[n];
        if (n2 > 256) {
            int n5;
            upDivPolyUVone2.vertex = new lvUVdt[n3];
            for (n5 = 0; n5 < n4; ++n5) {
                upDivPolyUVone2.vertex[n5] = upDivPolyUVone.vertex[n5];
            }
            for (n5 = n4; n5 < n3; ++n5) {
                upDivPolyUVone2.vertex[n5] = new lvUVdt();
            }
        } else {
            upDivPolyUVone2.vertex = upDivPolyUVone.vertex;
        }
    }

    private final void DivRadialVtxUV() throws lvThrowable {
        lvDivPolyUV.DownDivPolyUVone[] downDivPolyUVoneArray = this.DownDivPoly().divPolyUV.uvSpace;
        if (downDivPolyUVoneArray == null) {
            return;
        }
        for (int i = 0; i < downDivPolyUVoneArray.length; ++i) {
            this.DivRadialVtxUVmain(i);
        }
    }

    private final void DivRadialVtxUVmain(int n) throws lvThrowable {
        int n2;
        lvDivPolyUV.DownDivPolyUVone downDivPolyUVone = this.DownDivPoly().divPolyUV.uvSpace[n];
        lvDivPolyUV.UpDivPolyUVone upDivPolyUVone = this.UpDivPoly().divPolyUV.uvSpace[n];
        upDivPolyUVone.numVertex = this.UpDivPoly().numVertex;
        for (n2 = 0; n2 < downDivPolyUVone.numVtxUV; ++n2) {
            lvUVdt.Copy(downDivPolyUVone.vtxUV[n2], upDivPolyUVone.vertex[n2]);
        }
        n2 = downDivPolyUVone.numVtxUV;
        for (int i = 0; i < this.Gbl().allDivPoly.numFace; ++i) {
            lvRec.SeqPart seqPart = this.Gbl().allDivPoly.face[i].info;
            if (seqPart.num < 4) continue;
            this.GetCenterVtxUV(n, seqPart, upDivPolyUVone.vertex[n2]);
            ++n2;
        }
    }

    private final void GetCenterVtxUV(int n, lvRec.SeqPart seqPart, lvUVdt lvUVdt2) throws lvThrowable {
        lvDivPolyUV.DownDivPolyUVone downDivPolyUVone = this.DownDivPoly().divPolyUV.uvSpace[n];
        lvUVdt.SetUV(0.0, 0.0, lvUVdt2);
        for (int i = 0; i < seqPart.num; ++i) {
            int n2 = this.Gbl().allDivPoly.faceHalfSeq[seqPart.start + i];
            lvUVdt2.u += downDivPolyUVone.vtxUV[n2].u;
            lvUVdt2.v += downDivPolyUVone.vtxUV[n2].v;
        }
        this.Err().Assert(seqPart.num > 0, "lvDivPolyLow.GetCenterVtxUV(0)");
        lvUVdt2.u /= (double)seqPart.num;
        lvUVdt2.v /= (double)seqPart.num;
    }

    private final void Finish() {
        TmpDivPoly.access$502(this.Gbl().allDivPoly, null);
        TmpDivPoly.access$802(this.Gbl().allDivPoly, null);
        TmpDivPoly.access$502(this.Gbl().tmpDivPoly, null);
        TmpDivPoly.access$802(this.Gbl().tmpDivPoly, null);
        TmpDivPolyOne.access$902(this.Gbl().srcDivPoly, null);
        TmpDivPolyOne.access$902(this.Gbl().dstDivPoly0, null);
        TmpDivPolyOne.access$902(this.Gbl().dstDivPoly1, null);
    }

    public static class Global {
        private DownDivPoly curDownDivPoly = new DownDivPoly();
        private UpDivPoly curUpDivPoly = new UpDivPoly();
        private UpDivPoly staticUp = new UpDivPoly();
        private TmpDivPoly allDivPoly = new TmpDivPoly();
        private TmpDivPoly tmpDivPoly = new TmpDivPoly();
        private TmpDivPolyOne srcDivPoly = new TmpDivPolyOne();
        private TmpDivPolyOne dstDivPoly0 = new TmpDivPolyOne();
        private TmpDivPolyOne dstDivPoly1 = new TmpDivPolyOne();
        private TmpDivPoly staticAll = new TmpDivPoly();
        private TmpDivPoly staticTmp = new TmpDivPoly();
        private TmpDivPolyOne staticSrc = new TmpDivPolyOne();
        private TmpDivPolyOne staticDst0 = new TmpDivPolyOne();
        private TmpDivPolyOne staticDst1 = new TmpDivPolyOne();
        private TmpDivPolyOther tmpDt = null;
        private lvType.IntR[] tiDivVtxToVtx = null;
        private lvVector[] tvAryGetCenterVtxPos = new lvVector[256];
        private lvType.IntR[] tiDivVtxToVtx4 = null;
        private lvVector[] tvSearchConcave = null;
        private lvType.IntR[] tiDivVtxToVtxOver4 = null;
        private lvRec.CoordSys[] tcSearchMateVtxMain = null;
        private lvVector[] tvMakeCoordSys = null;
        private lvVector[] tvSearchMateVtxOne = null;
        private lvDouble[] tdSearchMateVtxOne = null;

        public Global(lvGlobal lvGlobal2) {
            this.GlobalIO(lvGlobal2);
            this.GlobalTmpFace();
            this.GlobalTmpFaceOne();
            this.tmpDt = new TmpDivPolyOther(lvGlobal2);
            this.GlobalTmp(lvGlobal2);
        }

        private final void GlobalIO(lvGlobal lvGlobal2) {
            int n;
            int n2;
            int n3 = lvDivPolyLow.GetNumVertex(256);
            this.staticUp.vertex = new lvRec.PosNorHi[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.staticUp.vertex[n2] = new lvRec.PosNorHi(lvGlobal2);
            }
            n2 = lvDivPolyLow.GetNumTriIndex(256);
            this.staticUp.triIndex = new lvRec.TriIndex[n2];
            for (n = 0; n < n2; ++n) {
                this.staticUp.triIndex[n] = new lvRec.TriIndex();
            }
            this.staticUp.divPolyUV.uvSpace = new lvDivPolyUV.UpDivPolyUVone[1];
            this.staticUp.divPolyUV.uvSpace[0] = new lvDivPolyUV.UpDivPolyUVone();
            this.staticUp.divPolyUV.uvSpace[0].vertex = new lvUVdt[n3];
            for (n = 0; n < n3; ++n) {
                this.staticUp.divPolyUV.uvSpace[0].vertex[n] = new lvUVdt();
            }
        }

        private final void GlobalTmpFace() {
            int n;
            int n2 = lvDivPolyLow.GetNumFace(256);
            TmpDivPoly.access$502(this.staticAll, new TmpFace[n2]);
            for (n = 0; n < n2; ++n) {
                ((TmpDivPoly)this.staticAll).face[n] = new TmpFace();
            }
            TmpDivPoly.access$502(this.staticTmp, new TmpFace[n2]);
            for (n = 0; n < n2; ++n) {
                ((TmpDivPoly)this.staticTmp).face[n] = new TmpFace();
            }
            n = lvDivPolyLow.GetNumFaceHalfSeq(256);
            TmpDivPoly.access$802(this.staticAll, new int[n]);
            TmpDivPoly.access$802(this.staticTmp, new int[n]);
        }

        private final void GlobalTmpFaceOne() {
            TmpDivPolyOne.access$902(this.staticSrc, new int[256]);
            TmpDivPolyOne.access$902(this.staticDst0, new int[256]);
            TmpDivPolyOne.access$902(this.staticDst1, new int[256]);
        }

        private final void GlobalTmp(lvGlobal lvGlobal2) {
            int n;
            this.tiDivVtxToVtx = new lvType.IntR[2];
            for (n = 0; n < 2; ++n) {
                this.tiDivVtxToVtx[n] = new lvType.IntR();
            }
            this.tiDivVtxToVtx4 = new lvType.IntR[2];
            for (n = 0; n < 2; ++n) {
                this.tiDivVtxToVtx4[n] = new lvType.IntR();
            }
            this.tvSearchConcave = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSearchConcave[n] = new lvVector(lvGlobal2);
            }
            this.tiDivVtxToVtxOver4 = new lvType.IntR[4];
            for (n = 0; n < 4; ++n) {
                this.tiDivVtxToVtxOver4[n] = new lvType.IntR();
            }
            this.tcSearchMateVtxMain = new lvRec.CoordSys[2];
            for (n = 0; n < 2; ++n) {
                this.tcSearchMateVtxMain[n] = new lvRec.CoordSys(lvGlobal2);
            }
            this.tvMakeCoordSys = new lvVector[2];
            for (n = 0; n < 2; ++n) {
                this.tvMakeCoordSys[n] = new lvVector(lvGlobal2);
            }
            this.tvSearchMateVtxOne = new lvVector[4];
            for (n = 0; n < 4; ++n) {
                this.tvSearchMateVtxOne[n] = new lvVector(lvGlobal2);
            }
            this.tdSearchMateVtxOne = new lvDouble[2];
            for (n = 0; n < 2; ++n) {
                this.tdSearchMateVtxOne[n] = new lvDouble(lvGlobal2);
            }
        }

        private final lvVector[] NewGetCenterVtxPos(int n) {
            if (n > 256) {
                return new lvVector[n];
            }
            return this.tvAryGetCenterVtxPos;
        }
    }

    private static class TmpDivPolyOther {
        private int curFaceNo;
        private lvVector faceNormal = null;

        public TmpDivPolyOther(lvGlobal lvGlobal2) {
            this.faceNormal = new lvVector(lvGlobal2);
        }
    }

    private static class TmpDivPolyOne {
        private int numHalf;
        private int[] faceHalfSeq = null;

        private TmpDivPolyOne() {
        }

        static /* synthetic */ int[] access$902(TmpDivPolyOne tmpDivPolyOne, int[] nArray) {
            tmpDivPolyOne.faceHalfSeq = nArray;
            return nArray;
        }
    }

    private static class TmpDivPoly {
        private int numFace;
        private TmpFace[] face = null;
        private int[] faceHalfSeq = null;

        private TmpDivPoly() {
        }

        static /* synthetic */ TmpFace[] access$502(TmpDivPoly tmpDivPoly, TmpFace[] tmpFaceArray) {
            tmpDivPoly.face = tmpFaceArray;
            return tmpFaceArray;
        }

        static /* synthetic */ int[] access$802(TmpDivPoly tmpDivPoly, int[] nArray) {
            tmpDivPoly.faceHalfSeq = nArray;
            return nArray;
        }
    }

    private static class TmpFace {
        private lvRec.SeqPart info = new lvRec.SeqPart();
        private boolean finish;

        private TmpFace() {
        }
    }

    public static class UpDivPoly {
        public int numVertex;
        public lvRec.PosNorHi[] vertex = null;
        public int numTriIndex;
        public lvRec.TriIndex[] triIndex = null;
        public lvDivPolyUV.UpDivPolyUV divPolyUV = new lvDivPolyUV.UpDivPolyUV();
    }

    public static class DownDivPoly {
        public int numVtxPos;
        public lvVector[] vtxPos = null;
        public lvDivPolyUV.DownDivPolyUV divPolyUV = new lvDivPolyUV.DownDivPolyUV();
    }
}

