/*
 * Decompiled with CFR 0.152.
 */
package jp.co.lattice.vApplet;

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URLEncoder;
import jp.co.lattice.vApplet.xvGlobal;
import jp.co.lattice.vApplet.xvRoot;
import jp.co.lattice.vApplet.xvShade;
import jp.co.lattice.vApplet.xvShadeCore;
import jp.co.lattice.vApplet.xvShadeTexCoord;
import jp.co.lattice.vApplet.xvTexture;
import jp.co.lattice.vApplet.xvView;
import jp.co.lattice.vKernel.core.c0.lvThrowable;
import jp.co.lattice.vKernel.core.c0.lvVector;
import jp.co.lattice.vProcessor.base.x3pFromProcessor;
import jp.co.lattice.vProcessor.com.x3pColor;
import jp.co.lattice.vProcessor.com.x3pGlobal;
import jp.co.lattice.vProcessor.com.x3pMatrix;

public class xvRend
extends xvRoot {
    public static final int FP = 65536;
    private static final int ALPHA = -16777216;
    public Applet applet;
    public int width;
    public int height;
    public Image image;
    public int[] mem;
    public int[] zbuf;
    private int bgColor = -16777216;
    private int[] bgTexMem = null;
    public x3pMatrix autoRotMat = null;
    public xvShadeCore shade = null;
    public xvShadeTexCoord texUV = null;
    public xvView view = null;
    public lvVector screenScl = null;
    public lvVector screenPoint = null;
    private x3pColor lightColor = null;
    private int lightAmbientIntensity = 128;
    public int ambientIntensity = 51;
    public x3pColor diffuseColor = null;
    public double shininess = 0.2;
    public x3pFromProcessor.Texture texture = null;
    public xvTexture texImage = null;
    private x3pColor cw0 = null;
    private x3pColor cw1 = null;
    private x3pColor cw2 = null;
    private lvVector vh = null;

    public final void SetAmbientIntensity(double d) {
        this.ambientIntensity = (int)(d * 256.0);
    }

    public xvRend(xvGlobal xvGlobal2, int n, int n2, Applet applet) {
        super(xvGlobal2);
        this.Constractor(xvGlobal2);
        this.applet = applet;
        this.SetSize(n, n2, applet);
        this.view.lightDir = new lvVector(xvGlobal2.processor, 1.0, 0.0, -1.0);
        try {
            this.view.lightDir.UnitAssign();
        }
        catch (lvThrowable lvThrowable2) {
            boolean bl = false;
        }
        this.view.viewDir = new lvVector(xvGlobal2.processor, 0.0, 0.0, 0.0);
        this.view.viewLookPt = new lvVector(xvGlobal2.processor, 0.0, 0.0, 0.0);
        this.view.viewDistant = 12.0;
        this.view.viewMat = new x3pMatrix(xvGlobal2.processor);
        this.view.viewRotateMat = new x3pMatrix(xvGlobal2.processor);
        this.view.ViewRotateDir(0.0, 0.0, 0.0);
        this.shade = new xvShade(xvGlobal2, this);
        this.texUV = new xvShadeTexCoord(xvGlobal2, this);
    }

    private void Constractor(xvGlobal xvGlobal2) {
        this.view = new xvView(xvGlobal2);
        this.screenScl = new lvVector(xvGlobal2.processor, 200.0, 200.0, 0.0);
        this.screenPoint = new lvVector(xvGlobal2.processor, 100.0, 100.0, 0.0);
        this.lightColor = new x3pColor(xvGlobal2.processor, 1.0, 1.0, 1.0);
        this.diffuseColor = new x3pColor(xvGlobal2.processor, 0.8, 0.8, 0.8);
        this.cw0 = new x3pColor(xvGlobal2.processor);
        this.cw1 = new x3pColor(xvGlobal2.processor);
        this.cw2 = new x3pColor(xvGlobal2.processor);
        this.vh = new lvVector(xvGlobal2.processor);
    }

    private x3pGlobal Processor() {
        return this.global.processor;
    }

    private final void SetSize(int n, int n2, Applet applet) {
        this.width = n;
        this.height = n2;
        this.mem = new int[n * n2];
        this.zbuf = new int[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            this.mem[i] = -16777216;
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, colorModel, this.mem, 0, n);
        this.image = applet.createImage(memoryImageSource);
        this.screenPoint.SetXYZ((double)n / 2.0, (double)n2 / 2.0, 0.0);
        this.screenScl.SetXYZ(n, n2, 0.0);
    }

    public void SetBgColor(String string) {
        String string2 = string.substring(1);
        this.bgColor = Integer.valueOf(string2, 16) | 0xFF000000;
    }

    public boolean SetBgTex(String string) {
        Image image = this.SetBgTexMain(string);
        if (image == null) {
            return true;
        }
        Image image2 = this.applet.createImage(this.width, this.height);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(this.applet.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.drawImage(image, 0, 0, this.width, this.height, null);
        this.bgTexMem = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, this.width, this.height, this.bgTexMem, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return false;
    }

    private Image SetBgTexMain(String string) {
        Image image = null;
        image = this.SetBgTexForIE(string);
        if (image != null) {
            return image;
        }
        image = this.SetBgTexForNC(string);
        if (image != null) {
            return image;
        }
        return null;
    }

    private Image SetBgTexForIE(String string) {
        Image image = this.applet.getImage(this.applet.getDocumentBase(), string);
        boolean bl = this.SetBgTexMediaTracker(image);
        if (bl) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            image = null;
        }
        return image;
    }

    private Image SetBgTexForNC(String string) {
        String string2 = URLEncoder.encode(string);
        Image image = this.applet.getImage(this.applet.getDocumentBase(), string2);
        boolean bl = this.SetBgTexMediaTracker(image);
        if (bl) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            image = null;
        }
        return image;
    }

    private boolean SetBgTexMediaTracker(Image image) {
        MediaTracker mediaTracker = new MediaTracker(this.applet);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return false;
    }

    public void SetAutoRotate(int n) {
        this.autoRotMat = new x3pMatrix(this.Processor());
        this.autoRotMat.SetRotateY((double)n * Math.PI / 180.0 * 2.0);
    }

    public final void Clear() {
        if (this.bgTexMem != null) {
            for (int i = 0; i < this.height * this.width; ++i) {
                this.mem[i] = this.bgTexMem[i] | 0xFF000000;
                this.zbuf[i] = Integer.MAX_VALUE;
            }
        } else {
            for (int i = 0; i < this.height * this.width; ++i) {
                this.mem[i] = this.bgColor;
                this.zbuf[i] = Integer.MAX_VALUE;
            }
        }
    }

    public final void Flush() {
        this.image.flush();
    }

    public final int ColorMul(int n, lvVector lvVector2, lvVector lvVector3, lvVector lvVector4) throws lvThrowable {
        double d = lvVector2.Dot(lvVector4);
        if (d < 0.0) {
            d *= -0.0;
        }
        this.cw1.Set(this.lightColor);
        this.cw1.Mul(this.lightAmbientIntensity);
        this.cw0.Set(n);
        this.cw0.Mul(this.ambientIntensity);
        this.cw0.Mul(this.cw1);
        try {
            this.cw0.Div(0x1000000);
        }
        catch (lvThrowable lvThrowable2) {
            this.Err().Assert(false, "xvRend.ColorMul(0)");
        }
        this.cw1.Set(n);
        this.cw1.Mul(d);
        this.cw0.Add(this.cw1);
        this.cw0.Mul(this.lightColor);
        try {
            this.cw0.Div(256);
        }
        catch (lvThrowable lvThrowable3) {
            this.Err().Assert(false, "xvRend.ColorMul(1)");
        }
        if (this.cw0.r > 255) {
            this.cw0.r = 255;
        }
        if (this.cw0.g > 255) {
            this.cw0.g = 255;
        }
        if (this.cw0.b > 255) {
            this.cw0.b = 255;
        }
        int n2 = this.cw0.r << 16 | this.cw0.g << 8 | this.cw0.b;
        return n2;
    }
}

