/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import com.parallelgraphics.cortona.dhandle.DHandle;
import vrml.BaseNode;
import vrml.InvalidVRMLSyntaxException;
import vrml.node.BlindNode;

public class Browser
extends DHandle {
    private String baseURL;

    public void replaceWorld(BaseNode[] baseNodeArray) {
        int[] nArray;
        if (baseNodeArray != null) {
            int n = baseNodeArray.length;
            nArray = new int[n];
            int n2 = n - 1;
            while (n2 >= 0) {
                int n3;
                BaseNode baseNode = baseNodeArray[n2];
                nArray[n2] = n3 = baseNode != null ? baseNode.getHandle() : 0;
                --n2;
            }
        } else {
            nArray = null;
        }
        this.replaceWorldNative(nArray);
    }

    private native float getFrameRateNative();

    private native void createVrmlFromURLNative(String[] var1, int var2, String var3, String var4);

    private native void addRouteNative(int var1, String var2, int var3, String var4);

    public void setDescription(String string) {
        this.setDescriptionNative(string);
    }

    private native void deleteRouteNative(int var1, String var2, int var3, String var4);

    public void addRoute(BaseNode baseNode, String string, BaseNode baseNode2, String string2) {
        this.addRouteNative(baseNode.getHandle(), string, baseNode2.getHandle(), string2);
    }

    public Browser(int n, String string) {
        super(n);
        this.addRef();
        this.setBaseURL(string);
    }

    public void deleteRoute(BaseNode baseNode, String string, BaseNode baseNode2, String string2) {
        this.deleteRouteNative(baseNode.getHandle(), string, baseNode2.getHandle(), string2);
    }

    private native Object createVrmlFromStringNative(String var1, String var2);

    public String getWorldURL() {
        return this.getWorldURLNative();
    }

    public String getVersion() {
        return this.getVersionNative();
    }

    public void loadURL(String[] stringArray, String[] stringArray2) throws InvalidVRMLSyntaxException {
        this.loadURLNative(stringArray, stringArray2);
    }

    public float getCurrentSpeed() {
        return this.getCurrentSpeedNative();
    }

    public BaseNode[] createVrmlFromString(String string) throws InvalidVRMLSyntaxException {
        Object object = this.createVrmlFromStringNative(string, this.getBaseURL());
        if (object instanceof String) {
            throw new InvalidVRMLSyntaxException((String)object);
        }
        int[] nArray = (int[])object;
        BaseNode[] baseNodeArray = new BlindNode[nArray.length];
        int n = 0;
        while (n < baseNodeArray.length) {
            baseNodeArray[n] = new BlindNode(nArray[n]);
            ++n;
        }
        return baseNodeArray;
    }

    private native String getWorldURLNative();

    private native float getCurrentSpeedNative();

    private native void setDescriptionNative(String var1);

    private native void replaceWorldNative(int[] var1);

    private native void loadURLNative(String[] var1, String[] var2);

    public String getName() {
        return this.getNameNative();
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String string) {
        this.baseURL = string;
    }

    public void createVrmlFromURL(String[] stringArray, BaseNode baseNode, String string) throws InvalidVRMLSyntaxException {
        if (stringArray == null || baseNode == null || string == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException();
            }
            ++n;
        }
        this.createVrmlFromURLNative(stringArray, baseNode.getHandle(), string, this.getBaseURL());
    }

    public float getCurrentFrameRate() {
        return this.getFrameRateNative();
    }

    private native String getVersionNative();

    private native String getNameNative();
}

