/*
 * Decompiled with CFR 0.152.
 */
package vrml.node;

import com.parallelgraphics.cortona.vrml.FieldHandle;
import vrml.BaseNode;
import vrml.ConstField;
import vrml.Field;
import vrml.InvalidEventInException;
import vrml.InvalidEventOutException;
import vrml.InvalidExposedFieldException;
import vrml.VrmlObject;

public abstract class Node
extends BaseNode {
    public Node(int n) {
        super(n);
    }

    public final Field getExposedField(String string) {
        VrmlObject vrmlObject = new VrmlObject();
        int n = this.getFieldHandle(string);
        vrmlObject.setHandle(n);
        if (n == 0) {
            throw new InvalidExposedFieldException("name == " + string);
        }
        int n2 = 0;
        if (n != 0) {
            n2 = Field.getCategory(n);
        }
        if (3 != n2) {
            throw new InvalidExposedFieldException("name == " + string + ", category == " + Node.getCategoryName(n2));
        }
        Field field = Field.makeField(n, n, Field.getFieldType(n), this.getBrowser());
        vrmlObject.setHandle(0);
        return field;
    }

    static String getCategoryName(int n) {
        switch (n) {
            case 0: {
                return "field";
            }
            case 1: {
                return "eventIn";
            }
            case 2: {
                return "eventOut";
            }
            case 3: {
                return "exposedField";
            }
        }
        return String.valueOf(n);
    }

    public final ConstField getEventOut(String string) {
        VrmlObject vrmlObject = new VrmlObject();
        int n = this.getFieldHandle(string);
        vrmlObject.setHandle(n);
        if (n == 0 || (Field.getCategory(n) & 2) == 0) {
            throw new InvalidEventOutException("Node.getEventOut: can't get eventOut " + string);
        }
        ConstField constField = Field.makeConstField(n, Field.getFieldType(n), this.getBrowser());
        vrmlObject.setHandle(0);
        return constField;
    }

    public final Field getEventIn(String string) {
        VrmlObject vrmlObject = new VrmlObject();
        int n = this.getFieldHandle(string);
        vrmlObject.setHandle(n);
        if (n == 0 || (Field.getCategory(n) & 1) == 0) {
            throw new InvalidEventInException("Node.getEventIn: can't get eventIn " + string);
        }
        int n2 = Field.getFieldType(n);
        VrmlObject vrmlObject2 = new VrmlObject();
        FieldHandle fieldHandle = Field.makeFieldHandle(n2);
        vrmlObject2.setHandle(fieldHandle.getValue());
        Field field = Field.makeField(fieldHandle.getValue(), n, n2, this.getBrowser());
        vrmlObject2.setHandle(0);
        vrmlObject.setHandle(0);
        return field;
    }
}

