/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import com.parallelgraphics.cortona.vrml.FieldHandle;
import com.parallelgraphics.cortona.vrml.PassiveScriptFactoryImpl;
import com.parallelgraphics.cortona.vrml.PassiveScriptImpl;
import vrml.Browser;
import vrml.ConstField;
import vrml.VrmlObject;
import vrml.field.ConstMFColor;
import vrml.field.ConstMFFloat;
import vrml.field.ConstMFInt32;
import vrml.field.ConstMFNode;
import vrml.field.ConstMFRotation;
import vrml.field.ConstMFString;
import vrml.field.ConstMFTime;
import vrml.field.ConstMFVec2f;
import vrml.field.ConstMFVec3f;
import vrml.field.ConstSFBool;
import vrml.field.ConstSFColor;
import vrml.field.ConstSFFloat;
import vrml.field.ConstSFImage;
import vrml.field.ConstSFInt32;
import vrml.field.ConstSFNode;
import vrml.field.ConstSFRotation;
import vrml.field.ConstSFString;
import vrml.field.ConstSFTime;
import vrml.field.ConstSFVec2f;
import vrml.field.ConstSFVec3f;
import vrml.field.MFColor;
import vrml.field.MFFloat;
import vrml.field.MFInt32;
import vrml.field.MFNode;
import vrml.field.MFRotation;
import vrml.field.MFString;
import vrml.field.MFTime;
import vrml.field.MFVec2f;
import vrml.field.MFVec3f;
import vrml.field.SFBool;
import vrml.field.SFColor;
import vrml.field.SFFloat;
import vrml.field.SFImage;
import vrml.field.SFInt32;
import vrml.field.SFNode;
import vrml.field.SFRotation;
import vrml.field.SFString;
import vrml.field.SFTime;
import vrml.field.SFVec2f;
import vrml.field.SFVec3f;

public abstract class Field
extends VrmlObject
implements Cloneable {
    private Field eventIn;
    public int category;
    public static final int SGI_SFBitMask = 201;
    public static final int SGI_SFBool = 202;
    public static final int SGI_SFColor = 203;
    public static final int SGI_SFEnum = 204;
    public static final int SGI_SFFloat = 205;
    public static final int SGI_SFImage = 206;
    public static final int SGI_SFLong = 207;
    public static final int SGI_SFMatrix = 208;
    public static final int SGI_SFNode = 209;
    public static final int SGI_SFRotation = 210;
    public static final int SGI_SFString = 211;
    public static final int SGI_SFVec2f = 212;
    public static final int SGI_SFVec3f = 213;
    public static final int SGI_SFVoid = 214;
    public static final int SGI_SFTime = 215;
    public static final int SGI_MFColor = 216;
    public static final int SGI_MFFloat = 217;
    public static final int SGI_MFTime = 218;
    public static final int SGI_MFLong = 219;
    public static final int SGI_MFNode = 220;
    public static final int SGI_MFRotation = 221;
    public static final int SGI_MFString = 222;
    public static final int SGI_MFVec2f = 223;
    public static final int SGI_MFVec3f = 224;
    public static final int FC_field = 0;
    public static final int FC_eventIn = 1;
    public static final int FC_eventOut = 2;
    public static final int FC_exposedField = 3;
    private Browser browser;

    public static native int getFieldType(int var0);

    protected native void insertValueInt(int var1, int var2);

    protected native int getImageHeight();

    protected native void insertValueDouble(int var1, double var2);

    protected native void setValueField(Field var1);

    protected native void getValueField(Field var1);

    protected native void get1ValueField(int var1, Field var2);

    protected native void set1ValueField(int var1, Field var2);

    public native int getSize();

    protected native void setValueFloatArray(int var1, float[] var2);

    protected native void getValueFloatArray(float[] var1);

    public Object clone() {
        int n = this.getFieldType();
        int n2 = this.getHandle();
        Field field = this instanceof ConstField ? Field.makeConstField(n2, n, this.getBrowser()) : Field.makeField(n2, this.eventIn != null ? this.eventIn.getHandle() : 0, n, this.getBrowser());
        VrmlObject.doAddRef(n2);
        if (this.eventIn != null) {
            VrmlObject.doAddRef(this.eventIn.getHandle());
        }
        return field;
    }

    protected void CompleteChanging() {
        if (this.category != 0) {
            double d = this.getTimestamp();
            if (1 == this.category) {
                this.OnSignal(((Field)this.eventIn.clone()).getHandle(), d);
                return;
            }
            if (2 == this.category) {
                this.Propagate(d);
                return;
            }
            if (3 == this.category) {
                this.OnSignal(this.eventIn.getHandle(), d);
            }
        }
    }

    protected native void insertValueNode(int var1, int var2);

    protected native void addValueString(String var1);

    public static Field makeField(int n, int n2, int n3, Browser browser) {
        if (browser == null) {
            try {
                throw new IllegalArgumentException("browser");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(System.err);
                throw illegalArgumentException;
            }
        }
        Field field = null;
        FieldHandle fieldHandle = new FieldHandle(n, n2, browser);
        switch (n3) {
            case 202: {
                field = new SFBool(fieldHandle);
                break;
            }
            case 203: {
                field = new SFColor(fieldHandle);
                break;
            }
            case 205: {
                field = new SFFloat(fieldHandle);
                break;
            }
            case 206: {
                field = new SFImage(fieldHandle);
                break;
            }
            case 207: {
                field = new SFInt32(fieldHandle);
                break;
            }
            case 209: {
                field = new SFNode(fieldHandle);
                break;
            }
            case 210: {
                field = new SFRotation(fieldHandle);
                break;
            }
            case 211: {
                field = new SFString(fieldHandle);
                break;
            }
            case 212: {
                field = new SFVec2f(fieldHandle);
                break;
            }
            case 213: {
                field = new SFVec3f(fieldHandle);
                break;
            }
            case 215: {
                field = new SFTime(fieldHandle);
                break;
            }
            case 216: {
                field = new MFColor(fieldHandle);
                break;
            }
            case 217: {
                field = new MFFloat(fieldHandle);
                break;
            }
            case 219: {
                field = new MFInt32(fieldHandle);
                break;
            }
            case 220: {
                field = new MFNode(fieldHandle);
                break;
            }
            case 221: {
                field = new MFRotation(fieldHandle);
                break;
            }
            case 222: {
                field = new MFString(fieldHandle);
                break;
            }
            case 218: {
                field = new MFTime(fieldHandle);
                break;
            }
            case 223: {
                field = new MFVec2f(fieldHandle);
                break;
            }
            case 224: {
                field = new MFVec3f(fieldHandle);
            }
        }
        return field;
    }

    protected double getTimestamp() {
        if (PassiveScriptImpl.getCurrentScript() != null && Thread.currentThread() == PassiveScriptImpl.getCurrentThread()) {
            return PassiveScriptImpl.getCurrentTime();
        }
        return this.makeTimeStamp();
    }

    protected native void addValueFloat(float[] var1);

    protected native void insertValueString(int var1, String var2);

    protected native void setValueInt(int var1);

    protected native int getValueInt();

    protected native int get1ValueInt(int var1);

    protected native void set1ValueInt(int var1, int var2);

    public String toString() {
        Field field = null;
        switch (this.getFieldType()) {
            case 216: {
                field = new SFColor();
                break;
            }
            case 217: {
                field = new SFFloat();
                break;
            }
            case 219: {
                field = new SFInt32();
                break;
            }
            case 220: {
                field = new SFNode();
                break;
            }
            case 221: {
                field = new SFRotation();
                break;
            }
            case 222: {
                field = new SFString();
                break;
            }
            case 218: {
                field = new SFTime();
                break;
            }
            case 223: {
                field = new SFVec2f();
                break;
            }
            case 224: {
                field = new SFVec3f();
            }
        }
        if (field == null) {
            return super.toString();
        }
        field.setBrowser(this.getBrowser());
        String string = new String("[ ");
        int n = 0;
        int n2 = this.getSize();
        while (n < n2) {
            if (n != 0) {
                string = string + ", ";
            }
            this.get1ValueField(n, field);
            string = string + field.toString();
            ++n;
        }
        string = string + " ]";
        return string;
    }

    protected native int getImageComponents();

    protected native int getImageWidth();

    protected native double get1ValueDouble(int var1);

    protected native void set1ValueDouble(int var1, double var2);

    protected native void addValueField(Field var1);

    protected native void setValueDouble(double var1);

    protected native double getValueDouble();

    protected native void insertValueFloat(int var1, float[] var2);

    protected native void setValueNode(int var1);

    protected native int getValueNode();

    protected native int get1ValueNode(int var1);

    protected native void set1ValueNode(int var1, int var2);

    protected native void setValueString(String var1);

    protected native String getValueString();

    protected native String get1ValueString(int var1);

    protected native void set1ValueString(int var1, String var2);

    public Browser getBrowser() {
        if (this.browser == null) {
            try {
                throw new RuntimeException("browser == null");
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace(System.err);
                throw runtimeException;
            }
        }
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    private native void Propagate(double var1);

    protected native void setValueFloat(float[] var1);

    protected native void getValueFloat(float[] var1);

    protected native void get1ValueFloat(int var1, float[] var2);

    protected native void set1ValueFloat(int var1, float[] var2);

    public static native int getCategory(int var0);

    protected native void setValueImage(int var1, int var2, int var3, byte[] var4);

    protected native void getImagePixels(byte[] var1);

    public static FieldHandle makeFieldHandle(int n) {
        PassiveScriptImpl passiveScriptImpl = PassiveScriptImpl.getCurrentScript();
        if (passiveScriptImpl == null) {
            passiveScriptImpl = PassiveScriptFactoryImpl.getRandomScript();
        }
        Browser browser = passiveScriptImpl.getBrowser();
        int n2 = passiveScriptImpl.makeFieldHandle(n);
        return new FieldHandle(n2, n2, browser);
    }

    private Field(int n) {
        super(n);
        this.category = Field.getCategory(n);
    }

    public Field(FieldHandle fieldHandle) {
        super(fieldHandle.getValue());
        this.category = Field.getCategory(fieldHandle.getValue());
        if (fieldHandle.getEventInValue() != 0) {
            if (fieldHandle.getEventInValue() == fieldHandle.getValue()) {
                this.eventIn = this;
            } else {
                this.eventIn = Field.makeConstField(fieldHandle.getEventInValue(), this.getFieldType(), fieldHandle.getBrowser());
                this.category = 1;
            }
        }
        this.setBrowser(fieldHandle.getBrowser());
    }

    protected native void addValueDouble(double var1);

    public static ConstField makeConstField(int n, int n2, Browser browser) {
        if (browser == null) {
            try {
                throw new IllegalArgumentException("browser");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace(System.err);
                throw illegalArgumentException;
            }
        }
        ConstField constField = null;
        FieldHandle fieldHandle = new FieldHandle(n, browser);
        switch (n2) {
            case 202: {
                constField = new ConstSFBool(fieldHandle);
                break;
            }
            case 203: {
                constField = new ConstSFColor(fieldHandle);
                break;
            }
            case 205: {
                constField = new ConstSFFloat(fieldHandle);
                break;
            }
            case 206: {
                constField = new ConstSFImage(fieldHandle);
                break;
            }
            case 207: {
                constField = new ConstSFInt32(fieldHandle);
                break;
            }
            case 209: {
                constField = new ConstSFNode(fieldHandle);
                break;
            }
            case 210: {
                constField = new ConstSFRotation(fieldHandle);
                break;
            }
            case 211: {
                constField = new ConstSFString(fieldHandle);
                break;
            }
            case 212: {
                constField = new ConstSFVec2f(fieldHandle);
                break;
            }
            case 213: {
                constField = new ConstSFVec3f(fieldHandle);
                break;
            }
            case 215: {
                constField = new ConstSFTime(fieldHandle);
                break;
            }
            case 216: {
                constField = new ConstMFColor(fieldHandle);
                break;
            }
            case 217: {
                constField = new ConstMFFloat(fieldHandle);
                break;
            }
            case 219: {
                constField = new ConstMFInt32(fieldHandle);
                break;
            }
            case 220: {
                constField = new ConstMFNode(fieldHandle);
                break;
            }
            case 221: {
                constField = new ConstMFRotation(fieldHandle);
                break;
            }
            case 222: {
                constField = new ConstMFString(fieldHandle);
                break;
            }
            case 218: {
                constField = new ConstMFTime(fieldHandle);
                break;
            }
            case 223: {
                constField = new ConstMFVec2f(fieldHandle);
                break;
            }
            case 224: {
                constField = new ConstMFVec3f(fieldHandle);
            }
        }
        return constField;
    }

    protected native void insertValueField(int var1, Field var2);

    protected native void addValueNode(int var1);

    protected native void setValueDoubleArray(int var1, double[] var2);

    public native void clear();

    protected native void getValueDoubleArray(double[] var1);

    protected native void setValueIntArray(int var1, int[] var2);

    protected native void getValueIntArray(int[] var1);

    public native void delete(int var1);

    protected native void addValueInt(int var1);

    protected native void setValueNodeArray(int var1, int[] var2);

    protected native void getValueNodeArray(int[] var1);

    protected native void setValueStringArray(int var1, String[] var2);

    protected native void getValueStringArray(String[] var1);

    private native void OnSignal(int var1, double var2);

    public int getFieldType() {
        return Field.getFieldType(this.getHandle());
    }
}

