/*
 * Decompiled with CFR 0.152.
 */
package com.parallelgraphics.cortona.vrml;

import com.parallelgraphics.cortona.Debug;
import com.parallelgraphics.cortona.PassiveScript;
import com.parallelgraphics.cortona.Utilities;
import com.parallelgraphics.cortona.vrml.GuessWhatLoader;
import com.parallelgraphics.cortona.vrml.PassiveScriptFactoryImpl;
import java.net.URL;
import vrml.Browser;
import vrml.Event;
import vrml.VrmlObject;
import vrml.node.Script;

public class PassiveScriptImpl
extends VrmlObject
implements PassiveScript {
    PassiveScriptFactoryImpl factory;
    Browser browser;
    Script script;
    URL url;
    private static PassiveScriptImpl currentScript;
    private static double currentTime;
    private static Thread currentThread;
    private static final int INITIALIZE = 0;
    private static final int SHUTDOWN = 1;
    private static final int PROCESS_EVENTS = 2;
    private static final int CONSTRUCT = 3;

    public static double getCurrentTime() {
        return currentTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Exception callUser(int n, double d, Object object) {
        try {
            currentScript = this;
            currentThread = Thread.currentThread();
            currentTime = d;
            try {
                switch (n) {
                    case 3: {
                        this.script = (Script)((Class)object).newInstance();
                        return null;
                    }
                    case 0: {
                        this.script.initialize();
                        return null;
                    }
                    case 1: {
                        this.script.shutdown();
                        return null;
                    }
                    case 2: {
                        Event[] eventArray = (Event[])object;
                        int n2 = eventArray != null ? eventArray.length : 0;
                        this.script.processEvents(n2, eventArray);
                        if (n2 <= 0) return null;
                        this.script.eventsProcessed();
                        return null;
                    }
                }
                return null;
            }
            finally {
                Object var8_7 = null;
                currentTime = 0.0;
                currentThread = null;
                currentScript = null;
            }
        }
        catch (Exception exception) {
            Debug.reportException(exception);
            return exception;
        }
    }

    private native void notifyPeer(boolean var1);

    public void initialize() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "initialize");
        }
        this.factory.whenScriptInitialized(this);
        this.callUser(0, this.makeTimeStamp(), null);
    }

    public void execute() {
        int n = this.getEventCount();
        Event[] eventArray = n > 0 ? new Event[n] : null;
        double d = 0.0;
        int n2 = 0;
        while (n > n2) {
            Event event = new Event();
            this.getNextEvent(event);
            event.Init(this.script.getBrowser());
            double d2 = event.getTimeStamp();
            if (d < d2) {
                d = d2;
            }
            eventArray[n2] = event;
            ++n2;
        }
        if (0.0 == d) {
            d = this.makeTimeStamp();
        }
        this.callUser(2, d, eventArray);
    }

    public void whenLoadingSucceeded(Class clazz) {
        Exception exception;
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "whenLoadingSucceeded", clazz.getName());
        }
        if ((exception = this.callUser(3, this.makeTimeStamp(), clazz)) != null) {
            this.whenLoadingFailed(exception);
        }
        this.script.assign(this.getHandle());
        Browser browser = new Browser();
        browser.setHandle(this.script.getBrowserHandle());
        browser.setBaseURL(this.getURL());
        this.setBrowser(browser);
        this.script.setBrowser(browser);
        this.notifyPeer(true);
    }

    public static Thread getCurrentThread() {
        return currentThread;
    }

    public void stopLoading() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "stopLoading");
        }
        GuessWhatLoader.stopLoading(this);
    }

    public PassiveScriptImpl() {
        super(0);
    }

    public void whenLoadingFailed(Throwable throwable) {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "whenLoadingFailed");
            Debug.reportException(throwable);
        }
        this.notifyPeer(false);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    private native int getEventCount();

    public void load(String string, String string2) {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "load", Utilities.formatString(string) + ", " + Utilities.formatString(string2));
        }
        try {
            this.url = Utilities.cookURL(Utilities.cookURL(string), string2);
            GuessWhatLoader.load(this);
            return;
        }
        catch (Throwable throwable) {
            this.whenLoadingFailed(throwable);
            return;
        }
    }

    private native void getNextEvent(Event var1);

    public PassiveScriptFactoryImpl getScriptFactory() {
        return this.factory;
    }

    public void setScriptFactory(PassiveScriptFactoryImpl passiveScriptFactoryImpl) {
        this.factory = passiveScriptFactoryImpl;
    }

    public URL getURL() {
        return this.url;
    }

    public static PassiveScriptImpl getCurrentScript() {
        return currentScript;
    }

    public int getPeer() {
        return this.getHandle();
    }

    public void setPeer(int n) {
        this.assign(n);
    }

    public native int makeFieldHandle(int var1);

    public void shutdown() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "shutdown");
        }
        this.callUser(1, this.makeTimeStamp(), null);
        this.factory.whenScriptShutdown(this);
    }
}

