/*
 * Decompiled with CFR 0.152.
 */
package com.parallelgraphics.cortona.vrml;

import com.parallelgraphics.cortona.Debug;
import com.parallelgraphics.cortona.PassiveScript;
import com.parallelgraphics.cortona.PassiveScriptFactory;
import com.parallelgraphics.cortona.Settings;
import com.parallelgraphics.cortona.Utilities;
import com.parallelgraphics.cortona.vrml.BrowserAware;
import com.parallelgraphics.cortona.vrml.PassiveScriptImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import vrml.Browser;

public class PassiveScriptFactoryImpl
implements PassiveScriptFactory {
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private static Hashtable scripts;

    public static PassiveScriptImpl getRandomScript() {
        Enumeration enumeration = scripts.keys();
        if (enumeration.hasMoreElements()) {
            return (PassiveScriptImpl)enumeration.nextElement();
        }
        return null;
    }

    public void initialize() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "initialize");
        }
    }

    private void redirectStdOut(Browser browser) {
        Object object = Utilities.newObject(Settings.getStdOutClassName());
        if (object instanceof BrowserAware) {
            ((BrowserAware)object).setBrowser(browser);
        }
        if (object instanceof OutputStream) {
            PrintStream printStream = System.out;
            System.setOut(new PrintStream((OutputStream)object));
            this.out = printStream;
        }
    }

    private void restoreStdOut() {
        if (this.out != null) {
            PrintStream printStream = System.out;
            System.setOut(this.out);
            this.out = null;
            printStream.close();
        }
    }

    public PassiveScript createScript() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "createPassiveScript");
        }
        PassiveScriptImpl passiveScriptImpl = new PassiveScriptImpl();
        passiveScriptImpl.setScriptFactory(this);
        return passiveScriptImpl;
    }

    private void redirectStdIn(Browser browser) {
        Object object = Utilities.newObject(Settings.getStdInClassName());
        if (object instanceof BrowserAware) {
            ((BrowserAware)object).setBrowser(browser);
        }
        if (object instanceof InputStream) {
            InputStream inputStream = System.in;
            System.setIn((InputStream)object);
            this.in = inputStream;
        }
    }

    private void restoreStdIn() {
        if (this.in != null) {
            InputStream inputStream = System.in;
            System.setIn(this.in);
            this.in = null;
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public void whenScriptShutdown(PassiveScriptImpl passiveScriptImpl) {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "whenScriptShutdown");
        }
        if (scripts.remove(passiveScriptImpl) != null && scripts.size() == 0) {
            this.restoreStandardStreams();
        }
    }

    private void redirectStandardStreams(Browser browser) {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "redirectStandardStreams");
        }
        this.redirectStdIn(browser);
        this.redirectStdOut(browser);
        this.redirectStdErr(browser);
    }

    private void restoreStandardStreams() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "restoreStandardStreams");
        }
        this.restoreStdErr();
        this.restoreStdOut();
        this.restoreStdIn();
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.ms.net.wininet.WininetStreamHandlerFactory");
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)clazz.newInstance());
        }
        catch (Throwable throwable) {}
        try {
            System.loadLibrary("cortjava");
        }
        catch (Throwable throwable) {}
        scripts = new Hashtable();
    }

    public void whenScriptInitialized(PassiveScriptImpl passiveScriptImpl) {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "whenScriptInitialized");
        }
        if (scripts.put(passiveScriptImpl, passiveScriptImpl) == null && 1 == scripts.size()) {
            this.redirectStandardStreams(passiveScriptImpl.getBrowser());
        }
    }

    private void redirectStdErr(Browser browser) {
        Object object = Utilities.newObject(Settings.getStdErrClassName());
        if (object instanceof BrowserAware) {
            ((BrowserAware)object).setBrowser(browser);
        }
        if (object instanceof OutputStream) {
            PrintStream printStream = System.err;
            System.setErr(new PrintStream((OutputStream)object));
            this.err = printStream;
        }
    }

    private void restoreStdErr() {
        if (this.err != null) {
            PrintStream printStream = System.err;
            System.setErr(this.err);
            this.err = null;
            printStream.close();
        }
    }

    public void shutdown() {
        if (Debug.isTracingEnabled(2)) {
            Debug.traceMethod(this, "shutdown");
        }
    }
}

