/*
 * Decompiled with CFR 0.152.
 */
package com.parallelgraphics.cortona.vrml;

import com.parallelgraphics.cortona.Debug;
import com.parallelgraphics.cortona.Settings;
import com.parallelgraphics.cortona.Utilities;
import com.parallelgraphics.cortona.vrml.ClassLoaderFactory;
import com.parallelgraphics.cortona.vrml.ClassLocation;
import com.parallelgraphics.cortona.vrml.PassiveScriptImpl;
import java.util.Vector;

public class GuessWhatLoader
extends Thread
implements Runnable {
    private static ClassLoaderFactory factory;
    private PassiveScriptImpl script;
    private static Vector scripts;
    private static Vector idleLoaders;
    private static Vector busyLoaders;
    private static int N;
    private static boolean synchronousLoading;
    private static /* synthetic */ Class class$com$parallelgraphics$cortona$vrml$GuessWhatLoader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void stopLoading(PassiveScriptImpl passiveScriptImpl) {
        if (Debug.isTracingEnabled(4)) {
            Debug.traceStaticMethod(class$com$parallelgraphics$cortona$vrml$GuessWhatLoader != null ? class$com$parallelgraphics$cortona$vrml$GuessWhatLoader : (class$com$parallelgraphics$cortona$vrml$GuessWhatLoader = GuessWhatLoader.class$("com.parallelgraphics.cortona.vrml.GuessWhatLoader")), "stopLoading", Utilities.formatObject(passiveScriptImpl));
        }
        Vector vector = scripts;
        synchronized (vector) {
            Object object;
            int n = busyLoaders.size() - 1;
            while (n >= 0) {
                object = (GuessWhatLoader)busyLoaders.elementAt(n);
                if (passiveScriptImpl == ((GuessWhatLoader)object).script) {
                    busyLoaders.removeElementAt(n);
                    ((Thread)object).stop();
                    return;
                }
                --n;
            }
            n = scripts.size() - 1;
            while (n >= 0) {
                object = (PassiveScriptImpl)scripts.elementAt(n);
                if (passiveScriptImpl == object) {
                    scripts.removeElementAt(n);
                    return;
                }
                --n;
            }
            return;
        }
    }

    private static void putRequest(PassiveScriptImpl passiveScriptImpl) {
        Vector vector = scripts;
        synchronized (vector) {
            block3: {
                scripts.addElement(passiveScriptImpl);
                scripts.notifyAll();
                if (idleLoaders.size() != 0 || 3 <= busyLoaders.size()) break block3;
                GuessWhatLoader guessWhatLoader = new GuessWhatLoader();
                idleLoaders.addElement(guessWhatLoader);
                guessWhatLoader.setDaemon(true);
                guessWhatLoader.start();
            }
            Object var3_3 = null;
            return;
        }
    }

    private boolean getRequest() {
        long l = Settings.getGuessWhatLoaderTimeout();
        Vector vector = scripts;
        synchronized (vector) {
            long l2 = System.currentTimeMillis();
            while (scripts.size() <= 0 && 0L < l) {
                try {
                    scripts.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                long l3 = System.currentTimeMillis() - l2;
                l -= l3;
            }
            idleLoaders.removeElement(this);
            if (scripts.size() > 0) {
                this.script = (PassiveScriptImpl)scripts.elementAt(0);
                scripts.removeElementAt(0);
                busyLoaders.addElement(this);
                boolean bl = true;
                Object var8_7 = null;
                return bl;
            }
            boolean bl = false;
            Object var8_8 = null;
            return bl;
        }
    }

    private static void processRequest(PassiveScriptImpl passiveScriptImpl) {
        if (Debug.isTracingEnabled(4)) {
            Debug.traceStaticMethod(class$com$parallelgraphics$cortona$vrml$GuessWhatLoader != null ? class$com$parallelgraphics$cortona$vrml$GuessWhatLoader : (class$com$parallelgraphics$cortona$vrml$GuessWhatLoader = GuessWhatLoader.class$("com.parallelgraphics.cortona.vrml.GuessWhatLoader")), "processRequest", Utilities.formatURL(passiveScriptImpl.getURL()));
        }
        try {
            ClassLoaderFactory classLoaderFactory = GuessWhatLoader.getClassLoaderFactory();
            ClassLocation classLocation = classLoaderFactory.parseURL(passiveScriptImpl.getURL());
            ClassLoader classLoader = classLoaderFactory.getClassLoader(classLocation);
            Class<?> clazz = classLoader.loadClass(classLocation.name);
            passiveScriptImpl.whenLoadingSucceeded(clazz);
            return;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            passiveScriptImpl.whenLoadingFailed(throwable);
            return;
        }
    }

    private void processRequest() {
        GuessWhatLoader.processRequest(this.script);
        Vector vector = scripts;
        synchronized (vector) {
            busyLoaders.removeElement(this);
            this.script = null;
            idleLoaders.addElement(this);
            Object var2_2 = null;
            return;
        }
    }

    public static void load(PassiveScriptImpl passiveScriptImpl) {
        if (Debug.isTracingEnabled(4)) {
            Debug.traceStaticMethod(class$com$parallelgraphics$cortona$vrml$GuessWhatLoader != null ? class$com$parallelgraphics$cortona$vrml$GuessWhatLoader : (class$com$parallelgraphics$cortona$vrml$GuessWhatLoader = GuessWhatLoader.class$("com.parallelgraphics.cortona.vrml.GuessWhatLoader")), "load", Utilities.formatObject(passiveScriptImpl));
        }
        if (synchronousLoading) {
            GuessWhatLoader.processRequest(passiveScriptImpl);
            return;
        }
        GuessWhatLoader.putRequest(passiveScriptImpl);
    }

    static {
        scripts = new Vector();
        idleLoaders = new Vector();
        busyLoaders = new Vector();
        N = Settings.getMaximumGuessWhatLoaderCount();
        synchronousLoading = N <= 0;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void run() {
        if (Debug.isTracingEnabled(4)) {
            Debug.beginMethod(this, "run");
        }
        while (this.getRequest()) {
            this.processRequest();
        }
        if (Debug.isTracingEnabled(4)) {
            Debug.endMethod(this, "run");
        }
    }

    public static synchronized ClassLoaderFactory getClassLoaderFactory() {
        if (factory != null) {
            return factory;
        }
        String string = Settings.getProperty("com.parallelgraphics.cortona.vrml.ClassLoaderFactory.class", "com.parallelgraphics.cortona.vrml.ClassLoaderFactoryImpl");
        try {
            Class<?> clazz = Class.forName(string);
            return (ClassLoaderFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            if (Debug.isTracingEnabled(4)) {
                Debug.reportException(throwable, null);
            }
            return null;
        }
    }
}

