/*
 * Decompiled with CFR 0.152.
 */
package com.parallelgraphics.cortona;

import com.ms.lang.RegKey;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Settings {
    private static Properties properties;
    private static boolean registryQueried;
    private static int tracingMask;

    public static String getProperty(String string, String string2) {
        Properties properties = Settings.getProperties();
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static synchronized int getTracingMask() {
        if (!registryQueried) {
            registryQueried = true;
            try {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                RegKey regKey = new RegKey(3, "SOFTWARE\\ParallelGraphics\\Cortona\\Debug", 1);
                tracingMask = regKey.getIntValue("trace", 0);
            }
            catch (Throwable throwable) {}
        }
        return tracingMask;
    }

    public static String getStdInClassName() {
        return Settings.getProperty("com.parallelgraphics.cortona.stdIn.class", "com.parallelgraphics.cortona.vrml.ConsoleInputStream");
    }

    public static String getStdOutClassName() {
        return Settings.getProperty("com.parallelgraphics.cortona.stdOut.class", "com.parallelgraphics.cortona.vrml.ConsoleOutputStream");
    }

    public static int getIntProperty(String string, int n) {
        Properties properties = Settings.getProperties();
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public static synchronized Properties getProperties() {
        if (properties != null) {
            return properties;
        }
        properties = new Properties();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("vrml.properties");
        if (inputStream != null) {
            try {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static String getStdErrClassName() {
        return Settings.getProperty("com.parallelgraphics.cortona.stdErr.class", "com.parallelgraphics.cortona.vrml.ConsoleOutputStream");
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        Properties properties = Settings.getProperties();
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }

    public static String getCLSID() {
        return Settings.getProperty("com.parallelgraphics.cortona.Control.CLSID", "{86A88967-7A20-11D2-8EDA-00600818EDB1}");
    }

    public static long getGuessWhatLoaderTimeout() {
        return Settings.getIntProperty("com.parallelgraphics.cortona.GuessWhatLoader.timeout", 3000);
    }

    public static int getMaximumGuessWhatLoaderCount() {
        return Settings.getIntProperty("com.parallelgraphics.cortona.GuessWhatLoader.count", 1);
    }

    public static synchronized boolean getDebug() {
        return Settings.getTracingMask() != 0;
    }
}

