/*
 * Decompiled with CFR 0.152.
 */
package com.parallelgraphics.cortona;

import com.parallelgraphics.cortona.Settings;

public class Debug {
    private static int tracingMask = Settings.getTracingMask();
    public static final int TRACE_USER_ERRORS = 1;
    public static final int TRACE_SCRIPT = 2;
    public static final int TRACE_CLASSLOADER = 4;
    public static final int TRACE_UTILITIES = 8;

    public static void trace(String string, Class clazz, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        stringBuffer.append(clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(')');
        if (string4 != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string4);
        } else {
            stringBuffer.append(';');
        }
        Debug.trace(stringBuffer.toString());
    }

    public static void endStaticMethod(Class clazz, String string, String string2) {
        Debug.trace("end", clazz, string, null, string2);
    }

    public static void endStaticMethod(Class clazz, String string) {
        Debug.endStaticMethod(clazz, string, null);
    }

    public static void traceMethod(Object object, String string, String string2) {
        Debug.traceStaticMethod(object.getClass(), string, string2);
    }

    public static void traceMethod(Object object, String string) {
        Debug.traceMethod(object, string, null);
    }

    public static void traceStaticMethod(Class clazz, String string, String string2) {
        Debug.trace(null, clazz, string, string2, null);
    }

    public static void traceStaticMethod(Class clazz, String string) {
        Debug.traceStaticMethod(clazz, string, null);
    }

    public static boolean isTracingEnabled(int n) {
        return (tracingMask & n) != 0;
    }

    public static void reportException(Throwable throwable, String string) {
        if (string != null && !"".equals(string)) {
            System.err.println(string);
        }
        throwable.printStackTrace(System.err);
    }

    public static void beginMethod(Object object, String string, String string2) {
        Debug.beginStaticMethod(object.getClass(), string, string2);
    }

    public static void beginMethod(Object object, String string) {
        Debug.beginMethod(object, string, null);
    }

    public static void reportException(Throwable throwable) {
        Debug.reportException(throwable, null);
    }

    public static void beginStaticMethod(Class clazz, String string, String string2) {
        Debug.trace("begin", clazz, string, string2, null);
    }

    public static void beginStaticMethod(Class clazz, String string) {
        Debug.beginStaticMethod(clazz, string, null);
    }

    public static void endMethod(Object object, String string, String string2) {
        Debug.endStaticMethod(object.getClass(), string, string2);
    }

    public static void endMethod(Object object, String string) {
        Debug.endMethod(object, string, null);
    }

    public static void trace(String string) {
        if (tracingMask != 0) {
            System.out.println(string);
        }
    }
}

