/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import vrml.Event;
import vrml.field.MFString;
import vrml.field.SFVec3f;
import vrml.node.Script;

public class Project4
extends Script {
    double xPos;
    double yPos;
    double zPos;
    double xPosDR;
    double yPosDR;
    double zPosDR;
    float xVel;
    float yVel;
    float zVel;
    float oldXVel;
    float oldYVel;
    float oldZVel;
    float xAcc;
    float yAcc;
    float zAcc;
    int loopsCompleted;
    DISSender sender;
    pduReader reader;
    long packetTime;
    SFVec3f position;
    MFString message;
    String[] text;
    boolean validVelocity;
    boolean validAcceleration;

    public void initialize() {
        this.validVelocity = false;
        this.validAcceleration = false;
        this.position = (SFVec3f)this.getEventOut("position_changed");
        this.position.setValue(-5.0f, 0.0f, 0.0f);
        this.message = (MFString)this.getEventOut("text_changed");
        this.text = new String[1];
        this.text[0] = "Initial Message";
        this.message.setValue(this.text);
        this.reader = new pduReader(this, this);
        Thread readerThread = new Thread(this.reader);
        readerThread.start();
        this.xVel = 0.0f;
        this.yVel = 0.0f;
        this.zVel = 0.0f;
        this.oldXVel = 0.0f;
        this.oldYVel = 0.0f;
        this.oldZVel = 0.0f;
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.zPos = 0.0;
        this.xAcc = 0.0f;
        this.yAcc = 0.0f;
        this.zAcc = 0.0f;
        this.sender = new DISSender();
        Thread senderThread = new Thread(this.sender);
        senderThread.start();
    }

    public void processEvent(Event e) {
        double elapsedTime = (double)(System.currentTimeMillis() - this.packetTime) / 1000.0;
        if (e.getName().equals("set_time")) {
            if (this.validAcceleration) {
                switch (this.loopsCompleted % 3) {
                    case 0: {
                        this.xPosDR = this.xPos + (double)this.xVel * elapsedTime;
                        this.yPosDR = this.yPos + (double)this.yVel * elapsedTime;
                        this.zPosDR = this.zPos + (double)this.zVel * elapsedTime;
                        this.text[0] = "Instantaneous Velocity";
                        break;
                    }
                    case 1: {
                        this.xPosDR = this.xPos + (double)this.xVel * elapsedTime + (double)(this.xVel - this.oldXVel) * elapsedTime * elapsedTime * 0.5;
                        this.yPosDR = this.yPos + (double)this.yVel * elapsedTime + (double)(this.yVel - this.oldYVel) * elapsedTime * elapsedTime * 0.5;
                        this.zPosDR = this.zPos + (double)this.zVel * elapsedTime + (double)(this.zVel - this.oldZVel) * elapsedTime * elapsedTime * 0.5;
                        this.text[0] = "Approximated Acceleration";
                        break;
                    }
                    case 2: {
                        this.xPosDR = this.xPos + (double)this.xVel * elapsedTime + (double)this.xAcc * elapsedTime * elapsedTime * 0.5;
                        this.yPosDR = this.yPos + (double)this.yVel * elapsedTime + (double)this.yAcc * elapsedTime * elapsedTime * 0.5;
                        this.zPosDR = this.zPos + (double)this.zVel * elapsedTime + (double)this.zAcc * elapsedTime * elapsedTime * 0.5;
                        this.text[0] = "Instantaneous Acceleration";
                    }
                }
            } else if (this.validAcceleration) {
                this.xPosDR = this.xPos + (double)this.xVel * elapsedTime;
                this.yPosDR = this.yPos + (double)this.yVel * elapsedTime;
                this.zPosDR = this.zPos + (double)this.zVel * elapsedTime;
            }
            this.position.setValue(new Double(this.xPosDR).floatValue(), new Double(this.yPosDR).floatValue(), new Double(this.zPosDR).floatValue());
            this.message.setValue(this.text);
        }
    }

    public void setMovementParameters(double newXPos, double newYPos, double newZPos, float newXVel, float newYVel, float newZVel, float newXAcc, float newYAcc, float newZAcc, int newLoopsCompleted) {
        this.oldXVel = this.xVel;
        this.oldYVel = this.yVel;
        this.oldZVel = this.zVel;
        this.xVel = newXVel;
        this.yVel = newYVel;
        this.zVel = newZVel;
        this.xPos = newXPos;
        this.yPos = newYPos;
        this.zPos = newZPos;
        this.xAcc = newXAcc;
        this.yAcc = newYAcc;
        this.zAcc = newZAcc;
        this.loopsCompleted = newLoopsCompleted;
        this.packetTime = System.currentTimeMillis();
        if (this.validVelocity) {
            this.validAcceleration = true;
        }
        this.validVelocity = true;
    }

    class pduReader
    extends Project4
    implements Runnable {
        DatagramSocket socket;
        DatagramPacket packet;
        Project4 parent;
        byte[] buffer;
        ByteArrayInputStream bais;
        DataInputStream dis;
        double px;
        double py;
        double pz;
        float vx;
        float vy;
        float vz;
        float ax;
        float ay;
        float az;
        int loopsCompleted;

        public pduReader(Project4 this$0, Project4 pParent) {
            this.parent = pParent;
            try {
                this.socket = new DatagramSocket(7777);
            }
            catch (Exception e) {
                System.out.println("Error establishing socket in pduReader:".concat(String.valueOf(String.valueOf(e))));
                System.exit(-1);
            }
        }

        public void run() {
            while (true) {
                this.buffer = new byte[144];
                try {
                    this.packet = new DatagramPacket(this.buffer, 144);
                    this.socket.receive(this.packet);
                    this.bais = new ByteArrayInputStream(this.buffer);
                    this.dis = new DataInputStream(this.bais);
                    this.dis.skipBytes(36);
                    this.vx = this.dis.readFloat();
                    this.vy = this.dis.readFloat();
                    this.vz = this.dis.readFloat();
                    this.px = this.dis.readDouble();
                    this.py = this.dis.readDouble();
                    this.pz = this.dis.readDouble();
                    this.dis.skipBytes(16);
                    this.ax = this.dis.readFloat();
                    this.ay = this.dis.readFloat();
                    this.az = this.dis.readFloat();
                    this.dis.skipBytes(40);
                    this.loopsCompleted = this.dis.readInt();
                }
                catch (Exception e) {
                    System.out.println("Error trying to read a packet from the socket in pduReader: ".concat(String.valueOf(String.valueOf(e))));
                    System.exit(-1);
                }
                this.parent.setMovementParameters(this.px, this.py, this.pz, this.vx, this.vy, this.vz, this.ax, this.ay, this.az, this.loopsCompleted);
            }
        }
    }
}

