/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DISSender
implements Runnable {
    DatagramSocket socket;
    DatagramPacket packet;
    ByteArrayOutputStream baos;
    DataOutputStream dos;
    byte[] buffer;
    InetAddress address;
    long startTime;
    long currentTime;
    long sleepTime;
    double cycleTime;
    double lx;
    double ly;
    double lz;
    float vx;
    float vy;
    float vz;
    float ax;
    float ay;
    float az;
    int loopsCompleted;

    public DISSender() {
        try {
            this.address = InetAddress.getLocalHost();
            this.socket = new DatagramSocket(7776);
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
        catch (Exception e) {
            System.out.println("Exception error in DISSender constructor.");
            System.out.print(e);
        }
        this.startTime = System.currentTimeMillis();
        this.lx = -5.0;
        this.ly = 0.0;
        this.lz = 0.0;
        this.vx = 0.0f;
        this.vy = 0.0f;
        this.vz = 0.0f;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.az = 0.0f;
        this.cycleTime = 5000.0;
        this.sleepTime = 1000L;
    }

    public DatagramPacket createDISPacket() {
        this.baos.reset();
        try {
            this.dos.writeByte(5);
            this.dos.writeByte(1);
            this.dos.writeByte(1);
            this.dos.writeByte(1);
            this.dos.writeInt(0);
            this.dos.writeShort(144);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeShort(0);
            this.dos.writeShort(0);
            this.dos.writeShort(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(2);
            this.dos.writeByte(6);
            this.dos.writeShort(0);
            this.dos.writeByte(3);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeDouble(0.0);
            this.dos.writeFloat(this.vx);
            this.dos.writeFloat(this.vy);
            this.dos.writeFloat(this.vz);
            this.dos.writeDouble(this.lx);
            this.dos.writeDouble(this.ly);
            this.dos.writeDouble(this.lz);
            this.dos.writeFloat(0.0f);
            this.dos.writeFloat(0.0f);
            this.dos.writeFloat(0.0f);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeFloat(this.ax);
            this.dos.writeFloat(this.ay);
            this.dos.writeFloat(this.az);
            this.dos.writeFloat(0.0f);
            this.dos.writeDouble(0.0);
            this.dos.writeDouble(0.0);
            this.dos.writeDouble(0.0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeByte(0);
            this.dos.writeInt(this.loopsCompleted);
        }
        catch (Exception e) {
            System.out.println("Exception in createDISPacket.");
            System.out.print(e);
        }
        this.buffer = this.baos.toByteArray();
        return new DatagramPacket(this.buffer, this.buffer.length, this.address, 7777);
    }

    public void moveObject() {
        this.currentTime = System.currentTimeMillis();
        if ((double)(this.currentTime - this.startTime) > this.cycleTime) {
            this.startTime = (long)((double)this.startTime + this.cycleTime);
            ++this.loopsCompleted;
        }
        double fraction = (double)(this.currentTime - this.startTime) / this.cycleTime;
        double T = fraction * Math.PI * 2.0;
        this.lx = Math.sin(T) * 5.0;
        this.ly = Math.cos(T) * 5.0;
        this.vx = new Double(Math.cos(T)).floatValue() * 5.0f;
        this.vy = new Double(Math.sin(T)).floatValue() * -5.0f;
        this.ax = new Double(Math.sin(T)).floatValue() * -5.0f;
        this.ay = new Double(Math.cos(T)).floatValue() * -5.0f;
        this.packet = this.createDISPacket();
        try {
            this.socket.send(this.packet);
        }
        catch (Exception e) {
            System.out.println("Exception in moveObject");
            System.out.print(e);
        }
    }

    public void run() {
        while (true) {
            this.moveObject();
            try {
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (Exception e) {
                System.out.println("Error while sleeping in DISSender");
                continue;
            }
            break;
        }
    }
}

