/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.util.x3duom;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.util.x3duom.X3DUnifiedObjectModel;

public final class X3DUnifiedObjectModel40 {
    private X3DUnifiedObjectModel x3duomInstance;
    private final String X3dUnifiedObjectModel40_XML_FILE = "X3dUnifiedObjectModel-4.0.xml";
    private JAXBContext jaxbContext;

    public X3DUnifiedObjectModel40() {
        this.initialize();
    }

    public void initialize() {
        try {
            X3D x3dObject = new X3D();
            File x3duomXmlFile = X3D.getTempFileFromX3dJsailJar("/specifications", "X3dUnifiedObjectModel-4.0.xml");
            if (!x3duomXmlFile.exists()) {
                String errorNotice = "*** [error] X3DUnifiedObjectModel40.X3dUnifiedObjectModel40_XML_FILE=\"X3dUnifiedObjectModel-4.0.xml\" not found";
                System.out.println(errorNotice);
                return;
            }
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{X3DUnifiedObjectModel.class});
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            this.x3duomInstance = (X3DUnifiedObjectModel)unmarshaller.unmarshal(x3duomXmlFile);
        }
        catch (JAXBException e) {
            System.out.println("X3DUnifiedObjectModel initialize() failure:");
            System.out.println((Object)e);
        }
    }

    public void marshallToXmlFile(String outputFilePath) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)this.x3duomInstance, new File(outputFilePath));
        }
        catch (JAXBException e) {
            System.out.println("X3DUnifiedObjectModel40 marshalToXML() marshaller.setProperty failure:");
            System.out.println((Object)e);
        }
    }

    public String marshalToXml() {
        byte[] encodedByteArray = null;
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            File tempFile = File.createTempFile("x3duomJaxb", "temp.xml");
            marshaller.marshal((Object)this.x3duomInstance, tempFile);
            encodedByteArray = Files.readAllBytes(Paths.get(tempFile.getPath(), new String[0]));
        }
        catch (IOException | JAXBException e) {
            System.out.println("X3DUnifiedObjectModel40 marshalToXML() failure:");
            System.out.println(e);
        }
        return new String(encodedByteArray);
    }
}

