/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFVec4f
extends X3DConcreteField
implements org.web3d.x3d.sai.SFVec4f {
    public static final String NAME = "SFVec4f";
    public static final float[] DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static final String DEFAULT_VALUE_STRING = "0.0 0.0 0.0 1.0";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] SFVec4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFVec4f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFVec4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFVec4f comparisonSFVec4f) {
        if (comparisonSFVec4f == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFVec4f.getPrimitiveValue();
    }

    public boolean equals(float[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        SFVec4f tempHold = new SFVec4f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFVec4f validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec4f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec4f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec4f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFVec4f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFVec4f.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec4f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFVec4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 4) {
                String errorNotice = "*** illegal number of values in initialization string, new SFVec4f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFVec4f[0] = Float.parseFloat(newValues[0]);
            this.SFVec4f[1] = Float.parseFloat(newValues[1]);
            this.SFVec4f[2] = Float.parseFloat(newValues[2]);
            this.SFVec4f[3] = Float.parseFloat(newValues[3]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFVec4f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFVec4f(SFVec4f newValue) {
        if (newValue == null) {
            this.SFVec4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFVec4f = newValue.getPrimitiveValue();
    }

    public SFVec4f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFVec4f newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec4f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec4f = newValue;
    }

    public SFVec4f(float x, float y, float z, float w) {
        this.SFVec4f[0] = x;
        this.SFVec4f[1] = y;
        this.SFVec4f[2] = z;
        this.SFVec4f[3] = w;
    }

    public SFVec4f normalize() {
        float length = (float)Math.sqrt(this.SFVec4f[0] * this.SFVec4f[0] + this.SFVec4f[1] * this.SFVec4f[1] + this.SFVec4f[2] * this.SFVec4f[2] + this.SFVec4f[3] * this.SFVec4f[3]);
        if (length > 0.0f) {
            this.SFVec4f[0] = this.SFVec4f[0] / length;
            this.SFVec4f[1] = this.SFVec4f[1] / length;
            this.SFVec4f[2] = this.SFVec4f[2] / length;
            this.SFVec4f[3] = this.SFVec4f[3] / length;
        }
        return this;
    }

    public SFVec4f(double x, double y, double z, double t) {
        this.setValue((float)x, (float)y, (float)z, (float)t);
    }

    public SFVec4f(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.SFVec4f;
    }

    public float[] getPrimitiveValue() {
        return this.SFVec4f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFVec4f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFVec4f[i]));
            } else {
                result.append(this.SFVec4f[i]);
            }
            if (i >= this.SFVec4f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(float[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFVec4f newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec4f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec4f = newValue;
    }

    public SFVec4f setValueArray(float[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFVec4f setValue(double[] newValue) {
        float[] newFloatArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            newFloatArray[i] = (float)newValue[i];
        }
        this.setValue(newFloatArray);
        return this;
    }

    public SFVec4f setValue(float x, float y, float z, float t) {
        this.SFVec4f[0] = x;
        this.SFVec4f[1] = y;
        this.SFVec4f[2] = z;
        this.SFVec4f[3] = t;
        return this;
    }

    public SFVec4f setValue(double x, double y, double z, double t) {
        this.setValue((float)x, (float)y, (float)z, (float)t);
        return this;
    }

    public float[] toFloatArray() {
        return this.SFVec4f;
    }

    public SFVec4f setValue(SFVec4f newValue) {
        if (newValue == null) {
            this.SFVec4f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFVec4f = newValue.getPrimitiveValue();
        return this;
    }

    public SFVec4f multiply(float scaleFactor) {
        this.SFVec4f[0] = this.SFVec4f[0] * scaleFactor;
        this.SFVec4f[1] = this.SFVec4f[1] * scaleFactor;
        this.SFVec4f[2] = this.SFVec4f[2] * scaleFactor;
        this.SFVec4f[3] = this.SFVec4f[3] * scaleFactor;
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFVec4f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFVec4f(DEFAULT_VALUE).matches()) {
                System.out.println("SFVec4f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFVec4f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

