/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFVec4d
extends X3DConcreteField
implements org.web3d.x3d.sai.SFVec4d {
    public static final String NAME = "SFVec4d";
    public static final double[] DEFAULT_VALUE = new double[]{0.0, 0.0, 0.0, 1.0};
    public static final String DEFAULT_VALUE_STRING = "0.0 0.0 0.0 1.0";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] SFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFVec4d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFVec4d comparisonSFVec4d) {
        if (comparisonSFVec4d == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFVec4d.getPrimitiveValue();
    }

    public boolean equals(double[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        SFVec4d tempHold = new SFVec4d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFVec4d validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec4d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec4d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec4d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFVec4d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFVec4d.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec4d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 4) {
                String errorNotice = "*** illegal number of values in initialization string, new SFVec4d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFVec4d[0] = Double.parseDouble(newValues[0]);
            this.SFVec4d[1] = Double.parseDouble(newValues[1]);
            this.SFVec4d[2] = Double.parseDouble(newValues[2]);
            this.SFVec4d[3] = Double.parseDouble(newValues[3]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFVec4d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFVec4d(SFVec4d newValue) {
        if (newValue == null) {
            this.SFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFVec4d = newValue.getPrimitiveValue();
    }

    public SFVec4d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFVec4d newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec4d = newValue;
    }

    public SFVec4d(double x, double y, double z, double w) {
        this.SFVec4d[0] = x;
        this.SFVec4d[1] = y;
        this.SFVec4d[2] = z;
        this.SFVec4d[3] = w;
    }

    public SFVec4d normalize() {
        double length = Math.sqrt(this.SFVec4d[0] * this.SFVec4d[0] + this.SFVec4d[1] * this.SFVec4d[1] + this.SFVec4d[2] * this.SFVec4d[2] + this.SFVec4d[3] * this.SFVec4d[3]);
        if (length > 0.0) {
            this.SFVec4d[0] = this.SFVec4d[0] / length;
            this.SFVec4d[1] = this.SFVec4d[1] / length;
            this.SFVec4d[2] = this.SFVec4d[2] / length;
            this.SFVec4d[3] = this.SFVec4d[3] / length;
        }
        return this;
    }

    public SFVec4d(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.SFVec4d;
    }

    public double[] getPrimitiveValue() {
        return this.SFVec4d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFVec4d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.SFVec4d[i]));
            } else {
                result.append(this.SFVec4d[i]);
            }
            if (i >= this.SFVec4d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(double[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFVec4d newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec4d = newValue;
    }

    public SFVec4d setValueArray(double[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFVec4d setValue(float[] newValue) {
        double[] newDoubleArray = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            newDoubleArray[i] = newValue[i];
        }
        this.setValue(newDoubleArray);
        return this;
    }

    public SFVec4d setValue(double x, double y, double z, double t) {
        this.SFVec4d[0] = x;
        this.SFVec4d[1] = y;
        this.SFVec4d[2] = z;
        this.SFVec4d[3] = t;
        return this;
    }

    public double[] toDoubleArray() {
        return this.SFVec4d;
    }

    public SFVec4d setValue(SFVec4d newValue) {
        if (newValue == null) {
            this.SFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFVec4d = newValue.getPrimitiveValue();
        return this;
    }

    public SFVec4d multiply(double scaleFactor) {
        this.SFVec4d[0] = this.SFVec4d[0] * scaleFactor;
        this.SFVec4d[1] = this.SFVec4d[1] * scaleFactor;
        this.SFVec4d[2] = this.SFVec4d[2] * scaleFactor;
        this.SFVec4d[3] = this.SFVec4d[3] * scaleFactor;
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFVec4d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFVec4d(DEFAULT_VALUE).matches()) {
                System.out.println("SFVec4d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFVec4d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

