/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFVec2f
extends X3DConcreteField
implements org.web3d.x3d.sai.SFVec2f {
    public static final String NAME = "SFVec2f";
    public static final float[] DEFAULT_VALUE = new float[]{0.0f, 0.0f};
    public static final String DEFAULT_VALUE_STRING = "0.0 0.0";
    public static final int TUPLE_SIZE = 2;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] SFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFVec2f() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFVec2f comparisonSFVec2f) {
        if (comparisonSFVec2f == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFVec2f.getPrimitiveValue();
    }

    public boolean equals(float[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        SFVec2f tempHold = new SFVec2f(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFVec2f validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec2f PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec2f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFVec2f";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFVec2f setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFVec2f.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFVec2f(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 2) {
                String errorNotice = "*** illegal number of values in initialization string, new SFVec2f(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFVec2f[0] = Float.parseFloat(newValues[0]);
            this.SFVec2f[1] = Float.parseFloat(newValues[1]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFVec2f(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFVec2f(SFVec2f newValue) {
        if (newValue == null) {
            this.SFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFVec2f = newValue.getPrimitiveValue();
    }

    public SFVec2f(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "*** Illegal SFVec2f newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec2f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec2f = newValue;
    }

    public SFVec2f(float x, float y) {
        this.SFVec2f[0] = x;
        this.SFVec2f[1] = y;
    }

    public SFVec2f normalize() {
        float length = (float)Math.sqrt(this.SFVec2f[0] * this.SFVec2f[0] + this.SFVec2f[1] * this.SFVec2f[1]);
        if (length > 0.0f) {
            this.SFVec2f[0] = this.SFVec2f[0] / length;
            this.SFVec2f[1] = this.SFVec2f[1] / length;
        }
        return this;
    }

    public SFVec2f(double x, double y) {
        this.setValue((float)x, (float)y);
    }

    public SFVec2f(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.SFVec2f;
    }

    public float[] getPrimitiveValue() {
        return this.SFVec2f;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFVec2f.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFVec2f[i]));
            } else {
                result.append(this.SFVec2f[i]);
            }
            if (i >= this.SFVec2f.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(float[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 2) {
            String errorNotice = "*** Illegal SFVec2f newValue array length=" + newValue.length + ", must equal 2 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFVec2f.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFVec2f = newValue;
    }

    public SFVec2f setValueArray(float[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFVec2f setValue(double[] newValue) {
        float[] newFloatArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            newFloatArray[i] = (float)newValue[i];
        }
        this.setValue(newFloatArray);
        return this;
    }

    public SFVec2f setValue(float x, float y) {
        this.SFVec2f[0] = x;
        this.SFVec2f[1] = y;
        return this;
    }

    public SFVec2f setValue(double x, double y) {
        this.setValue((float)x, (float)y);
        return this;
    }

    public float[] toFloatArray() {
        return this.SFVec2f;
    }

    public SFVec2f setValue(SFVec2f newValue) {
        if (newValue == null) {
            this.SFVec2f = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFVec2f = newValue.getPrimitiveValue();
        return this;
    }

    public SFVec2f multiply(float scaleFactor) {
        this.SFVec2f[0] = this.SFVec2f[0] * scaleFactor;
        this.SFVec2f[1] = this.SFVec2f[1] * scaleFactor;
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFVec2f, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFVec2f(DEFAULT_VALUE).matches()) {
                System.out.println("SFVec2f.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFVec2f initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){1}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

