/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFString
extends X3DConcreteField
implements org.web3d.x3d.sai.SFString {
    public static final String NAME = "SFString";
    public static final String DEFAULT_VALUE = "";
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s|\\S)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s|\\S)*");
    private static boolean priorRegexStackOverflowFound = false;
    private String SFString = "";
    public static final String NameStartCharFilter = "A-Z_a-z";
    public static final String NameCharFilter = "A-Z_a-z-.0-9";
    public static final String NameFilter = "[A-Z_a-z][A-Z_a-z-.0-9]*";
    public static final String NmtokenFilter = "[A-Z_a-z-.0-9]+";

    public static final boolean isArray() {
        return false;
    }

    public SFString() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFString = "";
    }

    public static final boolean isNMTOKEN(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        boolean result = value.matches(NmtokenFilter);
        return result;
    }

    public static final boolean meetsX3dInteroperabilityNamingConventions(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        boolean result = value.matches("[a-zA-Z_][a-zA-Z0-9_]*");
        String prefix = new String();
        if (org.web3d.x3d.jsail.fields.SFString.isX3dNodeName(value)) {
            System.out.print("[warning]");
            if (!prefix.isBlank()) {
                System.out.print(" prefix='" + prefix + "'");
            }
            System.out.println(" name='" + value + "' matches an X3D node name, literal name collisions can have unexpected consequences");
            return false;
        }
        if (org.web3d.x3d.jsail.fields.SFString.isX3dStatementName(value)) {
            System.out.print("[warning]");
            if (!prefix.isBlank()) {
                System.out.print(" prefix='" + prefix + "'");
            }
            System.out.println(" name='" + value + "' matches an X3D statement name, literal name collisions can have unexpected consequences");
            return false;
        }
        if (value.equals("CML-version")) {
            return true;
        }
        if (value.equals("Sound") || value.equals("Text")) {
            return true;
        }
        return result;
    }

    public static boolean isX3dNodeName(String value) {
        boolean isReservedName = value.equals("AcousticProperties") || value.equals("Analyser") || value.equals("Anchor") || value.equals("Appearance") || value.equals("Arc2D") || value.equals("ArcClose2D") || value.equals("AudioClip") || value.equals("AudioDestination") || value.equals("Background") || value.equals("BallJoint") || value.equals("Billboard") || value.equals("BiquadFilter") || value.equals("BlendedVolumeStyle") || value.equals("BooleanFilter") || value.equals("BooleanSequencer") || value.equals("BooleanToggle") || value.equals("BooleanTrigger") || value.equals("BoundaryEnhancementVolumeStyle") || value.equals("BoundedPhysicsModel") || value.equals("Box") || value.equals("BufferAudioSource") || value.equals("CADAssembly") || value.equals("CADFace") || value.equals("CADLayer") || value.equals("CADPart") || value.equals("CartoonVolumeStyle") || value.equals("ChannelMerger") || value.equals("ChannelSelector") || value.equals("ChannelSplitter") || value.equals("Circle2D") || value.equals("ClipPlane") || value.equals("CollidableOffset") || value.equals("CollidableShape") || value.equals("Collision") || value.equals("CollisionCollection") || value.equals("CollisionSensor") || value.equals("CollisionSpace") || value.equals("Color") || value.equals("ColorChaser") || value.equals("ColorDamper") || value.equals("ColorInterpolator") || value.equals("ColorRGBA") || value.equals("ComposedCubeMapTexture") || value.equals("ComposedShader") || value.equals("ComposedTexture3D") || value.equals("ComposedVolumeStyle") || value.equals("Cone") || value.equals("ConeEmitter") || value.equals("Contact") || value.equals("Contour2D") || value.equals("ContourPolyline2D") || value.equals("Convolver") || value.equals("Coordinate") || value.equals("CoordinateChaser") || value.equals("CoordinateDamper") || value.equals("CoordinateDouble") || value.equals("CoordinateInterpolator") || value.equals("CoordinateInterpolator2D") || value.equals("Cylinder") || value.equals("CylinderSensor") || value.equals("Delay") || value.equals("DirectionalLight") || value.equals("DISEntityManager") || value.equals("DISEntityTypeMapping") || value.equals("Disk2D") || value.equals("DoubleAxisHingeJoint") || value.equals("DynamicsCompressor") || value.equals("EaseInEaseOut") || value.equals("EdgeEnhancementVolumeStyle") || value.equals("ElevationGrid") || value.equals("EspduTransform") || value.equals("ExplosionEmitter") || value.equals("Extrusion") || value.equals("FillProperties") || value.equals("FloatVertexAttribute") || value.equals("Fog") || value.equals("FogCoordinate") || value.equals("FontStyle") || value.equals("ForcePhysicsModel") || value.equals("Gain") || value.equals("GeneratedCubeMapTexture") || value.equals("GeoCoordinate") || value.equals("GeoElevationGrid") || value.equals("GeoLocation") || value.equals("GeoLOD") || value.equals("GeoMetadata") || value.equals("GeoOrigin") || value.equals("GeoPositionInterpolator") || value.equals("GeoProximitySensor") || value.equals("GeoTouchSensor") || value.equals("GeoTransform") || value.equals("GeoViewpoint") || value.equals("Group") || value.equals("HAnimDisplacer") || value.equals("HAnimHumanoid") || value.equals("HAnimJoint") || value.equals("HAnimMotion") || value.equals("HAnimSegment") || value.equals("HAnimSite") || value.equals("ImageCubeMapTexture") || value.equals("ImageTexture") || value.equals("ImageTexture3D") || value.equals("IndexedFaceSet") || value.equals("IndexedLineSet") || value.equals("IndexedQuadSet") || value.equals("IndexedTriangleFanSet") || value.equals("IndexedTriangleSet") || value.equals("IndexedTriangleStripSet") || value.equals("Inline") || value.equals("IntegerSequencer") || value.equals("IntegerTrigger") || value.equals("IsoSurfaceVolumeData") || value.equals("KeySensor") || value.equals("Layer") || value.equals("LayerSet") || value.equals("Layout") || value.equals("LayoutGroup") || value.equals("LayoutLayer") || value.equals("LinePickSensor") || value.equals("LineProperties") || value.equals("LineSet") || value.equals("ListenerPointSource") || value.equals("LoadSensor") || value.equals("LocalFog") || value.equals("LOD") || value.equals("Material") || value.equals("Matrix3VertexAttribute") || value.equals("Matrix4VertexAttribute") || value.equals("MetadataBoolean") || value.equals("MetadataDouble") || value.equals("MetadataFloat") || value.equals("MetadataInteger") || value.equals("MetadataSet") || value.equals("MetadataString") || value.equals("MicrophoneSource") || value.equals("MotorJoint") || value.equals("MovieTexture") || value.equals("MultiTexture") || value.equals("MultiTextureCoordinate") || value.equals("MultiTextureTransform") || value.equals("NavigationInfo") || value.equals("Normal") || value.equals("NormalInterpolator") || value.equals("NurbsCurve") || value.equals("NurbsCurve2D") || value.equals("NurbsOrientationInterpolator") || value.equals("NurbsPatchSurface") || value.equals("NurbsPositionInterpolator") || value.equals("NurbsSet") || value.equals("NurbsSurfaceInterpolator") || value.equals("NurbsSweptSurface") || value.equals("NurbsSwungSurface") || value.equals("NurbsTextureCoordinate") || value.equals("NurbsTrimmedSurface") || value.equals("OpacityMapVolumeStyle") || value.equals("OrientationChaser") || value.equals("OrientationDamper") || value.equals("OrientationInterpolator") || value.equals("OrthoViewpoint") || value.equals("OscillatorSource") || value.equals("PackagedShader") || value.equals("ParticleSystem") || value.equals("PeriodicWave") || value.equals("PhysicalMaterial") || value.equals("PickableGroup") || value.equals("PixelTexture") || value.equals("PixelTexture3D") || value.equals("PlaneSensor") || value.equals("PointEmitter") || value.equals("PointLight") || value.equals("PointPickSensor") || value.equals("PointProperties") || value.equals("PointSet") || value.equals("Polyline2D") || value.equals("PolylineEmitter") || value.equals("Polypoint2D") || value.equals("PositionChaser") || value.equals("PositionChaser2D") || value.equals("PositionDamper") || value.equals("PositionDamper2D") || value.equals("PositionInterpolator") || value.equals("PositionInterpolator2D") || value.equals("PrimitivePickSensor") || value.equals("ProgramShader") || value.equals("ProjectionVolumeStyle") || value.equals("ProtoInstance") || value.equals("ProximitySensor") || value.equals("QuadSet") || value.equals("ReceiverPdu") || value.equals("Rectangle2D") || value.equals("RigidBody") || value.equals("RigidBodyCollection") || value.equals("ScalarChaser") || value.equals("ScalarDamper") || value.equals("ScalarInterpolator") || value.equals("ScreenFontStyle") || value.equals("ScreenGroup") || value.equals("Script") || value.equals("SegmentedVolumeData") || value.equals("ShadedVolumeStyle") || value.equals("ShaderPart") || value.equals("ShaderProgram") || value.equals("Shape") || value.equals("SignalPdu") || value.equals("SilhouetteEnhancementVolumeStyle") || value.equals("SingleAxisHingeJoint") || value.equals("SliderJoint") || value.equals("Sound") || value.equals("SpatialSound") || value.equals("Sphere") || value.equals("SphereSensor") || value.equals("SplinePositionInterpolator") || value.equals("SplinePositionInterpolator2D") || value.equals("SplineScalarInterpolator") || value.equals("SpotLight") || value.equals("SquadOrientationInterpolator") || value.equals("StaticGroup") || value.equals("StreamAudioDestination") || value.equals("StreamAudioSource") || value.equals("StringSensor") || value.equals("SurfaceEmitter") || value.equals("Switch") || value.equals("TexCoordChaser2D") || value.equals("TexCoordDamper2D") || value.equals("Text") || value.equals("TextureBackground") || value.equals("TextureCoordinate") || value.equals("TextureCoordinate3D") || value.equals("TextureCoordinate4D") || value.equals("TextureCoordinateGenerator") || value.equals("TextureProjector") || value.equals("TextureProjectorParallel") || value.equals("TextureProperties") || value.equals("TextureTransform") || value.equals("TextureTransform3D") || value.equals("TextureTransformMatrix3D") || value.equals("TimeSensor") || value.equals("TimeTrigger") || value.equals("ToneMappedVolumeStyle") || value.equals("TouchSensor") || value.equals("Transform") || value.equals("TransformSensor") || value.equals("TransmitterPdu") || value.equals("TriangleFanSet") || value.equals("TriangleSet") || value.equals("TriangleSet2D") || value.equals("TriangleStripSet") || value.equals("TwoSidedMaterial") || value.equals("UniversalJoint") || value.equals("UnlitMaterial") || value.equals("Viewpoint") || value.equals("ViewpointGroup") || value.equals("Viewport") || value.equals("VisibilitySensor") || value.equals("VolumeData") || value.equals("VolumeEmitter") || value.equals("VolumePickSensor") || value.equals("WaveShaper") || value.equals("WindPhysicsModel") || value.equals("WorldInfo");
        return isReservedName;
    }

    public static boolean isX3dStatementName(String value) {
        boolean isReservedName = value.equals("component") || value.equals("connect") || value.equals("EXPORT") || value.equals("ExternProtoDeclare") || value.equals("field") || value.equals("fieldValue") || value.equals("head") || value.equals("IMPORT") || value.equals("IS") || value.equals("meta") || value.equals("ProtoBody") || value.equals("ProtoDeclare") || value.equals("ProtoInterface") || value.equals("ROUTE") || value.equals("Scene") || value.equals("unit") || value.equals("X3D");
        return isReservedName;
    }

    public void appendValue(String newValue) {
        this.SFString = this.SFString + newValue;
    }

    public void prependValue(String newValue) {
        this.SFString = newValue + this.SFString;
    }

    public boolean equals(SFString comparisonSFString) {
        if (comparisonSFString == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFString.getPrimitiveValue();
    }

    public boolean equals(String comparisonValue) {
        return this.getPrimitiveValue() == comparisonValue;
    }

    public final String validate() {
        return this.validateRegex();
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFString PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFString";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFString";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFString setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFString.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFString(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFString = "";
            return this;
        }
        this.SFString = newValue;
        return this;
    }

    public SFString(SFString newValue) {
        if (newValue == null) {
            this.SFString = "";
            return;
        }
        this.SFString = newValue.getPrimitiveValue();
    }

    public SFString(String newValue) {
        this.SFString = newValue;
    }

    public static String toString(String value) {
        return String.valueOf(value);
    }

    public static String toStringX3D(String value) {
        return new SFString(value).toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "\\\"");
    }

    public static String toStringClassicVRML(String value) {
        return new SFString(value).toString().replaceAll("\"", "\\\\\\\"");
    }

    public String toStringX3D() {
        return org.web3d.x3d.jsail.fields.SFString.toStringX3D(this.SFString);
    }

    public String toStringClassicVRML() {
        return org.web3d.x3d.jsail.fields.SFString.toStringClassicVRML(this.SFString);
    }

    @Override
    public String getValue() {
        return this.SFString;
    }

    public String getPrimitiveValue() {
        return this.SFString;
    }

    public String toString() {
        return this.SFString;
    }

    @Override
    public void setValue(String newValue) {
        this.SFString = newValue;
    }

    public SFString setValue(SFString newValue) {
        if (newValue == null) {
            this.SFString = "";
            return this;
        }
        this.SFString = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFString == "";
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFString("").matches()) {
                System.out.println("SFString.initialize() problem: failed to match DEFAULT_VALUE=");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFString initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s|\\S)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

