/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix4;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3d;

public class SFMatrix4d
extends X3DConcreteField
implements org.web3d.x3d.sai.SFMatrix4d {
    public static final String NAME = "SFMatrix4d";
    public static final double[] DEFAULT_VALUE = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    public static final String DEFAULT_VALUE_STRING = "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 1";
    public static final int TUPLE_SIZE = 16;
    public static final String REGEX = "\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFMatrix4d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFMatrix4d comparisonSFMatrix4d) {
        if (comparisonSFMatrix4d == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFMatrix4d.getPrimitiveValue();
    }

    public boolean equals(double[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        SFMatrix4d tempHold = new SFMatrix4d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFMatrix4d validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFMatrix4d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix4d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFMatrix4d";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFMatrix4d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFMatrix4d.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFMatrix4d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 16) {
                String errorNotice = "*** illegal number of values in initialization string";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFMatrix4d[0] = Double.parseDouble(newValues[0]);
            this.SFMatrix4d[1] = Double.parseDouble(newValues[1]);
            this.SFMatrix4d[2] = Double.parseDouble(newValues[2]);
            this.SFMatrix4d[3] = Double.parseDouble(newValues[3]);
            this.SFMatrix4d[4] = Double.parseDouble(newValues[4]);
            this.SFMatrix4d[5] = Double.parseDouble(newValues[5]);
            this.SFMatrix4d[6] = Double.parseDouble(newValues[6]);
            this.SFMatrix4d[7] = Double.parseDouble(newValues[7]);
            this.SFMatrix4d[8] = Double.parseDouble(newValues[8]);
            this.SFMatrix4d[9] = Double.parseDouble(newValues[9]);
            this.SFMatrix4d[10] = Double.parseDouble(newValues[10]);
            this.SFMatrix4d[11] = Double.parseDouble(newValues[11]);
            this.SFMatrix4d[12] = Double.parseDouble(newValues[12]);
            this.SFMatrix4d[13] = Double.parseDouble(newValues[13]);
            this.SFMatrix4d[14] = Double.parseDouble(newValues[14]);
            this.SFMatrix4d[15] = Double.parseDouble(newValues[15]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFMatrix4d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFMatrix4d(SFMatrix4d newValue) {
        if (newValue == null) {
            this.SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFMatrix4d = newValue.getPrimitiveValue();
    }

    public SFMatrix4d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 16) {
            String errorNotice = "*** Illegal SFMatrix4d newValue array length=" + newValue.length + ", must equal 16 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFMatrix4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix4d = newValue;
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public double[] getPrimitiveValue() {
        return this.SFMatrix4d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFMatrix4d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.SFMatrix4d[i]));
            } else {
                result.append(this.SFMatrix4d[i]);
            }
            if (i >= this.SFMatrix4d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public SFMatrix4d setValue(double[] newValue) {
        if (newValue == null) {
            this.SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length != 16) {
            String errorNotice = "*** Illegal array newValue=" + String.valueOf(newValue) + " must base have length 16 for setValue() on SFMatrix4d";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFMatrix4d = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.SFMatrix4d = DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "*** Illegal SFMatrix4d[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return (float)this.SFMatrix4d[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale, SFRotation scaleOrientation, SFVec3d center) {
    }

    @Override
    public void getTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale) {
    }

    @Override
    public Matrix4 inverse() {
        return null;
    }

    @Override
    public Matrix4 transpose() {
        return null;
    }

    @Override
    public Matrix4 multiplyLeft(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRight(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRowVector(SFVec3d vector3d) {
        return null;
    }

    @Override
    public Matrix4 multiplyColVector(SFVec3d vector3d) {
        return null;
    }

    public double[] toDoubleArray() {
        return this.SFMatrix4d;
    }

    public SFMatrix4d setValue(SFMatrix4d newValue) {
        if (newValue == null) {
            this.SFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFMatrix4d = newValue.getPrimitiveValue();
        return this;
    }

    public SFMatrix4d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.SFMatrix4d.length) {
            int n = i++;
            this.SFMatrix4d[n] = this.SFMatrix4d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFMatrix4d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFMatrix4d(DEFAULT_VALUE).matches()) {
                System.out.println("SFMatrix4d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFMatrix4d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

