/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFImage
extends X3DConcreteField
implements org.web3d.x3d.sai.SFImage {
    public static final String NAME = "SFImage";
    public static final int[] DEFAULT_VALUE = new int[]{0, 0, 0};
    public static final String DEFAULT_VALUE_STRING = "0 0 0";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private int[] SFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    static final int WIDTH_INDEX = 0;
    static final int HEIGHT_INDEX = 1;
    static final int NUMBER_COMPONENTS_INDEX = 2;
    static final int NUMBER_PARAMETERS = 3;

    public static final boolean isArray() {
        return false;
    }

    public SFImage() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFImage comparisonSFImage) {
        if (comparisonSFImage == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonSFImage.getPrimitiveValue());
    }

    public boolean equals(int[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        if (this.SFImage.length != this.getWidth() * this.getHeight() + 3) {
            String errorNotice = "*** Illegal length of SFImage integer array (" + this.SFImage.length + ") while ((width=" + this.getWidth() + " * height=" + this.getHeight() + " + 3)=" + (this.getWidth() * this.getHeight() + 3);
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        SFImage tempHold = new SFImage(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFImage validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFImage PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFImage";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFImage";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFImage setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFImage.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFImage(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            this.SFImage = new int[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.SFImage[i] = newValues[i].startsWith("0x") ? Integer.decode(newValues[i]) : Integer.parseInt(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFImage(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFImage(SFImage newValue) {
        if (newValue == null) {
            this.SFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFImage = newValue.getPrimitiveValue();
    }

    public SFImage(int[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.SFImage = newValue;
    }

    public static String toString(int[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public int[] getPrimitiveValue() {
        return this.SFImage;
    }

    public String toString() {
        if (ConfigurationProperties.isSFImagePixelOutputHexadecimal()) {
            return this.toStringHexadecimal();
        }
        return this.toStringDecimal();
    }

    public String toStringDecimal() {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.SFImage.length; ++i) {
            resultBuilder.append(this.SFImage[i]);
            if (i >= this.SFImage.length - 1) continue;
            resultBuilder.append(" ");
        }
        return resultBuilder.toString();
    }

    public String toStringHexadecimal() {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.SFImage.length; ++i) {
            if (i < 3) {
                resultBuilder.append(this.SFImage[i]);
            } else {
                resultBuilder.append("0x").append(Integer.toHexString(this.SFImage[i]));
            }
            if (i >= this.SFImage.length - 1) continue;
            resultBuilder.append(" ");
        }
        return resultBuilder.toString();
    }

    @Override
    public int getWidth() {
        if (this.SFImage == null || this.SFImage.length < 3) {
            String errorNotice = "*** Null array or illegal data length for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int width = this.SFImage[0];
        int height = this.SFImage[1];
        if (width < 0 || height < 0) {
            String errorNotice = "*** Illegal negative value: width=" + width + ", height=" + height + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.SFImage[0];
    }

    @Override
    public int getHeight() {
        if (this.SFImage == null || this.SFImage.length < 3) {
            String errorNotice = "*** Null array or illegal data length for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int width = this.SFImage[0];
        int height = this.SFImage[1];
        if (width < 0 || height < 0) {
            String errorNotice = "*** Illegal negative value: width=" + width + ", height=" + height + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.SFImage[1];
    }

    @Override
    public int getNumberComponents() {
        if (this.SFImage == null || this.SFImage.length < 3) {
            String errorNotice = "*** Null array or illegal data length for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int components = this.SFImage[2];
        if (components < 0 || components > 4) {
            String errorNotice = "*** Illegal value, must be in range [0..4]: number of components=" + components + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this.SFImage[2];
    }

    public int getExpectedLength() {
        return this.getWidth() * this.getHeight();
    }

    public int getNumberOfPixelValues() {
        return Integer.max(this.SFImage.length - 3, 0);
    }

    @Override
    public void getPixels(int[] destinationPixels) {
        if (this.SFImage == null || this.SFImage.length < 3) {
            String errorNotice = "*** Null array or illegal data length for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int width = this.SFImage[0];
        int height = this.SFImage[1];
        int components = this.getNumberComponents();
        destinationPixels = new int[this.SFImage.length];
        if (width == 0 || height == 0 || components == 0) {
            destinationPixels = new int[]{};
        } else if (this.SFImage.length > 3) {
            destinationPixels = Arrays.copyOfRange(this.SFImage, 3, this.SFImage.length);
        } else {
            String errorNotice = "*** Illegal value for SFImage field type, getPixels() cannot get pixel array";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
    }

    @Override
    public WritableRenderedImage getImage() {
        return null;
    }

    @Override
    public void setImage(RenderedImage image) {
    }

    @Override
    public void setSubImage(RenderedImage image, int sourceWidth, int sourceHeight, int sourceXOffset, int sourceYOffset, int destinationXOffset, int destinationYOffset) {
    }

    @Override
    public void setValue(int width, int height, int components, int[] pixels) {
        if (width < 0 || height < 0) {
            String errorNotice = "*** Illegal negative value: width=" + width + ", height=" + height + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
        if (components < 0 || components > 4) {
            String errorNotice = "*** Illegal value, must be in range [0..4]: number of components=" + components + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
        if (width * height * components > 0 && pixels.length < width * height) {
            String errorNotice = "*** Illegal number of pixels: pixels.length=" + pixels.length + ", (width * height * components) = " + width + " * " + components + " * " + components + ") = " + width * height * components + " for SFImage field type";
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
        this.SFImage = new int[3 + width * height];
        this.SFImage[0] = width;
        this.SFImage[1] = height;
        this.SFImage[2] = components;
        System.arraycopy(pixels, 0, this.SFImage, 3, pixels.length);
    }

    public void setValue(int[] sfImageArray) {
        if (sfImageArray == null) {
            String errorNotice = "*** Illegal sfImageArray, cannot be null.";
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
        if (sfImageArray.length < 3) {
            String errorNotice = "*** Illegal sfImageArray.length=" + sfImageArray.length + ", must be at least 3.";
            validationResult.append(errorNotice).append("\n");
            throw new IllegalArgumentException(errorNotice);
        }
        this.setValue(sfImageArray[0], sfImageArray[1], sfImageArray[2], Arrays.copyOfRange(sfImageArray, 3, sfImageArray.length));
    }

    public static String getPixelHexFormat(int numberComponents) {
        switch (numberComponents) {
            case 0: {
                return "0x%02X";
            }
            case 1: {
                return "0x%02X";
            }
            case 2: {
                return "0x%04X";
            }
            case 3: {
                return "0x%06X";
            }
            case 4: {
                return "0x%08X";
            }
        }
        String errorNotice = "*** erroneous image numberComponents=" + numberComponents + " for SFImage, unable to compute getPixelHexFormat()";
        validationResult.append(errorNotice).append("\n");
        throw new InvalidFieldValueException(errorNotice);
    }

    public String getPixelsString() {
        StringBuilder result = new StringBuilder();
        String hexFormat = org.web3d.x3d.jsail.fields.SFImage.getPixelHexFormat(this.getNumberComponents());
        int[] destinationPixels = Arrays.copyOfRange(this.SFImage, 3, this.SFImage.length);
        for (int i = 0; i < destinationPixels.length; ++i) {
            result.append(String.format(hexFormat, destinationPixels[i]));
            result.append(" ");
        }
        return result.toString().trim();
    }

    public SFImage setValue(SFImage newValue) {
        if (newValue == null) {
            this.SFImage = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFImage = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFImage, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFImage(DEFAULT_VALUE).matches()) {
                System.out.println("SFImage.initialize() problem: failed to match DEFAULT_VALUE=" + String.valueOf(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFImage initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*([+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?\\s+){2}[+]?[0-4](\\s+(0x[0-9a-fA-F]{1,16}|[+]?(0|[1-9][0-9]*)([Ee][+]?[0-9]+)?))*\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

