/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFFloat
extends X3DConcreteField
implements org.web3d.x3d.sai.SFFloat {
    public static final String NAME = "SFFloat";
    public static final float DEFAULT_VALUE = 0.0f;
    public static final String DEFAULT_VALUE_STRING = "0.0";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float SFFloat = 0.0f;

    public static final boolean isArray() {
        return false;
    }

    public SFFloat() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFFloat = 0.0f;
    }

    public boolean equals(SFFloat comparisonSFFloat) {
        if (comparisonSFFloat == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFFloat.getPrimitiveValue();
    }

    public boolean equals(float comparisonValue) {
        return this.getPrimitiveValue() == comparisonValue;
    }

    public final String validate() {
        SFFloat tempHold = new SFFloat(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFFloat validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFFloat PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFFloat";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFFloat";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFFloat setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFFloat.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFFloat(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFFloat = 0.0f;
            return this;
        }
        try {
            this.SFFloat = Float.parseFloat(newValue);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFFloat(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFFloat(SFFloat newValue) {
        if (newValue == null) {
            this.SFFloat = 0.0f;
            return;
        }
        this.SFFloat = newValue.getPrimitiveValue();
    }

    public SFFloat(float newValue) {
        this.SFFloat = newValue;
    }

    public SFFloat(double newValue) {
        this.SFFloat = (float)newValue;
    }

    public SFFloat(int newValue) {
        this.SFFloat = newValue;
    }

    public static String toString(float value) {
        return String.valueOf(value);
    }

    @Override
    public float getValue() {
        return this.SFFloat;
    }

    public float getPrimitiveValue() {
        return this.SFFloat;
    }

    public String toString() {
        return String.valueOf(this.SFFloat);
    }

    @Override
    public void setValue(float newValue) {
        this.SFFloat = newValue;
    }

    public SFFloat setValue(double newValue) {
        this.SFFloat = (float)newValue;
        return this;
    }

    public SFFloat setValue(int newValue) {
        this.SFFloat = newValue;
        return this;
    }

    public String stripTrailingZeroes() {
        return org.web3d.x3d.jsail.fields.SFFloat.stripTrailingZeroes(this.getValue());
    }

    public static String stripTrailingZeroes(float value) {
        String stringValue = String.valueOf(value);
        if (stringValue.contains(".") && !stringValue.contains("E") && !stringValue.contains("e")) {
            return stringValue.replaceAll("[0]*$", "").replaceAll("\\.$", "");
        }
        return stringValue;
    }

    public SFFloat setValue(SFFloat newValue) {
        if (newValue == null) {
            this.SFFloat = 0.0f;
            return this;
        }
        this.SFFloat = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFFloat == 0.0f;
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFFloat(0.0f).matches()) {
                System.out.println("SFFloat.initialize() problem: failed to match DEFAULT_VALUE=0.0");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFFloat initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

