/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFColorRGBA
extends X3DConcreteField
implements org.web3d.x3d.sai.SFColorRGBA {
    public static final String NAME = "SFColorRGBA";
    public static final float[] DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public static final String DEFAULT_VALUE_STRING = "0 0 0 0";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*(([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*";
    public static final Pattern PATTERN = Pattern.compile("\\s*(([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] SFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return false;
    }

    public SFColorRGBA() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(SFColorRGBA comparisonSFColorRGBA) {
        if (comparisonSFColorRGBA == null) {
            return false;
        }
        return this.getPrimitiveValue() == comparisonSFColorRGBA.getPrimitiveValue();
    }

    public boolean equals(float[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        SFColorRGBA tempHold = new SFColorRGBA(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "SFColorRGBA validate() error: failed get/set round-trip test";
        }
        return "";
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new SFColorRGBA PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFColorRGBA";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFColorRGBA";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFColorRGBA setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFColorRGBA.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new SFColorRGBA(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length != 4) {
                String errorNotice = "*** illegal number of values in initialization string, new SFColorRGBA(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.SFColorRGBA[0] = Float.parseFloat(newValues[0]);
            this.SFColorRGBA[1] = Float.parseFloat(newValues[1]);
            this.SFColorRGBA[2] = Float.parseFloat(newValues[2]);
            this.SFColorRGBA[3] = Float.parseFloat(newValues[3]);
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new SFColorRGBA(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public SFColorRGBA(SFColorRGBA newValue) {
        if (newValue == null) {
            this.SFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.SFColorRGBA = newValue.getPrimitiveValue();
    }

    public SFColorRGBA(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFColorRGBA newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFColorRGBA.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        float red = newValue[0];
        float green = newValue[1];
        float blue = newValue[2];
        float alpha = newValue[3];
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "*** Illegal SFColorRGBA value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA = newValue;
    }

    public SFColorRGBA(float red, float green, float blue, float alpha) {
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "*** Illegal SFColorRGBA value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA[0] = red;
        this.SFColorRGBA[1] = green;
        this.SFColorRGBA[2] = blue;
        this.SFColorRGBA[3] = alpha;
    }

    public SFColorRGBA(double red, double green, double blue, double alpha) {
        this.setValue((float)red, (float)green, (float)blue, (float)alpha);
    }

    public SFColorRGBA(int hexColorValue, float alpha) {
        float red = (float)(hexColorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColorValue & 0xFF) / 255.0f;
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f) {
            String errorNotice = "*** Illegal SFColor value (" + red + "," + green + "," + blue + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA[0] = red;
        this.SFColorRGBA[1] = green;
        this.SFColorRGBA[2] = blue;
        this.SFColorRGBA[3] = alpha;
    }

    public SFColorRGBA setValue(int hexColorValue, float alpha) {
        float red = (float)(hexColorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColorValue & 0xFF) / 255.0f;
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "*** Illegal SFColor value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA[0] = red;
        this.SFColorRGBA[1] = green;
        this.SFColorRGBA[2] = blue;
        this.SFColorRGBA[3] = alpha;
        return this;
    }

    public SFColorRGBA complementRGB() {
        this.SFColorRGBA[0] = 1.0f - this.SFColorRGBA[0];
        this.SFColorRGBA[1] = 1.0f - this.SFColorRGBA[1];
        this.SFColorRGBA[2] = 1.0f - this.SFColorRGBA[2];
        return this;
    }

    public SFColorRGBA complementAlpha() {
        this.SFColorRGBA[3] = 1.0f - this.SFColorRGBA[3];
        return this;
    }

    public SFColorRGBA normalizeClip() {
        if (this.SFColorRGBA[0] < 0.0f) {
            this.SFColorRGBA[0] = 0.0f;
        }
        if (this.SFColorRGBA[1] < 0.0f) {
            this.SFColorRGBA[1] = 0.0f;
        }
        if (this.SFColorRGBA[2] < 0.0f) {
            this.SFColorRGBA[2] = 0.0f;
        }
        if (this.SFColorRGBA[3] < 0.0f) {
            this.SFColorRGBA[3] = 0.0f;
        }
        if (this.SFColorRGBA[0] > 1.0f) {
            this.SFColorRGBA[0] = 1.0f;
        }
        if (this.SFColorRGBA[1] > 1.0f) {
            this.SFColorRGBA[1] = 1.0f;
        }
        if (this.SFColorRGBA[2] > 1.0f) {
            this.SFColorRGBA[2] = 1.0f;
        }
        if (this.SFColorRGBA[3] > 1.0f) {
            this.SFColorRGBA[3] = 1.0f;
        }
        return this;
    }

    public SFColorRGBA setValue(double[] newValue) {
        float[] floatArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            floatArray[i] = (float)newValue[i];
        }
        this.setValue(floatArray);
        return this;
    }

    public SFColorRGBA(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.SFColorRGBA;
    }

    public float[] getPrimitiveValue() {
        return this.SFColorRGBA;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.SFColorRGBA.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.SFColorRGBA[i]));
            } else {
                result.append(this.SFColorRGBA[i]);
            }
            if (i >= this.SFColorRGBA.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void setValue(float[] newValue) {
        if (newValue == null) {
            return;
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal SFColorRGBA newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.SFColorRGBA.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        float red = newValue[0];
        float green = newValue[1];
        float blue = newValue[2];
        float alpha = newValue[3];
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "*** Illegal SFColorRGBA value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA = newValue;
    }

    public SFColorRGBA setValueArray(float[] newValue) {
        this.setValue(newValue);
        return this;
    }

    public SFColorRGBA setValue(float red, float green, float blue, float alpha) {
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            String errorNotice = "*** Illegal SFColorRGBA value (" + red + "," + green + "," + blue + "," + alpha + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA[0] = red;
        this.SFColorRGBA[1] = green;
        this.SFColorRGBA[2] = blue;
        return this;
    }

    public SFColorRGBA setValue(double red, double green, double blue, double alpha) {
        this.setValue((float)red, (float)green, (float)blue, (float)alpha);
        return this;
    }

    public SFColorRGBA setTransparency(float newTransparency) {
        if (newTransparency < 0.0f || newTransparency > 1.0f) {
            String errorNotice = "*** Illegal SFColorRGBA transparency value=" + newTransparency + ", must be within numeric range [0..1] inclusive";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.SFColorRGBA[3] = newTransparency;
        return this;
    }

    public SFColorRGBA setTransparency(double newTransparency) {
        this.setTransparency((float)newTransparency);
        return this;
    }

    public float[] toFloatArray() {
        return this.SFColorRGBA;
    }

    public SFColorRGBA setValue(SFColorRGBA newValue) {
        if (newValue == null) {
            this.SFColorRGBA = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.SFColorRGBA = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.SFColorRGBA, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFColorRGBA(DEFAULT_VALUE).matches()) {
                System.out.println("SFColorRGBA.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFColorRGBA initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*(([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*\"");
            System.out.println(exception.getDescription());
        }
    }
}

