/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFVec4d;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFVec4d
extends X3DConcreteField
implements org.web3d.x3d.sai.MFVec4d {
    public static final String NAME = "MFVec4d";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 4;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFVec4d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFVec4d comparisonMFVec4d) {
        if (comparisonMFVec4d == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonMFVec4d.getPrimitiveValue());
    }

    public boolean equals(double[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        MFVec4d tempHold = new MFVec4d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFVec4d validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new MFVec4d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec4d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec4d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFVec4d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFVec4d.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new MFVec4d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 4 != 0) {
                String errorNotice = "*** illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 4 when declaring new MFVec4d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFVec4d = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFVec4d[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new MFVec4d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFVec4d(MFVec4d newValue) {
        if (newValue == null) {
            this.MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFVec4d = newValue.getPrimitiveValue();
    }

    public MFVec4d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 4 != 0) {
            String errorNotice = "*** Illegal MFVec4d newValue array length=" + newValue.length + ", must be multiple of 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFVec4d = newValue;
    }

    public MFVec4d normalize() {
        int index = 0;
        while (index + 4 < this.MFVec4d.length) {
            double length = Math.sqrt(this.MFVec4d[index + 0] * this.MFVec4d[index + 0] + this.MFVec4d[index + 1] * this.MFVec4d[index + 1] + this.MFVec4d[index + 2] * this.MFVec4d[index + 2] + this.MFVec4d[index + 3] * this.MFVec4d[index + 3]);
            if (length > 0.0) {
                this.MFVec4d[index + 0] = this.MFVec4d[index + 0] / length;
                this.MFVec4d[index + 1] = this.MFVec4d[index + 1] / length;
                this.MFVec4d[index + 2] = this.MFVec4d[index + 2] / length;
                this.MFVec4d[index + 3] = this.MFVec4d[index + 3] / length;
            }
            index += 4;
        }
        return this;
    }

    public MFVec4d(SFVec4d newValue) {
        this.setValue(newValue);
    }

    public MFVec4d(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.MFVec4d;
    }

    public double[] getPrimitiveValue() {
        return this.MFVec4d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFVec4d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFVec4d[i]));
            } else {
                result.append(this.MFVec4d[i]);
            }
            if (i >= this.MFVec4d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, double[] destinationValue) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec4d.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec4d.length / 4) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFVec4d array length=" + this.MFVec4d.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFVec4d, index * 4, index * 4 + 4 - 1);
    }

    @Override
    public void setValue(int size, double[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFVec4d = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(double[][] valueDestination) {
    }

    @Override
    public void setValue(int size, double[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFVec4d = new double[newValue.length];
        this.MFVec4d = newValue;
    }

    public MFVec4d setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFVec4d = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec4d[i] = newValue[i];
        }
        return this;
    }

    public MFVec4d setValue(SFVec4d newValue) {
        if (newValue == null) {
            this.MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toDoubleArray());
        return this;
    }

    @Override
    public void set1Value(int index, double[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec4d.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 4) {
            String errorNotice = "*** Illegal MFVec4d newValue array length=" + newValue.length + ", must equal 4 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec4d.length / 4) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFVec4d array length=" + this.MFVec4d.length / 4;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec4d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public void append(double[] newValue) {
        if (newValue.length % 4 != 0) {
            String errorNotice = "*** illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4d(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFVec4d.length;
        this.MFVec4d = Arrays.copyOf(this.MFVec4d, this.MFVec4d.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec4d[originalLength + i] = newValue[i];
        }
    }

    public MFVec4d append(SFVec4d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFVec4d append(MFVec4d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, double[] newValue) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 4) {
            String errorNotice = "*** illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 4 for MFVec4dinsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec4d.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFVec4d array length=" + this.MFVec4d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFVec4d.length - index;
        this.MFVec4d = Arrays.copyOf(this.MFVec4d, this.MFVec4d.length + 4);
        System.arraycopy(this.MFVec4d, index, this.MFVec4d, index + 4, sliceLength);
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec4d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFVec4d.length;
    }

    @Override
    public void clear() {
        this.MFVec4d = new double[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec4d.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec4d.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFVec4d array length=" + this.MFVec4d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFVec4d.length - (index + 1) * 4;
        System.arraycopy(this.MFVec4d, (index + 1) * 4, this.MFVec4d, index * 4, offsetLength);
        this.MFVec4d = Arrays.copyOfRange(this.MFVec4d, 0, this.MFVec4d.length - 4);
    }

    public double[] toDoubleArray() {
        return this.MFVec4d;
    }

    public MFVec4d setValue(MFVec4d newValue) {
        if (newValue == null) {
            this.MFVec4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFVec4d = newValue.getPrimitiveValue();
        return this;
    }

    public MFVec4d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFVec4d.length) {
            int n = i++;
            this.MFVec4d[n] = this.MFVec4d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFVec4d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFVec4d(DEFAULT_VALUE).matches()) {
                System.out.println("MFVec4d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFVec4d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){3}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

