/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFString
extends X3DConcreteField
implements org.web3d.x3d.sai.MFString {
    public static final String NAME = "MFString";
    public static final String[] DEFAULT_VALUE = new String[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s|\\S)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s|\\S)*");
    private static boolean priorRegexStackOverflowFound = false;
    private String[] MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFString() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public MFString cleanupEnumerationValues() {
        this.MFString = org.web3d.x3d.jsail.fields.MFString.cleanupEnumerationValues(this.MFString);
        return this;
    }

    public static String cleanupEnumerationValue(String value) {
        String result = new String();
        if (value != null) {
            result = value;
        }
        return result.replaceAll("\"", " ").replaceAll(",", " ").replaceAll("\\[", " ").replaceAll("\\]", " ").trim().replaceAll(" ", DEFAULT_VALUE_STRING);
    }

    public static String[] cleanupEnumerationValues(String values) {
        String[] result = new String[]{values == null ? new String() : values.trim()};
        if (!result[0].contains("\"")) {
            return result;
        }
        return result[0].replaceAll("\"", " ").replaceAll(",", " ").replaceAll("\\[", " ").replaceAll("\\]", " ").trim().split("(\\s)+");
    }

    public static String[] cleanupEnumerationValues(String[] values) {
        String[] results = new String[]{};
        if (values != null) {
            results = values;
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = org.web3d.x3d.jsail.fields.MFString.cleanupEnumerationValue(results[i]);
        }
        return results;
    }

    public static ArrayList<String> cleanupEnumerationValues(ArrayList<String> values) {
        ArrayList<String> results = new ArrayList();
        if (values != null) {
            results = values;
        }
        for (String result : results) {
            String string = org.web3d.x3d.jsail.fields.MFString.cleanupEnumerationValue(result);
        }
        return results;
    }

    public static String[] toStringArray(String value) {
        String[] stringArray = new String[]{value};
        return stringArray;
    }

    public static String[] toStringArray(String[] valueArray) {
        return valueArray;
    }

    public MFString cleanupUnescapedEnclosingQuotes() {
        this.MFString = org.web3d.x3d.jsail.fields.MFString.cleanupUnescapedEnclosingQuotes(this.MFString);
        return this;
    }

    public static String cleanupUnescapedEnclosingQuotes(String singleValue) {
        String result = singleValue;
        if (result == null) {
            result = new String();
        }
        if (result.trim().startsWith("\"")) {
            result = result.trim().substring(1);
        }
        if (result.trim().endsWith("\"") && !result.trim().endsWith("\\\"")) {
            result = result.trim().substring(0, result.trim().length() - 1);
        }
        return result;
    }

    public static String[] cleanupUnescapedEnclosingQuotes(String[] values) {
        String[] result = values;
        if (result == null) {
            result = new String[]{};
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = org.web3d.x3d.jsail.fields.MFString.cleanupUnescapedEnclosingQuotes(result[i]);
        }
        return result;
    }

    public static ArrayList<String> cleanupUnescapedEnclosingQuotes(ArrayList<String> values) {
        ArrayList<String> results = values;
        if (results == null) {
            results = new ArrayList();
        }
        for (String result : results) {
            String string = org.web3d.x3d.jsail.fields.MFString.cleanupUnescapedEnclosingQuotes(result);
        }
        return results;
    }

    public boolean equals(MFString comparisonMFString) {
        if (comparisonMFString == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonMFString.getPrimitiveValue());
    }

    public boolean equals(String[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        return this.validateRegex();
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new MFString PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFString array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFString array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFString setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFString.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new MFString(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (!newValue.contains("\"")) {
            this.MFString = new String[1];
            this.MFString[0] = newValue;
            return this;
        }
        String[] newValues = org.web3d.x3d.jsail.fields.MFString.cleanupUnescapedEnclosingQuotes(newValue.trim()).split("\"[\\s+]\"");
        this.MFString = new String[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            this.MFString[i] = newValues[i].replace("\\\"", "\"");
        }
        return this;
    }

    public MFString(MFString newValue) {
        if (newValue == null) {
            this.MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFString = newValue.getPrimitiveValue();
    }

    public MFString(String[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        }
        this.MFString = new String[newValue.length];
        this.MFString = newValue;
    }

    public MFString(String newValue) {
        this.setValueByString(newValue);
    }

    public MFString(SFString newValue) {
        this.setValue(newValue);
    }

    public static String toString(String[] value) {
        Object result = new String();
        for (String eachValue : value) {
            result = (String)result + " \"" + eachValue.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\\\"") + "\"";
        }
        return ((String)result).trim();
    }

    public String toStringX3D() {
        Object result = new String();
        for (int i = 0; i < this.MFString.length; ++i) {
            if (!this.MFString[i].startsWith("\"")) {
                result = (String)result + "\"";
            }
            String escapedValue = this.MFString[i].replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\\\"");
            result = (String)result + escapedValue;
            if (!this.MFString[i].startsWith("\"")) {
                result = (String)result + "\"";
            }
            if (i >= this.MFString.length - 1) continue;
            result = (String)result + " ";
        }
        return result;
    }

    public String toStringClassicVRML() {
        Object result = new String();
        boolean isUrl = false;
        if (this.MFString.length > 0 && (this.MFString[0].trim().startsWith("https://") || this.MFString[0].trim().startsWith("http://"))) {
            isUrl = true;
        }
        if (this.MFString.length > 1 && (this.MFString[1].trim().startsWith("https://") || this.MFString[1].trim().startsWith("http://"))) {
            isUrl = true;
        }
        for (int i = 0; i < this.MFString.length; ++i) {
            if (!this.MFString[i].startsWith("\"")) {
                result = (String)result + "\"";
            }
            String escapedValue = this.MFString[i].replaceAll("\"", "\\\"");
            result = (String)result + escapedValue;
            if (!this.MFString[i].startsWith("\"")) {
                result = (String)result + "\"";
            }
            if (i < this.MFString.length - 1) {
                result = (String)result + " ";
            }
            if (!isUrl) continue;
            result = (String)result + "\n";
        }
        return result;
    }

    public boolean hasDuplicateValues() {
        if (this.MFString == null || this.MFString.length == 0) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(this.MFString.length);
        for (String value : this.MFString) {
            if (set.contains(value)) {
                return true;
            }
            set.add(value);
        }
        return false;
    }

    public MFString removeDuplicateValues() {
        if (this.MFString == null || this.MFString.length == 0) {
            return this;
        }
        this.MFString = (String[])Arrays.stream(this.MFString).distinct().toArray(String[]::new);
        return this;
    }

    @Override
    public void getValue(String[] valueDestination) {
        valueDestination = this.MFString;
    }

    public String[] getPrimitiveValue() {
        return this.MFString;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFString.length; ++i) {
            if (!this.MFString[i].startsWith("\"")) {
                result.append("\"");
            }
            result.append(String.valueOf(this.MFString[i]));
            if (!this.MFString[i].startsWith("\"")) {
                result.append("\"");
            }
            if (i >= this.MFString.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public String get1Value(int index) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFString.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFString.length / 1) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFString array length=" + this.MFString.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        return this.MFString[index];
    }

    @Override
    public void setValue(int size, String[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFString = Arrays.copyOf(newValue, size);
    }

    public void setValue(String[] newValue) {
        if (newValue == null) {
            newValue = new String[]{};
        }
        this.MFString = new String[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFString[i] = org.web3d.x3d.jsail.fields.MFString.cleanupUnescapedEnclosingQuotes(newValue[i]);
        }
    }

    public MFString setValue(SFString newValue) {
        if (newValue == null) {
            this.MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFString = new String[1];
        this.MFString[0] = newValue.getValue();
        return this;
    }

    @Override
    public void set1Value(int index, String newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFString.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFString.length / 1) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFString array length=" + this.MFString.length / 1;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        this.MFString[index] = newValue;
    }

    @Override
    public void append(String newValue) {
        this.MFString = Arrays.copyOf(this.MFString, this.MFString.length + 1);
        this.MFString[this.MFString.length - 1] = newValue;
    }

    public void append(String[] newValue) {
        if (newValue.length % 1 != 0) {
            String errorNotice = "*** illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 4 when declaring new MFVec4f(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFString.length;
        this.MFString = Arrays.copyOf(this.MFString, originalLength + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFString[originalLength + i] = newValue[i];
        }
    }

    public MFString append(SFString newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFString append(MFString newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, String newValue) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFString.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFString array length=" + this.MFString.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFString.length - index;
        this.MFString = Arrays.copyOf(this.MFString, this.MFString.length + 1);
        System.arraycopy(this.MFString, index, this.MFString, index + 1, sliceLength);
        this.MFString[index] = newValue;
    }

    @Override
    public int size() {
        return this.MFString.length;
    }

    @Override
    public void clear() {
        this.MFString = new String[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFString.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFString.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFString array length=" + this.MFString.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFString.length - (index + 1) * 1;
        System.arraycopy(this.MFString, (index + 1) * 1, this.MFString, index * 1, offsetLength);
        this.MFString = Arrays.copyOfRange(this.MFString, 0, this.MFString.length - 1);
    }

    public MFString setValue(MFString newValue) {
        if (newValue == null) {
            this.MFString = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFString = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFString, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFString(DEFAULT_VALUE).matches()) {
                System.out.println("MFString.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFString initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s|\\S)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

