/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFMatrix4d;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.Matrix4;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFVec3d;

public class MFMatrix4d
extends X3DConcreteField
implements org.web3d.x3d.sai.MFMatrix4d {
    public static final String NAME = "MFMatrix4d";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 16;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFMatrix4d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFMatrix4d comparisonMFMatrix4d) {
        if (comparisonMFMatrix4d == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonMFMatrix4d.getPrimitiveValue());
    }

    public boolean equals(double[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        MFMatrix4d tempHold = new MFMatrix4d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFMatrix4d validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new MFMatrix4d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix4d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFMatrix4d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFMatrix4d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFMatrix4d.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new MFMatrix4d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 16 != 0) {
                String errorNotice = "*** illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 16 when declaring new MFMatrix4d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFMatrix4d = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFMatrix4d[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new MFMatrix4d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFMatrix4d(MFMatrix4d newValue) {
        if (newValue == null) {
            this.MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFMatrix4d = newValue.getPrimitiveValue();
    }

    public MFMatrix4d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 16 != 0) {
            String errorNotice = "*** Illegal MFMatrix4d newValue array length=" + newValue.length + ", must be multiple of 16 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFMatrix4d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix4d = newValue;
    }

    public MFMatrix4d(SFMatrix4d newValue) {
        this.setValue(newValue);
    }

    public MFMatrix4d setValue(SFMatrix4d newValue) {
        this.setValue(newValue.getPrimitiveValue());
        return this;
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    public double[] getPrimitiveValue() {
        return this.MFMatrix4d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFMatrix4d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFMatrix4d[i]));
            } else {
                result.append(this.MFMatrix4d[i]);
            }
            if (i >= this.MFMatrix4d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public MFMatrix4d setValue(double[] newValue) {
        if (newValue == null) {
            this.MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        if (newValue.length % 16 != 0) {
            String errorNotice = "*** Illegal array newValue=" + String.valueOf(newValue) + " must base have length 16 for setValue() on MFMatrix4d";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFMatrix4d = newValue;
        return this;
    }

    @Override
    public void setIdentity() {
        this.MFMatrix4d = SFMatrix4d.DEFAULT_VALUE;
    }

    @Override
    public void set(int row, int column) {
    }

    @Override
    public float get(int row, int column) {
        if (row < 0 || row > 4 || column < 0 || column > 4) {
            String errorNotice = "*** Illegal MFMatrix4d[row=" + row + ",column=" + column + "] access, all values must be in numeric range [0..4]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return (float)this.MFMatrix4d[3 * row + column];
    }

    @Override
    public void setTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale, SFRotation scaleOrientation, SFVec3d center) {
    }

    @Override
    public void getTransform(SFVec3d translation, SFRotation rotation, SFVec3d scale) {
    }

    @Override
    public Matrix4 inverse() {
        return null;
    }

    @Override
    public Matrix4 transpose() {
        return null;
    }

    @Override
    public Matrix4 multiplyLeft(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRight(Matrix4 matrix3x3) {
        return null;
    }

    @Override
    public Matrix4 multiplyRowVector(SFVec3d vector3d) {
        return null;
    }

    @Override
    public Matrix4 multiplyColVector(SFVec3d vector3d) {
        return null;
    }

    public double[] toDoubleArray() {
        return this.MFMatrix4d;
    }

    public MFMatrix4d setValue(MFMatrix4d newValue) {
        if (newValue == null) {
            this.MFMatrix4d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFMatrix4d = newValue.getPrimitiveValue();
        return this;
    }

    public MFMatrix4d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFMatrix4d.length) {
            int n = i++;
            this.MFMatrix4d[n] = this.MFMatrix4d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFMatrix4d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFMatrix4d(DEFAULT_VALUE).matches()) {
                System.out.println("MFMatrix4d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFMatrix4d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){15}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

