/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFColor;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFColor
extends X3DConcreteField
implements org.web3d.x3d.sai.MFColor {
    public static final String NAME = "MFColor";
    public static final float[] DEFAULT_VALUE = new float[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 3;
    public static final String REGEX = "\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private float[] MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFColor() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFColor comparisonMFColor) {
        if (comparisonMFColor == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonMFColor.getPrimitiveValue());
    }

    public boolean equals(float[] comparisonValue) {
        if (comparisonValue == null) {
            return false;
        }
        return Arrays.equals(this.getPrimitiveValue(), comparisonValue);
    }

    public final String validate() {
        MFColor tempHold = new MFColor(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFColor validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** [error] Regular expression (regex) failure, new MFColor PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFColor array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFColor array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("[exception] " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFColor setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFColor.matches(newValue)) {
            String errorNotice = "*** [error] Regular expression (regex) failure, new MFColor(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 3 != 0) {
                String errorNotice = "*** illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 3 when declaring new MFColor(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFColor = new float[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFColor[i] = Float.parseFloat(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "*** new MFColor(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFColor(MFColor newValue) {
        if (newValue == null) {
            this.MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFColor = newValue.getPrimitiveValue();
    }

    public MFColor(float[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 3 != 0) {
            String errorNotice = "*** Illegal MFColor newValue array length=" + newValue.length + ", must be multiple of 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFColor.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFColor = newValue;
    }

    public MFColor set1Value(int index, int hexColorValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColor.length / 3) {
            String errorNotice = "*** Provided array index=" + index + " (for 3-tuples) must be less than MFColor array length=" + this.MFColor.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        float red = (float)(hexColorValue >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColorValue >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColorValue & 0xFF) / 255.0f;
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f) {
            String errorNotice = "*** Illegal SFColor value (" + red + "," + green + "," + blue + "), all values must be in numeric range [0..1]";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFColor[3 * index + 0] = red;
        this.MFColor[3 * index + 1] = green;
        this.MFColor[3 * index + 2] = blue;
        return this;
    }

    public MFColor complementRGB() {
        int index = 0;
        while (index + 2 < this.MFColor.length) {
            this.MFColor[3 * index + 0] = 1.0f - this.MFColor[3 * index + 0];
            this.MFColor[3 * index + 1] = 1.0f - this.MFColor[3 * index + 1];
            this.MFColor[3 * index + 2] = 1.0f - this.MFColor[3 * index + 2];
            index += 3;
        }
        return this;
    }

    public MFColor normalizeClip() {
        int index = 0;
        while (index + 2 < this.MFColor.length) {
            if (this.MFColor[3 * index + 0] < 0.0f) {
                this.MFColor[3 * index + 0] = 0.0f;
            }
            if (this.MFColor[3 * index + 1] < 0.0f) {
                this.MFColor[3 * index + 1] = 0.0f;
            }
            if (this.MFColor[3 * index + 2] < 0.0f) {
                this.MFColor[3 * index + 2] = 0.0f;
            }
            if (this.MFColor[3 * index + 0] > 1.0f) {
                this.MFColor[3 * index + 0] = 1.0f;
            }
            if (this.MFColor[3 * index + 1] > 1.0f) {
                this.MFColor[3 * index + 1] = 1.0f;
            }
            if (this.MFColor[3 * index + 2] > 1.0f) {
                this.MFColor[3 * index + 2] = 1.0f;
            }
            index += 3;
        }
        return this;
    }

    public MFColor(SFColor newValue) {
        this.setValue(newValue);
    }

    public MFColor(double[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(float[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(float[] valueDestination) {
        valueDestination = this.MFColor;
    }

    public float[] getPrimitiveValue() {
        return this.MFColor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFColor.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFFloat.stripTrailingZeroes(this.MFColor[i]));
            } else {
                result.append(this.MFColor[i]);
            }
            if (i >= this.MFColor.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, float[] destinationValue) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColor.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColor.length / 3) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFColor array length=" + this.MFColor.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFColor, index * 3, index * 3 + 3 - 1);
    }

    @Override
    public void setValue(int size, float[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFColor = Arrays.copyOf(newValue, size);
    }

    public void setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFColor = new float[newValue.length];
        this.MFColor = newValue;
    }

    public MFColor setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFColor = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFColor[i] = (float)newValue[i];
        }
        return this;
    }

    public MFColor setValue(SFColor newValue) {
        if (newValue == null) {
            this.MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toFloatArray());
        return this;
    }

    @Override
    public void set1Value(int index, float[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColor.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 3) {
            String errorNotice = "*** Illegal MFColor newValue array length=" + newValue.length + ", must equal 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFColor.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFColor.length / 3) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFColor array length=" + this.MFColor.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFColor[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public void append(float[] newValue) {
        if (newValue.length % 3 != 0) {
            String errorNotice = "*** illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 3 when declaring new MFColor(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFColor.length;
        this.MFColor = Arrays.copyOf(this.MFColor, this.MFColor.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFColor[originalLength + i] = newValue[i];
        }
    }

    public MFColor append(SFColor newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFColor append(MFColor newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, float[] newValue) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 3) {
            String errorNotice = "*** illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 3 for MFColorinsertValue(" + String.valueOf(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFColor.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFColor array length=" + this.MFColor.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFColor.length - index;
        this.MFColor = Arrays.copyOf(this.MFColor, this.MFColor.length + 3);
        System.arraycopy(this.MFColor, index, this.MFColor, index + 3, sliceLength);
        int offset = 0;
        float[] fArray = newValue;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float value;
            this.MFColor[index + offset] = value = fArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFColor.length;
    }

    @Override
    public void clear() {
        this.MFColor = new float[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "*** Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFColor.length == 0) {
            String errorNotice = "*** Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFColor.length) {
            String errorNotice = "*** Provided array index=" + index + " must be less than MFColor array length=" + this.MFColor.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFColor.length - (index + 1) * 3;
        System.arraycopy(this.MFColor, (index + 1) * 3, this.MFColor, index * 3, offsetLength);
        this.MFColor = Arrays.copyOfRange(this.MFColor, 0, this.MFColor.length - 3);
    }

    @Override
    public void getValue(float[][] valueDestination) {
    }

    @Override
    public void setValue(int size, float[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public float[] toFloatArray() {
        return this.MFColor;
    }

    public MFColor setValue(MFColor newValue) {
        if (newValue == null) {
            this.MFColor = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFColor = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFColor, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFColor(DEFAULT_VALUE).matches()) {
                System.out.println("MFColor.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFColor initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0(\\.[0-9]*)?|\\.[0-9]+)|1(\\.0*)?)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

