/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.VolumeRendering;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode;
import org.web3d.x3d.sai.VolumeRendering.X3DVolumeRenderStyleNode;

public class VolumeData
extends X3DConcreteNode
implements org.web3d.x3d.sai.VolumeRendering.VolumeData {
    private ArrayList<String> commentsList;
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private float[] dimensions;
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private X3DVolumeRenderStyleNode renderStyle;
    private ProtoInstance renderStyleProtoInstance;
    private boolean visible;
    private X3DTexture3DNode voxels;
    private ProtoInstance voxelsProtoInstance;
    public static final String NAME = "VolumeData";
    public static final String COMPONENT = "VolumeRendering";
    public static final int LEVEL = 1;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final float[] DIMENSIONS_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final X3DVolumeRenderStyleNode RENDERSTYLE_DEFAULT_VALUE = null;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final X3DTexture3DNode VOXELS_DEFAULT_VALUE = null;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_DIMENSIONS = "dimensions";
    public static final String toField_DIMENSIONS = "dimensions";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_RENDERSTYLE = "renderStyle";
    public static final String toField_RENDERSTYLE = "renderStyle";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    public static final String fromField_VOXELS = "voxels";
    public static final String toField_VOXELS = "voxels";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    public static final float[] getBboxCenterDefault() {
        return BBOXCENTER_DEFAULT_VALUE;
    }

    public static final boolean getBboxDisplayDefault() {
        return false;
    }

    public static final float[] getBboxSizeDefault() {
        return BBOXSIZE_DEFAULT_VALUE;
    }

    public static final float[] getDimensionsDefault() {
        return DIMENSIONS_DEFAULT_VALUE;
    }

    public static final IS getISDefault() {
        return IS_DEFAULT_VALUE;
    }

    public static final X3DMetadataObject getMetadataDefault() {
        return METADATA_DEFAULT_VALUE;
    }

    public static final X3DVolumeRenderStyleNode getRenderStyleDefault() {
        return RENDERSTYLE_DEFAULT_VALUE;
    }

    public static final boolean getVisibleDefault() {
        return true;
    }

    public static final X3DTexture3DNode getVoxelsDefault() {
        return VOXELS_DEFAULT_VALUE;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "bboxCenter" -> "SFVec3f";
            case "bboxDisplay" -> "SFBool";
            case "bboxSize" -> "SFVec3f";
            case "dimensions" -> "SFVec3f";
            case fromField_IS -> "SFNode";
            case "metadata" -> "SFNode";
            case "renderStyle" -> "SFNode";
            case "visible" -> "SFBool";
            case "voxels" -> "SFNode";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "bboxCenter" -> "initializeOnly";
            case "bboxDisplay" -> "inputOutput";
            case "bboxSize" -> "initializeOnly";
            case "dimensions" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "renderStyle" -> "inputOutput";
            case "visible" -> "inputOutput";
            case "voxels" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public VolumeData() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALLOWED_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.bboxCenter = VolumeData.getBboxCenterDefault();
        this.bboxDisplay = VolumeData.getBboxDisplayDefault();
        this.bboxSize = VolumeData.getBboxSizeDefault();
        this.dimensions = VolumeData.getDimensionsDefault();
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.renderStyle = null;
        this.renderStyleProtoInstance = null;
        this.visible = VolumeData.getVisibleDefault();
        this.voxels = null;
        this.voxelsProtoInstance = null;
        this.commentsList = new ArrayList();
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public VolumeData setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("VolumeData bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public VolumeData setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public VolumeData setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public VolumeData setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public VolumeData setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public VolumeData setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public VolumeData setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public VolumeData setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("VolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("VolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public VolumeData setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public VolumeData setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public VolumeData setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public VolumeData setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public float[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public VolumeData setDimensions(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("VolumeData dimensions newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] <= 0.0f || newValue[1] <= 0.0f || newValue[2] <= 0.0f) {
            throw new InvalidFieldValueException("VolumeData dimensions newValue=" + String.valueOf(newValue) + " has component value less than (or equal to) restriction minExclusive=0");
        }
        this.dimensions = newValue;
        return this;
    }

    public VolumeData setDimensions(SFVec3f newValue) {
        this.setDimensions(newValue.getPrimitiveValue());
        return this;
    }

    public VolumeData setDimensions(float x, float y, float z) {
        this.setDimensions(new float[]{x, y, z});
        return this;
    }

    public VolumeData setDimensions(double x, double y, double z) {
        return this.setDimensions(new SFVec3f(x, y, z));
    }

    public VolumeData setDimensions(double[] newArray) {
        return this.setDimensions(new SFVec3f(newArray));
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public VolumeData setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public VolumeData clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public VolumeData setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public VolumeData clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public VolumeData setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public X3DVolumeRenderStyleNode getRenderStyle() {
        return this.renderStyle;
    }

    @Override
    public VolumeData setRenderStyle(X3DVolumeRenderStyleNode newValue) {
        this.renderStyle = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.renderStyle)).setParent(this);
        }
        if (this.renderStyleProtoInstance != null) {
            this.renderStyleProtoInstance.setParent(null);
            this.renderStyleProtoInstance = null;
        }
        return this;
    }

    public VolumeData clearRenderStyle() {
        ((X3DConcreteElement)((Object)this.renderStyle)).clearParent();
        this.renderStyle = null;
        return this;
    }

    public VolumeData setRenderStyle(ProtoInstance newValue) {
        if (this.renderStyleProtoInstance != null) {
            this.renderStyleProtoInstance.setParent(null);
        }
        this.renderStyleProtoInstance = newValue;
        if (newValue != null) {
            this.renderStyleProtoInstance.setParent(this);
            this.renderStyleProtoInstance.setContainerField("renderStyle");
        }
        if (this.renderStyle != null) {
            ((X3DConcreteElement)((Object)this.renderStyle)).setParent(null);
            this.renderStyle = null;
        }
        return this;
    }

    private ProtoInstance getRenderStyleProtoInstance() {
        return this.renderStyleProtoInstance;
    }

    public boolean hasRenderStyle() {
        return this.renderStyle != null || this.renderStyleProtoInstance != null;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public VolumeData setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public VolumeData setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DTexture3DNode getVoxels() {
        return this.voxels;
    }

    @Override
    public VolumeData setVoxels(X3DTexture3DNode newValue) {
        this.voxels = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(this);
        }
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
            this.voxelsProtoInstance = null;
        }
        return this;
    }

    public VolumeData clearVoxels() {
        ((X3DConcreteElement)((Object)this.voxels)).clearParent();
        this.voxels = null;
        return this;
    }

    public VolumeData setVoxels(ProtoInstance newValue) {
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
        }
        this.voxelsProtoInstance = newValue;
        if (newValue != null) {
            this.voxelsProtoInstance.setParent(this);
            this.voxelsProtoInstance.setContainerField("voxels");
        }
        if (this.voxels != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(null);
            this.voxels = null;
        }
        return this;
    }

    private ProtoInstance getVoxelsProtoInstance() {
        return this.voxelsProtoInstance;
    }

    public boolean hasVoxels() {
        return this.voxels != null || this.voxelsProtoInstance != null;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final VolumeData setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("VolumeData DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public VolumeData setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final VolumeData setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("VolumeData USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public VolumeData setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final VolumeData setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public VolumeData setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    @Override
    public final VolumeData setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public VolumeData setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final VolumeData setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public VolumeData setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public VolumeData setUSE(VolumeData DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "*** setUSE(DEFnode) invoked on VolumeData that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public VolumeData(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public VolumeData addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public VolumeData addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public VolumeData addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.renderStyle != null || this.renderStyleProtoInstance != null || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<VolumeData");
        if (hasAttributes) {
            if (!this.getDEF().equals(this.getDEFDefault()) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(this.getUSEDefault())) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isBlank() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), VolumeData.getBboxCenterDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(this.getBboxDisplay() == VolumeData.getBboxDisplayDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), VolumeData.getBboxSizeDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals(VolumeData.getCssClassDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getDimensions(), VolumeData.getDimensionsDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" dimensions='").append(SFVec3f.toString(this.getDimensions())).append("'");
            }
            if (!(this.getHtmlId().equals(VolumeData.getHtmlIdDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!(this.getCssStyle().equals(VolumeData.getCssStyleDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getVisible() == VolumeData.getVisibleDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.renderStyle != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.renderStyle)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.renderStyleProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.renderStyleProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.voxels != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.voxels)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.voxelsProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</VolumeData>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.renderStyle != null || this.renderStyleProtoInstance != null || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(super.getDEFDefault())) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(super.getUSEDefault())) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), VolumeData.getBboxCenterDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() != VolumeData.getBboxDisplayDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toStringClassicVRML(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), VolumeData.getBboxSizeDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(VolumeData.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("dimensions")) continue;
                        stringClassicVRML.append(indentCharacter).append("dimensions").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getDimensions(), VolumeData.getDimensionsDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("dimensions ").append(SFVec3f.toString(this.getDimensions())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlId().equals(VolumeData.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlId())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(VolumeData.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getVisible() != VolumeData.getVisibleDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toStringClassicVRML(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.renderStyle != null) {
                stringClassicVRML.append(indentCharacter).append("renderStyle").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.renderStyle)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.renderStyleProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("renderStyle").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.renderStyleProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.voxels != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.voxels)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.voxelsProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            stringClassicVRML.append("\n").append((CharSequence)indent).append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (this.getUSE().isEmpty() && (hasAttributes || hasChild)) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.renderStyle != null && (referenceElement = ((X3DConcreteElement)((Object)this.renderStyle)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.renderStyleProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.renderStyleProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.voxels != null && (referenceElement = ((X3DConcreteElement)((Object)this.voxels)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.voxelsProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.voxelsProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.renderStyle != null && (referenceNode = ((X3DConcreteElement)((Object)this.renderStyle)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.renderStyleProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.renderStyleProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.voxels != null && (referenceNode = ((X3DConcreteElement)((Object)this.voxels)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.voxelsProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.voxelsProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setDimensions(this.getDimensions());
        this.setVisible(this.getVisible());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "*** VolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "*** VolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.renderStyle != null) {
            this.setRenderStyle(this.getRenderStyle());
            ((X3DConcreteElement)((Object)this.renderStyle)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.renderStyle)).getValidationResult());
        }
        if (this.renderStyleProtoInstance != null) {
            this.setRenderStyle(this.getRenderStyleProtoInstance());
            ((X3DConcreteElement)this.renderStyleProtoInstance).validate();
            this.validationResult.append(this.renderStyleProtoInstance.getValidationResult());
        }
        if (this.renderStyle != null && this.renderStyleProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both renderStyle and renderStyleProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasRenderStyle()) {
            String errorNotice = "*** VolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode renderStyle";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.voxels != null) {
            this.setVoxels(this.getVoxels());
            ((X3DConcreteElement)((Object)this.voxels)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.voxels)).getValidationResult());
        }
        if (this.voxelsProtoInstance != null) {
            this.setVoxels(this.getVoxelsProtoInstance());
            ((X3DConcreteElement)this.voxelsProtoInstance).validate();
            this.validationResult.append(this.voxelsProtoInstance.getValidationResult());
        }
        if (this.voxels != null && this.voxelsProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both voxels and voxelsProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasVoxels()) {
            String errorNotice = "*** VolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode voxels";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "*** IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isBlank() && !Arrays.asList(this.containerField_ALLOWED_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALLOWED_VALUES='" + new MFString(this.containerField_ALLOWED_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'VolumeData' node, ensure sufficient support by adding head statement <component name='VolumeRendering' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"VolumeRendering\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

