/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Texturing;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFColorRGBA;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFInt32;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class TextureProperties
extends X3DConcreteNode
implements org.web3d.x3d.sai.Texturing.TextureProperties {
    private ArrayList<String> commentsList;
    private float anisotropicDegree;
    private float[] borderColor;
    private int borderWidth;
    private String boundaryModeR = new String();
    private String boundaryModeS = new String();
    private String boundaryModeT = new String();
    private boolean generateMipMaps;
    private IS IS;
    private String magnificationFilter = new String();
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private String minificationFilter = new String();
    private String textureCompression = new String();
    private float texturePriority;
    static boolean boundaryModeRWarningAlreadyProvided = false;
    public static final String BOUNDARYMODER_CLAMP = "CLAMP";
    public static final String BOUNDARYMODER_CLAMP_TO_EDGE = "CLAMP_TO_EDGE";
    public static final String BOUNDARYMODER_CLAMP_TO_BOUNDARY = "CLAMP_TO_BOUNDARY";
    public static final String BOUNDARYMODER_MIRRORED_REPEAT = "MIRRORED_REPEAT";
    public static final String BOUNDARYMODER_REPEAT = "REPEAT";
    static boolean boundaryModeSWarningAlreadyProvided = false;
    public static final String BOUNDARYMODES_CLAMP = "CLAMP";
    public static final String BOUNDARYMODES_CLAMP_TO_EDGE = "CLAMP_TO_EDGE";
    public static final String BOUNDARYMODES_CLAMP_TO_BOUNDARY = "CLAMP_TO_BOUNDARY";
    public static final String BOUNDARYMODES_MIRRORED_REPEAT = "MIRRORED_REPEAT";
    public static final String BOUNDARYMODES_REPEAT = "REPEAT";
    static boolean boundaryModeTWarningAlreadyProvided = false;
    public static final String BOUNDARYMODET_CLAMP = "CLAMP";
    public static final String BOUNDARYMODET_CLAMP_TO_EDGE = "CLAMP_TO_EDGE";
    public static final String BOUNDARYMODET_CLAMP_TO_BOUNDARY = "CLAMP_TO_BOUNDARY";
    public static final String BOUNDARYMODET_MIRRORED_REPEAT = "MIRRORED_REPEAT";
    public static final String BOUNDARYMODET_REPEAT = "REPEAT";
    static boolean magnificationFilterWarningAlreadyProvided = false;
    public static final String MAGNIFICATIONFILTER_AVG_PIXEL = "AVG_PIXEL";
    public static final String MAGNIFICATIONFILTER_DEFAULT = "DEFAULT";
    public static final String MAGNIFICATIONFILTER_FASTEST = "FASTEST";
    public static final String MAGNIFICATIONFILTER_NEAREST_PIXEL = "NEAREST_PIXEL";
    public static final String MAGNIFICATIONFILTER_NICEST = "NICEST";
    static boolean minificationFilterWarningAlreadyProvided = false;
    public static final String MINIFICATIONFILTER_AVG_PIXEL = "AVG_PIXEL";
    public static final String MINIFICATIONFILTER_AVG_PIXEL_AVG_MIPMAP = "AVG_PIXEL_AVG_MIPMAP";
    public static final String MINIFICATIONFILTER_AVG_PIXEL_NEAREST_MIPMAP = "AVG_PIXEL_NEAREST_MIPMAP";
    public static final String MINIFICATIONFILTER_DEFAULT = "DEFAULT";
    public static final String MINIFICATIONFILTER_FASTEST = "FASTEST";
    public static final String MINIFICATIONFILTER_NEAREST_PIXEL = "NEAREST_PIXEL";
    public static final String MINIFICATIONFILTER_NEAREST_PIXEL_AVG_MIPMAP = "NEAREST_PIXEL_AVG_MIPMAP";
    public static final String MINIFICATIONFILTER_NEAREST_PIXEL_NEAREST_MIPMAP = "NEAREST_PIXEL_NEAREST_MIPMAP";
    public static final String MINIFICATIONFILTER_NICEST = "NICEST";
    static boolean textureCompressionWarningAlreadyProvided = false;
    public static final String TEXTURECOMPRESSION_DEFAULT = "DEFAULT";
    public static final String TEXTURECOMPRESSION_FASTEST = "FASTEST";
    public static final String TEXTURECOMPRESSION_HIGH = "HIGH";
    public static final String TEXTURECOMPRESSION_LOW = "LOW";
    public static final String TEXTURECOMPRESSION_MEDIUM = "MEDIUM";
    public static final String TEXTURECOMPRESSION_NICEST = "NICEST";
    public static final String NAME = "TextureProperties";
    public static final String COMPONENT = "Texturing";
    public static final int LEVEL = 2;
    public static final float ANISOTROPICDEGREE_DEFAULT_VALUE = 1.0f;
    public static final float[] BORDERCOLOR_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public static final int BORDERWIDTH_DEFAULT_VALUE = 0;
    public static final String BOUNDARYMODER_DEFAULT_VALUE = "REPEAT";
    public static final String BOUNDARYMODES_DEFAULT_VALUE = "REPEAT";
    public static final String BOUNDARYMODET_DEFAULT_VALUE = "REPEAT";
    public static final boolean GENERATEMIPMAPS_DEFAULT_VALUE = false;
    public static final IS IS_DEFAULT_VALUE = null;
    public static final String MAGNIFICATIONFILTER_DEFAULT_VALUE = "FASTEST";
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final String MINIFICATIONFILTER_DEFAULT_VALUE = "FASTEST";
    public static final String TEXTURECOMPRESSION_DEFAULT_VALUE = "FASTEST";
    public static final float TEXTUREPRIORITY_DEFAULT_VALUE = 0.0f;
    public static final String containerField_DEFAULT_VALUE = "textureProperties";
    public static final String fromField_ANISOTROPICDEGREE = "anisotropicDegree";
    public static final String toField_ANISOTROPICDEGREE = "anisotropicDegree";
    public static final String fromField_BORDERCOLOR = "borderColor";
    public static final String toField_BORDERCOLOR = "borderColor";
    public static final String fromField_BORDERWIDTH = "borderWidth";
    public static final String toField_BORDERWIDTH = "borderWidth";
    public static final String fromField_BOUNDARYMODER = "boundaryModeR";
    public static final String toField_BOUNDARYMODER = "boundaryModeR";
    public static final String fromField_BOUNDARYMODES = "boundaryModeS";
    public static final String toField_BOUNDARYMODES = "boundaryModeS";
    public static final String fromField_BOUNDARYMODET = "boundaryModeT";
    public static final String toField_BOUNDARYMODET = "boundaryModeT";
    public static final String fromField_IS = "IS";
    public static final String fromField_MAGNIFICATIONFILTER = "magnificationFilter";
    public static final String toField_MAGNIFICATIONFILTER = "magnificationFilter";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_MINIFICATIONFILTER = "minificationFilter";
    public static final String toField_MINIFICATIONFILTER = "minificationFilter";
    public static final String fromField_TEXTURECOMPRESSION = "textureCompression";
    public static final String toField_TEXTURECOMPRESSION = "textureCompression";
    public static final String fromField_TEXTUREPRIORITY = "texturePriority";
    public static final String toField_TEXTUREPRIORITY = "texturePriority";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    public static final float getAnisotropicDegreeDefault() {
        return 1.0f;
    }

    public static final float[] getBorderColorDefault() {
        return BORDERCOLOR_DEFAULT_VALUE;
    }

    public static final int getBorderWidthDefault() {
        return 0;
    }

    public static final String getBoundaryModeRDefault() {
        return "REPEAT";
    }

    public static final String getBoundaryModeSDefault() {
        return "REPEAT";
    }

    public static final String getBoundaryModeTDefault() {
        return "REPEAT";
    }

    public static final boolean getGenerateMipMapsDefault() {
        return false;
    }

    public static final IS getISDefault() {
        return IS_DEFAULT_VALUE;
    }

    public static final String getMagnificationFilterDefault() {
        return "FASTEST";
    }

    public static final X3DMetadataObject getMetadataDefault() {
        return METADATA_DEFAULT_VALUE;
    }

    public static final String getMinificationFilterDefault() {
        return "FASTEST";
    }

    public static final String getTextureCompressionDefault() {
        return "FASTEST";
    }

    public static final float getTexturePriorityDefault() {
        return 0.0f;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "anisotropicDegree" -> "SFFloat";
            case "borderColor" -> "SFColorRGBA";
            case "borderWidth" -> "SFInt32";
            case "boundaryModeR" -> "SFString";
            case "boundaryModeS" -> "SFString";
            case "boundaryModeT" -> "SFString";
            case "generateMipMaps" -> "SFBool";
            case fromField_IS -> "SFNode";
            case "magnificationFilter" -> "SFString";
            case "metadata" -> "SFNode";
            case "minificationFilter" -> "SFString";
            case "textureCompression" -> "SFString";
            case "texturePriority" -> "SFFloat";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "anisotropicDegree" -> "inputOutput";
            case "borderColor" -> "inputOutput";
            case "borderWidth" -> "inputOutput";
            case "boundaryModeR" -> "inputOutput";
            case "boundaryModeS" -> "inputOutput";
            case "boundaryModeT" -> "inputOutput";
            case "generateMipMaps" -> "initializeOnly";
            case fromField_IS -> "inputOutput";
            case "magnificationFilter" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "minificationFilter" -> "inputOutput";
            case "textureCompression" -> "inputOutput";
            case "texturePriority" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public TextureProperties() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALLOWED_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.anisotropicDegree = TextureProperties.getAnisotropicDegreeDefault();
        this.borderColor = TextureProperties.getBorderColorDefault();
        this.borderWidth = TextureProperties.getBorderWidthDefault();
        this.boundaryModeR = TextureProperties.getBoundaryModeRDefault();
        this.boundaryModeS = TextureProperties.getBoundaryModeSDefault();
        this.boundaryModeT = TextureProperties.getBoundaryModeTDefault();
        this.generateMipMaps = TextureProperties.getGenerateMipMapsDefault();
        this.IS = null;
        this.magnificationFilter = TextureProperties.getMagnificationFilterDefault();
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.minificationFilter = TextureProperties.getMinificationFilterDefault();
        this.textureCompression = TextureProperties.getTextureCompressionDefault();
        this.texturePriority = TextureProperties.getTexturePriorityDefault();
        this.commentsList = new ArrayList();
    }

    @Override
    public float getAnisotropicDegree() {
        return this.anisotropicDegree;
    }

    @Override
    public TextureProperties setAnisotropicDegree(float newValue) {
        if (newValue < 1.0f) {
            throw new InvalidFieldValueException("TextureProperties anisotropicDegree newValue=" + newValue + " has component value less than restriction minInclusive=1");
        }
        this.anisotropicDegree = newValue;
        return this;
    }

    public TextureProperties setAnisotropicDegree(SFFloat newValue) {
        this.setAnisotropicDegree(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProperties setAnisotropicDegree(double newValue) {
        return this.setAnisotropicDegree((float)newValue);
    }

    @Override
    public float[] getBorderColor() {
        return this.borderColor;
    }

    @Override
    public TextureProperties setBorderColor(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 4) {
            throw new InvalidFieldValueException("TextureProperties borderColor newValue=" + SFColorRGBA.toString(newValue) + " has length=" + newValue.length + " instead of required length 4");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f || newValue[3] < 0.0f) {
            throw new InvalidFieldValueException("TextureProperties borderColor newValue=" + String.valueOf(newValue) + " has component value less than restriction minInclusive=0");
        }
        if (newValue[0] > 1.0f || newValue[1] > 1.0f || newValue[2] > 1.0f || newValue[3] > 1.0f) {
            throw new InvalidFieldValueException("TextureProperties borderColor newValue=" + SFColorRGBA.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.borderColor = newValue;
        return this;
    }

    public TextureProperties setBorderColor(SFColorRGBA newValue) {
        this.setBorderColor(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProperties setBorderColor(float red, float green, float blue, float alpha) {
        this.setBorderColor(new float[]{red, green, blue, alpha});
        return this;
    }

    public TextureProperties setBorderColor(double red, double green, double blue, double alpha) {
        return this.setBorderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public TextureProperties setBorderColor(double[] newArray) {
        return this.setBorderColor(new SFColorRGBA(newArray));
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public TextureProperties setBorderWidth(int newValue) {
        if (newValue < 0) {
            throw new InvalidFieldValueException("TextureProperties borderWidth newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.borderWidth = newValue;
        return this;
    }

    public TextureProperties setBorderWidth(SFInt32 newValue) {
        this.setBorderWidth(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getBoundaryModeR() {
        return this.boundaryModeR;
    }

    @Override
    public TextureProperties setBoundaryModeR(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.boundaryModeR = newValue;
        return this;
    }

    public TextureProperties setBoundaryModeR(SFString newValue) {
        this.setBoundaryModeR(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getBoundaryModeS() {
        return this.boundaryModeS;
    }

    @Override
    public TextureProperties setBoundaryModeS(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.boundaryModeS = newValue;
        return this;
    }

    public TextureProperties setBoundaryModeS(SFString newValue) {
        this.setBoundaryModeS(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getBoundaryModeT() {
        return this.boundaryModeT;
    }

    @Override
    public TextureProperties setBoundaryModeT(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.boundaryModeT = newValue;
        return this;
    }

    public TextureProperties setBoundaryModeT(SFString newValue) {
        this.setBoundaryModeT(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public boolean getGenerateMipMaps() {
        return this.generateMipMaps;
    }

    @Override
    public TextureProperties setGenerateMipMaps(boolean newValue) {
        this.generateMipMaps = newValue;
        return this;
    }

    public TextureProperties setGenerateMipMaps(SFBool newValue) {
        this.setGenerateMipMaps(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public TextureProperties setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public TextureProperties clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public String getMagnificationFilter() {
        return this.magnificationFilter;
    }

    @Override
    public TextureProperties setMagnificationFilter(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.magnificationFilter = newValue;
        return this;
    }

    public TextureProperties setMagnificationFilter(SFString newValue) {
        this.setMagnificationFilter(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public TextureProperties setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public TextureProperties clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public TextureProperties setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public String getMinificationFilter() {
        return this.minificationFilter;
    }

    @Override
    public TextureProperties setMinificationFilter(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.minificationFilter = newValue;
        return this;
    }

    public TextureProperties setMinificationFilter(SFString newValue) {
        this.setMinificationFilter(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getTextureCompression() {
        return this.textureCompression;
    }

    @Override
    public TextureProperties setTextureCompression(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if ((newValue = MFString.cleanupUnescapedEnclosingQuotes(newValue)) == null) {
            newValue = new String();
        }
        this.textureCompression = newValue;
        return this;
    }

    public TextureProperties setTextureCompression(SFString newValue) {
        this.setTextureCompression(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getTexturePriority() {
        return this.texturePriority;
    }

    @Override
    public TextureProperties setTexturePriority(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("TextureProperties texturePriority newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("TextureProperties texturePriority newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.texturePriority = newValue;
        return this;
    }

    public TextureProperties setTexturePriority(SFFloat newValue) {
        this.setTexturePriority(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProperties setTexturePriority(double newValue) {
        return this.setTexturePriority((float)newValue);
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final TextureProperties setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("TextureProperties DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public TextureProperties setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final TextureProperties setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("TextureProperties USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public TextureProperties setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final TextureProperties setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public TextureProperties setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    @Override
    public final TextureProperties setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public TextureProperties setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final TextureProperties setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public TextureProperties setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public TextureProperties setUSE(TextureProperties DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "*** setUSE(DEFnode) invoked on TextureProperties that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public TextureProperties(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public TextureProperties addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public TextureProperties addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public TextureProperties addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<TextureProperties");
        if (hasAttributes) {
            if (!this.getDEF().equals(this.getDEFDefault()) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(this.getUSEDefault())) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isBlank() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getAnisotropicDegree() == TextureProperties.getAnisotropicDegreeDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" anisotropicDegree='").append(SFFloat.toString(this.getAnisotropicDegree())).append("'");
            }
            if (!(Arrays.equals(this.getBorderColor(), TextureProperties.getBorderColorDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" borderColor='").append(SFColorRGBA.toString(this.getBorderColor())).append("'");
            }
            if (!(this.getBorderWidth() == TextureProperties.getBorderWidthDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" borderWidth='").append(SFInt32.toString(this.getBorderWidth())).append("'");
            }
            if (!(this.getBoundaryModeR().equals(TextureProperties.getBoundaryModeRDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" boundaryModeR='").append(new SFString(this.getBoundaryModeR()).toStringX3D()).append("'");
            }
            if (!(this.getBoundaryModeS().equals(TextureProperties.getBoundaryModeSDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" boundaryModeS='").append(new SFString(this.getBoundaryModeS()).toStringX3D()).append("'");
            }
            if (!(this.getBoundaryModeT().equals(TextureProperties.getBoundaryModeTDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" boundaryModeT='").append(new SFString(this.getBoundaryModeT()).toStringX3D()).append("'");
            }
            if (!(this.getCssClass().equals(TextureProperties.getCssClassDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(this.getGenerateMipMaps() == TextureProperties.getGenerateMipMapsDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" generateMipMaps='").append(SFBool.toString(this.getGenerateMipMaps())).append("'");
            }
            if (!(this.getHtmlId().equals(TextureProperties.getHtmlIdDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!(this.getMagnificationFilter().equals(TextureProperties.getMagnificationFilterDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" magnificationFilter='").append(new SFString(this.getMagnificationFilter()).toStringX3D()).append("'");
            }
            if (!(this.getMinificationFilter().equals(TextureProperties.getMinificationFilterDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" minificationFilter='").append(new SFString(this.getMinificationFilter()).toStringX3D()).append("'");
            }
            if (!(this.getCssStyle().equals(TextureProperties.getCssStyleDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getTextureCompression().equals(TextureProperties.getTextureCompressionDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" textureCompression='").append(new SFString(this.getTextureCompression()).toStringX3D()).append("'");
            }
            if (!(this.getTexturePriority() == TextureProperties.getTexturePriorityDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" texturePriority='").append(SFFloat.toString(this.getTexturePriority())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</TextureProperties>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(super.getDEFDefault())) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(super.getUSEDefault())) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("anisotropicDegree")) continue;
                        stringClassicVRML.append(indentCharacter).append("anisotropicDegree").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getAnisotropicDegree() != TextureProperties.getAnisotropicDegreeDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("anisotropicDegree ").append(SFFloat.toString(this.getAnisotropicDegree())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("borderColor")) continue;
                        stringClassicVRML.append(indentCharacter).append("borderColor").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBorderColor(), TextureProperties.getBorderColorDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("borderColor ").append(SFColorRGBA.toString(this.getBorderColor())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("borderWidth")) continue;
                        stringClassicVRML.append(indentCharacter).append("borderWidth").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBorderWidth() != TextureProperties.getBorderWidthDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("borderWidth ").append(SFInt32.toString(this.getBorderWidth())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("boundaryModeR")) continue;
                        stringClassicVRML.append(indentCharacter).append("boundaryModeR").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getBoundaryModeR().equals(TextureProperties.getBoundaryModeRDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("boundaryModeR ").append("\"").append(SFString.toString(this.getBoundaryModeR())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("boundaryModeS")) continue;
                        stringClassicVRML.append(indentCharacter).append("boundaryModeS").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getBoundaryModeS().equals(TextureProperties.getBoundaryModeSDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("boundaryModeS ").append("\"").append(SFString.toString(this.getBoundaryModeS())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("boundaryModeT")) continue;
                        stringClassicVRML.append(indentCharacter).append("boundaryModeT").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getBoundaryModeT().equals(TextureProperties.getBoundaryModeTDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("boundaryModeT ").append("\"").append(SFString.toString(this.getBoundaryModeT())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(TextureProperties.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("generateMipMaps")) continue;
                        stringClassicVRML.append(indentCharacter).append("generateMipMaps").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getGenerateMipMaps() != TextureProperties.getGenerateMipMapsDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("generateMipMaps ").append(SFBool.toStringClassicVRML(this.getGenerateMipMaps())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlId().equals(TextureProperties.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlId())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("magnificationFilter")) continue;
                        stringClassicVRML.append(indentCharacter).append("magnificationFilter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getMagnificationFilter().equals(TextureProperties.getMagnificationFilterDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("magnificationFilter ").append("\"").append(SFString.toString(this.getMagnificationFilter())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("minificationFilter")) continue;
                        stringClassicVRML.append(indentCharacter).append("minificationFilter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getMinificationFilter().equals(TextureProperties.getMinificationFilterDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("minificationFilter ").append("\"").append(SFString.toString(this.getMinificationFilter())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(TextureProperties.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("textureCompression")) continue;
                        stringClassicVRML.append(indentCharacter).append("textureCompression").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getTextureCompression().equals(TextureProperties.getTextureCompressionDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("textureCompression ").append("\"").append(SFString.toString(this.getTextureCompression())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("texturePriority")) continue;
                        stringClassicVRML.append(indentCharacter).append("texturePriority").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTexturePriority() != TextureProperties.getTexturePriorityDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("texturePriority ").append(SFFloat.toString(this.getTexturePriority())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            stringClassicVRML.append("\n").append((CharSequence)indent).append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (this.getUSE().isEmpty() && (hasAttributes || hasChild)) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAnisotropicDegree(this.getAnisotropicDegree());
        this.setBorderColor(this.getBorderColor());
        this.setBorderWidth(this.getBorderWidth());
        this.setBoundaryModeR(this.getBoundaryModeR());
        this.setBoundaryModeS(this.getBoundaryModeS());
        this.setBoundaryModeT(this.getBoundaryModeT());
        this.setGenerateMipMaps(this.getGenerateMipMaps());
        this.setMagnificationFilter(this.getMagnificationFilter());
        this.setMinificationFilter(this.getMinificationFilter());
        this.setTextureCompression(this.getTextureCompression());
        this.setTexturePriority(this.getTexturePriority());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        this.setCssStyle(this.getCssStyle());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "*** TextureProperties USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "*** TextureProperties USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "*** IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isBlank() && !Arrays.asList(this.containerField_ALLOWED_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALLOWED_VALUES='" + new MFString(this.containerField_ALLOWED_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'TextureProperties' node, ensure sufficient support by adding head statement <component name='Texturing' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Texturing\").setLevel(2);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

