/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Shape;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFColor;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing.X3DSingleTextureNode;

public class UnlitMaterial
extends X3DConcreteNode
implements org.web3d.x3d.sai.Shape.UnlitMaterial {
    private ArrayList<String> commentsList;
    private float[] emissiveColor;
    private X3DSingleTextureNode emissiveTexture;
    private ProtoInstance emissiveTextureProtoInstance;
    private String emissiveTextureMapping = new String();
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float normalScale;
    private X3DSingleTextureNode normalTexture;
    private ProtoInstance normalTextureProtoInstance;
    private String normalTextureMapping = new String();
    private float transparency;
    public static final String NAME = "UnlitMaterial";
    public static final String COMPONENT = "Shape";
    public static final int LEVEL = 1;
    public static final float[] EMISSIVECOLOR_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final X3DSingleTextureNode EMISSIVETEXTURE_DEFAULT_VALUE = null;
    public static final String EMISSIVETEXTUREMAPPING_DEFAULT_VALUE = "";
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final float NORMALSCALE_DEFAULT_VALUE = 1.0f;
    public static final X3DSingleTextureNode NORMALTEXTURE_DEFAULT_VALUE = null;
    public static final String NORMALTEXTUREMAPPING_DEFAULT_VALUE = "";
    public static final float TRANSPARENCY_DEFAULT_VALUE = 0.0f;
    public static final String containerField_DEFAULT_VALUE = "material";
    public static final String fromField_EMISSIVECOLOR = "emissiveColor";
    public static final String toField_EMISSIVECOLOR = "emissiveColor";
    public static final String fromField_EMISSIVETEXTURE = "emissiveTexture";
    public static final String toField_EMISSIVETEXTURE = "emissiveTexture";
    public static final String fromField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";
    public static final String toField_EMISSIVETEXTUREMAPPING = "emissiveTextureMapping";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_NORMALSCALE = "normalScale";
    public static final String toField_NORMALSCALE = "normalScale";
    public static final String fromField_NORMALTEXTURE = "normalTexture";
    public static final String toField_NORMALTEXTURE = "normalTexture";
    public static final String fromField_NORMALTEXTUREMAPPING = "normalTextureMapping";
    public static final String toField_NORMALTEXTUREMAPPING = "normalTextureMapping";
    public static final String fromField_TRANSPARENCY = "transparency";
    public static final String toField_TRANSPARENCY = "transparency";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    public static final float[] getEmissiveColorDefault() {
        return EMISSIVECOLOR_DEFAULT_VALUE;
    }

    public static final X3DSingleTextureNode getEmissiveTextureDefault() {
        return EMISSIVETEXTURE_DEFAULT_VALUE;
    }

    public static final String getEmissiveTextureMappingDefault() {
        return "";
    }

    public static final IS getISDefault() {
        return IS_DEFAULT_VALUE;
    }

    public static final X3DMetadataObject getMetadataDefault() {
        return METADATA_DEFAULT_VALUE;
    }

    public static final float getNormalScaleDefault() {
        return 1.0f;
    }

    public static final X3DSingleTextureNode getNormalTextureDefault() {
        return NORMALTEXTURE_DEFAULT_VALUE;
    }

    public static final String getNormalTextureMappingDefault() {
        return "";
    }

    public static final float getTransparencyDefault() {
        return 0.0f;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "emissiveColor" -> "SFColor";
            case "emissiveTexture" -> "SFNode";
            case "emissiveTextureMapping" -> "SFString";
            case fromField_IS -> "SFNode";
            case "metadata" -> "SFNode";
            case "normalScale" -> "SFFloat";
            case "normalTexture" -> "SFNode";
            case "normalTextureMapping" -> "SFString";
            case "transparency" -> "SFFloat";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "emissiveColor" -> "inputOutput";
            case "emissiveTexture" -> "inputOutput";
            case "emissiveTextureMapping" -> "inputOutput";
            case fromField_IS -> "inputOutput";
            case "metadata" -> "inputOutput";
            case "normalScale" -> "inputOutput";
            case "normalTexture" -> "inputOutput";
            case "normalTextureMapping" -> "inputOutput";
            case "transparency" -> "inputOutput";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public UnlitMaterial() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALLOWED_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.emissiveColor = UnlitMaterial.getEmissiveColorDefault();
        this.emissiveTexture = null;
        this.emissiveTextureProtoInstance = null;
        this.emissiveTextureMapping = UnlitMaterial.getEmissiveTextureMappingDefault();
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.normalScale = UnlitMaterial.getNormalScaleDefault();
        this.normalTexture = null;
        this.normalTextureProtoInstance = null;
        this.normalTextureMapping = UnlitMaterial.getNormalTextureMappingDefault();
        this.transparency = UnlitMaterial.getTransparencyDefault();
        this.commentsList = new ArrayList();
    }

    @Override
    public float[] getEmissiveColor() {
        return this.emissiveColor;
    }

    @Override
    public UnlitMaterial setEmissiveColor(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("UnlitMaterial emissiveColor newValue=" + SFColor.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) {
            throw new InvalidFieldValueException("UnlitMaterial emissiveColor newValue=" + String.valueOf(newValue) + " has component value less than restriction minInclusive=0");
        }
        if (newValue[0] > 1.0f || newValue[1] > 1.0f || newValue[2] > 1.0f) {
            throw new InvalidFieldValueException("UnlitMaterial emissiveColor newValue=" + SFColor.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.emissiveColor = newValue;
        return this;
    }

    public UnlitMaterial setEmissiveColor(SFColor newValue) {
        this.setEmissiveColor(newValue.getPrimitiveValue());
        return this;
    }

    public UnlitMaterial setEmissiveColor(float red, float green, float blue) {
        this.setEmissiveColor(new float[]{red, green, blue});
        return this;
    }

    public UnlitMaterial setEmissiveColor(double red, double green, double blue) {
        return this.setEmissiveColor((float)red, (float)green, (float)blue);
    }

    public UnlitMaterial setEmissiveColor(double[] newArray) {
        return this.setEmissiveColor(new SFColor(newArray));
    }

    @Override
    public X3DSingleTextureNode getEmissiveTexture() {
        return this.emissiveTexture;
    }

    @Override
    public UnlitMaterial setEmissiveTexture(X3DSingleTextureNode newValue) {
        this.emissiveTexture = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.emissiveTexture)).setParent(this);
        }
        if (this.emissiveTextureProtoInstance != null) {
            this.emissiveTextureProtoInstance.setParent(null);
            this.emissiveTextureProtoInstance = null;
        }
        return this;
    }

    public UnlitMaterial clearEmissiveTexture() {
        ((X3DConcreteElement)((Object)this.emissiveTexture)).clearParent();
        this.emissiveTexture = null;
        return this;
    }

    public UnlitMaterial setEmissiveTexture(ProtoInstance newValue) {
        if (this.emissiveTextureProtoInstance != null) {
            this.emissiveTextureProtoInstance.setParent(null);
        }
        this.emissiveTextureProtoInstance = newValue;
        if (newValue != null) {
            this.emissiveTextureProtoInstance.setParent(this);
            this.emissiveTextureProtoInstance.setContainerField("emissiveTexture");
        }
        if (this.emissiveTexture != null) {
            ((X3DConcreteElement)((Object)this.emissiveTexture)).setParent(null);
            this.emissiveTexture = null;
        }
        return this;
    }

    private ProtoInstance getEmissiveTextureProtoInstance() {
        return this.emissiveTextureProtoInstance;
    }

    public boolean hasEmissiveTexture() {
        return this.emissiveTexture != null || this.emissiveTextureProtoInstance != null;
    }

    @Override
    public String getEmissiveTextureMapping() {
        return this.emissiveTextureMapping;
    }

    @Override
    public UnlitMaterial setEmissiveTextureMapping(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.emissiveTextureMapping = newValue;
        return this;
    }

    public UnlitMaterial setEmissiveTextureMapping(SFString newValue) {
        this.setEmissiveTextureMapping(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public UnlitMaterial setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public UnlitMaterial clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public UnlitMaterial setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public UnlitMaterial clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public UnlitMaterial setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float getNormalScale() {
        return this.normalScale;
    }

    @Override
    public UnlitMaterial setNormalScale(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("UnlitMaterial normalScale newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        this.normalScale = newValue;
        return this;
    }

    public UnlitMaterial setNormalScale(SFFloat newValue) {
        this.setNormalScale(newValue.getPrimitiveValue());
        return this;
    }

    public UnlitMaterial setNormalScale(double newValue) {
        return this.setNormalScale((float)newValue);
    }

    @Override
    public X3DSingleTextureNode getNormalTexture() {
        return this.normalTexture;
    }

    @Override
    public UnlitMaterial setNormalTexture(X3DSingleTextureNode newValue) {
        this.normalTexture = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.normalTexture)).setParent(this);
        }
        if (this.normalTextureProtoInstance != null) {
            this.normalTextureProtoInstance.setParent(null);
            this.normalTextureProtoInstance = null;
        }
        return this;
    }

    public UnlitMaterial clearNormalTexture() {
        ((X3DConcreteElement)((Object)this.normalTexture)).clearParent();
        this.normalTexture = null;
        return this;
    }

    public UnlitMaterial setNormalTexture(ProtoInstance newValue) {
        if (this.normalTextureProtoInstance != null) {
            this.normalTextureProtoInstance.setParent(null);
        }
        this.normalTextureProtoInstance = newValue;
        if (newValue != null) {
            this.normalTextureProtoInstance.setParent(this);
            this.normalTextureProtoInstance.setContainerField("normalTexture");
        }
        if (this.normalTexture != null) {
            ((X3DConcreteElement)((Object)this.normalTexture)).setParent(null);
            this.normalTexture = null;
        }
        return this;
    }

    private ProtoInstance getNormalTextureProtoInstance() {
        return this.normalTextureProtoInstance;
    }

    public boolean hasNormalTexture() {
        return this.normalTexture != null || this.normalTextureProtoInstance != null;
    }

    @Override
    public String getNormalTextureMapping() {
        return this.normalTextureMapping;
    }

    @Override
    public UnlitMaterial setNormalTextureMapping(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.normalTextureMapping = newValue;
        return this;
    }

    public UnlitMaterial setNormalTextureMapping(SFString newValue) {
        this.setNormalTextureMapping(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float getTransparency() {
        return this.transparency;
    }

    @Override
    public UnlitMaterial setTransparency(float newValue) {
        if (newValue < 0.0f) {
            throw new InvalidFieldValueException("UnlitMaterial transparency newValue=" + newValue + " has component value less than restriction minInclusive=0");
        }
        if (newValue > 1.0f) {
            throw new InvalidFieldValueException("UnlitMaterial transparency newValue=" + SFFloat.toString(newValue) + " has component value greater than restriction maxInclusive=1");
        }
        this.transparency = newValue;
        return this;
    }

    public UnlitMaterial setTransparency(SFFloat newValue) {
        this.setTransparency(newValue.getPrimitiveValue());
        return this;
    }

    public UnlitMaterial setTransparency(double newValue) {
        return this.setTransparency((float)newValue);
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final UnlitMaterial setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("UnlitMaterial DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public UnlitMaterial setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final UnlitMaterial setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("UnlitMaterial USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public UnlitMaterial setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final UnlitMaterial setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public UnlitMaterial setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    @Override
    public final UnlitMaterial setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public UnlitMaterial setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final UnlitMaterial setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public UnlitMaterial setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public UnlitMaterial setUSE(UnlitMaterial DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "*** setUSE(DEFnode) invoked on UnlitMaterial that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public UnlitMaterial(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public UnlitMaterial addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public UnlitMaterial addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public UnlitMaterial addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.emissiveTexture != null || this.emissiveTextureProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.normalTexture != null || this.normalTextureProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<UnlitMaterial");
        if (hasAttributes) {
            if (!this.getDEF().equals(this.getDEFDefault()) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(this.getUSEDefault())) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isBlank() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals(UnlitMaterial.getCssClassDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getEmissiveColor(), UnlitMaterial.getEmissiveColorDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" emissiveColor='").append(SFColor.toString(this.getEmissiveColor())).append("'");
            }
            if (!(this.getEmissiveTextureMapping().equals(UnlitMaterial.getEmissiveTextureMappingDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" emissiveTextureMapping='").append(new SFString(this.getEmissiveTextureMapping()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlId().equals(UnlitMaterial.getHtmlIdDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!(this.getNormalScale() == UnlitMaterial.getNormalScaleDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" normalScale='").append(SFFloat.toString(this.getNormalScale())).append("'");
            }
            if (!(this.getNormalTextureMapping().equals(UnlitMaterial.getNormalTextureMappingDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" normalTextureMapping='").append(new SFString(this.getNormalTextureMapping()).toStringX3D()).append("'");
            }
            if (!(this.getCssStyle().equals(UnlitMaterial.getCssStyleDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
            if (!(this.getTransparency() == UnlitMaterial.getTransparencyDefault() && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" transparency='").append(SFFloat.toString(this.getTransparency())).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.emissiveTexture != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.emissiveTexture)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.emissiveTextureProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.emissiveTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.normalTexture != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.normalTexture)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.normalTextureProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.normalTextureProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</UnlitMaterial>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.emissiveTexture != null || this.emissiveTextureProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || this.normalTexture != null || this.normalTextureProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(super.getDEFDefault())) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(super.getUSEDefault())) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(UnlitMaterial.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("emissiveColor")) continue;
                        stringClassicVRML.append(indentCharacter).append("emissiveColor").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getEmissiveColor(), UnlitMaterial.getEmissiveColorDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("emissiveColor ").append(SFColor.toString(this.getEmissiveColor())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("emissiveTextureMapping")) continue;
                        stringClassicVRML.append(indentCharacter).append("emissiveTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getEmissiveTextureMapping().equals(UnlitMaterial.getEmissiveTextureMappingDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("emissiveTextureMapping ").append("\"").append(SFString.toString(this.getEmissiveTextureMapping())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlId().equals(UnlitMaterial.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlId())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("normalScale")) continue;
                        stringClassicVRML.append(indentCharacter).append("normalScale").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getNormalScale() != UnlitMaterial.getNormalScaleDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("normalScale ").append(SFFloat.toString(this.getNormalScale())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("normalTextureMapping")) continue;
                        stringClassicVRML.append(indentCharacter).append("normalTextureMapping").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getNormalTextureMapping().equals(UnlitMaterial.getNormalTextureMappingDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("normalTextureMapping ").append("\"").append(SFString.toString(this.getNormalTextureMapping())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(UnlitMaterial.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("transparency")) continue;
                        stringClassicVRML.append(indentCharacter).append("transparency").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getTransparency() != UnlitMaterial.getTransparencyDefault() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("transparency ").append(SFFloat.toString(this.getTransparency())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.emissiveTexture != null) {
                stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.emissiveTexture)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.emissiveTextureProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("emissiveTexture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.emissiveTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.normalTexture != null) {
                stringClassicVRML.append(indentCharacter).append("normalTexture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.normalTexture)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.normalTextureProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("normalTexture").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.normalTextureProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            stringClassicVRML.append("\n").append((CharSequence)indent).append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (this.getUSE().isEmpty() && (hasAttributes || hasChild)) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.emissiveTexture != null && (referenceElement = ((X3DConcreteElement)((Object)this.emissiveTexture)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.emissiveTextureProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.emissiveTextureProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.normalTexture != null && (referenceElement = ((X3DConcreteElement)((Object)this.normalTexture)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.normalTextureProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.normalTextureProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.emissiveTexture != null && (referenceNode = ((X3DConcreteElement)((Object)this.emissiveTexture)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.emissiveTextureProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.emissiveTextureProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.normalTexture != null && (referenceNode = ((X3DConcreteElement)((Object)this.normalTexture)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.normalTextureProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.normalTextureProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setEmissiveColor(this.getEmissiveColor());
        this.setEmissiveTextureMapping(this.getEmissiveTextureMapping());
        this.setNormalScale(this.getNormalScale());
        this.setNormalTextureMapping(this.getNormalTextureMapping());
        this.setTransparency(this.getTransparency());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        this.setCssStyle(this.getCssStyle());
        if (this.emissiveTexture != null) {
            this.setEmissiveTexture(this.getEmissiveTexture());
            ((X3DConcreteElement)((Object)this.emissiveTexture)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.emissiveTexture)).getValidationResult());
        }
        if (this.emissiveTextureProtoInstance != null) {
            this.setEmissiveTexture(this.getEmissiveTextureProtoInstance());
            ((X3DConcreteElement)this.emissiveTextureProtoInstance).validate();
            this.validationResult.append(this.emissiveTextureProtoInstance.getValidationResult());
        }
        if (this.emissiveTexture != null && this.emissiveTextureProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both emissiveTexture and emissiveTextureProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasEmissiveTexture()) {
            String errorNotice = "*** UnlitMaterial USE='" + this.getUSE() + "' is not allowed to have contained SFNode emissiveTexture";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "*** UnlitMaterial USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "*** UnlitMaterial USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.normalTexture != null) {
            this.setNormalTexture(this.getNormalTexture());
            ((X3DConcreteElement)((Object)this.normalTexture)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.normalTexture)).getValidationResult());
        }
        if (this.normalTextureProtoInstance != null) {
            this.setNormalTexture(this.getNormalTextureProtoInstance());
            ((X3DConcreteElement)this.normalTextureProtoInstance).validate();
            this.validationResult.append(this.normalTextureProtoInstance.getValidationResult());
        }
        if (this.normalTexture != null && this.normalTextureProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both normalTexture and normalTextureProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasNormalTexture()) {
            String errorNotice = "*** UnlitMaterial USE='" + this.getUSE() + "' is not allowed to have contained SFNode normalTexture";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "*** IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isBlank() && !Arrays.asList(this.containerField_ALLOWED_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALLOWED_VALUES='" + new MFString(this.containerField_ALLOWED_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'UnlitMaterial' node, ensure sufficient support by adding head statement <component name='Shape' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Shape\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

