/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Networking;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class EXPORT
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    private String AS = new String();
    private String localDEF = new String();
    public static final String NAME = "EXPORT";
    public static final String COMPONENT = "Networking";
    public static final int LEVEL = 3;
    public static final String AS_DEFAULT_VALUE = "";
    public static final String LOCALDEF_DEFAULT_VALUE = "";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 3;
    }

    public static final String getASDefault() {
        return "";
    }

    public static final String getLocalDEFDefault() {
        return "";
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "AS" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "localDEF" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "AS" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "localDEF" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public EXPORT() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.AS = EXPORT.getASDefault();
        this.localDEF = EXPORT.getLocalDEFDefault();
        this.commentsList = new ArrayList();
    }

    public String getAS() {
        return this.AS;
    }

    public EXPORT setAS(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("EXPORT AS newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.AS = newValue;
        return this;
    }

    public EXPORT setAS(SFString newValue) {
        this.setAS(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final EXPORT setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("EXPORT class newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public EXPORT setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    public final EXPORT setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("EXPORT id newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public EXPORT setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    public String getLocalDEF() {
        return this.localDEF;
    }

    public EXPORT setLocalDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("EXPORT localDEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.localDEF = newValue;
        return this;
    }

    public EXPORT setLocalDEF(SFString newValue) {
        this.setLocalDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final EXPORT setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("EXPORT style newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public EXPORT setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public EXPORT addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public EXPORT addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public EXPORT addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<EXPORT");
        if (hasAttributes) {
            if (!this.getAS().equals(EXPORT.getASDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" AS='").append(new SFString(this.getAS()).toStringX3D()).append("'");
            }
            if (!this.getCssClass().equals(EXPORT.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getHtmlId().equals(EXPORT.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!this.getLocalDEF().equals(EXPORT.getLocalDEFDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" localDEF='").append(new SFString(this.getLocalDEF()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals(EXPORT.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</EXPORT>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("EXPORT ").append(this.getLocalDEF());
        if (this.getLocalDEF().equals("")) {
            stringClassicVRML.append("TODO_MISSING_LOCALDEF");
        }
        if (!this.getAS().equals("")) {
            stringClassicVRML.append(" AS ").append(SFString.toString(this.getAS())).append(" ");
        }
        stringClassicVRML.append("\n").append((CharSequence)indent);
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setAS(this.getAS());
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        if (this.getLocalDEF().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, EXPORT localDEF field is required but no value found.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setLocalDEF(this.getLocalDEF());
        this.setCssStyle(this.getCssStyle());
        String errorNotice = new String();
        String EXPORT_description = "<EXPORT localDEF='" + this.localDEF + "' AS='" + this.AS + "'/>";
        if (this.findAncestorScene() == null) {
            if (!ConfigurationProperties.isCreationConnectionValidationExceptionAllowed()) {
                errorNotice = "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH: EXPORT is not currently connected to Scene scene graph and thus cannot get checked.";
                this.validationResult.append(EXPORT_description).append("\n").append(errorNotice).append("\n");
            }
        } else {
            X3DConcreteNode localDEFObject = this.findAncestorScene().findNodeByDEF(this.localDEF);
            if (this.localDEF.isEmpty()) {
                errorNotice = "EXPORT has no localDEF defined. ";
            } else if (localDEFObject == null) {
                errorNotice = "Local node with DEF=localDEF not found. ";
            }
            if (!errorNotice.isEmpty()) {
                this.validationResult.append(EXPORT_description).append("\n").append(errorNotice).append("\n");
                throw new InvalidFieldValueException(EXPORT_description + "\n" + errorNotice);
            }
        }
        return this.validationResult.toString();
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public EXPORT setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public EXPORT setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public EXPORT setUSE(String newValue) {
        return this;
    }
}

