/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Geospatial;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFFloat;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.MFVec3d;
import org.web3d.x3d.jsail.fields.SFFloat;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3d;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Geospatial.GeoOrigin;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;

public class GeoPositionInterpolator
extends X3DConcreteNode
implements org.web3d.x3d.sai.Geospatial.GeoPositionInterpolator {
    private ArrayList<String> commentsList;
    private GeoOrigin geoOrigin;
    private ProtoInstance geoOriginProtoInstance;
    private ArrayList<String> geoSystem = new ArrayList();
    private double[] geovalue;
    private IS IS;
    private ArrayList<Float> key = new ArrayList();
    private double[] keyValue;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private float fraction;
    private float[] value;
    public static final String NAME = "GeoPositionInterpolator";
    public static final String COMPONENT = "Geospatial";
    public static final int LEVEL = 1;
    public static final GeoOrigin GEOORIGIN_DEFAULT_VALUE = null;
    private static final ArrayList<String> GEOSYSTEM_DEFAULT_VALUE = new ArrayList<String>(Arrays.asList("GD", "WE"));
    public static final IS IS_DEFAULT_VALUE = null;
    private static final ArrayList<Float> KEY_DEFAULT_VALUE = new ArrayList();
    private static final double[] KEYVALUE_DEFAULT_VALUE = new double[0];
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_GEOVALUE_CHANGED = "geovalue_changed";
    public static final String fromField_IS = "IS";
    public static final String fromField_KEY = "key";
    public static final String toField_KEY = "key";
    public static final String fromField_KEYVALUE = "keyValue";
    public static final String toField_KEYVALUE = "keyValue";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String toField_SET_FRACTION = "set_fraction";
    public static final String fromField_VALUE_CHANGED = "value_changed";
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    public static final GeoOrigin getGeoOriginDefault() {
        return GEOORIGIN_DEFAULT_VALUE;
    }

    public static final String[] getGeoSystemDefault() {
        String[] valuesArray = new String[GEOSYSTEM_DEFAULT_VALUE.size()];
        int i = 0;
        for (String arrayElement : GEOSYSTEM_DEFAULT_VALUE) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public static final ArrayList<String> getGeoSystemDefaultList() {
        ArrayList<String> newArrayList = new ArrayList<String>();
        for (String value : GEOSYSTEM_DEFAULT_VALUE) {
            newArrayList.add(value);
        }
        return newArrayList;
    }

    public static final IS getISDefault() {
        return IS_DEFAULT_VALUE;
    }

    public static final float[] getKeyDefault() {
        float[] valuesArray = new float[KEY_DEFAULT_VALUE.size()];
        int i = 0;
        for (float arrayElement : KEY_DEFAULT_VALUE) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public static final ArrayList<Float> getKeyDefaultList() {
        ArrayList<Float> newArrayList = new ArrayList<Float>();
        for (Float value : KEY_DEFAULT_VALUE) {
            newArrayList.add(value);
        }
        return newArrayList;
    }

    public static final double[] getKeyValueDefault() {
        return KEYVALUE_DEFAULT_VALUE;
    }

    public static final X3DMetadataObject getMetadataDefault() {
        return METADATA_DEFAULT_VALUE;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "geoOrigin" -> "SFNode";
            case "geoSystem" -> "MFString";
            case "geovalue" -> "SFVec3d";
            case fromField_IS -> "SFNode";
            case "key" -> "MFFloat";
            case "keyValue" -> "MFVec3d";
            case "metadata" -> "SFNode";
            case "fraction" -> "SFFloat";
            case "value" -> "SFVec3f";
            case "DEF" -> "SFString";
            case "USE" -> "SFString";
            case "class" -> "SFString";
            case "id" -> "SFString";
            case "style" -> "SFString";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "geoOrigin" -> "initializeOnly";
            case "geoSystem" -> "initializeOnly";
            case fromField_GEOVALUE_CHANGED -> "outputOnly";
            case fromField_IS -> "inputOutput";
            case "key" -> "inputOutput";
            case "keyValue" -> "inputOutput";
            case "metadata" -> "inputOutput";
            case toField_SET_FRACTION -> "inputOnly";
            case fromField_VALUE_CHANGED -> "outputOnly";
            case "DEF" -> "inputOutput";
            case "USE" -> "inputOutput";
            case "class" -> "inputOutput";
            case "id" -> "inputOutput";
            case "style" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public GeoPositionInterpolator() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALLOWED_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.geoOrigin = null;
        this.geoOriginProtoInstance = null;
        this.geoSystem = GeoPositionInterpolator.getGeoSystemDefaultList();
        this.IS = null;
        this.key = GeoPositionInterpolator.getKeyDefaultList();
        this.keyValue = new double[0];
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.commentsList = new ArrayList();
    }

    @Override
    public GeoOrigin getGeoOrigin() {
        return this.geoOrigin;
    }

    @Override
    public GeoPositionInterpolator setGeoOrigin(GeoOrigin newValue) {
        this.geoOrigin = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.geoOrigin)).setParent(this);
        }
        if (this.geoOriginProtoInstance != null) {
            this.geoOriginProtoInstance.setParent(null);
            this.geoOriginProtoInstance = null;
        }
        return this;
    }

    public GeoPositionInterpolator clearGeoOrigin() {
        ((X3DConcreteElement)((Object)this.geoOrigin)).clearParent();
        this.geoOrigin = null;
        return this;
    }

    public GeoPositionInterpolator setGeoOrigin(ProtoInstance newValue) {
        if (this.geoOriginProtoInstance != null) {
            this.geoOriginProtoInstance.setParent(null);
        }
        this.geoOriginProtoInstance = newValue;
        if (newValue != null) {
            this.geoOriginProtoInstance.setParent(this);
            this.geoOriginProtoInstance.setContainerField("geoOrigin");
        }
        if (this.geoOrigin != null) {
            ((X3DConcreteElement)((Object)this.geoOrigin)).setParent(null);
            this.geoOrigin = null;
        }
        return this;
    }

    private ProtoInstance getGeoOriginProtoInstance() {
        return this.geoOriginProtoInstance;
    }

    public boolean hasGeoOrigin() {
        return this.geoOrigin != null || this.geoOriginProtoInstance != null;
    }

    @Override
    public String[] getGeoSystem() {
        String[] valuesArray = new String[this.geoSystem.size()];
        int i = 0;
        for (String arrayElement : this.geoSystem) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<String> getGeoSystemList() {
        return this.geoSystem;
    }

    public String getGeoSystemString() {
        StringBuilder result = new StringBuilder();
        for (String arrayElement : this.geoSystem) {
            result.append("\"");
            result.append(arrayElement);
            result.append("\"");
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public GeoPositionInterpolator setGeoSystem(String[] newValue) {
        this.clearGeoSystem();
        for (int i = 0; i < newValue.length; ++i) {
            this.geoSystem.add(newValue[i]);
        }
        return this;
    }

    public GeoPositionInterpolator setGeoSystem(MFString newValue) {
        if (newValue == null) {
            this.clearGeoSystem();
            return this;
        }
        this.setGeoSystem(newValue.getPrimitiveValue());
        return this;
    }

    public GeoPositionInterpolator setGeoSystem(SFString newValue) {
        if (newValue.getValue().length() - newValue.getValue().replace("\"", "").length() > 2) {
            return this.setGeoSystem(new MFString(newValue));
        }
        this.setGeoSystem(newValue.getValue());
        return this;
    }

    public GeoPositionInterpolator setGeoSystem(String newValue) {
        if (newValue.length() - newValue.replace("\"", "").length() > 2) {
            return this.setGeoSystem(new MFString(newValue));
        }
        this.clearGeoSystem();
        this.geoSystem.add(newValue);
        return this;
    }

    public GeoPositionInterpolator setGeoSystem(ArrayList<String> newValue) {
        if (newValue.isEmpty()) {
            this.clearGeoSystem();
        } else {
            String[] newArray = new String[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setGeoSystem(newArray);
        }
        return this;
    }

    public GeoPositionInterpolator clearGeoSystem() {
        this.geoSystem.clear();
        return this;
    }

    public GeoPositionInterpolator addGeoSystem(String newValue) {
        if (newValue == null) {
            return this;
        }
        String normalizedString = MFString.cleanupEnumerationValue(newValue);
        if (normalizedString.isBlank()) {
            System.out.println("*** warning, GeoPositionInterpolator.addGeoSystem(\"" + newValue + "\") ignored since empty string cannot be a contained enumeration");
        } else if (!this.geoSystem.contains(normalizedString)) {
            this.geoSystem.add(normalizedString);
        } else {
            System.out.println("*** warning, GeoPositionInterpolator.addGeoSystem(\"" + newValue + "\") ignored since this duplicate value is already one of contained enumerations");
        }
        return this;
    }

    public GeoPositionInterpolator addGeoSystem(SFString newValue) {
        if (newValue == null) {
            return this;
        }
        String normalizedString = MFString.cleanupEnumerationValue(newValue.getValue());
        if (normalizedString.isBlank()) {
            System.out.println("*** warning, GeoPositionInterpolator.addGeoSystem(\"" + newValue.getValue() + "\") ignored since empty string cannot be a contained enumeration");
        } else if (!this.geoSystem.contains(normalizedString)) {
            this.geoSystem.add(normalizedString);
        } else {
            System.out.println("*** warning, GeoPositionInterpolator.addGeoSystem(\"" + newValue.getValue() + "\") ignored since this duplicate value is already one of contained enumerations");
        }
        return this;
    }

    @Override
    public double[] getGeovalue() {
        return this.geovalue;
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public GeoPositionInterpolator setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public GeoPositionInterpolator clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public float[] getKey() {
        float[] valuesArray = new float[this.key.size()];
        int i = 0;
        for (Float arrayElement : this.key) {
            valuesArray[i++] = arrayElement.floatValue();
        }
        return valuesArray;
    }

    public ArrayList<Float> getKeyList() {
        return this.key;
    }

    public String getKeyString() {
        StringBuilder result = new StringBuilder();
        for (Float arrayElement : this.key) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public GeoPositionInterpolator setKey(float[] newValue) {
        this.clearKey();
        for (int i = 0; i < newValue.length; ++i) {
            this.key.add(Float.valueOf(newValue[i]));
        }
        return this;
    }

    public GeoPositionInterpolator setKey(MFFloat newValue) {
        if (newValue == null) {
            this.clearKey();
            return this;
        }
        this.setKey(newValue.getPrimitiveValue());
        return this;
    }

    public GeoPositionInterpolator setKey(ArrayList<Float> newValue) {
        if (newValue.isEmpty()) {
            this.clearKey();
        } else {
            float[] newArray = new float[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i).floatValue();
            }
            this.setKey(newArray);
        }
        return this;
    }

    public GeoPositionInterpolator clearKey() {
        this.key.clear();
        return this;
    }

    public GeoPositionInterpolator setKey(int[] newValue) {
        if (newValue == null) {
            this.clearKey();
            return this;
        }
        float[] holdArray = new float[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            holdArray[i] = newValue[i];
        }
        this.setKey(holdArray);
        return this;
    }

    public GeoPositionInterpolator addKey(float newValue) {
        this.key.add(Float.valueOf(newValue));
        return this;
    }

    public GeoPositionInterpolator addKey(SFFloat newValue) {
        this.key.add(Float.valueOf(newValue.getPrimitiveValue()));
        return this;
    }

    public GeoPositionInterpolator setKey(double[] newArray) {
        return this.setKey(new MFFloat(newArray));
    }

    @Override
    public double[] getKeyValue() {
        return this.keyValue;
    }

    @Override
    public GeoPositionInterpolator setKeyValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        if (newValue.length % 3 != 0) {
            throw new InvalidFieldValueException("GeoPositionInterpolator keyValue newValue=" + MFVec3d.toString(newValue) + " has length=" + newValue.length + ", must be a multiple of 3");
        }
        this.keyValue = newValue;
        return this;
    }

    public GeoPositionInterpolator setKeyValue(MFVec3d newValue) {
        this.setKeyValue(newValue.getPrimitiveValue());
        return this;
    }

    public GeoPositionInterpolator addKeyValue(SFVec3d newValue) {
        double[] result = Arrays.copyOf(this.keyValue, this.keyValue.length + 3);
        System.arraycopy(newValue.getPrimitiveValue(), 0, result, this.keyValue.length, 3);
        this.keyValue = result;
        return this;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public GeoPositionInterpolator setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
            if (this.metadata instanceof MetadataSet) {
                ((X3DConcreteNode)((Object)this.metadata)).setContainerFieldOverride("metadata");
            }
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public GeoPositionInterpolator clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public GeoPositionInterpolator setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public float[] getValue() {
        return this.value;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final GeoPositionInterpolator setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoPositionInterpolator DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public GeoPositionInterpolator setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final GeoPositionInterpolator setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("GeoPositionInterpolator USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public GeoPositionInterpolator setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final GeoPositionInterpolator setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public GeoPositionInterpolator setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    @Override
    public final GeoPositionInterpolator setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public GeoPositionInterpolator setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    @Override
    public final GeoPositionInterpolator setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public GeoPositionInterpolator setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public GeoPositionInterpolator setUSE(GeoPositionInterpolator DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "*** setUSE(DEFnode) invoked on GeoPositionInterpolator that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public GeoPositionInterpolator(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public GeoPositionInterpolator addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public GeoPositionInterpolator addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public GeoPositionInterpolator addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.geoOrigin != null || this.geoOriginProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasChild = false;
        }
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<GeoPositionInterpolator");
        if (hasAttributes) {
            if (!this.getDEF().equals(this.getDEFDefault()) && !this.hasUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals(this.getUSEDefault())) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isBlank() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(this.getCssClass().equals(GeoPositionInterpolator.getCssClassDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!((this.getGeoSystem().length <= 0 || Arrays.equals(this.getGeoSystem(), GeoPositionInterpolator.getGeoSystemDefault())) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" geoSystem='").append(new MFString(this.getGeoSystem()).toStringX3D()).append("'");
            }
            if (!(this.getHtmlId().equals(GeoPositionInterpolator.getHtmlIdDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!((this.getKey().length <= 0 || Arrays.equals(this.getKey(), GeoPositionInterpolator.getKeyDefault())) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" key='").append(MFFloat.toString(this.getKey())).append("'");
            }
            if (!((this.getKeyValue().length <= 0 || this.getKeyValue().equals(GeoPositionInterpolator.getKeyValueDefault())) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" keyValue='").append(MFVec3d.toString(this.getKeyValue())).append("'");
            }
            if (!(this.getCssStyle().equals(GeoPositionInterpolator.getCssStyleDefault()) && ConfigurationProperties.getStripDefaultAttributes() || this.hasUSE())) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild && !this.hasUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.geoOrigin != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.geoOrigin)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.geoOriginProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.geoOriginProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</GeoPositionInterpolator>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.geoOrigin != null || this.geoOriginProtoInstance != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.commentsList.isEmpty();
        if (this.hasUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals(super.getDEFDefault())) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals(super.getUSEDefault())) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals(GeoPositionInterpolator.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("geoSystem")) continue;
                        stringClassicVRML.append(indentCharacter).append("geoSystem").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getGeoSystem().length > 0 && !Arrays.equals(this.getGeoSystem(), GeoPositionInterpolator.getGeoSystemDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("geoSystem ").append("[ ").append(MFString.toString(this.getGeoSystem())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("id")) continue;
                        stringClassicVRML.append(indentCharacter).append("id").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getHtmlId().equals(GeoPositionInterpolator.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlId())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("key")) continue;
                        stringClassicVRML.append(indentCharacter).append("key").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getKey().length > 0 && !Arrays.equals(this.getKey(), GeoPositionInterpolator.getKeyDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("key ").append("[ ").append(MFFloat.toString(this.getKey())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("keyValue")) continue;
                        stringClassicVRML.append(indentCharacter).append("keyValue").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getKeyValue().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("keyValue ").append("[ ").append(MFVec3d.toString(this.getKeyValue())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("style")) continue;
                        stringClassicVRML.append(indentCharacter).append("style").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssStyle().equals(GeoPositionInterpolator.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.geoOrigin != null) {
                stringClassicVRML.append(indentCharacter).append("geoOrigin").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.geoOrigin)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.geoOriginProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("geoOrigin").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.geoOriginProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            stringClassicVRML.append("\n").append((CharSequence)indent).append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (this.getUSE().isEmpty() && (hasAttributes || hasChild)) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.geoOrigin != null && (referenceElement = ((X3DConcreteElement)((Object)this.geoOrigin)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.geoOriginProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.geoOriginProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.geoOrigin != null && (referenceNode = ((X3DConcreteElement)((Object)this.geoOrigin)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.geoOriginProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.geoOriginProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        this.setGeoSystem(this.getGeoSystem());
        this.setKey(this.getKey());
        this.setKeyValue(this.getKeyValue());
        if (!this.hasUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.hasUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        this.setCssStyle(this.getCssStyle());
        if (this.geoOrigin != null) {
            this.setGeoOrigin(this.getGeoOrigin());
            ((X3DConcreteElement)((Object)this.geoOrigin)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.geoOrigin)).getValidationResult());
        }
        if (this.geoOriginProtoInstance != null) {
            this.setGeoOrigin(this.getGeoOriginProtoInstance());
            ((X3DConcreteElement)this.geoOriginProtoInstance).validate();
            this.validationResult.append(this.geoOriginProtoInstance.getValidationResult());
        }
        if (this.geoOrigin != null && this.geoOriginProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both geoOrigin and geoOriginProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasGeoOrigin()) {
            String errorNotice = "*** GeoPositionInterpolator USE='" + this.getUSE() + "' is not allowed to have contained SFNode geoOrigin";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.hasUSE() && this.hasIS()) {
            String errorNotice = "*** GeoPositionInterpolator USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice = "*** Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice);
            throw new InvalidProtoException(errorNotice);
        }
        if (this.hasUSE() && this.hasMetadata()) {
            String errorNotice = "*** GeoPositionInterpolator USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice);
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            String errorNotice = "*** IS statement present, but contains no connect statements";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidProtoException(errorNotice);
        }
        if (!this.getContainerFieldOverride().isBlank() && !Arrays.asList(this.containerField_ALLOWED_VALUES).contains(this.getContainerFieldOverride())) {
            String errorNotice = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALLOWED_VALUES='" + new MFString(this.containerField_ALLOWED_VALUES).toStringX3D() + "'.";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldException(errorNotice);
        }
        if (this.findAncestorX3D() != null) {
            boolean hasSatisfactorySupport;
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean bl = hasSatisfactorySupport = this.findAncestorX3D().supportsX3dProfile(modelProfile) || this.findAncestorX3D().supportsX3dComponent(COMPONENT, 1);
            if (!hasSatisfactorySupport) {
                String errorNotice = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for current X3D model containing 'GeoPositionInterpolator' node, ensure sufficient support by adding head statement <component name='Geospatial' level='1'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"Geospatial\").setLevel(1);";
                this.validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldException(errorNotice);
            }
        }
        return this.validationResult.toString();
    }
}

