/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.component;
import org.web3d.x3d.jsail.Core.meta;
import org.web3d.x3d.jsail.Core.unit;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class head
extends X3DConcreteStatement {
    private ArrayList<String> commentsList;
    private ArrayList<component> componentList = new ArrayList();
    private ArrayList<meta> metaList = new ArrayList();
    private ArrayList<unit> unitList = new ArrayList();
    public static final String NAME = "head";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    private boolean serializingVRML97output = false;

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        return switch (fieldName) {
            case "containerField" -> "SFString";
            case "class" -> "SFString";
            case "component" -> "MFNode";
            case "id" -> "SFString";
            case "meta" -> "MFNode";
            case "style" -> "SFString";
            case "unit" -> "MFNode";
            default -> fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
        };
    }

    @Override
    public String getAccessType(String fieldName) {
        return switch (fieldName) {
            case "class" -> "inputOutput";
            case "component" -> "inputOutput";
            case "id" -> "inputOutput";
            case "meta" -> "inputOutput";
            case "style" -> "inputOutput";
            case "unit" -> "inputOutput";
            default -> fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
        };
    }

    public head() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.componentList = new ArrayList();
        this.metaList = new ArrayList();
        this.unitList = new ArrayList();
        this.commentsList = new ArrayList();
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    public final head setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public head setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public ArrayList<component> getComponentList() {
        return this.componentList;
    }

    public head setComponentList(ArrayList<component> newValue) {
        this.componentList = newValue;
        for (component arrayElement : this.componentList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addComponent(component newValue) {
        if (newValue == null) {
            this.clearComponent();
            return this;
        }
        this.componentList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setComponent(component newValue) {
        if (newValue == null) {
            this.clearComponent();
            return this;
        }
        for (component element : this.componentList) {
            element.clearParent();
        }
        this.clearComponent();
        this.componentList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearComponent() {
        for (component element : this.componentList) {
            element.clearParent();
        }
        this.componentList.clear();
        return this;
    }

    public boolean hasComponent() {
        return !this.componentList.isEmpty();
    }

    @Override
    public String getHtmlId() {
        return super.getHtmlId();
    }

    public final head setHtmlId(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteHtmlId(newValue);
        return this;
    }

    public head setHtmlId(SFString newValue) {
        this.setHtmlId(newValue.getPrimitiveValue());
        return this;
    }

    public ArrayList<meta> getMetaList() {
        return this.metaList;
    }

    public head setMetaList(ArrayList<meta> newValue) {
        this.metaList = newValue;
        for (meta arrayElement : this.metaList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addMeta(meta newValue) {
        if (newValue == null) {
            this.clearMeta();
            return this;
        }
        this.metaList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setMeta(meta newValue) {
        if (newValue == null) {
            this.clearMeta();
            return this;
        }
        for (meta element : this.metaList) {
            element.clearParent();
        }
        this.clearMeta();
        this.metaList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearMeta() {
        for (meta element : this.metaList) {
            element.clearParent();
        }
        this.metaList.clear();
        return this;
    }

    public boolean hasMeta() {
        return !this.metaList.isEmpty();
    }

    @Override
    public String getCssStyle() {
        return super.getCssStyle();
    }

    public final head setCssStyle(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssStyle(newValue);
        return this;
    }

    public head setCssStyle(SFString newValue) {
        this.setCssStyle(newValue.getPrimitiveValue());
        return this;
    }

    public ArrayList<unit> getUnitList() {
        return this.unitList;
    }

    public head setUnitList(ArrayList<unit> newValue) {
        this.unitList = newValue;
        for (unit arrayElement : this.unitList) {
            arrayElement.setParent(this);
        }
        return this;
    }

    public head addUnit(unit newValue) {
        if (newValue == null) {
            this.clearUnit();
            return this;
        }
        this.unitList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head setUnit(unit newValue) {
        if (newValue == null) {
            this.clearUnit();
            return this;
        }
        for (unit element : this.unitList) {
            element.clearParent();
        }
        this.clearUnit();
        this.unitList.add(newValue);
        newValue.setParent(this);
        return this;
    }

    public head clearUnit() {
        for (unit element : this.unitList) {
            element.clearParent();
        }
        this.unitList.clear();
        return this;
    }

    public boolean hasUnit() {
        return !this.unitList.isEmpty();
    }

    public head addComponent(String componentName, int level) {
        return this.addComponent(new component(componentName, level));
    }

    public head addUnit(String newName, String newCategory, float newConversionFactor) {
        return this.addUnit(new unit(newName, newCategory, newConversionFactor));
    }

    public head addUnit(String newName, String newCategory, double newConversionFactor) {
        return this.addUnit(new unit(newName, newCategory, newConversionFactor));
    }

    public head addMeta(String newName, String newDescription) {
        return this.addMeta(new meta(newName, newDescription));
    }

    @Override
    public head addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public head addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public head addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    private void handleFieldSynonyms() {
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.componentList.isEmpty() || !this.metaList.isEmpty() || !this.unitList.isEmpty() || !this.commentsList.isEmpty();
        this.handleFieldSynonyms();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<head");
        if (hasAttributes) {
            if (!this.getCssClass().equals(head.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!this.getHtmlId().equals(head.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" id='").append(new SFString(this.getHtmlId()).toStringX3D()).append("'");
            }
            if (!this.getCssStyle().equals(head.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" style='").append(new SFString(this.getCssStyle()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            for (component component2 : this.componentList) {
                stringX3D.append(((X3DConcreteElement)component2).toStringX3D(indentLevel + indentIncrement));
            }
            for (unit unit2 : this.unitList) {
                stringX3D.append(((X3DConcreteElement)unit2).toStringX3D(indentLevel + indentIncrement));
            }
            for (meta meta2 : this.metaList) {
                stringX3D.append(meta2.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</head>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = !this.componentList.isEmpty() || !this.metaList.isEmpty() || !this.unitList.isEmpty() || !this.commentsList.isEmpty();
        if (!this.serializingVRML97output) {
            this.handleFieldSynonyms();
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("# [head]").append("\n");
        if (hasAttributes) {
            if (!this.getCssClass().equals(head.getCssClassDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringClassicVRML.append(" # class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n");
            }
            if (!this.getHtmlId().equals(head.getHtmlIdDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringClassicVRML.append(" # id ").append("\"").append(SFString.toString(this.getHtmlId())).append("\"").append("\n");
            }
            if (!this.getCssStyle().equals(head.getCssStyleDefault()) || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringClassicVRML.append(" # style ").append("\"").append(SFString.toString(this.getCssStyle())).append("\"").append("\n");
            }
        }
        if (hasChild) {
            for (component component2 : this.componentList) {
                stringClassicVRML.append(((X3DConcreteElement)component2).toStringClassicVRML(indentLevel));
            }
            for (unit unit2 : this.unitList) {
                stringClassicVRML.append(((X3DConcreteElement)unit2).toStringClassicVRML(indentLevel));
            }
            stringClassicVRML.append("\n").append((CharSequence)indent).append("\n");
            for (meta meta2 : this.metaList) {
                stringClassicVRML.append(meta2.toStringClassicVRML(indentLevel));
            }
            stringClassicVRML.append("# This model file was produced using X3DJSAIL https://www.web3d.org/specifications/java/X3DJSAIL.html\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
            }
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        this.serializingVRML97output = true;
        String result = this.toStringClassicVRML(indentLevel);
        this.serializingVRML97output = false;
        return result;
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "*** findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "*** findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        String exceptionMessage;
        this.validationResult = new StringBuilder();
        if (!this.hasMeta()) {
            this.validationResult.append("ERROR_NODE_NOT_FOUND: X3D head has no meta elements and thus is undescribed\n");
        }
        this.setCssClass(this.getCssClass());
        this.setHtmlId(this.getHtmlId());
        this.setCssStyle(this.getCssStyle());
        for (component component2 : this.componentList) {
            try {
                ((X3DConcreteElement)component2).validate();
                this.validationResult.append(component2.getValidationResult());
            }
            catch (Exception e) {
                exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace(System.err);
            }
        }
        this.setComponentList(this.getComponentList());
        for (meta meta2 : this.metaList) {
            try {
                ((X3DConcreteElement)meta2).validate();
                this.validationResult.append(meta2.getValidationResult());
            }
            catch (Exception e) {
                exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace(System.err);
            }
        }
        this.setMetaList(this.getMetaList());
        for (unit unit2 : this.unitList) {
            try {
                ((X3DConcreteElement)unit2).validate();
                this.validationResult.append(unit2.getValidationResult());
            }
            catch (Exception e) {
                exceptionMessage = "[exception] during validation: " + e.getMessage();
                this.validationResult.append(exceptionMessage);
                e.printStackTrace(System.err);
            }
        }
        this.setUnitList(this.getUnitList());
        int index = 0;
        for (component componentStatement : this.componentList) {
            for (int j = 0; j < index; ++j) {
                if (!componentStatement.getName().equalsIgnoreCase(this.componentList.get(j).getName())) continue;
                this.validationResult.append("Redundant statements found, same category:\n  ").append(componentStatement.toStringX3D()).append(" and\n  ").append(this.componentList.get(j).toStringX3D());
            }
            ++index;
        }
        index = 0;
        for (unit unitStatement : this.unitList) {
            for (int j = 0; j < index; ++j) {
                if (!unitStatement.getCategory().equalsIgnoreCase(this.unitList.get(j).getCategory())) continue;
                this.validationResult.append("Redundant statements found: ").append(unitStatement.toStringX3D()).append(" and ").append(this.unitList.get(j).toStringX3D());
            }
            ++index;
        }
        index = -1;
        for (meta metaStatement : this.metaList) {
            for (int j = 0; j < index; ++j) {
                if (metaStatement.getName().equalsIgnoreCase(this.metaList.get(j).getName()) && metaStatement.getContent().equalsIgnoreCase(this.metaList.get(j).getContent())) {
                    this.validationResult.append("WARNING_MESSAGE").append(": duplicate statement found: <meta name='").append(metaStatement.getName()).append("' content='").append(metaStatement.getContent()).append("'/>\n");
                    continue;
                }
                if (!metaStatement.getName().equalsIgnoreCase(this.metaList.get(j).getName()) || !metaStatement.getName().equalsIgnoreCase("description") && !metaStatement.getName().equalsIgnoreCase("created") && !metaStatement.getName().equalsIgnoreCase("modified") && !metaStatement.getName().equalsIgnoreCase("identifier") && !metaStatement.getName().equalsIgnoreCase("title") && !metaStatement.getName().equalsIgnoreCase("subject")) continue;
                this.validationResult.append("Duplicate found: <meta name='").append(metaStatement.getName()).append("'/>\n");
            }
            ++index;
        }
        return this.validationResult.toString();
    }

    public meta findMetaByName(String metaName) {
        for (meta element : this.metaList) {
            if (!element.getName().equalsIgnoreCase(metaName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasMeta(String metaName) {
        return this.findMetaByName(metaName) != null;
    }

    public component findComponentByName(String componentName) {
        for (component element : this.componentList) {
            if (!element.getName().equalsIgnoreCase(componentName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasComponent(String componentName) {
        return this.findComponentByName(componentName) != null;
    }

    public unit findUnitByName(String unitName) {
        for (unit element : this.unitList) {
            if (!element.getName().equalsIgnoreCase(unitName)) continue;
            return element;
        }
        return null;
    }

    public boolean hasUnit(String unitName) {
        return this.findUnitByName(unitName) != null;
    }
}

