/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.web3d.x3d.jsail.BlenderLauncher;
import org.web3d.x3d.jsail.MeshLabLauncher;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.X3DException;

public class ConfigurationProperties {
    public static final int indentIncrement_DEFAULT = 2;
    private static int indentIncrement = 2;
    public static final char indentCharacter_SPACE = ' ';
    public static final char indentCharacter_TAB = '\t';
    public static final char indentCharacter_DEFAULT = ' ';
    private static char indentCharacter = (char)32;
    public static final String XML_ENCODING_DECLARATION_DEFAULT = "UTF-8";
    public static final String ERROR_CONFIGURATION_X3DJSAIL = "ERROR_CONFIGURATION_X3DJSAIL";
    public static final String WARNING_CONFIGURATION_X3DJSAIL = "WARNING_CONFIGURATION_X3DJSAIL";
    public static final String WARNING_MESSAGE = "WARNING_MESSAGE";
    public static final String ERROR_ILLEGAL_VALUE = "ERROR_ILLEGAL_VALUE";
    public static final String ERROR_NOT_CONNECTED_TO_SCENE_GRAPH = "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH";
    public static final String ERROR_VALUE_NOT_FOUND = "ERROR_VALUE_NOT_FOUND";
    public static final String ERROR_NODE_NOT_FOUND = "ERROR_NODE_NOT_FOUND";
    public static final String ERROR_UNKNOWN_FIELD_ACCESSTYPE = "ERROR_UNKNOWN_FIELD_ACCESSTYPE";
    public static final String ERROR_UNKNOWN_FIELD_TYPE = "ERROR_UNKNOWN_FIELD_TYPE";
    public static final String ERROR_UNKNOWN_PROTODECLARE_NODE_TYPE = "ERROR_UNKNOWN_PROTODECLARE_NODE_TYPE";
    public static final String ERROR_UNKNOWN_EXTERNPROTODECLARE_NODE_TYPE = "ERROR_UNKNOWN_EXTERNPROTODECLARE_NODE_TYPE";
    public static final String ERROR_UNKNOWN_PROTOINSTANCE_NODE_TYPE = "ERROR_UNKNOWN_PROTOINSTANCE_NODE_TYPE";
    public static final String WARNING_PROTOINSTANCE_NOT_FOUND = "WARNING_PROTOINSTANCE_NOT_FOUND";
    public static boolean debugModeActive = false;
    public static final boolean SFImagePixelOutputHexadecimal_DEFAULT = true;
    private static boolean SFImagePixelOutputHexadecimal = true;
    public static final boolean stripDefaultAttributes_DEFAULT = true;
    private static boolean stripDefaultAttributes = true;
    public static final boolean validationExceptionAllowed_DEFAULT = false;
    private static boolean validationExceptionAllowed = false;
    public static final boolean creationConnectionValidationExceptionAllowed_DEFAULT = true;
    private static boolean creationConnectionValidationExceptionAllowed = true;
    public static final boolean normalizeCommentWhitespace_DEFAULT = true;
    private static boolean normalizeCommentWhitespace = true;
    public static final boolean overwriteExistingFiles_DEFAULT = true;
    private static boolean overwriteExistingFiles = true;
    public static final boolean consoleOutputVerbose_DEFAULT = true;
    private static boolean consoleOutputVerbose = true;
    public static final String NAME_X3DJSAIL = "X3D Java Scene Access Interface Library (X3DJSAIL)";
    public static final String VERSION_DATE = "28 November 2025";
    public static final String URL_X3DJSAIL = "https://www.web3d.org/specifications/java/X3DJSAIL.html";
    public static final String URL_X3DRESOURCES = "https://www.web3d.org/x3d/content/examples/X3dResources.html";
    public static final String URL_X3DSCENEAUTHORINGHINTS = "https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html";
    public static final String URL_X3DREGEXES = "https://www.web3d.org/specifications/X3dRegularExpressions.html";
    public static final String URL_X3DTOOLTIPS = "https://www.web3d.org/x3d/tooltips/X3dTooltips.html";
    public static final String URL_X3DUOM = "https://www.web3d.org/specifications/X3DUOM.html";
    public static final String STYLESHEET_HTML_DOCUMENTATION = "X3dToXhtml.xslt";
    public static final String STYLESHEET_VRML97 = "X3dToVrml97.xslt";
    public static final String STYLESHEET_X3DV_CLASSICVRML = "X3dToX3dvClassicVrmlEncoding.xslt";
    public static final String STYLESHEET_MODEL_META_TO_MARKDOWN = "X3dModelMetaToMarkdown.xslt";
    public static final String STYLESHEET_X3DSCHEMATRON_SVRLREPORT = "SvrlReportText.xslt";
    public static final String STYLESHEET_X3DSCHEMATRON = "X3dSchematronValidityChecks.xslt";
    public static final String STYLESHEET_X3DTIDY = "X3dTidy.xslt";
    public static final String STYLESHEET_ExtrusionCrossSectionSVG = "X3dExtrusionCrossSectionToSvg.xslt";
    public static final String STYLESHEET_X3DOM = "X3dToX3domX_ITE.xslt";
    public static final String STYLESHEET_X_ITE = "X3dToX3domX_ITE.xslt";
    @Deprecated
    public static final String STYLESHEET_COBWEB = "X3dToX3domX_ITE.xslt";
    public static final String STYLESHEET_JAVA = "X3dToJava.xslt";
    public static final String STYLESHEET_JAVASCRIPT = "X3dToNodeJS.xslt";
    public static final String STYLESHEET_JSON = "X3dToJson.xslt";
    public static final String STYLESHEET_PYTHON = "X3dToPython.xslt";
    public static final ArrayList<String> X3DJSAIL_JAR_RELEASE_VERSIONS = new ArrayList<String>(Arrays.asList("X3DJSAIL.4.0.classes.jar", "X3DJSAIL.4.0.full.jar", "X3DJSAIL.3.3.classes.jar", "X3DJSAIL.3.3.full.jar"));
    private static final boolean deleteIntermediateFiles_DEFAULT = true;
    private static boolean deleteIntermediateFiles = true;
    private static final boolean stripTrailingZeroes_DEFAULT = true;
    private static boolean stripTrailingZeroes = true;
    public static final String XSLT_ENGINE_SAXON = "SAXON9HE";
    public static final String XSLT_ENGINE_NATIVE_JAVA = "NATIVE_JAVA";
    private static String xsltEngine = "SAXON9HE";
    public static final String EXI_ENGINE_OPENEXI = "OPENEXI";
    public static final String EXI_ENGINE_EXIFICIENT = "EXIFICIENT";
    private static String exiEngine = "EXIFICIENT";
    public static final String PROPERTIES_FILENAME_DEFAULT = "X3DJSAIL.properties";
    private static String propertiesFileName = "X3DJSAIL.properties";

    public static boolean isStylesheetSupported(String stylesheetName) {
        return stylesheetName.equalsIgnoreCase(STYLESHEET_HTML_DOCUMENTATION) || stylesheetName.equalsIgnoreCase(STYLESHEET_JAVA) || stylesheetName.equalsIgnoreCase(STYLESHEET_JAVASCRIPT) || stylesheetName.equalsIgnoreCase(STYLESHEET_JSON) || stylesheetName.equalsIgnoreCase(STYLESHEET_PYTHON) || stylesheetName.equalsIgnoreCase(STYLESHEET_MODEL_META_TO_MARKDOWN) || stylesheetName.equalsIgnoreCase(STYLESHEET_ExtrusionCrossSectionSVG) || stylesheetName.equalsIgnoreCase(STYLESHEET_VRML97) || stylesheetName.equalsIgnoreCase(STYLESHEET_X3DV_CLASSICVRML) || stylesheetName.equalsIgnoreCase("X3dToX3domX_ITE.xslt") || stylesheetName.equalsIgnoreCase("X3dToX3domX_ITE.xslt") || stylesheetName.equalsIgnoreCase(STYLESHEET_X3DSCHEMATRON) || stylesheetName.equalsIgnoreCase(STYLESHEET_X3DSCHEMATRON_SVRLREPORT) || stylesheetName.equalsIgnoreCase(STYLESHEET_X3DTIDY);
    }

    public static String getExpectedOutputFileExtension(String stylesheetName) {
        String expectedFileNameExtension = "";
        if (stylesheetName.equals(STYLESHEET_ExtrusionCrossSectionSVG)) {
            expectedFileNameExtension = ".svg";
        } else if (stylesheetName.equals(STYLESHEET_HTML_DOCUMENTATION)) {
            expectedFileNameExtension = ".html";
        } else if (stylesheetName.equals(STYLESHEET_X3DSCHEMATRON)) {
            expectedFileNameExtension = ".svrl";
        } else if (stylesheetName.equals(STYLESHEET_X3DSCHEMATRON_SVRLREPORT)) {
            expectedFileNameExtension = ".txt";
        } else if (stylesheetName.equals(STYLESHEET_X3DTIDY)) {
            expectedFileNameExtension = ".x3d";
        } else if (stylesheetName.equals(STYLESHEET_VRML97)) {
            expectedFileNameExtension = ".wrl";
        } else if (stylesheetName.equals(STYLESHEET_X3DV_CLASSICVRML)) {
            expectedFileNameExtension = ".x3dv";
        } else if (stylesheetName.equals(STYLESHEET_JAVASCRIPT)) {
            expectedFileNameExtension = ".js";
        } else if (stylesheetName.equals(STYLESHEET_JAVA)) {
            expectedFileNameExtension = ".java";
        } else if (stylesheetName.equals(STYLESHEET_JSON)) {
            expectedFileNameExtension = ".json";
        } else if (stylesheetName.equals(STYLESHEET_PYTHON)) {
            expectedFileNameExtension = ".py";
        } else if (stylesheetName.equals("X3dToX3domX_ITE.xslt")) {
            expectedFileNameExtension = ".html";
        } else if (stylesheetName.equals("X3dToX3domX_ITE.xslt")) {
            expectedFileNameExtension = ".html";
        } else if (stylesheetName.equals(STYLESHEET_MODEL_META_TO_MARKDOWN)) {
            expectedFileNameExtension = ".md";
        }
        if (expectedFileNameExtension.isEmpty()) {
            throw new X3DException("getExpectedOutputFileExtension(" + stylesheetName + ") stylesheetName not recognized; (see ConfigurationProperties for allowed choices)");
        }
        return expectedFileNameExtension;
    }

    public static final boolean isDeleteIntermediateFiles() {
        return deleteIntermediateFiles;
    }

    public static final void setDeleteIntermediateFiles(boolean newValue) {
        deleteIntermediateFiles = newValue;
    }

    public static final boolean isStripTrailingZeroes() {
        return stripTrailingZeroes;
    }

    public static final void setStripTrailingZeroes(boolean newValue) {
        stripTrailingZeroes = newValue;
    }

    public static final String getXsltEngine() {
        return xsltEngine;
    }

    public static final void setXsltEngine(String newValue) {
        if (!newValue.equals(XSLT_ENGINE_SAXON) && !newValue.equals(XSLT_ENGINE_NATIVE_JAVA)) {
            String errorNotice = "*** Invalid setXsltEngine(String newValue) invocation, newValue='" + newValue + "', legal values are ConfigurationProperties.XSLT_ENGINE_SAXON or ConfigurationProperties.XSLT_ENGINE_NATIVE_JAVA";
            throw new InvalidFieldValueException(errorNotice);
        }
        xsltEngine = newValue;
    }

    public static final String getExiEngine() {
        return exiEngine;
    }

    public static final void setExiEngine(String newValue) {
        if (!newValue.equals(EXI_ENGINE_EXIFICIENT) && !newValue.equals(EXI_ENGINE_OPENEXI)) {
            String errorNotice = "*** Invalid setExiEngine(String newValue) invocation, newValue='" + newValue + "', legal values are ConfigurationProperties.EXI_ENGINE_EXIFICIENT or ConfigurationProperties.EXI_ENGINE_OPENEXI";
            throw new InvalidFieldValueException(errorNotice);
        }
        exiEngine = newValue;
    }

    public static final void initialize() {
        indentIncrement = 2;
        indentCharacter = (char)32;
        SFImagePixelOutputHexadecimal = true;
        stripDefaultAttributes = true;
        validationExceptionAllowed = false;
        deleteIntermediateFiles = true;
        stripTrailingZeroes = true;
        normalizeCommentWhitespace = true;
        overwriteExistingFiles = true;
        consoleOutputVerbose = true;
        ConfigurationProperties.setExiEngine(EXI_ENGINE_EXIFICIENT);
        ConfigurationProperties.setXsltEngine(XSLT_ENGINE_SAXON);
    }

    public static void setPropertiesFileName(String fileName) {
        propertiesFileName = fileName;
    }

    public static String getPropertiesFileName() {
        return propertiesFileName;
    }

    public static void loadProperties() {
        Properties loadedProperties = new Properties();
        try {
            File propertiesFile = new File(ConfigurationProperties.getPropertiesFileName());
            if (!propertiesFile.exists()) {
                System.out.println("WARNING_CONFIGURATION_X3DJSAIL: " + ConfigurationProperties.getPropertiesFileName() + " properties file not found");
            }
            FileInputStream propertiesFileInputStream = new FileInputStream(propertiesFile);
            loadedProperties.load(propertiesFileInputStream);
            propertiesFileInputStream.close();
        }
        catch (IOException ioe) {
            System.out.println("ERROR_CONFIGURATION_X3DJSAIL: " + ioe.getMessage());
            ioe.printStackTrace(System.err);
        }
        System.out.print(ConfigurationProperties.getPropertiesFileName() + " includes " + loadedProperties.size());
        if (loadedProperties.isEmpty()) {
            System.out.println(" properties");
        } else if (loadedProperties.size() == 1) {
            System.out.println(" property:");
        } else {
            System.out.println(" properties:");
        }
        loadedProperties.list(System.out);
        if (loadedProperties.size() > 0) {
            if (loadedProperties.contains("indentIncrement")) {
                indentIncrement = Integer.getInteger(loadedProperties.getProperty("indentIncrement"));
            }
            if (loadedProperties.contains("indentCharacter")) {
                String indentCharacterProperty = loadedProperties.getProperty("indentCharacter");
                if (indentCharacterProperty.toUpperCase().contains("SPACE")) {
                    indentCharacter = (char)32;
                } else if (indentCharacterProperty.toUpperCase().contains("TAB")) {
                    indentCharacter = (char)32;
                } else if (!indentCharacterProperty.isEmpty()) {
                    System.out.println("Error: unrecognized property indentCharacter='" + indentCharacterProperty + "' (allowed values are SPACE and TAB)");
                }
            }
            if (loadedProperties.contains("SFImagePixelOutputHexadecimal")) {
                SFImagePixelOutputHexadecimal = Boolean.getBoolean(loadedProperties.getProperty("SFImagePixelOutputHexadecimal"));
            }
            if (loadedProperties.contains("showDefaultAttributes")) {
                stripDefaultAttributes = !Boolean.getBoolean(loadedProperties.getProperty("showDefaultAttributes"));
                System.out.println("[warning] legacy property showDefaultAttributes='" + !stripDefaultAttributes + "' found, changed to stripDefaultAttributes='" + stripDefaultAttributes + "' instead");
            }
            if (loadedProperties.contains("stripDefaultAttributes")) {
                stripDefaultAttributes = Boolean.getBoolean(loadedProperties.getProperty("stripDefaultAttributes"));
            }
            if (loadedProperties.contains("validationExceptionAllowed")) {
                validationExceptionAllowed = Boolean.getBoolean(loadedProperties.getProperty("validationExceptionAllowed"));
            }
            if (loadedProperties.contains("deleteIntermediateFiles")) {
                deleteIntermediateFiles = Boolean.getBoolean(loadedProperties.getProperty("deleteIntermediateFiles"));
            }
            if (loadedProperties.contains("stripTrailingZeroes")) {
                stripTrailingZeroes = Boolean.getBoolean(loadedProperties.getProperty("stripTrailingZeroes"));
            }
            if (loadedProperties.contains("normalizeCommentWhitespace")) {
                normalizeCommentWhitespace = Boolean.getBoolean(loadedProperties.getProperty("normalizeCommentWhitespace"));
            }
            if (loadedProperties.contains("overwriteExistingFiles")) {
                overwriteExistingFiles = Boolean.getBoolean(loadedProperties.getProperty("overwriteExistingFiles"));
            }
            if (loadedProperties.contains("consoleOutputVerbose")) {
                consoleOutputVerbose = Boolean.getBoolean(loadedProperties.getProperty("consoleOutputVerbose"));
            }
            if (loadedProperties.contains("EXI_ENGINE") && loadedProperties.getProperty("EXI_ENGINE").toUpperCase().contains(EXI_ENGINE_EXIFICIENT)) {
                ConfigurationProperties.setExiEngine(EXI_ENGINE_EXIFICIENT);
            } else if (loadedProperties.contains("EXI_ENGINE") && loadedProperties.getProperty("EXI_ENGINE").toUpperCase().contains(EXI_ENGINE_OPENEXI)) {
                ConfigurationProperties.setExiEngine(EXI_ENGINE_OPENEXI);
            } else if (loadedProperties.contains("EXI_ENGINE")) {
                System.out.println("Error: unrecognized property EXI_ENGINE=" + loadedProperties.getProperty("EXI_ENGINE") + "' (allowed values are EXIFICIENT and OPENEXI)");
            }
            if (loadedProperties.contains("XSLT_ENGINE") && loadedProperties.getProperty("EXI_ENGINE").toUpperCase().contains("SAXON")) {
                ConfigurationProperties.setXsltEngine(XSLT_ENGINE_SAXON);
            } else if (loadedProperties.contains("XSLT_ENGINE") && loadedProperties.getProperty("EXI_ENGINE").toUpperCase().contains(XSLT_ENGINE_NATIVE_JAVA)) {
                ConfigurationProperties.setXsltEngine(XSLT_ENGINE_NATIVE_JAVA);
            } else if (loadedProperties.contains("XSLT_ENGINE")) {
                System.out.println("Error: unrecognized property XSLT_ENGINE=" + loadedProperties.getProperty("XSLT_ENGINE") + "' (allowed values are SAXON and NATIVE_JAVA)");
            }
            if (loadedProperties.contains("BLENDER_PATH")) {
                BlenderLauncher.setBlenderPath(loadedProperties.getProperty("BLENDER_PATH"));
            }
            if (loadedProperties.contains("MESHLAB_PATH")) {
                MeshLabLauncher.setMeshLabPath(loadedProperties.getProperty("MESHLAB_PATH"));
            }
        }
        System.out.println("------------------------");
        System.out.println(ConfigurationProperties.getPropertiesFileName() + " loading complete.");
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static char getIndentCharacter() {
        return indentCharacter;
    }

    public static void setIndentCharacter(char newIndentCharacter) {
        if (newIndentCharacter != ' ' && newIndentCharacter != '\t') {
            String errorNotice = "*** Invalid indentCharacter='" + newIndentCharacter + "' provided to ConfigurationProperties, expected indentCharacter_SPACE or indentCharacter_TAB";
            throw new InvalidFieldValueException(errorNotice);
        }
        indentCharacter = newIndentCharacter;
    }

    public static int getIndentIncrement() {
        return indentIncrement;
    }

    public static void setIndentIncrement(int newIndentIncrement) {
        if (newIndentIncrement < 0) {
            indentIncrement = 0;
            String errorNotice = "*** Invalid indentIncrement=" + indentIncrement + " provided to ConfigurationProperties";
            throw new IllegalArgumentException(errorNotice);
        }
        indentIncrement = newIndentIncrement;
    }

    public static boolean isX3dCanonicalForm() {
        return indentIncrement == 2 && indentCharacter == ' ';
    }

    public static void setX3dCanonicalForm() {
        indentIncrement = 2;
        indentCharacter = (char)32;
    }

    public static boolean isDebugModeActive() {
        return debugModeActive;
    }

    public static void setDebugModeActive(boolean newDebugModeActive) {
        debugModeActive = newDebugModeActive;
    }

    public static boolean isSFImagePixelOutputHexadecimal() {
        return SFImagePixelOutputHexadecimal;
    }

    public static void setSFImagePixelOutputHexadecimal(boolean newSFImagePixelOutputHexadecimal) {
        SFImagePixelOutputHexadecimal = newSFImagePixelOutputHexadecimal;
    }

    public static boolean getStripDefaultAttributes() {
        return stripDefaultAttributes;
    }

    public static void setStripDefaultAttributes(boolean newStripDefaultAttributes) {
        stripDefaultAttributes = newStripDefaultAttributes;
    }

    public static boolean isValidationExceptionAllowed() {
        return validationExceptionAllowed;
    }

    public static void setValidationExceptionAllowed(boolean newValidationExceptionAllowed) {
        validationExceptionAllowed = newValidationExceptionAllowed;
    }

    public static boolean isCreationConnectionValidationExceptionAllowed() {
        return creationConnectionValidationExceptionAllowed;
    }

    public static void setCreationConnectionValidationExceptionAllowed(boolean newCreationConnectionValidationExceptionAllowed) {
        creationConnectionValidationExceptionAllowed = newCreationConnectionValidationExceptionAllowed;
    }

    public static boolean isNormalizeCommentWhitespace() {
        return normalizeCommentWhitespace;
    }

    public static void setNormalizeCommentWhitespace(boolean newNormalizeCommentWhitespace) {
        normalizeCommentWhitespace = newNormalizeCommentWhitespace;
    }

    public static boolean isOverwriteExistingFiles() {
        return overwriteExistingFiles;
    }

    public static void setOverwriteExistingFiles(boolean newOverwriteExistingFiles) {
        overwriteExistingFiles = newOverwriteExistingFiles;
    }

    public static boolean isConsoleOutputVerbose() {
        return consoleOutputVerbose;
    }

    public static void setConsoleOutputVerbose(boolean newConsoleOutputVerbose) {
        consoleOutputVerbose = newConsoleOutputVerbose;
    }
}

