/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail;

import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.w3c.dom.Document;
import org.web3d.x3d.jsail.BlenderLauncher;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DLoaderDOM;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.X3DException;
import org.web3d.x3d.tools.x3db.X3dCanonicalizer;
import org.xml.sax.SAXException;

public class CommandLine {
    private static X3D loadedX3dModel;
    public static final String USAGE = "Usage: java [-classpath X3DJSAIL.*.jar] org.web3d.x3d.jsail.CommandLine\n       [-help | -version | -home | -javadoc | -resources | -hints | -regexes | -tooltips | -X3DUOM]\n       [-properties [propertiesFile]]\n       [sourceModel.x3d | sourceModel.exi [-fromEXI] | sourceModel.gz [-fromGZIP] | sourceModel.zip [-fromZIP]]\n       [-canonical] [-validate] [-EXIFICIENT | -OpenEXI]\n       [-Schematron | -Tidy | -toX3D | -toXML | -toClassicVrml | -toJava | -toJSON | -toPython | -toVRML97]\n       [-toHTML | -toX3DOM | -toX_ITE | -toMarkdown | -toEXI | -toGZIP | -toZIP]\n       [-tofile [resultFile.*]] [-toImage [snapshotName.*]]";
    public static final String USAGE_LONG = "-classpath X3DJSAIL.*.jar         # optional classpath, can be set as environment variable\norg.web3d.x3d.jsail.CommandLine   # invoke CommandLine application\n==================================#====== informational ======================\n-help                             # provide this help message\n-version                          # version date when this X3DJSAIL build was autogenerated\n-home                             # launch X3DJSAIL home page\n-javadoc                          # launch X3DJSAIL javadoc page\n-resources                        # launch X3D Resources page\n-hints                            # launch X3D Scene Authoring Hints page\n-regex                            # launch X3D Regular Expressions page\n-tooltips                         # launch X3D Tooltips page\n-X3DUOM                           # launch X3D Unified Object Model (X3DUOM) page\n =================================#====== properties, inputs =================\n-properties [propertiesFile]      # override X3DJSAIL properties (default file: X3DJSAIL.properties)\n-EXIFICIENT                       # use Exificient (default) as EXI_ENGINE\n-OpenEXI                          # use OpenEXI (Nagasena)   as EXI_ENGINE (testing in progress)\nsourceModel.x3d                   # source model file name, X3D  format\nsourceModel.exi [-fromEXI]        # source model file name, EXI  format\nsourceModel.gz  [-fromGZIP]       # source model file name, GZIP format\nsourceModel.zip [-fromZIP]        # source model file name, ZIP  format\n==================================#====== operations =========================\n-canonical                        # canonical XML output using X3D Canonicalization (c14n)\n-validate                         # validate correctness of loaded model\n-Schematron                       # X3D Schematron diagnostics and Quality Assurance (QA)\n-Tidy                             # X3D-Tidy cleanup in .x3d (XML) format\n-toX3D                            # output in .x3d (XML) format\n-toXML                            # output in .xml (X3D) format\n-toClassicVrml                    # output in .x3dv (ClassicVrml) X3D format\n-toJava                           # output in .java source code using X3DJSAIL\n-toJSON                           # output in .json (JavaScript Object Notation) format\n-toPython                         # output in .py Python source code\n-toVRML97                         # output in .wrl  (VRML97) format\n-toHTML                           # output in .html  pretty-print documentation\n-toX3DOM                          # output in .xhtml page with X3DOM display of X3D model\n-toX_ITE                          # output in .html  page with X_ITE display of X3D model\n-toMarkdown                       # output document metadata (meta tags) in .md (Markdown) format\n-toEXI                            # output in .exi (Efficient XML Interchange) compressed-XML format\n-toGZIP                           # output in .gz  (X3D XML) format, with gzip compression\n-toZIP                            # output in .zip (X3D XML) format, with zip  compression\n==================================#====== outputs ============================\n-tofile  [resultFile.*]           # specify output filename (otherwise original name with extension)\n-toImage [snapshotName.*]         # create output images for each Viewpoint using Blender\n";
    private static final String WARNING = "[Warning] ";
    private static final String ERROR = "[Error] ";
    private static boolean canonicalize;
    private static boolean convertToVRML97;
    private static boolean convertToClassicVRML;
    private static boolean convertToX3D;
    private static boolean convertToXML;
    private static boolean convertToHTML;
    private static boolean convertToMarkdown;
    private static boolean includeSubdirectoryPaths;
    private static boolean convertToTidy;
    private static boolean convertToJava;
    private static boolean convertToJS;
    private static boolean convertToJSON;
    private static boolean convertToPython;
    private static boolean convertToX3DOM;
    private static boolean convertToX_ITE;
    private static boolean convertToEXI;
    private static boolean convertFromEXI;
    private static boolean convertToGZIP;
    private static boolean convertFromGZIP;
    private static boolean convertToZIP;
    private static boolean convertFromZIP;
    private static boolean validateSwitch;
    private static boolean schematronSwitch;
    private static String conversionExtension;
    private static BufferedWriter bufferedWriter;

    public static void setLoadedX3dModel(X3D newX3dModel) {
        loadedX3dModel = newX3dModel;
    }

    public static void clearLoadedX3dModel() {
        loadedX3dModel = new X3D();
    }

    public static final void initialize() {
        CommandLine.clearLoadedX3dModel();
    }

    private static void initializeConfigurationSwitches() {
        canonicalize = false;
        convertToVRML97 = false;
        convertToClassicVRML = false;
        convertToX3D = false;
        convertToXML = false;
        convertToHTML = false;
        convertToMarkdown = false;
        includeSubdirectoryPaths = true;
        convertToTidy = false;
        convertToJava = false;
        convertToJS = false;
        convertToJSON = false;
        convertToPython = false;
        convertToX3DOM = false;
        convertToX_ITE = false;
        convertToEXI = false;
        convertFromEXI = false;
        convertToGZIP = false;
        convertFromGZIP = false;
        convertToZIP = false;
        convertFromZIP = false;
        validateSwitch = false;
        schematronSwitch = false;
        conversionExtension = new String();
    }

    public static void main(String[] args) {
        CommandLine.run(args);
    }

    public static void run(String singleStringArguments) {
        CommandLine.run(singleStringArguments.split("(\\s)"));
    }

    public static void run(String[] args) {
        File sourceFile = null;
        long sourceFileLength = 0L;
        String sourceFileName = "";
        String sourceFileNameRoot = "";
        Object resultFileName = "";
        Object resultFileNameRoot = "";
        String tempFileName = "temp9876543210.txt";
        File resultFile = new File("temp9876543210.txt");
        boolean convertToFile = false;
        boolean loadProperties = false;
        String propertiesFileName = "";
        String propertiesFileNameRoot = "";
        DecimalFormat formatPrecision2 = new DecimalFormat("#0.00");
        Charset charset = Charset.forName("UTF-8");
        CommandLine.initializeConfigurationSwitches();
        if (loadedX3dModel == null) {
            CommandLine.initialize();
        }
        if (args == null || args.length < 1) {
            System.out.println(USAGE);
            System.out.println();
            System.out.println(USAGE_LONG);
            return;
        }
        for (int i = 0; i <= args.length - 1; ++i) {
            if (args[i].trim().isEmpty()) continue;
            args[i] = args[i].trim();
            if (!args[i].startsWith("-")) {
                if (!sourceFileName.isEmpty()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] multiple source file names found, \"" + sourceFileName + "\" and \"" + args[i] + "\"");
                    System.out.println(USAGE);
                    return;
                }
                sourceFileName = args[i];
                sourceFileNameRoot = sourceFileName;
                if (sourceFileNameRoot.contains(".")) {
                    sourceFileNameRoot = sourceFileName.substring(0, sourceFileName.lastIndexOf("."));
                }
                sourceFile = new File(sourceFileName);
                String messageSuffix = new String();
                if (!sourceFile.exists()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] file not found: " + sourceFileName);
                    return;
                }
                sourceFileLength = sourceFile.length();
                System.out.println("parameter: source file " + sourceFile.getName() + " filesize " + sourceFileLength + " bytes" + messageSuffix);
                if (sourceFileName.endsWith(".exi")) {
                    convertFromEXI = true;
                    continue;
                }
                if (sourceFileName.endsWith(".gz")) {
                    convertFromGZIP = true;
                    continue;
                }
                if (!sourceFileName.endsWith(".zip")) continue;
                convertFromZIP = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-tofile")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    resultFileName = args[i + 1];
                    if (((String)resultFileName).contains(".")) {
                        resultFileNameRoot = ((String)resultFileName).substring(0, ((String)resultFileName).lastIndexOf("."));
                    } else {
                        resultFileNameRoot = resultFileName;
                        System.out.println("[warning]  \"" + (String)resultFileName + "\" contains no period or filename extension");
                    }
                    System.out.println("CommandLine parameter: \"" + args[i] + "\" \"" + args[i + 1] + "\" for result file name " + (String)resultFileName);
                    ++i;
                } else {
                    System.out.println("parameter: \"" + args[i] + "\" for result file name " + (String)resultFileName);
                }
                convertToFile = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-properties") || args[i].equalsIgnoreCase("-propertiesFile")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    propertiesFileName = args[i + 1];
                    propertiesFileNameRoot = propertiesFileName.substring(0, propertiesFileName.lastIndexOf("."));
                    System.out.println("CommandLine parameter: \"" + args[i] + "\" \"" + args[i + 1] + "\" for properties file name root " + propertiesFileNameRoot);
                    ++i;
                } else {
                    System.out.println("CommandLine parameter: \"" + args[i] + "\" for properties file name root " + propertiesFileNameRoot);
                }
                loadProperties = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-x3d") || args[i].equalsIgnoreCase("-tox3d")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToX3D = true;
                conversionExtension = ".x3d";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to X3D encoding");
                continue;
            }
            if (args[i].equalsIgnoreCase("-xml") || args[i].equalsIgnoreCase("-toxml")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToXML = true;
                conversionExtension = ".xml";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to XML encoding");
                continue;
            }
            if (args[i].equalsIgnoreCase("-canonical") || args[i].equalsIgnoreCase("-c14n") || args[i].equalsIgnoreCase("-canonicalize") || args[i].equalsIgnoreCase("-canonicalization")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                canonicalize = true;
                convertToFile = true;
                if (((String)resultFileName).isEmpty()) {
                    resultFileName = sourceFileNameRoot + "Canonical.xml";
                }
                if (((String)resultFileName).endsWith(".x3d")) {
                    conversionExtension = ".x3d";
                } else if (((String)resultFileName).endsWith(".xml")) {
                    conversionExtension = ".xml";
                }
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for X3D and XML canonicalization (C14N)");
                continue;
            }
            if (args[i].equalsIgnoreCase("-html") || args[i].equalsIgnoreCase("-tohtml") || args[i].equalsIgnoreCase("-html5") || args[i].equalsIgnoreCase("-tohtml5") || args[i].equalsIgnoreCase("-xhtml") || args[i].equalsIgnoreCase("-toxhtml") || args[i].equalsIgnoreCase("-prettyprint")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToHTML = true;
                conversionExtension = args[i].equalsIgnoreCase("-xhtml") || args[i].equalsIgnoreCase("-toxhtml") ? ".xhtml" : ".html";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for producing " + conversionExtension + " pretty-print documentation");
                continue;
            }
            if (args[i].equalsIgnoreCase("-md") || args[i].equalsIgnoreCase("-tomd") || args[i].equalsIgnoreCase("-markdown") || args[i].equalsIgnoreCase("-tomarkdown")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                includeSubdirectoryPaths = true;
                convertToMarkdown = true;
                conversionExtension = ".md";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for producing " + conversionExtension + " model meta information markdown");
                continue;
            }
            if (args[i].equalsIgnoreCase("-Schematron") || args[i].equalsIgnoreCase("-X3DSchematron") || args[i].equalsIgnoreCase("-X3D_Schematron") || args[i].equalsIgnoreCase("-X3D-Schematron")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                schematronSwitch = true;
                conversionExtension = ".txt";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" to produce X3D Schematron diagnostics for .x3d model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-tidy") || args[i].equalsIgnoreCase("-totidy") || args[i].equalsIgnoreCase("-x3dtidy") || args[i].equalsIgnoreCase("-tox3dtidy")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToTidy = true;
                conversionExtension = ".x3d";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for producing X3D-Tidy cleanup of .x3d model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-x3dv") || args[i].equalsIgnoreCase("-tox3dv") || args[i].equalsIgnoreCase("-toClassicVRML") || args[i].equalsIgnoreCase("-ClassicVRML")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToClassicVRML = true;
                conversionExtension = ".x3dv";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to ClassicVRML encoding");
                continue;
            }
            if (args[i].equalsIgnoreCase("-java") || args[i].equalsIgnoreCase("-tojava")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToJava = true;
                conversionExtension = ".java";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to Java source code");
                continue;
            }
            if (args[i].equalsIgnoreCase("-json") || args[i].equalsIgnoreCase("-tojson")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToJSON = true;
                conversionExtension = ".json";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to JSON encoding");
                continue;
            }
            if (args[i].equalsIgnoreCase("-Python") || args[i].equalsIgnoreCase("-toPython")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToPython = true;
                conversionExtension = ".py";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to Python source code");
                continue;
            }
            if (args[i].equalsIgnoreCase("-js") || args[i].equalsIgnoreCase("-tojs")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToJS = true;
                conversionExtension = ".js";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to X3DJSONLD JavaScript source");
                continue;
            }
            if (args[i].equalsIgnoreCase("-vrml") || args[i].equalsIgnoreCase("-vrml97") || args[i].equalsIgnoreCase("-wrl") || args[i].equalsIgnoreCase("-tovrml") || args[i].equalsIgnoreCase("-tovrml97")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToVRML97 = true;
                conversionExtension = ".wrl";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to VRML97 encoding");
                continue;
            }
            if (args[i].equalsIgnoreCase("-x3dom") || args[i].equalsIgnoreCase("-tox3dom")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToX3DOM = true;
                conversionExtension = ".html";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to X3DOM HTML page containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-X_ITE") || args[i].equalsIgnoreCase("-toX_ITE")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToX_ITE = true;
                conversionExtension = ".html";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to X_ITE HTML page containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-EXIFICIENT")) {
                ConfigurationProperties.setExiEngine("EXIFICIENT");
                System.out.println("CommandLine parameter: \"" + args[i] + "\" invoked ConfigurationProperties.setExiEngine(EXIFICIENT);");
                continue;
            }
            if (args[i].equalsIgnoreCase("-OPENEXI") || args[i].equalsIgnoreCase("-OPEN-EXI") || args[i].equalsIgnoreCase("-NAGASENA")) {
                ConfigurationProperties.setExiEngine("OPENEXI");
                System.out.println("CommandLine parameter: \"" + args[i] + "\" invoked ConfigurationProperties.setExiEngine(OPENEXI);");
                System.out.println("  [warning] \"OPENEXI\" testing in progress, can also use EXIFICIENT instead.");
                continue;
            }
            if (args[i].equalsIgnoreCase("-EXI") || args[i].equalsIgnoreCase("-toEXI")) {
                if (sourceFileName.toLowerCase().endsWith(".exi")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert an .exi file -toEXI");
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToEXI = true;
                convertToFile = true;
                conversionExtension = ".exi";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to compressed EXI containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-EXI") && sourceFileName.toLowerCase().endsWith(".exi") || args[i].equalsIgnoreCase("-fromEXI")) {
                if (!sourceFileName.toLowerCase().endsWith(".exi")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert a non-exi file -toEXI");
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertFromEXI = true;
                conversionExtension = ".x3d";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion from compressed EXI containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-toGZ") || args[i].equalsIgnoreCase("-toGZIP")) {
                if (sourceFileName.toLowerCase().endsWith(".gz")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert -toGZIP an already gzip .gz file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToGZIP = true;
                convertToFile = true;
                conversionExtension = ".gz";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to compressed GZIP containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-fromGZ") || args[i].equalsIgnoreCase("-fromGZIP")) {
                if (!sourceFileName.toLowerCase().endsWith(".gz")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert -fromGZIP an non-gzip file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertFromGZIP = true;
                conversionExtension = ".x3d";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion from compressed GZIP containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-toZIP")) {
                if (sourceFileName.toLowerCase().endsWith(".zip")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert -toZIP a non-zip file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertToZIP = true;
                conversionExtension = ".zip";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion to compressed ZIP containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-fromZIP")) {
                if (!sourceFileName.toLowerCase().endsWith(".zip")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot convert -fromZIP a non-zip file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                CommandLine.clearPriorConversionSwitches(args[i]);
                convertFromZIP = true;
                convertToFile = true;
                conversionExtension = ".x3d";
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for conversion from compressed ZIP containing model");
                continue;
            }
            if (args[i].equalsIgnoreCase("-toImage") || args[i].equalsIgnoreCase("-screenshot")) {
                CommandLine.initializeConfigurationSwitches();
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for creating screenshot image of default viewpoint");
                System.out.println("Pass through to BlenderLauncher...");
                BlenderLauncher.run(args);
                return;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("-validate")) {
                validateSwitch = true;
                if (((String)resultFileName).isEmpty()) {
                    resultFileName = "Validation.txt";
                    System.out.println("CommandLine parameter: \"" + args[i] + "\" for model validation");
                    continue;
                }
                System.out.println("CommandLine parameter: \"" + args[i] + "\" for model validation to result file");
                continue;
            }
            if (args[i].equalsIgnoreCase("-home") || args[i].equalsIgnoreCase("-page") || args[i].equalsIgnoreCase("-homepage") || args[i].equalsIgnoreCase("-website") || args[i].equalsIgnoreCase("-X3DJSAIL")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                System.out.println("Opening https://www.web3d.org/specifications/java/X3DJSAIL.html");
                CommandLine.openHomePageX3DJSAIL();
                return;
            }
            if (args[i].equalsIgnoreCase("-javadoc")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                System.out.println("Opening Javadoc at https://www.web3d.org/specifications/java/X3DJSAIL.html");
                CommandLine.openJavadocX3DJSAIL();
                return;
            }
            if (args[i].equalsIgnoreCase("-resources") || args[i].equalsIgnoreCase("-X3dResources")) {
                System.out.println("Opening https://www.web3d.org/x3d/content/examples/X3dResources.html");
                if (i < args.length - 1) {
                    CommandLine.openX3dResourcesPage(args[i + 1]);
                } else {
                    CommandLine.openX3dResourcesPage();
                }
                return;
            }
            if (args[i].equalsIgnoreCase("-hints") || args[i].equalsIgnoreCase("-SceneAuthoringHints") || args[i].equalsIgnoreCase("-X3dSceneAuthoringHints")) {
                System.out.println("Opening https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html");
                if (i < args.length - 1) {
                    CommandLine.openX3dSceneAuthoringHintsPage(args[i + 1]);
                } else {
                    CommandLine.openX3dSceneAuthoringHintsPage();
                }
                return;
            }
            if (args[i].equalsIgnoreCase("-tooltips") || args[i].equalsIgnoreCase("-X3dTooltips")) {
                System.out.println("Opening https://www.web3d.org/x3d/tooltips/X3dTooltips.html");
                if (i < args.length - 1) {
                    CommandLine.openX3dTooltipsPage(args[i + 1]);
                } else {
                    CommandLine.openX3dTooltipsPage();
                }
                return;
            }
            if (args[i].equalsIgnoreCase("-regex") || args[i].equalsIgnoreCase("-regexes") || args[i].equalsIgnoreCase("-RegularExpressions")) {
                System.out.println("Opening https://www.web3d.org/specifications/X3dRegularExpressions.html");
                if (i < args.length - 1) {
                    CommandLine.openX3dRegexesPage(args[i + 1]);
                } else {
                    CommandLine.openX3dRegexesPage();
                }
                return;
            }
            if (args[i].equalsIgnoreCase("-X3DUOM")) {
                System.out.println("Opening https://www.web3d.org/specifications/X3DUOM.html");
                CommandLine.openX3DUOMpage();
                return;
            }
            if (args[i].toLowerCase().contains("-help")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                System.out.println(USAGE);
                System.out.println();
                System.out.println(USAGE_LONG);
                return;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                CommandLine.clearPriorConversionSwitches(args[i]);
                System.out.println("X3DJSAIL version date: 28 November 2025");
                if (i != args.length - 1 && args.length <= 2) continue;
                return;
            }
            System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] unrecognized CommandLine option \"" + args[i] + "\"");
            System.out.println(USAGE);
            System.out.println();
            System.out.println(USAGE_LONG);
            return;
        }
        if (loadProperties) {
            if (!propertiesFileName.isEmpty()) {
                ConfigurationProperties.setPropertiesFileName(propertiesFileName);
            }
            ConfigurationProperties.loadProperties();
        }
        if (!sourceFileName.isEmpty() && ((String)resultFileName).isEmpty()) {
            resultFileNameRoot = sourceFileNameRoot;
            resultFileName = (String)resultFileNameRoot + conversionExtension;
        }
        if (convertToX3D && !conversionExtension.equalsIgnoreCase(".x3d") || convertToXML && !conversionExtension.equalsIgnoreCase(".xml") || canonicalize && !conversionExtension.equalsIgnoreCase(".x3d") && !conversionExtension.equalsIgnoreCase(".xml") || convertToHTML && !conversionExtension.equalsIgnoreCase(".html") && !conversionExtension.equalsIgnoreCase(".xhtml") || convertToMarkdown && !conversionExtension.equalsIgnoreCase(".md") || schematronSwitch && !conversionExtension.equalsIgnoreCase(".txt") || convertToTidy && !conversionExtension.equalsIgnoreCase(".x3d") || convertToClassicVRML && !conversionExtension.equalsIgnoreCase(".x3dv") || convertToVRML97 && !conversionExtension.equalsIgnoreCase(".wrl") || convertToX3DOM && !conversionExtension.equalsIgnoreCase(".html") && !conversionExtension.equalsIgnoreCase(".xhtml") || convertToX_ITE && !conversionExtension.equalsIgnoreCase(".html") && !conversionExtension.equalsIgnoreCase(".xhtml") || convertToEXI && !conversionExtension.equalsIgnoreCase(".exi") || convertToGZIP && !conversionExtension.equalsIgnoreCase(".gz") || convertToZIP && !conversionExtension.equalsIgnoreCase(".zip")) {
            System.out.println("[Warning]  [org.web3d.x3d.jsail.CommandLine] mismatched file extension \"" + conversionExtension + "\" for conversion");
        }
        if (!sourceFileName.isEmpty()) {
            boolean result;
            if (convertFromGZIP) {
                if (!sourceFileName.toLowerCase().endsWith(".gz")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot -gunzip a non-gzip file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                result = loadedX3dModel.fromFileGZIP(sourceFileName);
                System.out.println("load result: " + result);
                return;
            }
            if (convertFromZIP) {
                if (!sourceFileName.toLowerCase().endsWith(".zip")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot -gunzip a non-zip file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                result = loadedX3dModel.fromFileZIP(sourceFileName, (String)resultFileName);
                System.out.println("load result: " + result);
                return;
            }
            if (convertFromEXI) {
                if (!sourceFileName.toLowerCase().endsWith(".exi")) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.CommandLine] cannot -fromEXI a non-EXI file " + sourceFileName);
                    System.out.println(USAGE);
                    return;
                }
                result = loadedX3dModel.fromFileEXI(sourceFileName);
                System.out.println("load result: " + result);
                return;
            }
            if (canonicalize) {
                String sourceString = CommandLine.getFileContents(sourceFileName);
                if (sourceFile == null) {
                    sourceFile = new File(sourceFileName);
                }
                if (((String)resultFileName).endsWith(".x3d")) {
                    resultFileName = (String)resultFileNameRoot + "Canonical.xml";
                    System.out.println("CommandLine invocation: changed resultFileName=" + (String)resultFileName + " to meet X3dC14n requirement");
                }
                CharSequence[] invocationArguments = new String[]{sourceFile.getAbsolutePath(), resultFileName};
                System.out.println("CommandLine invocation: new X3dCanonicalizer(" + String.join((CharSequence)",", invocationArguments) + ")");
                X3dCanonicalizer x3dCanonicalizer = new X3dCanonicalizer((String[])invocationArguments);
                System.out.println("...x3dCanonicalizer.isCanonical()=" + x3dCanonicalizer.isCanonical());
                resultFile = new File((String)resultFileName);
                if (resultFile == null) {
                    throw new X3DException("ERROR: Failure to create resultFile " + (String)resultFileName);
                }
                if (resultFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
                    System.out.println("Note: x3dCanonicalizer is overwriting prior file " + (String)resultFileName);
                } else if (resultFile.exists()) {
                    System.out.println("[warning] x3dCanonicalizer is not allowed to overwrite prior file: " + (String)resultFileName);
                    System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
                    return;
                }
                Path outputFilePath = Paths.get((String)resultFileName, new String[0]);
                if (ConfigurationProperties.isDebugModeActive()) {
                    String errorNotice = "*** [diagnostic] Output file path=" + String.valueOf(outputFilePath.toAbsolutePath()) + "\n";
                    System.out.println(errorNotice);
                }
                String outputSceneText = x3dCanonicalizer.getFinalC14nScene();
                try {
                    Path directoryPath = outputFilePath.getParent();
                    if (directoryPath != null) {
                        Files.createDirectories(directoryPath, new FileAttribute[0]);
                    }
                    bufferedWriter = Files.newBufferedWriter(outputFilePath, charset, new OpenOption[0]);
                    bufferedWriter.write(outputSceneText, 0, outputSceneText.length());
                    bufferedWriter.close();
                    outputFilePath.toFile();
                }
                catch (IOException exception) {
                    exception.printStackTrace(System.err);
                    throw new X3DException("IOException for fileName " + (String)resultFileName + ", unable to save file: " + String.valueOf(exception));
                }
                return;
            }
            if (convertToHTML) {
                System.out.println("convert to HTML files using X3dToXhtml.xslt:");
                if (sourceFile == null) {
                    sourceFile = new File(sourceFileName);
                }
                if (!convertToFile) {
                    System.out.println();
                }
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToXhtml.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToXhtml.xslt"));
                }
                return;
            }
            if (convertToVRML97) {
                System.out.println("convert to VRML97 using X3dToVrml97.xslt:");
                if (!convertToFile) {
                    System.out.println();
                }
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToVrml97.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToVrml97.xslt"));
                }
                return;
            }
            if (convertToClassicVRML) {
                System.out.println("convert to ClassicVRML using X3dToX3dvClassicVrmlEncoding.xslt:");
                if (!convertToFile) {
                    System.out.println();
                }
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToX3dvClassicVrmlEncoding.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToX3dvClassicVrmlEncoding.xslt"));
                }
                return;
            }
            if (convertToJava) {
                String presetXsltEngine = ConfigurationProperties.getXsltEngine();
                ConfigurationProperties.setXsltEngine("NATIVE_JAVA");
                System.out.println("convert to Java using X3dToJava.xslt:");
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToJava.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToJava.xslt"));
                }
                ConfigurationProperties.setXsltEngine(presetXsltEngine);
                return;
            }
            if (convertToJSON) {
                String presetXsltEngine = ConfigurationProperties.getXsltEngine();
                ConfigurationProperties.setXsltEngine("NATIVE_JAVA");
                System.out.println("convert to JSON using X3dToJson.xslt:");
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToJson.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToJson.xslt"));
                }
                ConfigurationProperties.setXsltEngine(presetXsltEngine);
                return;
            }
            if (convertToPython) {
                String presetXsltEngine = ConfigurationProperties.getXsltEngine();
                ConfigurationProperties.setXsltEngine("NATIVE_JAVA");
                System.out.println("convert to Python using X3dToPython.xslt:");
                if (convertToFile) {
                    CommandLine.fileStylesheetConversion(sourceFile, "X3dToPython.xslt", (String)resultFileName);
                } else {
                    System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dToPython.xslt"));
                }
                ConfigurationProperties.setXsltEngine(presetXsltEngine);
                return;
            }
            if (schematronSwitch) {
                try {
                    String intermediateFileName = (String)resultFileName + ".svrl";
                    if (!convertToFile) {
                        System.out.println();
                    }
                    System.out.println("First creating intermediate SVRL file using stylesheet X3dSchematronValidityChecks.xslt");
                    File intermediateFile = CommandLine.fileStylesheetConversion(sourceFile, "X3dSchematronValidityChecks.xslt", intermediateFileName);
                    System.out.println("   intermediate SVRL file " + intermediateFileName + " fileExists=" + intermediateFile.exists());
                    System.out.println("... Next creating final report file using stylesheet SvrlReportText.xslt");
                    if (convertToFile) {
                        resultFile = CommandLine.fileStylesheetConversion(intermediateFile, "SvrlReportText.xslt", (String)resultFileName);
                        System.out.println("Resulting result file: " + (String)resultFileName + " exists=" + resultFile.exists());
                    } else {
                        CommandLine.fileStylesheetConversionToString(intermediateFile, "SvrlReportText.xslt");
                    }
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            } else {
                if (convertToTidy) {
                    System.out.println("convert to X3D Tidy cleaned-up version");
                    if (!convertToFile) {
                        System.out.println();
                    }
                    if (convertToFile) {
                        CommandLine.fileStylesheetConversion(sourceFile, "X3dTidy.xslt", (String)resultFileName);
                    } else {
                        System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dTidy.xslt"));
                    }
                    return;
                }
                if (convertToMarkdown) {
                    System.out.println("convert to " + conversionExtension + " model meta information markdown, include subdirectories in meta links: " + includeSubdirectoryPaths);
                    if (!convertToFile) {
                        System.out.println();
                    }
                    if (convertToFile) {
                        CommandLine.fileStylesheetConversion(sourceFile, "X3dModelMetaToMarkdown.xslt", (String)resultFileName);
                    } else {
                        System.out.println(CommandLine.fileStylesheetConversionToString(sourceFile, "X3dModelMetaToMarkdown.xslt"));
                    }
                    return;
                }
            }
            System.out.println("Parsing using Document Object Model (DOM) based X3DLoaderDOM...");
            X3DLoaderDOM x3dLoader = new X3DLoaderDOM();
            boolean successfulLoad = x3dLoader.loadModelFromFileX3D(sourceFileName);
            if (successfulLoad && x3dLoader.isLoadSuccessful()) {
                ConfigurationProperties.setXsltEngine("NATIVE_JAVA");
                resultFile = new File("temp9876543210.txt");
                try {
                    X3DConcreteElement x3dConcreteElement = x3dLoader.getX3dObjectTree();
                    if (!(x3dConcreteElement instanceof X3D)) {
                        if (x3dConcreteElement == null) {
                            System.out.println("[Error] TODO problem with X3dLoader, x3dConcreteElement is null.");
                            return;
                        }
                        System.out.println("[Error] TODO problem with X3dLoader, result has type " + x3dConcreteElement.getClass().getCanonicalName());
                        return;
                    }
                    loadedX3dModel = (X3D)x3dConcreteElement;
                    if (convertToJS) {
                        String presetXsltEngine = ConfigurationProperties.getXsltEngine();
                        ConfigurationProperties.setXsltEngine("NATIVE_JAVA");
                        System.out.println("convert to JS JavaScript:");
                        if (convertToFile) {
                            resultFile = loadedX3dModel.toFileJavaScript((String)resultFileName);
                        } else {
                            System.out.println(loadedX3dModel.toStringJavaScript());
                        }
                        ConfigurationProperties.setXsltEngine(presetXsltEngine);
                    } else if (convertToX3D) {
                        System.out.println("convert to X3D:");
                        if (!convertToFile) {
                            System.out.println();
                        }
                        if (convertToFile) {
                            resultFile = loadedX3dModel.toFileX3D((String)resultFileName);
                        } else {
                            System.out.println(loadedX3dModel.toStringX3D());
                        }
                    } else if (convertToXML) {
                        System.out.println("convert to XML:");
                        if (!convertToFile) {
                            System.out.println();
                        }
                        if (convertToFile) {
                            resultFile = loadedX3dModel.toFileXML((String)resultFileName);
                        } else {
                            System.out.println(loadedX3dModel.toStringXML());
                        }
                    } else if (convertToX3DOM) {
                        System.out.println("convert to X3DOM using X3dToX3domX_ITE.xslt:");
                        if (!convertToFile) {
                            System.out.println();
                        }
                        if (convertToFile) {
                            resultFile = loadedX3dModel.toFileX3DOM((String)resultFileName);
                        } else {
                            System.out.println(loadedX3dModel.toStringX3DOM());
                        }
                    } else if (convertToX_ITE) {
                        System.out.println("convert to X_ITE using X3dToX3domX_ITE.xslt:");
                        if (!convertToFile) {
                            System.out.println();
                        }
                        if (convertToFile) {
                            resultFile = loadedX3dModel.toFileX_ITE(sourceFileName, (String)resultFileName);
                        } else {
                            System.out.println(loadedX3dModel.toStringX_ITE(sourceFileName));
                        }
                    } else if (convertToEXI) {
                        System.out.println("convert to EXI using " + ConfigurationProperties.getExiEngine() + ":");
                        System.out.println("source: " + sourceFileName + " filesize " + sourceFileLength + " bytes");
                        resultFile = loadedX3dModel.toFileEXI((String)resultFileName);
                        String compressionRatio = formatPrecision2.format((double)resultFile.length() / (double)sourceFileLength * 100.0);
                        System.out.println("result: " + resultFile.getName() + " filesize " + resultFile.length() + " bytes, compression " + compressionRatio + "% of original");
                    } else if (convertToGZIP) {
                        System.out.println("convert to GZIP:");
                        System.out.println("source: " + sourceFileName + " filesize " + sourceFileLength + " bytes");
                        resultFile = loadedX3dModel.toFileGZIP((String)resultFileName);
                        String compressionRatio = formatPrecision2.format((double)resultFile.length() / (double)sourceFileLength * 100.0);
                        System.out.println("result: " + resultFile.getName() + "  filesize " + resultFile.length() + " bytes, compression " + compressionRatio + "% of original");
                    } else if (convertToZIP) {
                        System.out.println("convert to ZIP:");
                        System.out.println("source: " + sourceFileName + " filesize " + sourceFileLength + " bytes");
                        resultFile = loadedX3dModel.toFileZIP((String)resultFileName, sourceFileName);
                        String compressionRatio = formatPrecision2.format((double)resultFile.length() / (double)sourceFileLength * 100.0);
                        System.out.println("result: " + resultFile.getName() + " filesize " + resultFile.length() + " bytes, compression " + compressionRatio + "% of original");
                    }
                    if (validateSwitch) {
                        String outputValidationText = loadedX3dModel.validate();
                        if (!convertToFile) {
                            if (outputValidationText.isEmpty()) {
                                outputValidationText = "validate results: success, no problems noted";
                                System.out.println(outputValidationText);
                            } else {
                                System.out.println("validate results:");
                                System.out.println(outputValidationText);
                            }
                            return;
                        }
                        if (convertToFile && outputValidationText.isEmpty()) {
                            outputValidationText = "success, no problems noted, no output file written";
                            System.out.println(outputValidationText);
                            return;
                        }
                        if (convertToFile) {
                            if (!((String)resultFileName).endsWith(".txt")) {
                                resultFileName = (String)resultFileName + ".txt";
                            }
                            Path outputFilePath = Paths.get((String)resultFileName, new String[0]);
                            Object errorNotice = new String();
                            if (ConfigurationProperties.isDebugModeActive()) {
                                errorNotice = (String)errorNotice + "[diagnostic] Output file path=" + String.valueOf(outputFilePath.toAbsolutePath()) + "\n";
                            }
                            System.out.println((String)errorNotice);
                            try {
                                Path directoryPath = outputFilePath.getParent();
                                if (directoryPath != null) {
                                    Files.createDirectories(directoryPath, new FileAttribute[0]);
                                }
                                bufferedWriter = Files.newBufferedWriter(outputFilePath, charset, new OpenOption[0]);
                                bufferedWriter.write(outputValidationText, 0, outputValidationText.length());
                                bufferedWriter.close();
                                outputFilePath.toFile();
                            }
                            catch (IOException exception) {
                                exception.printStackTrace(System.err);
                                throw new X3DException("[Error] IOException for resultFileName " + (String)resultFileName + ", unable to save file: " + String.valueOf(exception));
                            }
                        }
                    }
                    if (!(convertToEXI || convertToGZIP || convertToZIP)) {
                        if (convertToFile && resultFile.exists() && !resultFile.getName().equals("temp9876543210.txt")) {
                            System.out.println("file conversion successful: " + resultFile.getName() + " (" + resultFile.length() + " bytes)");
                        } else if (convertToFile) {
                            System.out.println("[Error] file conversion unsuccessful!");
                        } else if (validateSwitch) {
                            System.out.println("model validation complete.");
                        } else if (schematronSwitch) {
                            System.out.println("X3D Schematron model diagnostics complete.");
                        }
                    }
                }
                catch (X3DException e) {
                    e.printStackTrace(System.err);
                    System.out.println("[Error] TODO must fix model - problem handling local exception within CommandLine, exiting.");
                }
            } else {
                System.out.println("[Error] Source model file load unsuccessful");
            }
        } else if (!loadProperties) {
            System.out.println("[Error] Source model file name is empty, therefore file loading not possible.");
        }
        if (resultFile.getName().equals("temp9876543210.txt")) {
            resultFile.delete();
        }
    }

    public static void openJavadocX3DJSAIL() {
        String onlineURL = "https://www.web3d.org/specifications/java/X3DJSAIL.html".substring(0, "https://www.web3d.org/specifications/java/X3DJSAIL.html".lastIndexOf("/") + 1) + "javadoc/index.html";
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("javadoc/index.html"));
            } else {
                System.out.println("Java Desktop not supported, cannot open");
                System.out.println("  " + onlineURL);
            }
        }
        catch (IOException | URISyntaxException e1) {
            try {
                Desktop.getDesktop().browse(new URI(onlineURL));
            }
            catch (IOException | URISyntaxException e2) {
                System.out.println("URL_X3DJSAIL Javadoc: " + onlineURL);
                System.out.println("URL_X3DJSAIL failure: " + e2.getMessage());
            }
        }
    }

    public static void openHomePageX3DJSAIL() {
        CommandLine.openHomePageX3DJSAIL("");
    }

    public static void openHomePageX3DJSAIL(String bookmark) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("X3DJSAIL.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("X3DJSAIL.html"));
                }
            } else {
                System.out.println("Java Desktop not supported, cannot open X3DJSAIL.html");
            }
        }
        catch (IOException | URISyntaxException e1) {
            try {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/specifications/java/X3DJSAIL.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/specifications/java/X3DJSAIL.html"));
                }
            }
            catch (IOException | URISyntaxException e2) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    System.out.println("URL_X3DJSAIL: https://www.web3d.org/specifications/java/X3DJSAIL.html#" + bookmark);
                } else {
                    System.out.println("URL_X3DJSAIL: https://www.web3d.org/specifications/java/X3DJSAIL.html");
                }
                System.out.println("URL_X3DJSAIL failure: " + e2.getMessage());
            }
        }
    }

    public static void openX3dResourcesPage() {
        CommandLine.openX3dResourcesPage("");
    }

    public static void openX3dResourcesPage(String bookmark) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/content/examples/X3dResources.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/content/examples/X3dResources.html"));
                }
            }
        }
        catch (IOException | URISyntaxException e2) {
            if (bookmark != null && !bookmark.isEmpty()) {
                System.out.println("URL_X3DJSAIL: https://www.web3d.org/x3d/content/examples/X3dResources.html#" + bookmark);
            } else {
                System.out.println("URL_X3DJSAIL: https://www.web3d.org/x3d/content/examples/X3dResources.html");
            }
            System.out.println("URL_X3DJSAIL failure: " + e2.getMessage());
        }
    }

    public static void openX3dTooltipsPage() {
        CommandLine.openX3dTooltipsPage("");
    }

    public static void openX3dTooltipsPage(String bookmark) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/tooltips/X3dTooltips.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/tooltips/X3dTooltips.html"));
                }
            }
        }
        catch (IOException | URISyntaxException e2) {
            if (bookmark != null && !bookmark.isEmpty()) {
                System.out.println("URL_X3DTOOLTIPS: https://www.web3d.org/x3d/tooltips/X3dTooltips.html#" + bookmark);
            } else {
                System.out.println("URL_X3DTOOLTIPS: https://www.web3d.org/x3d/tooltips/X3dTooltips.html");
            }
            System.out.println("URL_X3DTOOLTIPS failure: " + e2.getMessage());
        }
    }

    public static void openX3dRegexesPage() {
        CommandLine.openX3dRegexesPage("");
    }

    public static void openX3dRegexesPage(String bookmark) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/specifications/X3dRegularExpressions.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/specifications/X3dRegularExpressions.html"));
                }
            }
        }
        catch (IOException | URISyntaxException e2) {
            if (bookmark != null && !bookmark.isEmpty()) {
                System.out.println("URL_X3DREGEXES: https://www.web3d.org/specifications/X3dRegularExpressions.html#" + bookmark);
            } else {
                System.out.println("URL_X3DREGEXES: https://www.web3d.org/specifications/X3dRegularExpressions.html");
            }
            System.out.println("URL_X3DREGEXES failure: " + e2.getMessage());
        }
    }

    public static void openX3DUOMpage() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("https://www.web3d.org/specifications/X3DUOM.html"));
            }
        }
        catch (IOException | URISyntaxException e2) {
            System.out.println("URL_X3DUOM: https://www.web3d.org/specifications/X3DUOM.html");
            System.out.println("URL_X3DUOM failure: " + e2.getMessage());
        }
    }

    public static void openX3dSceneAuthoringHintsPage() {
        CommandLine.openX3dSceneAuthoringHintsPage("");
    }

    public static void openX3dSceneAuthoringHintsPage(String bookmark) {
        try {
            if (Desktop.isDesktopSupported()) {
                if (bookmark != null && !bookmark.isEmpty()) {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#" + bookmark));
                } else {
                    Desktop.getDesktop().browse(new URI("https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html"));
                }
            }
        }
        catch (IOException | URISyntaxException e2) {
            if (bookmark != null && !bookmark.isEmpty()) {
                System.out.println("URL_X3DSCENEAUTHORINGHINTS: https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html#" + bookmark);
            } else {
                System.out.println("URL_X3DSCENEAUTHORINGHINTS: https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html");
            }
            System.out.println("URL_X3DSCENEAUTHORINGHINTS failure: " + e2.getMessage());
        }
    }

    private static void clearPriorConversionSwitches(String newCommand) {
        if (convertToVRML97 || convertToClassicVRML || convertToX3D || convertToXML || convertToHTML || convertToMarkdown || convertToTidy || convertToJava || convertToPython || convertToJSON || convertToJS || convertToX3DOM || convertToX_ITE || schematronSwitch) {
            System.out.println("[Warning] Prior conversion flag overridden by " + newCommand);
        }
        convertToVRML97 = false;
        convertToClassicVRML = false;
        convertToX3D = false;
        convertToXML = false;
        convertToHTML = false;
        convertToMarkdown = false;
        includeSubdirectoryPaths = true;
        schematronSwitch = false;
        convertToTidy = false;
        convertToJava = false;
        convertToJS = false;
        convertToJSON = false;
        convertToPython = false;
        convertToX3DOM = false;
        convertToX_ITE = false;
    }

    public static File fileStylesheetConversion(String inputFilePath, String stylesheetName, String outputFileName) {
        File inputFile = new File(inputFilePath);
        return CommandLine.fileStylesheetConversion(inputFile, stylesheetName, outputFileName);
    }

    public static String fileStylesheetConversionToString(File inputFile, String stylesheetName) {
        Object errorNotice = new String();
        String fileNameRoot = "tempFile";
        String fileExtension = ConfigurationProperties.getExpectedOutputFileExtension(stylesheetName);
        String fileName = fileNameRoot + fileExtension;
        String resultText = new String();
        try {
            File outputFile = File.createTempFile(fileNameRoot, fileExtension);
            if (outputFile == null) {
                errorNotice = (String)errorNotice + "outputFile not created: " + fileName + ", ";
            } else {
                outputFile.deleteOnExit();
            }
            CommandLine.fileStylesheetConversion(inputFile, stylesheetName, outputFile.getAbsolutePath());
            resultText = CommandLine.getFileContents(outputFile);
        }
        catch (IOException ex) {
            errorNotice = (String)errorNotice + "IOException: " + ex.getMessage();
            ex.printStackTrace(System.err);
        }
        if (!((String)errorNotice).isEmpty()) {
            System.out.println((String)errorNotice);
        }
        return resultText;
    }

    public static File fileStylesheetConversion(File inputFile, String stylesheetName, String outputFileName) {
        String parameterName1 = new String();
        String parameterValue1 = new String();
        String parameterName2 = new String();
        String parameterValue2 = new String();
        Object errorNotice = new String();
        if (inputFile == null || !inputFile.isFile() || !inputFile.canRead()) {
            throw new X3DException("fileStylesheetConversion(inputFile, stylesheetName, outputFileName) inputFile not provided");
        }
        if (stylesheetName == null || stylesheetName.isEmpty()) {
            throw new X3DException("fileStylesheetConversion(stylesheetName, fileName) stylesheetName not provided; (see ConfigurationProperties for allowed choices)");
        }
        if (!ConfigurationProperties.isStylesheetSupported(stylesheetName)) {
            throw new X3DException("fileStylesheetConversion(stylesheetName, fileName) stylesheetName=" + stylesheetName + " not recognized; (see ConfigurationProperties for allowed choices)");
        }
        String expectedFileNameExtension = ConfigurationProperties.getExpectedOutputFileExtension(stylesheetName);
        if (outputFileName == null || outputFileName.isEmpty()) {
            throw new X3DException("toFileStylesheetConversionToFile(" + inputFile.getName() + "', " + stylesheetName + "', " + outputFileName + ") outputFileName not provided");
        }
        if (!(outputFileName.endsWith(expectedFileNameExtension) || outputFileName.endsWith(".xhtml") && expectedFileNameExtension.equals(".html") || outputFileName.endsWith(".js") && expectedFileNameExtension.equals(".json") || outputFileName.endsWith(".x3d") && expectedFileNameExtension.equals(".svrl") || outputFileName.endsWith(".txt"))) {
            throw new X3DException("outputFileName \"" + outputFileName + "\" does not end with expected extension \"" + expectedFileNameExtension + "\"");
        }
        Path outputFilePath = Paths.get(outputFileName, new String[0]);
        if (ConfigurationProperties.isDebugModeActive()) {
            errorNotice = (String)errorNotice + "[diagnostic] Output file path=" + String.valueOf(outputFilePath.toAbsolutePath()) + "\n";
            System.out.println((String)errorNotice);
        }
        Charset charset = Charset.forName("UTF-8");
        File outputFile = outputFilePath.toFile();
        if (outputFile == null) {
            errorNotice = (String)errorNotice + "outputFile not created: " + String.valueOf(outputFilePath.getFileName()) + ", ";
        } else if (outputFile.exists() && ConfigurationProperties.isOverwriteExistingFiles()) {
            errorNotice = (String)errorNotice + "Note: fileStylesheetConversion() is overwriting prior file " + String.valueOf(outputFilePath);
        } else if (outputFile.exists()) {
            System.out.println("[warning] fileStylesheetConversion() is not allowed to overwrite prior file: " + String.valueOf(outputFilePath));
            System.out.println("  see X3DJSAIL.properties file, or ConfigurationProperties.isOverwriteExistingFiles() and .setOverwriteExistingFiles(), to get/set permissions");
            return null;
        }
        try {
            File stylesheetFile = X3D.getTempFileFromX3dJsailJar("/stylesheets", stylesheetName);
            if (stylesheetFile == null) {
                errorNotice = (String)errorNotice + "Temporary stylesheet not created: " + stylesheetName + ", ";
            } else if (!stylesheetFile.exists()) {
                errorNotice = (String)errorNotice + "Temporary stylesheet not found: " + stylesheetFile.getAbsolutePath() + ", ";
            }
            if (stylesheetName.equalsIgnoreCase("X3dToX3dvClassicVrmlEncoding.xslt")) {
                File stylesheetFile2 = X3D.getTempFileFromX3dJsailJar("/stylesheets", "X3dToVrml97.xslt");
                if (stylesheetFile2 == null) {
                    errorNotice = (String)errorNotice + "Temporary stylesheet not created: X3dToVrml97.xslt, ";
                } else if (!stylesheetFile2.exists()) {
                    errorNotice = (String)errorNotice + "Temporary stylesheet not found: " + stylesheetFile2.getAbsolutePath() + ", ";
                }
                File stylesheetFile3 = new File(stylesheetFile.getParent(), "X3dToVrml97.xslt");
                String targetPath = stylesheetFile3.getAbsolutePath();
                if (stylesheetFile3.exists()) {
                    stylesheetFile3.delete();
                }
                Files.copy(Paths.get(stylesheetFile2.getAbsolutePath(), new String[0]), Paths.get(targetPath, new String[0]), new CopyOption[0]);
            }
            if (ConfigurationProperties.getXsltEngine().equals("SAXON9HE")) {
                Processor processor = new Processor(false);
                XsltCompiler xsltCompiler = processor.newXsltCompiler();
                XsltExecutable xsltExecutable = xsltCompiler.compile((Source)new StreamSource(stylesheetFile));
                XdmNode source = processor.newDocumentBuilder().build((Source)new StreamSource(inputFile));
                Serializer out = processor.newSerializer(outputFile);
                out.setOutputProperty(Serializer.Property.METHOD, "html");
                out.setOutputProperty(Serializer.Property.INDENT, "yes");
                XsltTransformer xsltTransformer = xsltExecutable.load();
                xsltTransformer.setInitialContextNode(source);
                xsltTransformer.setDestination((Destination)out);
                if (parameterName1.length() > 0) {
                    xsltTransformer.setParameter(new QName(parameterName1), (XdmValue)new XdmAtomicValue(parameterValue1));
                }
                if (parameterName2.length() > 0) {
                    xsltTransformer.setParameter(new QName(parameterName2), (XdmValue)new XdmAtomicValue(parameterValue2));
                }
                xsltTransformer.setParameter(new QName("produceSVGfigures"), (XdmValue)new XdmAtomicValue("false"));
                xsltTransformer.transform();
            } else if (ConfigurationProperties.getXsltEngine().equals("NATIVE_JAVA")) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document x3dDocument = builder.parse(inputFile);
                TransformerFactory tFactory = TransformerFactory.newInstance();
                StreamSource styleStreamSource = new StreamSource(stylesheetFile);
                Transformer transformer = tFactory.newTransformer(styleStreamSource);
                if (parameterName1.length() > 0) {
                    transformer.setParameter(parameterName1, parameterValue1);
                }
                if (parameterName2.length() > 0) {
                    transformer.setParameter(parameterName2, parameterValue2);
                }
                transformer.setParameter("produceSVGfigures", "false");
                DOMSource domSource = new DOMSource(x3dDocument);
                StreamResult streamResult = new StreamResult(outputFile);
                transformer.transform(domSource, streamResult);
            } else {
                errorNotice = "Invalid ConfigurationProperties.getXsltEngine() value='" + ConfigurationProperties.getXsltEngine() + "', legal values are ConfigurationProperties.XSLT_ENGINE_SAXON or ConfigurationProperties.XSLT_ENGINE_NATIVE_JAVA";
                throw new InvalidFieldValueException((String)errorNotice);
            }
            if (!((String)errorNotice).isEmpty()) {
                System.out.println((String)errorNotice);
            }
            return outputFile;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
            throw new X3DException((String)errorNotice + exception.toString() + " exception when transforming and creating string, unable to save result: " + String.valueOf(exception));
        }
        catch (SaxonApiException saxonApiException) {
            throw new X3DException((String)errorNotice + "SaxonApiException when transforming and creating string, unable to save result: " + String.valueOf((Object)saxonApiException));
        }
    }

    protected static String getFileContents(String inputFileName) {
        File inputFile = new File(inputFileName);
        return CommandLine.getFileContents(inputFile);
    }

    protected static String getFileContents(File inputFile) {
        Charset charset = Charset.forName("UTF-8");
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(inputFile.getAbsolutePath(), new String[0]));
            String sourceString = new String(encoded, charset);
            return sourceString;
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            String inputFileName = "[null]";
            if (inputFile != null) {
                inputFileName = inputFile.getPath();
            }
            throw new X3DException("[Error] CommandLine.getFileContents(" + inputFileName + ") IOException for inputFile " + String.valueOf(inputFile) + ", unable to read file: " + String.valueOf(ex));
        }
    }

    static {
        canonicalize = false;
        convertToVRML97 = false;
        convertToClassicVRML = false;
        convertToX3D = false;
        convertToXML = false;
        convertToHTML = false;
        convertToMarkdown = false;
        includeSubdirectoryPaths = true;
        convertToTidy = false;
        convertToJava = false;
        convertToJS = false;
        convertToJSON = false;
        convertToPython = false;
        convertToX3DOM = false;
        convertToX_ITE = false;
        convertToEXI = false;
        convertFromEXI = false;
        convertToGZIP = false;
        convertFromGZIP = false;
        convertToZIP = false;
        convertFromZIP = false;
        validateSwitch = false;
        schematronSwitch = false;
        conversionExtension = new String();
    }
}

