/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.MetadataSet;
import org.web3d.x3d.jsail.Core.X3D;
import org.web3d.x3d.sai.InvalidExecutionContextException;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class BlenderLauncher {
    public static final String BLENDER_URL = "https://www.blender.org";
    private static final String blenderExecutableName_DEFAULT = "blender";
    private static String blenderExecutableName = "blender";
    private static String blenderPath = "";
    public static final String BLENDER_PATH_DEFAULT_WINDOWS = "C:\\Program Files\\Blender Foundation\\Blender 4.5";
    public static final String BLENDER_PATH_DEFAULT_MACOS = "/Applications/blender.app/Contents/MacOS/blender";
    public static final String BLENDER_PATH_DEFAULT_LINUX = "/usr/bin/blender";
    public static final String BLENDER_PYTHON_SCRIPT_X3D_TO_PNG = "BlenderX3dToPng.py";
    public static final String BLENDER_PYTHON_SCRIPT_STL_TO_X3D = "BlenderStlToX3d.py";
    private static File BlenderX3dToPngPythonFile;
    public static final String USAGE = "Usage: java [-classpath X3DJSAIL.*.jar] org.web3d.x3d.jsail.BlenderLauncher sourceFile [-convert [resultFile]] [-toImage [snapshotName.*]] [-home | -help | -version | -properties fileName.properties | -BLENDER_PATH directoryPath]";
    private static final String WARNING = "[Warning] ";
    private static final String ERROR = "[Error] ";
    private static boolean modelConvert;
    private static boolean modelExport;
    private static boolean modelImport;
    private static String conversionExtension;
    private static BufferedWriter bufferedWriter;
    private static boolean executeCommandSuccessful;

    public static final String getBlenderExecutableName() {
        String OPERATING_SYSTEM_NAME = System.getProperty("os.name");
        if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("windows") && blenderExecutableName.equals(blenderExecutableName_DEFAULT)) {
            blenderExecutableName = blenderExecutableName + ".exe";
        }
        return blenderExecutableName;
    }

    public static final String getBlenderPath() {
        return blenderPath;
    }

    public static final void setBlenderPath(String newValue) {
        File blenderServerFile;
        if (newValue == null || newValue.isEmpty()) {
            String errorNotice = "*** Invalid setBlenderPath(String newValue) invocation, newValue='" + newValue + "', " + BlenderLauncher.getBlenderExecutableName() + " not found at this location";
            throw new InvalidFieldValueException(errorNotice);
        }
        blenderPath = newValue;
        if (blenderPath.endsWith(BlenderLauncher.getBlenderExecutableName())) {
            blenderPath = blenderPath.substring(0, blenderPath.lastIndexOf(BlenderLauncher.getBlenderExecutableName()));
        }
        if (!blenderPath.endsWith("\\") && !blenderPath.endsWith(File.separator)) {
            blenderPath = blenderPath + File.separator;
        }
        if (!(blenderServerFile = new File(blenderPath, BlenderLauncher.getBlenderExecutableName())).exists()) {
            String errorNotice = "*** Invalid setBlenderPath(String newValue) invocation, newValue='" + newValue + "', " + blenderPath + BlenderLauncher.getBlenderExecutableName() + " not found at this location";
            throw new InvalidFieldValueException(errorNotice);
        }
    }

    public static final void initialize() {
        BlenderLauncher.checkBlenderPath();
        BlenderLauncher.initializeConfigurationSwitches();
    }

    private static void initializeConfigurationSwitches() {
        modelConvert = true;
        modelExport = false;
        modelImport = false;
        conversionExtension = new String();
    }

    public static void main(String[] args) {
        BlenderLauncher.run(args);
    }

    public static void run(String singleStringArguments) {
        BlenderLauncher.run(singleStringArguments.split("(\\s)"));
    }

    public static void run(String[] args) {
        long sourceFileLength = 0L;
        String sourceFileName = "";
        String sourceFileNameRoot = "";
        boolean convertToFile = false;
        boolean createImageSnapshot = false;
        boolean loadProperties = false;
        boolean resetPath = false;
        Object resultFileName = "";
        Object resultFileNameRoot = "";
        String propertiesFileName = "";
        String propertiesFileNameRoot = "";
        DecimalFormat formatPrecision2 = new DecimalFormat("#0.00");
        BlenderLauncher.initializeConfigurationSwitches();
        if (args == null || args.length < 1) {
            System.out.println(USAGE);
            return;
        }
        for (int i = 0; i <= args.length - 1; ++i) {
            args[i] = args[i].trim();
            if (!args[i].startsWith("-")) {
                File sourceFile;
                if (modelConvert && !sourceFileName.isEmpty() && !((String)resultFileName).isEmpty()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.BlenderLauncher] too many file names found, source=\"" + sourceFileName + "\" and result \"" + (String)resultFileName + "\" prior to argument \"" + args[i] + "\". Check usage:");
                    System.out.println(USAGE);
                    return;
                }
                if (modelConvert && !sourceFileName.isEmpty()) {
                    resultFileName = args[i];
                    resultFileNameRoot = resultFileName;
                    if (((String)resultFileNameRoot).contains(".")) {
                        resultFileNameRoot = ((String)resultFileName).substring(0, ((String)resultFileNameRoot).lastIndexOf("."));
                    }
                    File resultFile = new File((String)resultFileName);
                    conversionExtension = ((String)resultFileName).substring(((String)resultFileName).lastIndexOf("."));
                    if (!conversionExtension.isEmpty()) continue;
                    System.out.println("[Error]  [org.web3d.x3d.jsail.BlenderLauncher] result file extension is needed for conversion but not found: " + (String)resultFileName);
                    System.out.println(USAGE);
                    return;
                }
                sourceFileName = args[i];
                sourceFileNameRoot = sourceFileName;
                if (sourceFileNameRoot.contains(".")) {
                    sourceFileNameRoot = sourceFileName.substring(0, sourceFileName.lastIndexOf("."));
                }
                if (!(sourceFile = new File(sourceFileName)).exists()) {
                    System.out.println("[Error]  [org.web3d.x3d.jsail.BlenderLauncher] file not found: " + sourceFileName);
                    return;
                }
                sourceFileLength = sourceFile.length();
                System.out.println("BlenderLauncher parameter: source file " + sourceFile.getName() + " filesize " + sourceFileLength + " bytes");
                continue;
            }
            if (args[i].equalsIgnoreCase("-properties") || args[i].equalsIgnoreCase("-propertiesFile")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    propertiesFileName = args[i + 1];
                    propertiesFileNameRoot = propertiesFileName.substring(0, propertiesFileName.lastIndexOf("."));
                    System.out.println("BlenderLauncher parameter: \"" + args[i] + "\" \"" + args[i + 1] + "\" for properties file name root " + propertiesFileNameRoot);
                    ++i;
                } else {
                    System.out.println("BlenderLauncher parameter: \"" + args[i] + "\" for properties file name root " + propertiesFileNameRoot);
                }
                loadProperties = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-BLENDER_PATH") || args[i].equalsIgnoreCase("-BLENDERPATH")) {
                if (args.length > i + 1 && args[i + 1] != null && !args[i + 1].isEmpty() && !args[i + 1].startsWith("-")) {
                    String newPath = args[i + 1];
                    System.out.println("parameters: \"" + args[i] + "\" \"" + newPath + "\" for setting Blender path");
                    BlenderLauncher.setBlenderPath(newPath);
                    BlenderLauncher.checkBlenderPath();
                    ++i;
                } else {
                    System.out.println("Error: parameter: \"" + args[i] + "\" missing new Blender path value");
                }
                resetPath = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-toImage") || args[i].equalsIgnoreCase("-screenshot")) {
                BlenderLauncher.initializeConfigurationSwitches();
                createImageSnapshot = true;
                System.out.println("BlenderLauncher parameter: \"" + args[i] + "\" for creating screenshot image of default viewpoint");
                continue;
            }
            if (args[i].equalsIgnoreCase("-convert")) {
                BlenderLauncher.initializeConfigurationSwitches();
                modelConvert = true;
                System.out.println("BlenderLauncher parameter: \"" + args[i] + "\" for conversion between formats");
                continue;
            }
            if (args[i].equalsIgnoreCase("-home") || args[i].equalsIgnoreCase("-page") || args[i].equalsIgnoreCase("-homepage") || args[i].equalsIgnoreCase("-website")) {
                BlenderLauncher.launchBlenderWebPage();
                return;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.out.println("Blender version: " + BlenderLauncher.getBlenderVersion());
                return;
            }
            if (args[i].toLowerCase().contains("-help")) {
                System.out.println(USAGE);
                System.out.println(BLENDER_URL);
                System.out.println("Blender help:");
                System.out.println(BlenderLauncher.getBlenderHelp());
                return;
            }
            System.out.println("[Error]  [org.web3d.x3d.jsail.BlenderLauncher] unrecognized BlenderLauncher option \"" + args[i] + "\"");
            System.out.println(USAGE);
            return;
        }
        if (loadProperties) {
            if (!propertiesFileName.isEmpty()) {
                ConfigurationProperties.setPropertiesFileName(propertiesFileName);
            }
            ConfigurationProperties.loadProperties();
        }
        if (!sourceFileName.isEmpty() && ((String)resultFileName).isEmpty()) {
            conversionExtension = createImageSnapshot ? ".png" : ".x3d";
            resultFileName = sourceFileNameRoot + conversionExtension;
            resultFileNameRoot = sourceFileNameRoot;
            File file = new File((String)resultFileName);
        }
        if (modelImport && !conversionExtension.equalsIgnoreCase(".x3d") || createImageSnapshot && !conversionExtension.equalsIgnoreCase(".png")) {
            System.out.println("[Warning]  [org.web3d.x3d.jsail.BlenderLauncher] resultFile " + (String)resultFileName + " has mismatched file extension \"" + conversionExtension + "\" for conversion");
        }
        if (!sourceFileName.isEmpty()) {
            if (createImageSnapshot) {
                BlenderLauncher.checkBlenderPath();
                if (BlenderX3dToPngPythonFile == null) {
                    BlenderX3dToPngPythonFile = X3D.getTempFileFromX3dJsailJar("python/blenderScripts", BLENDER_PYTHON_SCRIPT_X3D_TO_PNG);
                }
                StringBuilder toImageCommand = new StringBuilder();
                toImageCommand.append(BlenderLauncher.getBlenderPath()).append(BlenderLauncher.getBlenderExecutableName()).append(" ").append("--background").append(" ").append("--factory-startup").append(" ").append("--python").append(" ").append(BlenderX3dToPngPythonFile.getAbsolutePath()).append(" ").append("--").append(" ").append(sourceFileName);
                System.out.println("executeCommand(\"" + toImageCommand.toString() + "\")");
                String result = BlenderLauncher.executeCommand(toImageCommand.toString());
                System.out.println("executeCommand() response:");
                System.out.println(result);
                System.out.println("expected result: " + (String)resultFileName);
            } else if (modelConvert) {
                executeCommandSuccessful = BlenderLauncher.convertModel(sourceFileName, (String)resultFileName);
                System.out.println("load success: " + executeCommandSuccessful);
                return;
            }
        } else if (!loadProperties && !resetPath) {
            String message = "[Error] Source model file name is empty, therefore file loading not possible.";
            System.out.println(message);
            throw new InvalidExecutionContextException(message);
        }
    }

    public static void launchBlenderWebPage() {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(BLENDER_URL));
            }
        }
        catch (IOException | URISyntaxException e2) {
            System.out.println("launchBlenderWebPage failure: " + e2.getMessage());
        }
    }

    public static void checkBlenderPath() {
        Object checkedBlenderPath;
        String BLENDER_PATH_ENVIRONMENT_VARIABLE = System.getProperty("BLENDER_PATH");
        String OPERATING_SYSTEM_NAME = System.getProperty("os.name");
        if (BlenderLauncher.getBlenderPath() == null || BlenderLauncher.getBlenderPath().isEmpty()) {
            if (BLENDER_PATH_ENVIRONMENT_VARIABLE != null && !BLENDER_PATH_ENVIRONMENT_VARIABLE.isEmpty()) {
                BlenderLauncher.setBlenderPath(BLENDER_PATH_ENVIRONMENT_VARIABLE);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("windows")) {
                BlenderLauncher.setBlenderPath(BLENDER_PATH_DEFAULT_WINDOWS);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("mac")) {
                BlenderLauncher.setBlenderPath(BLENDER_PATH_DEFAULT_MACOS);
            } else if (OPERATING_SYSTEM_NAME.toLowerCase(Locale.ENGLISH).contains("linux")) {
                BlenderLauncher.setBlenderPath(BLENDER_PATH_DEFAULT_LINUX);
            }
        }
        if (!(((String)(checkedBlenderPath = BlenderLauncher.getBlenderPath())).isEmpty() || ((String)checkedBlenderPath).endsWith("\\") || ((String)checkedBlenderPath).endsWith("/"))) {
            checkedBlenderPath = (String)checkedBlenderPath + File.separator;
            BlenderLauncher.setBlenderPath((String)checkedBlenderPath);
        }
    }

    public static boolean wasPriorCommandSuccessful() {
        return executeCommandSuccessful;
    }

    protected static String executeCommand(String command) {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            String line;
            ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList(command.split("\\s")));
            ProcessBuilder processBuilder = new ProcessBuilder(commandArgs);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                outputBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            outputBuilder.append(e.getMessage()).append("\n").append(e.getCause()).append("\n");
            e.printStackTrace(System.err);
            throw new InvalidExecutionContextException(command);
        }
        return outputBuilder.toString();
    }

    public static boolean convertModel(String inputFileName, String outputFileName) {
        return BlenderLauncher.convertModel("", inputFileName, outputFileName);
    }

    public static boolean convertModel(String path, String inputFileName, String outputFileName) {
        return false;
    }

    public static X3D importModel(String path, String fileName) {
        return null;
    }

    public static X3D importSTL(String path, String fileName) {
        InputStream pythonScriptInputStream = BlenderLauncher.class.getResourceAsStream("/BlenderStlToX3d.py");
        if (pythonScriptInputStream == null) {
            String string = "*** File not found: BlenderStlToX3d.py";
        }
        return null;
    }

    public static String exportSTL(X3D modelToExport) {
        return "";
    }

    public static boolean exportSTLtoFile(X3D modelToExport, String path, String fileName) {
        String result = BlenderLauncher.exportSTL(modelToExport);
        return true;
    }

    public static String getBlenderAnalytics(X3D modelOfInterest) {
        return "";
    }

    public static MetadataSet getBlenderAnalyticsX3dMetadataSet(X3D modelOfInterest) {
        return null;
    }

    public static String getBlenderVersion() {
        BlenderLauncher.checkBlenderPath();
        StringBuilder blenderCommand = new StringBuilder();
        blenderCommand.append(BlenderLauncher.getBlenderPath()).append(BlenderLauncher.getBlenderExecutableName()).append(" --version");
        String result = BlenderLauncher.executeCommand(blenderCommand.toString());
        return result.substring(0, result.indexOf("\n")).trim();
    }

    public static String getBlenderHelp() {
        BlenderLauncher.checkBlenderPath();
        StringBuilder blenderCommand = new StringBuilder();
        blenderCommand.append(BlenderLauncher.getBlenderPath()).append(BlenderLauncher.getBlenderExecutableName()).append(" --help");
        String result = BlenderLauncher.executeCommand(blenderCommand.toString());
        return result.replaceAll("\r\n", "\n").replaceAll("\n\n", "\n").trim();
    }

    public static boolean hasBlender() {
        return BlenderLauncher.getBlenderVersion().startsWith("Blender");
    }

    static {
        modelConvert = false;
        modelExport = false;
        modelImport = false;
        conversionExtension = new String();
        executeCommandSuccessful = false;
    }
}

