import X3Dpackage


X3D0 = (X3Dpackage.X3D().setProfile("Immersive").setVersion("3.3")
      .setHead(X3Dpackage.head()
        .addComponent(X3Dpackage.component().setLevel(1).setName("Geospatial"))
        .addComponent(X3Dpackage.component().setLevel(2).setName("NURBS"))
        .addComponent(X3Dpackage.component().setLevel(2).setName("Core"))
        .addComponent(X3Dpackage.component().setLevel(1).setName("Navigation"))
        .addComponent(X3Dpackage.component().setLevel(1).setName("Text"))
        .addMeta(X3Dpackage.meta().setContent("X3dHeaderPrototypeSyntaxExamples.x3d").setName("title"))
        .addMeta(X3Dpackage.meta().setContent("X3D scene header and prototype syntax examples. This example header indicates that the content is XML encoded, follows the Interactive Profile and explicitly lists additional necessary components. The X3D header may also contain additional semantic information. Used for specification EXAMPLE excerpts in 19776:1 XML Encoding.").setName("description"))
        .addMeta(X3Dpackage.meta().setContent("14 October 2002").setName("created"))
        .addMeta(X3Dpackage.meta().setContent("7 May 2017").setName("modified"))
        .addMeta(X3Dpackage.meta().setContent("Don Brutzman").setName("creator"))
        .addMeta(X3Dpackage.meta().setContent("X3D encodings, ISO/IEC 19776-1.3, Part 1: XML encoding, 4.3 XML file syntax").setName("specificationSection"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/documents/specifications/19776-1/V3.3/Part01/concepts.html#XMLFileSyntax").setName("specificationUrl"))
        .addMeta(X3Dpackage.meta().setContent("http://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/X3dHeaderPrototypeSyntaxExamples.x3d").setName("identifier"))
        .addMeta(X3Dpackage.meta().setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit").setName("generator"))
        .addMeta(X3Dpackage.meta().setContent("../license.html").setName("license")))
      .setScene(X3Dpackage.Scene()
        .addChildren(X3Dpackage.ExternProtoDeclare().setName("ViewPositionOrientation").setUrl(["../../Savage/Tools/Authoring/ViewPositionOrientationPrototype.x3d#ViewPositionOrientation","https://savage.nps.edu/Savage/Tools/Authoring/ViewPositionOrientationPrototype.x3d#ViewPositionOrientation","../../Savage/Tools/Authoring/ViewPositionOrientationPrototype.wrl#ViewPositionOrientation","https://savage.nps.edu/Savage/Tools/Authoring/ViewPositionOrientationPrototype.wrl#ViewPositionOrientation"])
          .addField(X3Dpackage.field().setAccessType("inputOutput").setName("enabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("initializeOnly").setName("traceEnabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("inputOnly").setName("set_traceEnabled").setType("SFBool"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setName("position_changed").setType("SFVec3f"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setName("orientation_changed").setType("SFRotation"))
          .addField(X3Dpackage.field().setAccessType("outputOnly").setName("outputViewpointString").setType("MFString")))
        .addChildren(X3Dpackage.ProtoDeclare().setName("NewWorldInfoNode")
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.WorldInfo().setDEF("ExamplePrototypeBody"))))
        .addChildren(X3Dpackage.ProtoInstance().setName("NewWorldInfoNode"))
        .addChildren(X3Dpackage.ProtoDeclare().setName("EmissiveMaterial")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setAccessType("inputOutput").setName("onlyColor").setType("SFColor").setValue("1 0 0")))
          .setProtoBody(X3Dpackage.ProtoBody()
            # Override default diffuseColor value 0.8 0.8 0.8 

            .addChildren(X3Dpackage.Material().setDiffuseColor([0,0,0])
              # Connect emissiveColor field of current node to onlyColor field of parent ProtoDeclare. 

              .setIS(X3Dpackage.IS()
                .addConnect(X3Dpackage.connect().setNodeField("emissiveColor").setProtoField("onlyColor"))))))
        .addChildren(X3Dpackage.ProtoDeclare().setName("ShiftGroupUp2m")
          .setProtoInterface(X3Dpackage.ProtoInterface()
            .addField(X3Dpackage.field().setAccessType("inputOutput").setName("children").setType("MFNode")
              .addChildren(X3Dpackage.Group(setBboxSize = [2,2,2]).setDEF("DefaultNodeValue")
                # Authors need to override this node when creating the ProtoInstance fieldValue name=\"children\" 

                )))
          .setProtoBody(X3Dpackage.ProtoBody()
            .addChildren(X3Dpackage.Transform().setTranslation([0,2,0])
              .addChildren(X3Dpackage.Group()
                .setIS(X3Dpackage.IS()
                  .addConnect(X3Dpackage.connect().setNodeField("children").setProtoField("children")))))))
        .addChildren(X3Dpackage.ProtoInstance().setName("ShiftGroupUp2m"))
        # ==================== 

        .addChildren(X3Dpackage.Viewpoint().setDEF("ExampleSingleElement").setDescription("Hello syntax"))
        .addChildren(X3Dpackage.Group().setDEF("ExampleChildElement")
          .addChildren(X3Dpackage.Shape()
            .setGeometry(X3Dpackage.Box())
            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.Material().setDiffuseColor([0.6,0.4,0.2])))))
        .addChildren(X3Dpackage.Transform().setDEF("TransformExampleUSE").setRotation([0,1,0,0.78]).setTranslation([0,2.5,0])
          .addChildren(X3Dpackage.Group().setUSE("ExampleChildElement")))
        .addChildren(X3Dpackage.Collision()
          .setProxy(X3Dpackage.Shape()
            # note that Collision proxy Shape is not rendered 

            .setGeometry(X3Dpackage.Text().setString(["He said, \"Immel did it!\""]))
            # alternative: Text string='\"He said, \\&quot;Immel did it!\\&quot;\"' 

            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.Material())))
          .addChildren(X3Dpackage.Group().setUSE("ExampleChildElement")))
        .addChildren(X3Dpackage.Transform().setTranslation([0,-2.5,0])
          .addChildren(X3Dpackage.Shape()
            .setAppearance(X3Dpackage.Appearance()
              .setMaterial(X3Dpackage.ProtoInstance().setName("EmissiveMaterial")
                .addFieldValue(X3Dpackage.fieldValue().setName("onlyColor").setValue("0.2 0.6 0.6"))))
            .setGeometry(X3Dpackage.Text().setString(["X3D Header Prototype syntax examples","(view console for EXTERNPROTO output)"])
              .setFontStyle(X3Dpackage.FontStyle(setJustify = ["MIDDLE","MIDDLE"], setSize = 0.6)))))
        .addChildren(X3Dpackage.ProtoInstance().setName("ViewPositionOrientation")
          .addFieldValue(X3Dpackage.fieldValue().setName("enabled").setValue("true")))
        .addChildren(X3Dpackage.TimeSensor().setDEF("Clock").setCycleInterval(4).setLoop(True))
        .addChildren(X3Dpackage.OrientationInterpolator().setDEF("Spinner").setKey([0,0.5,1]).setKeyValue([0,1,0,0,0,1,0,3.14159,0,1,0,6.28318]))
        .addChildren(X3Dpackage.ROUTE().setFromField("fraction_changed").setFromNode("Clock").setToField("set_fraction").setToNode("Spinner"))
        .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("Spinner").setToField("rotation").setToNode("TransformExampleUSE"))
        .addChildren(X3Dpackage.Inline().setDEF("someInline").setUrl(["someUrl.x3d","http://www.web3d.org/x3d/content/examples/Basic/X3dSpecifications/someUrl.x3d"]))
        .addChildren(X3Dpackage.IMPORT().setAS("someInlineRoot").setImportedDEF("someName").setInlineDEF("someInline"))
        .addChildren(X3Dpackage.PositionInterpolator().setDEF("StayInPlace").setKey([0,1]).setKeyValue([0,0,0,0,0,0]))
        .addChildren(X3Dpackage.ROUTE().setFromField("fraction_changed").setFromNode("Clock").setToField("set_fraction").setToNode("StayInPlace"))
        .addChildren(X3Dpackage.ROUTE().setFromField("value_changed").setFromNode("StayInPlace").setToField("set_translation").setToNode("someInlineRoot"))))

