from X3Dpackage import *
X3D0 = X3D()
X3D0.setProfile("Immersive")
X3D0.setVersion("3.3")
head1 = head()
meta2 = meta()
meta2.setContent("ArchPrototype.x3d")
meta2.setName("title")
head1.addMeta(meta2)
meta3 = meta()
meta3.setContent("Create an arch. Can modify general parameters: clearSpanWidth, riseHeight, depth, topAbutmentHeight, pierWidth, pierHeight. See the reference file ArchModelingDiagrams.pdf to find further information. See also ArchPrototypeScript_more_readable.js.")
meta3.setName("description")
head1.addMeta(meta3)
meta4 = meta()
meta4.setContent("Possibility to create shapes related to arch: ArchHalf; IntradosOnly; ArchFilled; ArchHalfFilled; Lintel. See the reference file ArchModelingDiagrams.pdf to find further information.")
meta4.setName("description")
head1.addMeta(meta4)
meta5 = meta()
meta5.setContent("Michele Foti, Don Brutzman")
meta5.setName("creator")
head1.addMeta(meta5)
meta6 = meta()
meta6.setContent("15 December 2014")
meta6.setName("created")
head1.addMeta(meta6)
meta7 = meta()
meta7.setContent("27 November 2015")
meta7.setName("modified")
head1.addMeta(meta7)
meta8 = meta()
meta8.setContent("ArchModelingDiagrams.pdf")
meta8.setName("reference")
head1.addMeta(meta8)
meta9 = meta()
meta9.setContent("https://en.wikipedia.org/wiki/Arch")
meta9.setName("reference")
head1.addMeta(meta9)
meta10 = meta()
meta10.setContent("http://X3dGraphics.com/examples/X3dForAdvancedModeling/Buildings/ArchPrototype.x3d")
meta10.setName("identifier")
head1.addMeta(meta10)
meta11 = meta()
meta11.setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit")
meta11.setName("generator")
head1.addMeta(meta11)
meta12 = meta()
meta12.setContent("../license.html")
meta12.setName("license")
head1.addMeta(meta12)
X3D0.setHead(head1)
Scene13 = Scene()
ProtoDeclare14 = ProtoDeclare()
ProtoDeclare14.setAppinfo("Create an arch. Can modify general parameters: clearSpanWidth, riseHeight, depth, topAbutmentHeight, pierWidth, pierHeight. - Possibility to create shapes related to an arch: ArchHalf; IntradosOnly; ArchFilled; ArchHalfFilled; Lintel. See the reference file ArchModelingDiagrams.pdf to find further information. See also ArchPrototypeScript_more_readable.js.js.")
ProtoDeclare14.setName("ArchPrototype")
ProtoInterface15 = ProtoInterface()
# COLOR OF ARCH 
field16 = field()
field16.setAccessType("inputOutput")
field16.setAppinfo("color of arch")
field16.setName("diffuseColor")
field16.setType("SFColor")
field16.setValue("0.2 0.8 0.8")
ProtoInterface15.addField(field16)
field17 = field()
field17.setAccessType("inputOutput")
field17.setAppinfo("color of arch")
field17.setName("emissiveColor")
field17.setType("SFColor")
field17.setValue("0.2 0.8 0.8")
ProtoInterface15.addField(field17)
# INPUT PARAMETERS 
# General parameters: measures in meters 
field18 = field()
field18.setAccessType("initializeOnly")
field18.setAppinfo("clearSpanWidth: clearSpanWidth must be double of riseHeight to obtain an half circumference")
field18.setName("clearSpanWidth")
field18.setType("SFFloat")
field18.setValue("4")
ProtoInterface15.addField(field18)
field19 = field()
field19.setAccessType("initializeOnly")
field19.setAppinfo("riseHeight: riseHeight must be half of clearSpanWidth to obtain an half circumference")
field19.setName("riseHeight")
field19.setType("SFFloat")
field19.setValue("2")
ProtoInterface15.addField(field19)
field20 = field()
field20.setAccessType("initializeOnly")
field20.setAppinfo("depth")
field20.setName("depth")
field20.setType("SFFloat")
field20.setValue("3")
ProtoInterface15.addField(field20)
field21 = field()
field21.setAccessType("initializeOnly")
field21.setAppinfo("topAbutmentHeight:topAbutmentHeight=0 means no topAbutment")
field21.setName("topAbutmentHeight")
field21.setType("SFFloat")
field21.setValue("0.5")
ProtoInterface15.addField(field21)
field22 = field()
field22.setAccessType("initializeOnly")
field22.setAppinfo("pierWidth:pierWidtht=0 means no pierWidth")
field22.setName("pierWidth")
field22.setType("SFFloat")
field22.setValue("0.5")
ProtoInterface15.addField(field22)
field23 = field()
field23.setAccessType("initializeOnly")
field23.setAppinfo("pierHeight: pierHeight=0 means no pierHeight")
field23.setName("pierHeight")
field23.setType("SFFloat")
field23.setValue("1")
ProtoInterface15.addField(field23)
# Parameters to create to create shapes related to arch: put true to apply 
field24 = field()
field24.setAccessType("initializeOnly")
field24.setAppinfo("archHalf: can modify also clearSpanWidth, riseHeight, depth, pierWidth, pierHeight, topAbutmentHeight, archHalfExtensionWidth at purpose, clearSpanWidth measure refers to a full arc, consider clearSpanWidth/2 for the archHalf width")
field24.setName("archHalf")
field24.setType("SFBool")
field24.setValue("false")
ProtoInterface15.addField(field24)
field25 = field()
field25.setAccessType("initializeOnly")
field25.setAppinfo("archHalfExtensionWidth: measure in meters, use only if archHalf=true, it is the width of the etension of the abutment of the archHalf. See the reference file ArchModelingDiagrams.pdf to find further information.")
field25.setName("archHalfExtensionWidth")
field25.setType("SFFloat")
field25.setValue("0")
ProtoInterface15.addField(field25)
field26 = field()
field26.setAccessType("initializeOnly")
field26.setAppinfo("onlyIntrados: note it is a flat curved surface, can modify also clearSpanWidth, riseHeight, depth at purpose, if needed apply archHalf=true.")
field26.setName("onlyIntrados")
field26.setType("SFBool")
field26.setValue("false")
ProtoInterface15.addField(field26)
field27 = field()
field27.setAccessType("initializeOnly")
field27.setAppinfo("archFilled: note it is an half cylinder, can modify also clearSpanWidth, riseHeight, depth at purpose.")
field27.setName("archFilled")
field27.setType("SFBool")
field27.setValue("false")
ProtoInterface15.addField(field27)
field28 = field()
field28.setAccessType("initializeOnly")
field28.setAppinfo("archHalfFilled: note it is a quarter cylinder, can modify also clearSpanWidth, riseHeight, depth at purpose, clearSpanWidth measure refers to a full arc, consider clearSpanWidth/2 for the archHalfFilled width.")
field28.setName("archHalfFilled")
field28.setType("SFBool")
field28.setValue("false")
ProtoInterface15.addField(field28)
field29 = field()
field29.setAccessType("initializeOnly")
field29.setAppinfo("lintel: no arc is rendered, but a lintel: topAbutmentHeight on pierHeight, total height is pierHeight + topAbutmentHeight, if needed apply archHalf=true.")
field29.setName("lintel")
field29.setType("SFBool")
field29.setValue("false")
ProtoInterface15.addField(field29)
ProtoDeclare14.setProtoInterface(ProtoInterface15)
ProtoBody30 = ProtoBody()
# First node determines node type of this prototype 
# IndexedFaceset creates arch 
Transform31 = Transform()
Transform31.setDEF("ArchTransform")
Shape32 = Shape()
Shape32.setDEF("Arch")
# note that convex='false' (meaning concave geometry) is crucial for this IFS of a geometric chord to render properly 
IndexedFaceSet33 = IndexedFaceSet(convex = False, creaseAngle = 0, solid = False)
IndexedFaceSet33.setDEF("ArchIndex")
Coordinate34 = Coordinate()
Coordinate34.setDEF("ArchChord")
IndexedFaceSet33.setCoord(Coordinate34)
Shape32.setGeometry(IndexedFaceSet33)
Appearance35 = Appearance()
Material36 = Material()
Material36.setDEF("MaterialNode")
IS37 = IS()
connect38 = connect()
connect38.setNodeField("emissiveColor")
connect38.setProtoField("emissiveColor")
IS37.addConnect(connect38)
connect39 = connect()
connect39.setNodeField("diffuseColor")
connect39.setProtoField("diffuseColor")
IS37.addConnect(connect39)
Material36.IS = IS37
Appearance35.setMaterial(Material36)
Shape32.setAppearance(Appearance35)
Transform31.addChildren(Shape32)
ProtoBody30.addChildren(Transform31)
# Subsequent nodes do not render, but still must be a valid X3D subgraph 
# This embedded Script provides the X3D author with additional visibility and control over prototype inputs and outputs 
Script40 = Script()
Script40.setDEF("ArchPrototypeScript")
Script40.setUrl(["../node/ArchPrototypeScript.js"])
# INPUT PARAMETERS 
# General parameters 
# Parameters to create to create shapes related to arch: put true to apply 
# OUTPUT PARAMETERS 
field41 = field()
field41.setAccessType("initializeOnly")
field41.setAppinfo("user or default input for clearSpanWidth parameter")
field41.setName("clearSpanWidth")
field41.setType("SFFloat")
Script40.addField(field41)
field42 = field()
field42.setAccessType("initializeOnly")
field42.setAppinfo("user or default input for riseHeight parameter")
field42.setName("riseHeight")
field42.setType("SFFloat")
Script40.addField(field42)
field43 = field()
field43.setAccessType("initializeOnly")
field43.setAppinfo("user or default input for depth parameter")
field43.setName("depth")
field43.setType("SFFloat")
Script40.addField(field43)
field44 = field()
field44.setAccessType("initializeOnly")
field44.setAppinfo("user or default input for topAbutmentHeight parameter")
field44.setName("topAbutmentHeight")
field44.setType("SFFloat")
Script40.addField(field44)
field45 = field()
field45.setAccessType("initializeOnly")
field45.setAppinfo("user or default input for pierWidth parameter")
field45.setName("pierWidth")
field45.setType("SFFloat")
Script40.addField(field45)
field46 = field()
field46.setAccessType("initializeOnly")
field46.setAppinfo("user or default input for pierHeight parameter")
field46.setName("pierHeight")
field46.setType("SFFloat")
Script40.addField(field46)
field47 = field()
field47.setAccessType("initializeOnly")
field47.setAppinfo("user or default input for archHalf parameter")
field47.setName("archHalf")
field47.setType("SFBool")
Script40.addField(field47)
field48 = field()
field48.setAccessType("initializeOnly")
field48.setAppinfo("user or default input for archHalfExtensionWidth parameter")
field48.setName("archHalfExtensionWidth")
field48.setType("SFFloat")
Script40.addField(field48)
field49 = field()
field49.setAccessType("initializeOnly")
field49.setAppinfo("user or default input for onlyIntrados parameter")
field49.setName("onlyIntrados")
field49.setType("SFBool")
Script40.addField(field49)
field50 = field()
field50.setAccessType("initializeOnly")
field50.setAppinfo("user or default input for archFilled parameter")
field50.setName("archFilled")
field50.setType("SFBool")
Script40.addField(field50)
field51 = field()
field51.setAccessType("initializeOnly")
field51.setAppinfo("user or default input for archHalfFilled parameter")
field51.setName("archHalfFilled")
field51.setType("SFBool")
Script40.addField(field51)
field52 = field()
field52.setAccessType("initializeOnly")
field52.setAppinfo("user or default input for lintel parameter")
field52.setName("lintel")
field52.setType("SFBool")
Script40.addField(field52)
field53 = field()
field53.setAccessType("outputOnly")
field53.setAppinfo("computedScale: modify scale field - NOTE it is not used to modify the whole arch, but to modify clearSpanWidth, riseHeight, depth. It does not affect topAbutmentHeight, pierWidth, pierHeight, archHalfExtensionWidth")
field53.setName("computedScale")
field53.setType("SFVec3f")
Script40.addField(field53)
field54 = field()
field54.setAccessType("outputOnly")
field54.setAppinfo("send computed points to the Coordinate node")
field54.setName("pointOut")
field54.setType("MFVec3f")
Script40.addField(field54)
field55 = field()
field55.setAccessType("outputOnly")
field55.setAppinfo("send computed indices to the IndexedFaceSet node")
field55.setName("indexOut")
field55.setType("MFInt32")
Script40.addField(field55)
IS56 = IS()
connect57 = connect()
connect57.setNodeField("clearSpanWidth")
connect57.setProtoField("clearSpanWidth")
IS56.addConnect(connect57)
connect58 = connect()
connect58.setNodeField("riseHeight")
connect58.setProtoField("riseHeight")
IS56.addConnect(connect58)
connect59 = connect()
connect59.setNodeField("depth")
connect59.setProtoField("depth")
IS56.addConnect(connect59)
connect60 = connect()
connect60.setNodeField("pierWidth")
connect60.setProtoField("pierWidth")
IS56.addConnect(connect60)
connect61 = connect()
connect61.setNodeField("topAbutmentHeight")
connect61.setProtoField("topAbutmentHeight")
IS56.addConnect(connect61)
connect62 = connect()
connect62.setNodeField("pierHeight")
connect62.setProtoField("pierHeight")
IS56.addConnect(connect62)
connect63 = connect()
connect63.setNodeField("archHalf")
connect63.setProtoField("archHalf")
IS56.addConnect(connect63)
connect64 = connect()
connect64.setNodeField("archHalfExtensionWidth")
connect64.setProtoField("archHalfExtensionWidth")
IS56.addConnect(connect64)
connect65 = connect()
connect65.setNodeField("onlyIntrados")
connect65.setProtoField("onlyIntrados")
IS56.addConnect(connect65)
connect66 = connect()
connect66.setNodeField("archFilled")
connect66.setProtoField("archFilled")
IS56.addConnect(connect66)
connect67 = connect()
connect67.setNodeField("archHalfFilled")
connect67.setProtoField("archHalfFilled")
IS56.addConnect(connect67)
connect68 = connect()
connect68.setNodeField("lintel")
connect68.setProtoField("lintel")
IS56.addConnect(connect68)
Script40.IS = IS56
ProtoBody30.addChildren(Script40)
ROUTE69 = ROUTE()
ROUTE69.setFromField("computedScale")
ROUTE69.setFromNode("ArchPrototypeScript")
ROUTE69.setToField("scale")
ROUTE69.setToNode("ArchTransform")
ProtoBody30.addChildren(ROUTE69)
ROUTE70 = ROUTE()
ROUTE70.setFromField("pointOut")
ROUTE70.setFromNode("ArchPrototypeScript")
ROUTE70.setToField("point")
ROUTE70.setToNode("ArchChord")
ProtoBody30.addChildren(ROUTE70)
ROUTE71 = ROUTE()
ROUTE71.setFromField("indexOut")
ROUTE71.setFromNode("ArchPrototypeScript")
ROUTE71.setToField("set_coordIndex")
ROUTE71.setToNode("ArchIndex")
ProtoBody30.addChildren(ROUTE71)
ProtoDeclare14.setProtoBody(ProtoBody30)
Scene13.addChildren(ProtoDeclare14)
ProtoInstance72 = ProtoInstance()
ProtoInstance72.setDEF("ArchInstance")
ProtoInstance72.setName("ArchPrototype")
fieldValue73 = fieldValue()
fieldValue73.setName("diffuseColor")
fieldValue73.setValue("0.5 0.3 0.6")
ProtoInstance72.addFieldValue(fieldValue73)
fieldValue74 = fieldValue()
fieldValue74.setName("emissiveColor")
fieldValue74.setValue("0.5 0.3 0.6")
ProtoInstance72.addFieldValue(fieldValue74)
fieldValue75 = fieldValue()
fieldValue75.setName("clearSpanWidth")
fieldValue75.setValue("5")
ProtoInstance72.addFieldValue(fieldValue75)
fieldValue76 = fieldValue()
fieldValue76.setName("riseHeight")
fieldValue76.setValue("2.5")
ProtoInstance72.addFieldValue(fieldValue76)
fieldValue77 = fieldValue()
fieldValue77.setName("depth")
fieldValue77.setValue("2")
ProtoInstance72.addFieldValue(fieldValue77)
fieldValue78 = fieldValue()
fieldValue78.setName("topAbutmentHeight")
fieldValue78.setValue("0.6")
ProtoInstance72.addFieldValue(fieldValue78)
fieldValue79 = fieldValue()
fieldValue79.setName("pierWidth")
fieldValue79.setValue("1")
ProtoInstance72.addFieldValue(fieldValue79)
fieldValue80 = fieldValue()
fieldValue80.setName("pierHeight")
fieldValue80.setValue("2")
ProtoInstance72.addFieldValue(fieldValue80)
Scene13.addChildren(ProtoInstance72)
# Add any ROUTEs here that connect ProtoInstance to/from prior nodes in Scene (and outside of ProtoDeclare) 
Inline81 = Inline()
Inline81.setDEF("CoordinateAxes")
Inline81.setUrl(["../data/CoordinateAxes.x3d"])
Scene13.addChildren(Inline81)
X3D0.setScene(Scene13)
