import java.util.*;
import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc annotations follow, see below for source.
/**
 * <p> Printable cleat clamp from MakerBot Thingiverse model archive, converted to X3D. </p>
 <p> Related links: <a href="../../../AdditiveManufacturing/CleatClamp.java">CleatClamp.java</a> source, <a href="../../../AdditiveManufacturing/CleatClampIndex.html" target="_top">CleatClamp catalog page</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../AdditiveManufacturing/CleatClamp.x3d">CleatClamp.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Printable cleat clamp from MakerBot Thingiverse model archive, converted to X3D. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 31 August 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 18 July 2015 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 1 November 2018 </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> Do not use for climbing or yachting. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Moritz the Maker, mx5, <a href="http://www.thingiverse.com/mx5" target="_blank">http://www.thingiverse.com/mx5</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> Printable cleat, <a href="http://www.thingiverse.com/thing:143653" target="_blank">http://www.thingiverse.com/thing:143653</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> Creative Commons - Attribution - Share Alike <a href="http://creativecommons.org/licenses/by-sa/3.0" target="_blank">http://creativecommons.org/licenses/by-sa/3.0</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Converted to X3D by Okino PolyTrans <a href="http://www.okino.com" target="_blank">http://www.okino.com</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../AdditiveManufacturing/CleatClamp.x3d._VP_default_CoordinateAxes.png">CleatClamp.x3d._VP_default_CoordinateAxes.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../AdditiveManufacturing/CleatClampNuGrafRendering.png">CleatClampNuGrafRendering.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../AdditiveManufacturing/CleatClampMeshLabRendering.png">CleatClampMeshLabRendering.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> cleat_clamp.scad </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> cleat_clamp.stl </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> Image </i> </td>
			<td> <a href="../../../AdditiveManufacturing/CleatClampPrinted.png">CleatClampPrinted.png</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="http://x3dGraphics.com/examples/X3dForAdvancedModeling/AdditiveManufacturing/CleatClamp.x3d" target="_blank">http://x3dGraphics.com/examples/X3dForAdvancedModeling/AdditiveManufacturing/CleatClamp.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../AdditiveManufacturing/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet to create Java source code from an <code>.x3d</code> model.
	</p>

	* @author Moritz the Maker, mx5, http://www.thingiverse.com/mx5
 */

public class CleatClamp
{
	/** Default constructor to create this object. */
	public CleatClamp ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
  x3dModel = new X3DObject().setProfile(X3DObject.PROFILE_IMMERSIVE).setVersion(X3DObject.VERSION_3_3)
  .setHead(new headObject()
    .addMeta(new metaObject().setName(metaObject.NAME_TITLE      ).setContent("CleatClamp.x3d"))
    .addMeta(new metaObject().setName(metaObject.NAME_DESCRIPTION).setContent("Printable cleat clamp from MakerBot Thingiverse model archive, converted to X3D."))
    .addMeta(new metaObject().setName(metaObject.NAME_CREATED    ).setContent("31 August 2013"))
    .addMeta(new metaObject().setName(metaObject.NAME_TRANSLATED ).setContent("18 July 2015"))
    .addMeta(new metaObject().setName(metaObject.NAME_MODIFIED   ).setContent("1 November 2018"))
    .addMeta(new metaObject().setName(metaObject.NAME_WARNING    ).setContent("Do not use for climbing or yachting."))
    .addMeta(new metaObject().setName(metaObject.NAME_CREATOR    ).setContent("Moritz the Maker, mx5, http://www.thingiverse.com/mx5"))
    .addMeta(new metaObject().setName(metaObject.NAME_REFERENCE  ).setContent("Printable cleat, http://www.thingiverse.com/thing:143653"))
    .addMeta(new metaObject().setName(metaObject.NAME_LICENSE    ).setContent("Creative Commons - Attribution - Share Alike http://creativecommons.org/licenses/by-sa/3.0"))
    .addMeta(new metaObject().setName(metaObject.NAME_GENERATOR  ).setContent("Converted to X3D by Okino PolyTrans http://www.okino.com"))
    .addMeta(new metaObject().setName(metaObject.NAME_IMAGE      ).setContent("CleatClamp.x3d._VP_default_CoordinateAxes.png"))
    .addMeta(new metaObject().setName(metaObject.NAME_IMAGE      ).setContent("CleatClampNuGrafRendering.png"))
    .addMeta(new metaObject().setName(metaObject.NAME_IMAGE      ).setContent("CleatClampMeshLabRendering.png"))
    .addMeta(new metaObject().setName(metaObject.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new metaObject().setName(metaObject.NAME_REFERENCE  ).setContent("cleat_clamp.scad"))
    .addMeta(new metaObject().setName(metaObject.NAME_REFERENCE  ).setContent("cleat_clamp.stl"))
    .addMeta(new metaObject().setName(metaObject.NAME_IMAGE      ).setContent("CleatClampPrinted.png"))
    .addMeta(new metaObject().setName(metaObject.NAME_IDENTIFIER ).setContent("http://x3dGraphics.com/examples/X3dForAdvancedModeling/AdditiveManufacturing/CleatClamp.x3d"))
    .addMeta(new metaObject().setName(metaObject.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new metaObject().setName(metaObject.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new SceneObject()
    .addComments(" <WorldInfo info='\"Gravity: off\"'/> <NavigationInfo headlight='false'/> ")
    .addComments(" Current light source name = defaultambient ")
    .addComments(" Ambient light source <PointLight ambientIntensity='1' color='1 1 1' on='true'/> ")
    .addChild(new SwitchObject().setWhichChoice(-1)
      .addChild(new InlineObject("CoordinateAxes").setUrl(new String[] {"../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.x3d","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.x3d","../../X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","http://X3dGraphics.com/examples/X3dForWebAuthors/Chapter03Grouping/CoordinateAxes.wrl","https://savage.nps.edu/Savage/Tools/Authoring/CoordinateAxes.wrl"})))
    .addChild(new ViewpointObject("defaultCamera").setDescription("default").setPosition(0.0f,0.0f,2.0f))
    .addChild(new TransformObject("ScaleCentimetersToMeters").setRotation(1.0f,0.0f,0.0f,1.570796f).setScale(0.01f,0.01f,0.01f)
      .addChild(new ViewpointObject("obliqueCamera").setDescription("oblique").setFieldOfView(0.643501f).setOrientation(-0.50352f,0.83843f,0.20857f,0.91773f).setPosition(102.672f,68.4039f,102.672f))
      .addChild(new TransformObject("cleat_clamp")
        .addChild(new TransformObject("RaiseBaseToZeroHeight").setTranslation(0.0f,22.0f,0.0f)
          .addChild(new TransformObject("openscad_model").setTranslation(0.0f,-8.6f,0.0f)
            .addChild(new TransformObject().setTranslation(-0.0f,8.6f,-0.0f)
              .addChild(new GroupObject("openscad_model_geometry")
                .addChild(new ShapeObject()
                  .setAppearance(new AppearanceObject()
                    .setMaterial(new MaterialObject("default").setAmbientIntensity(0.3f).setDiffuseColor(0.4f,0.4f,0.4f).setShininess(0.25f).setSpecularColor(0.7f,0.7f,0.7f)))
                  .setGeometry(new IndexedFaceSetObject().setSolid(false).setCoordIndex(getIndexedFaceSet_10_28_coordIndex()).setNormalIndex(getIndexedFaceSet_10_28_normalIndex())
                    .setCoord(new CoordinateObject().setPoint(getCoordinate_11_28_point()))
                    .setNormal(new NormalObject().setVector(getNormal_11_29_vector())))))))))));
    }
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_10_28_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,2,3,4,-1,1,5,3,-1,3,5,6,-1,5,1,0,-1,7,0,8,-1,0,2,8,-1,9,5,0,-1,9,0,10,-1,10,0,11,-1,11,0,7,-1,2,4,12,-1,12,4,13,-1,8,2,12,-1,14,4,15,-1,4,3,15,-1,13,4,14,-1,15,3,6,-1,15,6,16,-1,16,6,17,-1,5,18,6,-1,6,18,17,-1,18,5,9,-1,19,7,20,-1,7,8,20,-1,21,11,7,-1,21,7,22,-1,22,7,19,-1,20,8,23,-1,23,8,12,-1,24,9,25,-1,25,9,10,-1,18,9,24,-1,25,10,26,-1,26,10,27,-1,27,10,21,-1,10,11,21,-1,23,12,28,-1,28,12,29,-1,12,13,29,-1,29,13,30,-1,31,13,32,-1,13,14,32,-1,30,13,31,-1,14,15,33,-1,32,14,34,-1,34,14,33,-1,33,15,35,-1,35,15,36,-1,36,15,16,-1,36,16,37,-1,37,16,38,-1,38,16,17,-1,39,17,40,-1,18,41,17,-1,17,41,40,-1,38,17,39,-1,41,18,42,-1,42,18,24,-1,43,22,19,-1,43,19,44,-1,44,19,45,-1,45,19,46,-1,19,20,46,-1,46,20,47,-1,47,20,28,-1,20,23,28,-1,48,21,43,-1,43,21,22,-1,27,21,49,-1,49,21,48,-1,42,24,25,-1,42,25,50,-1,50,25,51,-1,51,25,26,-1,51,26,52,-1,52,26,53,-1,53,26,49,-1,26,27,49,-1,47,28,54,-1,54,28,55,-1,28,29,55,-1,55,29,56,-1,29,30,56,-1,56,30,57,-1,57,30,58,-1,58,30,31,-1,58,31,59,-1,59,31,60,-1,31,34,60,-1,31,32,34,-1,34,33,61,-1,61,33,62,-1,62,33,63,-1,33,35,63,-1,60,34,64,-1,64,34,61,-1,63,35,36,-1,63,36,65,-1,65,36,66,-1,66,36,37,-1,67,37,68,-1,68,37,39,-1,37,38,39,-1,66,37,67,-1,39,40,69,-1,68,39,70,-1,70,39,69,-1,69,40,71,-1,41,72,40,-1,40,72,71,-1,72,41,73,-1,73,41,42,-1,73,42,74,-1,74,42,50,-1,75,48,43,-1,75,43,76,-1,76,43,44,-1,76,44,45,-1,45,46,77,-1,76,45,78,-1,78,45,79,-1,79,45,80,-1,45,77,80,-1,77,46,54,-1,46,47,54,-1,49,48,81,-1,81,48,82,-1,82,48,75,-1,53,49,83,-1,83,49,81,-1,74,50,51,-1,84,51,52,-1,74,51,84,-1,85,84,52,-1,85,52,86,-1,86,52,87,-1,87,52,83,-1,52,53,83,-1,77,54,88,-1,88,54,89,-1,54,55,89,-1,89,55,90,-1,90,55,91,-1,55,56,91,-1,56,57,91,-1,91,57,92,-1,92,57,58,-1,92,58,93,-1,93,58,94,-1,94,58,59,-1,94,59,95,-1,95,59,96,-1,59,64,96,-1,59,60,64,-1,97,61,98,-1,61,62,98,-1,64,61,99,-1,99,61,97,-1,62,63,98,-1,98,63,100,-1,100,63,101,-1,101,63,65,-1,96,64,99,-1,101,65,66,-1,101,66,102,-1,102,66,103,-1,103,66,67,-1,67,68,70,-1,103,67,104,-1,104,67,70,-1,70,69,105,-1,105,69,106,-1,106,69,107,-1,69,71,107,-1,104,70,108,-1,108,70,105,-1,72,109,71,-1,71,109,107,-1,109,72,73,-1,109,73,110,-1,110,73,111,-1,111,73,74,-1,111,74,112,-1,112,74,84,-1,113,75,114,-1,114,75,115,-1,115,75,76,-1,113,82,75,-1,115,76,116,-1,116,76,78,-1,80,77,88,-1,116,78,79,-1,116,79,117,-1,117,79,118,-1,118,79,119,-1,79,80,119,-1,120,80,88,-1,119,80,120,-1,121,81,122,-1,122,81,113,-1,81,82,113,-1,83,81,121,-1,87,83,123,-1,123,83,121,-1,112,84,85,-1,112,85,124,-1,124,85,125,-1,125,85,86,-1,125,86,126,-1,126,86,127,-1,127,86,123,-1,86,87,123,-1,120,88,128,-1,128,88,129,-1,129,88,130,-1,88,89,130,-1,130,89,131,-1,89,90,131,-1,90,91,131,-1,131,91,132,-1,91,92,132,-1,132,92,133,-1,133,92,134,-1,134,92,93,-1,134,93,94,-1,134,94,135,-1,135,94,95,-1,135,95,136,-1,136,95,137,-1,137,95,138,-1,95,139,138,-1,95,96,139,-1,139,96,99,-1,99,97,140,-1,97,98,140,-1,140,98,141,-1,98,100,141,-1,139,99,142,-1,142,99,143,-1,143,99,140,-1,144,100,101,-1,141,100,145,-1,145,100,144,-1,144,101,146,-1,146,101,102,-1,146,102,103,-1,146,103,147,-1,147,103,148,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_2()
		{
			int[] value = {148,103,149,-1,103,104,149,-1,149,104,108,-1,108,105,150,-1,150,105,151,-1,105,106,151,-1,106,107,151,-1,151,107,152,-1,109,153,107,-1,107,153,152,-1,154,149,108,-1,154,108,155,-1,155,108,156,-1,156,108,150,-1,153,109,157,-1,157,109,110,-1,157,110,111,-1,157,111,158,-1,158,111,112,-1,158,112,159,-1,159,112,160,-1,160,112,124,-1,122,113,161,-1,161,113,114,-1,161,114,162,-1,162,114,115,-1,163,115,116,-1,162,115,164,-1,164,115,163,-1,163,116,117,-1,163,117,165,-1,165,117,118,-1,118,119,166,-1,165,118,167,-1,167,118,168,-1,168,118,169,-1,118,166,169,-1,166,119,128,-1,119,120,128,-1,123,121,170,-1,170,121,171,-1,171,121,172,-1,121,122,172,-1,172,122,161,-1,127,123,170,-1,160,124,125,-1,160,125,173,-1,173,125,126,-1,174,173,126,-1,174,126,175,-1,175,126,176,-1,176,126,177,-1,126,127,177,-1,177,127,170,-1,128,129,178,-1,166,128,178,-1,178,129,179,-1,129,130,179,-1,130,131,180,-1,179,130,181,-1,181,130,180,-1,131,132,182,-1,180,131,182,-1,132,133,182,-1,182,133,183,-1,183,133,134,-1,184,134,135,-1,183,134,184,-1,184,135,185,-1,185,135,186,-1,186,135,136,-1,186,136,187,-1,187,136,137,-1,137,138,188,-1,187,137,189,-1,137,188,189,-1,138,139,188,-1,188,139,142,-1,143,140,190,-1,190,140,191,-1,140,141,191,-1,191,141,192,-1,192,141,193,-1,141,145,193,-1,142,143,190,-1,188,142,194,-1,194,142,195,-1,195,142,190,-1,193,145,144,-1,193,144,196,-1,196,144,197,-1,197,144,146,-1,197,146,198,-1,198,146,147,-1,198,147,148,-1,148,149,199,-1,198,148,200,-1,200,148,201,-1,201,148,199,-1,199,149,154,-1,202,150,203,-1,150,151,203,-1,156,150,204,-1,204,150,202,-1,203,151,205,-1,151,152,205,-1,152,153,206,-1,205,152,206,-1,206,153,157,-1,199,154,155,-1,207,199,155,-1,207,155,208,-1,155,156,208,-1,208,156,204,-1,206,157,209,-1,209,157,158,-1,210,158,211,-1,211,158,159,-1,209,158,210,-1,212,159,160,-1,211,159,212,-1,212,160,173,-1,172,161,213,-1,213,161,214,-1,214,161,215,-1,215,161,162,-1,215,162,164,-1,216,164,163,-1,216,163,217,-1,217,163,218,-1,218,163,165,-1,215,164,216,-1,218,165,219,-1,219,165,167,-1,169,166,220,-1,220,166,221,-1,221,166,178,-1,222,167,168,-1,219,167,222,-1,168,169,223,-1,168,224,225,-1,168,225,226,-1,168,226,222,-1,226,227,222,-1,224,168,223,-1,223,169,220,-1,177,170,228,-1,228,170,229,-1,229,170,230,-1,170,171,230,-1,230,171,213,-1,171,172,213,-1,231,173,232,-1,232,173,174,-1,212,173,231,-1,233,174,175,-1,232,174,233,-1,233,175,234,-1,175,235,236,-1,175,236,237,-1,175,237,234,-1,237,238,234,-1,175,176,235,-1,235,176,239,-1,176,177,239,-1,239,177,228,-1,221,178,240,-1,240,178,241,-1,241,178,242,-1,178,179,242,-1,242,179,243,-1,179,181,243,-1,181,180,243,-1,243,180,244,-1,244,180,245,-1,180,182,245,-1,182,183,245,-1,245,183,246,-1,246,183,184,-1,246,184,247,-1,247,184,248,-1,248,184,185,-1,248,185,186,-1,248,186,249,-1,249,186,187,-1,250,187,251,-1,187,189,251,-1,249,187,252,-1,252,187,250,-1,189,188,194,-1,251,189,253,-1,253,189,254,-1,254,189,194,-1,195,190,255,-1,190,191,255,-1,255,191,256,-1,256,191,257,-1,191,192,257,-1,257,192,258,-1,192,193,258,-1,258,193,196,-1,254,194,259,-1,259,194,260,-1,260,194,261,-1,194,195,261,-1,261,195,255,-1,258,196,262,-1,262,196,197,-1,263,197,264,-1,264,197,198,-1,262,197,263,-1,264,198,200,-1,201,199,207,-1,265,200,201,-1,264,200,265,-1,265,201,266,-1,266,201,267,-1,267,201,268,-1,201,207,268,-1,204,202,269,-1,202,203,269,-1,269,203,270,-1,270,203,271,-1,203,205,271,-1,208,204,272,-1,272,204,269,-1,205,206,273,-1,271,205,273,-1,273,206,209,-1,274,207,275,-1,275,207,208,-1,268,207,274,-1,275,208,276,-1,276,208,277,-1,277,208,272,-1,273,209,278,-1,278,209,279,-1,279,209,210,-1,279,210,211,-1,279,211,280,-1,280,211,212,-1,280,212,281,-1,281,212,282,-1,282,212,231,-1,213,214,283,-1,230,213,283,-1,283,214,215,-1,283,215,216,-1,216,284,285,-1,216,285,286,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_3()
		{
			int[] value = {216,286,283,-1,284,216,217,-1,284,217,218,-1,218,222,287,-1,218,287,288,-1,218,288,289,-1,218,289,284,-1,290,284,289,-1,222,218,219,-1,223,220,224,-1,220,291,292,-1,220,292,293,-1,220,293,294,-1,220,294,224,-1,295,224,294,-1,220,221,291,-1,291,221,240,-1,227,287,222,-1,296,288,297,-1,297,288,287,-1,297,287,227,-1,227,226,297,-1,297,226,298,-1,298,226,225,-1,298,225,295,-1,295,294,298,-1,295,225,224,-1,239,228,235,-1,228,299,300,-1,228,300,301,-1,228,301,302,-1,228,302,235,-1,303,235,302,-1,228,229,299,-1,229,230,299,-1,230,283,304,-1,230,304,299,-1,304,305,299,-1,306,231,232,-1,282,231,306,-1,232,234,307,-1,232,307,308,-1,232,308,309,-1,232,309,306,-1,310,306,309,-1,234,232,233,-1,234,238,307,-1,237,311,312,-1,238,237,312,-1,308,307,312,-1,307,238,312,-1,313,311,302,-1,236,311,237,-1,303,311,236,-1,302,311,303,-1,235,303,236,-1,240,241,291,-1,241,314,315,-1,241,315,291,-1,315,316,291,-1,241,242,314,-1,314,242,317,-1,317,242,318,-1,242,243,318,-1,318,243,319,-1,243,244,319,-1,244,245,319,-1,319,245,320,-1,245,246,320,-1,320,246,321,-1,321,246,322,-1,322,246,247,-1,322,247,248,-1,322,248,323,-1,323,248,249,-1,323,249,324,-1,324,249,325,-1,325,249,252,-1,325,252,250,-1,325,250,326,-1,326,250,327,-1,250,253,327,-1,250,251,253,-1,253,254,328,-1,327,253,328,-1,328,254,259,-1,261,255,329,-1,329,255,330,-1,330,255,331,-1,255,256,331,-1,331,256,332,-1,256,257,332,-1,257,258,332,-1,332,258,333,-1,333,258,334,-1,334,258,262,-1,335,259,336,-1,259,260,336,-1,328,259,335,-1,260,261,336,-1,336,261,329,-1,334,262,263,-1,337,263,264,-1,334,263,337,-1,338,264,339,-1,339,264,265,-1,337,264,338,-1,339,265,340,-1,340,265,266,-1,340,266,267,-1,340,267,341,-1,341,267,342,-1,267,268,342,-1,342,268,274,-1,272,269,343,-1,343,269,344,-1,269,270,344,-1,270,271,344,-1,344,271,345,-1,271,273,346,-1,345,271,346,-1,277,272,347,-1,347,272,348,-1,348,272,343,-1,346,273,349,-1,349,273,278,-1,342,274,350,-1,350,274,276,-1,274,275,276,-1,350,276,351,-1,351,276,347,-1,276,277,347,-1,349,278,279,-1,349,279,352,-1,352,279,280,-1,352,280,353,-1,353,280,354,-1,354,280,281,-1,281,306,355,-1,281,355,356,-1,281,356,354,-1,306,281,282,-1,357,283,358,-1,358,283,286,-1,358,286,359,-1,359,286,285,-1,359,285,290,-1,290,289,359,-1,290,285,284,-1,359,289,296,-1,296,289,288,-1,298,294,360,-1,360,294,293,-1,360,293,361,-1,361,293,292,-1,361,292,316,-1,316,315,361,-1,316,292,291,-1,297,362,296,-1,363,362,297,-1,298,363,297,-1,296,364,359,-1,362,364,296,-1,365,363,298,-1,360,365,298,-1,366,313,301,-1,301,313,302,-1,367,366,304,-1,300,366,301,-1,305,366,300,-1,304,366,305,-1,299,305,300,-1,357,367,283,-1,283,367,304,-1,306,310,355,-1,309,368,369,-1,310,309,369,-1,356,355,369,-1,355,310,369,-1,308,312,368,-1,309,308,368,-1,312,370,368,-1,312,371,370,-1,311,371,312,-1,311,372,371,-1,313,372,311,-1,313,373,372,-1,366,373,313,-1,361,315,374,-1,374,315,314,-1,318,375,376,-1,318,376,377,-1,318,377,314,-1,317,318,314,-1,318,319,375,-1,319,320,375,-1,320,378,375,-1,320,379,378,-1,380,375,378,-1,320,321,379,-1,381,321,382,-1,383,382,384,-1,385,321,381,-1,386,379,387,-1,388,321,385,-1,389,321,388,-1,390,321,389,-1,391,321,390,-1,392,321,391,-1,393,321,392,-1,379,321,393,-1,379,393,387,-1,394,379,386,-1,395,379,396,-1,379,394,396,-1,397,379,398,-1,379,395,398,-1,379,397,399,-1,399,400,379,-1,379,400,401,-1,401,402,379,-1,379,402,403,-1,404,403,405,-1,406,403,404,-1,379,403,406,-1,381,382,383,-1,382,321,407,-1,407,321,322,-1,407,322,323,-1,407,323,324,-1,407,324,325,-1,407,325,326,-1,407,326,408,-1,408,326,409,-1,326,327,409,-1,409,327,410,-1,410,327,411,-1,327,328,411,-1,411,328,412,-1,412,328,413,-1,413,328,335,-1,329,330,414,-1,336,329,415,-1,415,329,414,-1,414,330,416,-1,416,330,417,-1,330,331,417,-1,417,331,418,-1,331,332,418,-1,418,332,419,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_4()
		{
			int[] value = {332,333,419,-1,419,333,334,-1,420,334,337,-1,419,334,420,-1,413,335,421,-1,421,335,415,-1,335,336,415,-1,420,337,422,-1,422,337,338,-1,423,338,424,-1,424,338,339,-1,422,338,423,-1,424,339,425,-1,425,339,340,-1,425,340,341,-1,425,341,426,-1,426,341,427,-1,341,342,427,-1,428,342,429,-1,429,342,350,-1,427,342,428,-1,348,343,430,-1,343,344,430,-1,344,345,430,-1,430,345,431,-1,345,346,432,-1,433,345,434,-1,434,345,432,-1,435,434,436,-1,433,434,435,-1,437,345,433,-1,438,345,437,-1,439,345,438,-1,440,345,439,-1,441,345,440,-1,442,345,441,-1,443,345,442,-1,444,345,443,-1,445,345,444,-1,446,345,445,-1,447,345,446,-1,448,345,447,-1,449,345,448,-1,450,345,449,-1,451,345,450,-1,452,345,451,-1,453,345,452,-1,454,345,453,-1,455,345,454,-1,456,345,455,-1,457,345,456,-1,431,345,457,-1,458,346,459,-1,432,346,458,-1,460,458,459,-1,459,346,349,-1,351,347,430,-1,347,348,430,-1,459,349,352,-1,461,350,351,-1,429,350,462,-1,462,350,461,-1,461,351,463,-1,463,351,430,-1,464,352,354,-1,459,352,464,-1,459,464,465,-1,354,352,353,-1,356,369,466,-1,354,356,466,-1,358,467,357,-1,468,467,358,-1,359,468,358,-1,357,469,367,-1,357,467,469,-1,364,468,359,-1,470,365,360,-1,361,470,360,-1,471,470,361,-1,374,471,361,-1,467,468,469,-1,469,468,364,-1,469,364,362,-1,469,362,363,-1,469,363,365,-1,469,365,470,-1,469,470,471,-1,469,471,472,-1,469,472,473,-1,469,473,474,-1,469,474,475,-1,469,475,476,-1,469,476,477,-1,469,477,478,-1,469,478,479,-1,469,479,480,-1,469,480,481,-1,482,481,483,-1,484,483,485,-1,486,487,488,-1,486,489,487,-1,490,491,492,-1,488,491,490,-1,493,494,495,-1,469,495,496,-1,469,496,497,-1,469,497,498,-1,469,498,499,-1,469,499,500,-1,469,500,501,-1,469,501,502,-1,469,502,503,-1,469,503,504,-1,469,504,505,-1,469,505,506,-1,469,506,507,-1,469,507,508,-1,469,508,509,-1,469,509,510,-1,469,510,370,-1,469,370,371,-1,469,371,372,-1,469,372,373,-1,469,373,511,-1,512,469,513,-1,514,469,512,-1,469,514,495,-1,515,494,493,-1,493,516,517,-1,490,494,515,-1,484,486,518,-1,488,487,491,-1,469,481,482,-1,493,514,516,-1,490,492,494,-1,514,493,495,-1,484,519,489,-1,484,489,486,-1,517,518,520,-1,517,516,518,-1,513,469,482,-1,482,483,484,-1,520,518,486,-1,484,485,519,-1,366,511,373,-1,367,511,366,-1,367,469,511,-1,466,369,509,-1,369,510,509,-1,368,510,369,-1,368,370,510,-1,472,471,374,-1,521,472,374,-1,374,314,521,-1,521,314,377,-1,521,377,522,-1,522,377,376,-1,522,376,380,-1,380,378,522,-1,522,378,523,-1,380,376,375,-1,523,378,379,-1,406,523,379,-1,406,524,523,-1,525,524,526,-1,404,524,406,-1,527,524,404,-1,526,524,527,-1,526,528,529,-1,526,529,530,-1,528,526,527,-1,527,404,405,-1,528,527,405,-1,405,403,528,-1,529,403,531,-1,532,533,534,-1,535,533,532,-1,528,403,529,-1,529,531,536,-1,529,536,537,-1,529,537,538,-1,529,538,539,-1,540,533,535,-1,539,540,535,-1,529,539,535,-1,402,541,403,-1,403,541,531,-1,401,542,402,-1,402,542,541,-1,401,400,542,-1,399,543,400,-1,400,543,542,-1,399,397,543,-1,398,544,397,-1,397,544,543,-1,398,395,544,-1,396,545,395,-1,395,545,544,-1,396,394,545,-1,394,386,545,-1,387,546,386,-1,386,546,545,-1,393,547,387,-1,387,547,546,-1,393,392,547,-1,547,392,548,-1,548,392,391,-1,548,391,390,-1,390,389,548,-1,548,389,549,-1,549,389,388,-1,549,388,550,-1,550,388,385,-1,550,385,381,-1,550,381,551,-1,551,381,383,-1,383,384,551,-1,551,384,552,-1,384,382,552,-1,552,382,553,-1,554,553,555,-1,556,553,554,-1,557,553,556,-1,558,553,557,-1,559,553,558,-1,552,553,559,-1,560,561,562,-1,563,560,564,-1,564,560,562,-1,565,560,563,-1,463,560,565,-1,430,560,463,-1,566,560,430,-1,567,568,560,-1,569,570,571,-1,572,573,574,-1,553,560,575,-1,382,560,553,-1,407,560,382,-1,408,560,407,-1,576,560,408,-1,577,560,576,-1,578,560,577,-1,579,560,580,-1,581,582,583,-1,584,585,586,-1,587,560,568,-1,588,589,590,-1,591,560,592,-1,593,594,595,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_5()
		{
			int[] value = {575,560,591,-1,575,596,595,-1,596,593,595,-1,595,594,597,-1,591,596,575,-1,594,572,597,-1,572,574,597,-1,598,599,574,-1,586,573,584,-1,600,601,602,-1,590,603,588,-1,604,584,603,-1,605,606,607,-1,606,608,607,-1,609,610,583,-1,610,581,583,-1,583,582,611,-1,582,612,611,-1,611,613,431,-1,613,614,431,-1,601,615,602,-1,431,616,430,-1,616,617,430,-1,618,619,560,-1,617,620,430,-1,620,566,430,-1,621,588,622,-1,623,621,622,-1,571,622,569,-1,624,625,626,-1,571,623,622,-1,600,602,627,-1,604,603,628,-1,629,630,627,-1,586,631,573,-1,632,570,569,-1,587,592,560,-1,633,634,635,-1,598,573,631,-1,636,637,638,-1,574,573,598,-1,574,636,638,-1,574,599,636,-1,637,639,638,-1,638,640,635,-1,640,633,635,-1,635,634,627,-1,634,629,627,-1,632,606,605,-1,627,630,600,-1,602,615,626,-1,590,628,603,-1,615,641,626,-1,641,624,626,-1,626,625,605,-1,642,567,560,-1,625,643,605,-1,604,585,584,-1,643,644,605,-1,644,645,605,-1,645,646,605,-1,569,606,632,-1,646,632,605,-1,639,640,638,-1,612,613,611,-1,619,580,560,-1,621,589,588,-1,608,610,609,-1,608,609,607,-1,566,618,560,-1,614,616,431,-1,579,642,560,-1,408,647,576,-1,648,647,408,-1,408,649,648,-1,408,410,649,-1,408,409,410,-1,410,411,649,-1,649,411,412,-1,649,412,648,-1,648,412,647,-1,412,413,647,-1,647,413,650,-1,650,413,421,-1,415,414,578,-1,578,414,560,-1,414,416,560,-1,421,415,578,-1,416,417,560,-1,560,417,561,-1,417,418,561,-1,418,419,561,-1,561,419,420,-1,561,420,422,-1,577,421,578,-1,650,421,577,-1,561,422,562,-1,562,422,423,-1,562,423,424,-1,562,424,564,-1,564,424,425,-1,564,425,426,-1,564,426,563,-1,563,426,651,-1,426,427,651,-1,651,427,652,-1,652,427,428,-1,653,428,654,-1,428,429,654,-1,652,428,653,-1,654,429,462,-1,655,656,431,-1,431,457,657,-1,658,659,431,-1,660,431,657,-1,660,655,431,-1,659,661,431,-1,656,658,431,-1,661,611,431,-1,457,456,662,-1,657,457,662,-1,456,455,663,-1,662,456,663,-1,455,454,663,-1,454,453,664,-1,663,454,664,-1,453,452,664,-1,452,451,665,-1,664,452,665,-1,451,450,665,-1,450,449,666,-1,665,450,666,-1,449,448,666,-1,448,447,666,-1,447,446,667,-1,666,447,667,-1,446,445,668,-1,667,446,668,-1,668,445,444,-1,669,668,444,-1,669,444,443,-1,669,443,442,-1,669,442,441,-1,670,669,441,-1,670,441,440,-1,671,670,440,-1,439,671,440,-1,671,439,438,-1,672,671,438,-1,437,672,438,-1,672,437,433,-1,673,672,433,-1,433,435,674,-1,673,433,675,-1,675,433,674,-1,676,677,678,-1,679,677,676,-1,679,680,677,-1,680,681,677,-1,681,682,677,-1,682,683,677,-1,677,684,675,-1,684,673,675,-1,683,684,677,-1,435,685,674,-1,435,436,685,-1,686,687,688,-1,685,686,688,-1,689,675,688,-1,675,674,688,-1,674,685,688,-1,436,686,685,-1,436,434,686,-1,432,458,690,-1,434,432,686,-1,686,432,690,-1,464,691,692,-1,465,464,692,-1,690,460,692,-1,460,465,692,-1,458,460,690,-1,459,465,460,-1,462,461,463,-1,654,462,463,-1,653,654,463,-1,463,652,653,-1,565,652,463,-1,354,466,691,-1,464,354,691,-1,691,466,508,-1,466,509,508,-1,691,508,507,-1,692,691,507,-1,692,507,506,-1,687,692,506,-1,687,506,505,-1,688,687,505,-1,688,505,504,-1,693,688,504,-1,503,693,504,-1,694,693,503,-1,502,694,503,-1,695,694,502,-1,501,695,502,-1,696,695,501,-1,500,696,501,-1,697,696,500,-1,499,697,500,-1,698,697,499,-1,498,698,499,-1,699,698,498,-1,497,699,498,-1,700,699,497,-1,496,700,497,-1,701,700,496,-1,495,701,496,-1,702,701,495,-1,494,702,495,-1,703,702,494,-1,492,703,494,-1,704,703,492,-1,491,704,492,-1,491,705,704,-1,487,705,491,-1,487,706,705,-1,489,706,487,-1,489,707,706,-1,519,707,489,-1,519,708,707,-1,485,708,519,-1,485,709,708,-1,483,709,485,-1,483,710,709,-1,481,710,483,-1,481,711,710,-1,481,480,711,-1,480,712,711,-1,480,479,712,-1,479,713,712,-1,479,478,713,-1,478,714,713,-1,478,477,714,-1,477,715,714,-1,477,476,715,-1,476,526,715,-1,476,475,526,-1,526,475,525,-1,475,474,525,-1,525,474,522,-1,474,473,522,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_6()
		{
			int[] value = {522,473,521,-1,473,472,521,-1,482,716,717,-1,718,482,717,-1,718,719,482,-1,719,513,482,-1,513,719,720,-1,721,513,720,-1,721,722,513,-1,722,512,513,-1,484,723,724,-1,725,484,724,-1,725,716,484,-1,716,482,484,-1,726,727,518,-1,518,727,723,-1,518,723,484,-1,728,726,518,-1,728,518,729,-1,518,516,729,-1,516,730,729,-1,731,730,516,-1,731,516,732,-1,516,514,732,-1,514,733,732,-1,734,733,514,-1,734,514,722,-1,514,512,722,-1,520,735,736,-1,737,520,736,-1,737,738,520,-1,738,517,520,-1,486,739,740,-1,741,486,740,-1,741,735,486,-1,735,520,486,-1,488,742,743,-1,744,488,743,-1,744,739,488,-1,739,486,488,-1,745,746,490,-1,490,746,742,-1,490,742,488,-1,747,745,490,-1,747,490,748,-1,490,515,748,-1,515,749,748,-1,750,749,515,-1,750,515,751,-1,515,493,751,-1,493,752,751,-1,753,752,493,-1,753,493,738,-1,493,517,738,-1,522,523,525,-1,525,523,524,-1,526,530,715,-1,532,530,535,-1,715,530,532,-1,715,754,755,-1,755,756,715,-1,715,756,757,-1,754,715,532,-1,530,529,535,-1,754,532,534,-1,754,534,755,-1,534,533,755,-1,756,533,758,-1,759,760,761,-1,761,762,763,-1,761,764,759,-1,763,765,766,-1,763,766,767,-1,763,767,768,-1,763,764,761,-1,768,764,763,-1,769,764,768,-1,770,553,771,-1,772,773,774,-1,772,553,770,-1,774,775,555,-1,774,555,553,-1,774,553,772,-1,771,553,764,-1,771,764,769,-1,776,764,777,-1,755,533,756,-1,756,758,778,-1,756,778,779,-1,756,779,780,-1,756,780,759,-1,756,759,764,-1,756,764,776,-1,540,781,533,-1,533,781,758,-1,782,781,539,-1,539,781,540,-1,539,538,782,-1,783,782,537,-1,537,782,538,-1,537,536,783,-1,531,541,536,-1,536,541,783,-1,541,542,784,-1,783,541,785,-1,785,541,784,-1,542,543,786,-1,784,542,786,-1,543,544,787,-1,786,543,787,-1,544,545,788,-1,787,544,788,-1,788,545,546,-1,546,547,789,-1,788,546,790,-1,790,546,789,-1,789,547,791,-1,791,547,792,-1,547,548,792,-1,792,548,549,-1,793,549,550,-1,792,549,793,-1,794,550,551,-1,794,793,550,-1,795,551,796,-1,551,552,796,-1,796,552,559,-1,795,794,551,-1,796,559,558,-1,796,558,797,-1,797,558,557,-1,556,797,557,-1,797,556,798,-1,798,556,554,-1,798,554,775,-1,775,554,555,-1,764,553,575,-1,576,650,577,-1,647,650,576,-1,799,575,595,-1,764,575,800,-1,800,575,801,-1,801,575,802,-1,802,575,803,-1,803,575,799,-1,799,595,804,-1,804,595,805,-1,805,595,806,-1,806,595,807,-1,807,595,808,-1,808,595,597,-1,808,597,809,-1,809,597,574,-1,809,574,810,-1,810,574,638,-1,810,638,811,-1,811,638,812,-1,812,638,635,-1,812,635,813,-1,813,635,814,-1,814,635,627,-1,815,627,816,-1,816,627,817,-1,627,602,817,-1,814,627,818,-1,818,627,815,-1,819,602,820,-1,602,626,820,-1,817,602,819,-1,820,626,821,-1,821,626,822,-1,626,605,822,-1,822,605,823,-1,605,607,823,-1,607,609,824,-1,823,607,824,-1,825,609,826,-1,826,609,827,-1,827,609,828,-1,828,609,829,-1,609,583,829,-1,824,609,825,-1,829,583,830,-1,830,583,831,-1,831,583,832,-1,832,583,833,-1,833,583,834,-1,583,611,834,-1,679,676,835,-1,836,679,837,-1,837,679,835,-1,838,679,836,-1,834,679,838,-1,839,679,834,-1,611,661,834,-1,661,840,834,-1,840,841,834,-1,841,842,834,-1,842,843,834,-1,843,844,834,-1,844,845,834,-1,845,846,834,-1,846,847,834,-1,847,848,834,-1,848,849,834,-1,849,850,834,-1,850,851,834,-1,851,852,834,-1,852,853,834,-1,853,854,834,-1,854,855,834,-1,855,856,834,-1,856,857,834,-1,857,839,834,-1,858,679,839,-1,565,651,652,-1,563,651,565,-1,580,859,860,-1,579,580,860,-1,619,859,580,-1,618,861,734,-1,721,618,722,-1,722,618,734,-1,859,618,721,-1,619,618,859,-1,566,861,618,-1,620,862,861,-1,566,620,861,-1,617,862,620,-1,616,863,731,-1,733,616,732,-1,732,616,731,-1,862,616,733,-1,617,616,862,-1,614,863,616,-1,864,863,613,-1,613,863,614,-1,612,864,613,-1,612,582,865,-1,729,612,728,-1,728,612,865,-1,730,612,729,-1,864,612,730,-1,582,581,865,-1,581,610,866,-1,865,581,866,-1,610,608,866,-1,608,606,726,-1,866,608,726,-1,606,569,726,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_7()
		{
			int[] value = {569,622,726,-1,726,622,867,-1,622,588,867,-1,867,588,603,-1,868,867,603,-1,603,584,868,-1,868,723,727,-1,584,723,868,-1,724,723,584,-1,573,724,584,-1,869,724,573,-1,573,572,869,-1,869,572,594,-1,870,869,594,-1,594,593,870,-1,870,716,725,-1,593,716,870,-1,717,716,593,-1,596,717,593,-1,871,717,596,-1,871,596,591,-1,872,871,591,-1,592,872,591,-1,872,592,587,-1,873,720,719,-1,587,873,719,-1,718,872,719,-1,872,587,719,-1,587,568,873,-1,873,568,567,-1,860,873,567,-1,642,860,567,-1,860,642,579,-1,589,874,875,-1,590,589,875,-1,621,874,589,-1,623,876,753,-1,737,623,738,-1,738,623,753,-1,874,623,737,-1,621,623,874,-1,571,876,623,-1,570,877,876,-1,571,570,876,-1,632,877,570,-1,646,878,750,-1,752,646,751,-1,751,646,750,-1,877,646,752,-1,632,646,877,-1,645,878,646,-1,879,878,644,-1,644,878,645,-1,643,879,644,-1,643,625,880,-1,748,643,747,-1,747,643,880,-1,749,643,748,-1,879,643,749,-1,625,624,880,-1,624,641,881,-1,880,624,881,-1,641,615,881,-1,615,601,745,-1,881,615,745,-1,601,600,745,-1,600,630,745,-1,745,630,882,-1,630,629,882,-1,882,629,634,-1,883,882,634,-1,634,633,883,-1,883,742,746,-1,633,742,883,-1,743,742,633,-1,640,743,633,-1,884,743,640,-1,640,639,884,-1,884,639,637,-1,885,884,637,-1,637,636,885,-1,885,739,744,-1,636,739,885,-1,740,739,636,-1,599,740,636,-1,886,740,599,-1,886,599,598,-1,887,886,598,-1,631,887,598,-1,887,631,586,-1,888,736,735,-1,586,888,735,-1,741,887,735,-1,887,586,735,-1,586,585,888,-1,888,585,604,-1,875,888,604,-1,628,875,604,-1,875,628,590,-1,661,659,889,-1,840,661,889,-1,658,890,889,-1,659,658,889,-1,658,656,890,-1,656,655,891,-1,890,656,891,-1,655,660,891,-1,660,657,662,-1,891,660,662,-1,891,662,892,-1,892,662,893,-1,662,663,893,-1,893,663,894,-1,663,664,894,-1,894,664,895,-1,664,665,895,-1,895,665,896,-1,665,666,896,-1,896,666,667,-1,896,667,897,-1,897,667,898,-1,667,668,898,-1,898,668,899,-1,899,668,900,-1,668,669,900,-1,900,669,670,-1,900,670,901,-1,901,670,671,-1,902,901,671,-1,902,671,672,-1,903,902,672,-1,903,672,904,-1,904,672,673,-1,684,904,673,-1,904,684,683,-1,905,904,683,-1,682,905,683,-1,905,682,681,-1,906,905,681,-1,680,906,681,-1,858,906,680,-1,679,858,680,-1,835,676,907,-1,676,678,907,-1,689,688,693,-1,678,689,693,-1,908,837,693,-1,837,835,693,-1,835,907,693,-1,907,678,693,-1,678,677,689,-1,677,675,689,-1,690,692,687,-1,686,690,687,-1,908,693,694,-1,909,908,694,-1,909,694,695,-1,910,909,695,-1,911,912,695,-1,912,910,695,-1,910,913,909,-1,911,695,696,-1,914,911,696,-1,914,696,697,-1,915,914,697,-1,915,697,698,-1,916,915,698,-1,917,918,698,-1,918,916,698,-1,917,698,699,-1,919,917,699,-1,919,699,700,-1,920,919,700,-1,921,922,700,-1,922,920,700,-1,921,700,701,-1,923,921,701,-1,924,925,701,-1,925,923,701,-1,924,701,702,-1,926,924,702,-1,926,702,703,-1,927,926,703,-1,928,929,703,-1,929,927,703,-1,928,703,704,-1,930,928,704,-1,704,705,931,-1,930,704,931,-1,705,706,932,-1,933,705,934,-1,934,705,932,-1,931,705,933,-1,706,707,935,-1,932,706,935,-1,707,708,936,-1,937,707,938,-1,938,707,936,-1,935,707,937,-1,709,939,708,-1,708,939,940,-1,708,940,941,-1,941,936,708,-1,710,942,709,-1,709,942,939,-1,711,943,710,-1,710,943,944,-1,710,944,945,-1,945,942,710,-1,712,946,711,-1,711,946,943,-1,713,947,712,-1,712,947,946,-1,714,948,713,-1,949,948,950,-1,713,948,949,-1,713,951,947,-1,951,713,949,-1,715,757,714,-1,714,757,948,-1,717,871,872,-1,718,717,872,-1,859,721,720,-1,860,859,873,-1,873,859,720,-1,724,869,870,-1,725,724,870,-1,726,867,868,-1,727,726,868,-1,865,866,726,-1,728,865,726,-1,863,864,730,-1,731,863,730,-1,861,862,733,-1,734,861,733,-1,874,737,736,-1,875,874,888,-1,888,874,736,-1,740,886,887,-1,741,740,887,-1,743,884,885,-1,744,743,885,-1,745,882,883,-1,746,745,883,-1,880,881,745,-1,747,880,745,-1,878,879,749,-1,750,878,749,-1,876,877,752,-1,753,876,752,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_8()
		{
			int[] value = {757,756,776,-1,950,757,776,-1,950,948,757,-1,776,777,950,-1,950,777,952,-1,950,952,949,-1,953,952,777,-1,954,953,777,-1,777,764,954,-1,954,764,955,-1,764,800,955,-1,798,775,956,-1,956,775,774,-1,773,956,774,-1,956,773,957,-1,957,773,772,-1,770,957,772,-1,957,770,958,-1,958,770,771,-1,769,958,771,-1,958,769,959,-1,959,769,768,-1,767,959,768,-1,766,959,767,-1,960,959,765,-1,765,959,766,-1,960,765,961,-1,961,765,763,-1,961,763,962,-1,962,763,762,-1,761,962,762,-1,760,962,761,-1,963,962,759,-1,759,962,760,-1,759,780,963,-1,964,963,779,-1,779,963,780,-1,779,778,964,-1,781,964,758,-1,758,964,778,-1,781,782,965,-1,964,781,966,-1,781,965,966,-1,782,783,967,-1,782,967,965,-1,783,785,967,-1,784,786,968,-1,785,784,969,-1,969,784,968,-1,967,785,970,-1,785,969,970,-1,786,787,971,-1,968,786,971,-1,787,788,972,-1,971,787,972,-1,972,788,790,-1,789,791,973,-1,790,789,974,-1,974,789,973,-1,972,790,975,-1,975,790,974,-1,973,791,976,-1,976,791,977,-1,791,792,977,-1,977,792,793,-1,978,793,794,-1,977,793,978,-1,979,794,795,-1,979,978,794,-1,980,795,981,-1,981,795,796,-1,980,979,795,-1,981,796,797,-1,798,982,797,-1,982,981,797,-1,956,983,798,-1,983,982,798,-1,799,804,984,-1,803,799,985,-1,985,799,984,-1,955,800,986,-1,986,800,987,-1,800,801,987,-1,987,801,988,-1,801,802,988,-1,802,803,988,-1,988,803,989,-1,989,803,985,-1,804,805,984,-1,805,806,990,-1,984,805,990,-1,990,806,991,-1,806,807,991,-1,991,807,808,-1,991,808,992,-1,992,808,809,-1,992,809,810,-1,992,810,993,-1,993,810,811,-1,994,811,995,-1,995,811,812,-1,993,811,994,-1,995,812,996,-1,996,812,813,-1,996,813,814,-1,996,814,997,-1,997,814,818,-1,815,816,998,-1,999,818,815,-1,999,815,1000,-1,1000,815,998,-1,998,816,1001,-1,816,817,1001,-1,817,819,1002,-1,1001,817,1002,-1,997,818,999,-1,819,820,1002,-1,1002,820,1003,-1,820,821,1003,-1,1004,821,1005,-1,821,822,1005,-1,1003,821,1004,-1,1005,822,1006,-1,822,823,1006,-1,823,824,1006,-1,824,825,1007,-1,1006,824,1007,-1,1007,825,826,-1,1007,826,1008,-1,1008,826,827,-1,1009,827,828,-1,1008,827,1009,-1,1009,828,829,-1,1009,829,1010,-1,1010,829,830,-1,1011,830,1012,-1,1012,830,831,-1,1010,830,1011,-1,1012,831,832,-1,1012,832,1013,-1,1013,832,833,-1,1013,833,1014,-1,1014,833,1015,-1,1015,833,834,-1,834,838,1016,-1,1015,834,1016,-1,1017,906,858,-1,839,1017,858,-1,857,1017,839,-1,1018,1017,857,-1,856,1018,857,-1,855,1018,856,-1,1019,1018,855,-1,854,1019,855,-1,853,1019,854,-1,1020,1019,853,-1,852,1020,853,-1,851,1020,852,-1,850,1020,851,-1,849,1021,1020,-1,850,849,1020,-1,1022,1021,849,-1,848,1022,849,-1,1023,1022,848,-1,847,1023,848,-1,846,1023,847,-1,845,1023,846,-1,844,1024,1023,-1,845,844,1023,-1,844,843,1024,-1,842,1025,1024,-1,843,842,1024,-1,842,841,1025,-1,840,889,1025,-1,841,840,1025,-1,838,1026,1016,-1,838,1027,1026,-1,838,836,913,-1,910,838,913,-1,910,1027,838,-1,836,837,908,-1,913,836,909,-1,909,836,908,-1,1025,889,1028,-1,889,1029,1028,-1,889,890,1029,-1,890,1030,1029,-1,890,891,1030,-1,1030,891,892,-1,1030,892,1031,-1,1031,892,1032,-1,892,893,1032,-1,1032,893,1033,-1,893,894,1033,-1,1033,894,1034,-1,894,895,1034,-1,1034,895,1035,-1,895,896,1035,-1,1035,896,897,-1,1035,897,1036,-1,1036,897,1037,-1,897,898,1037,-1,1037,898,1038,-1,898,899,1038,-1,1038,899,1039,-1,1039,899,1040,-1,899,900,1040,-1,1040,900,901,-1,1040,901,1041,-1,1041,901,902,-1,1042,1041,902,-1,1042,902,903,-1,1043,1042,903,-1,1043,903,1044,-1,1044,903,904,-1,1044,904,905,-1,1045,1044,905,-1,1045,905,906,-1,1046,1045,906,-1,1017,1046,906,-1,1027,910,912,-1,1047,1027,912,-1,914,1047,911,-1,911,1047,912,-1,1048,914,915,-1,1048,915,916,-1,1048,916,1049,-1,1049,916,918,-1,1049,918,1050,-1,1050,918,917,-1,1050,917,919,-1,919,920,1050,-1,1050,920,1051,-1,1051,920,922,-1,1051,922,1052,-1,1052,922,921,-1,1052,921,923,-1,1052,923,1053,-1,1053,923,925,-1,1053,925,1054,-1,1054,925,924,-1,1054,924,926,-1,926,927,1054,-1,1054,927,1055,-1,1055,927,929,-1,1055,929,1056,-1,1056,929,928,-1,1056,928,930,-1,1057,1058,933,-1,931,1058,930,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_9()
		{
			int[] value = {933,1058,931,-1,933,934,1057,-1,1059,1060,937,-1,934,1060,1057,-1,932,1060,934,-1,935,1060,932,-1,937,1060,935,-1,937,938,1059,-1,1061,1062,941,-1,938,1062,1059,-1,936,1062,938,-1,941,1062,936,-1,941,940,1061,-1,1063,1064,945,-1,940,1064,1061,-1,939,1064,940,-1,942,1064,939,-1,945,1064,942,-1,945,944,1063,-1,944,1065,1063,-1,943,1065,944,-1,946,1065,943,-1,952,1066,951,-1,947,1066,946,-1,951,1066,947,-1,951,949,952,-1,1066,952,953,-1,1067,953,1068,-1,1068,953,954,-1,1067,1066,953,-1,954,955,1069,-1,1069,955,1070,-1,1071,1068,954,-1,1071,954,1069,-1,1070,955,1072,-1,955,986,1072,-1,957,1073,956,-1,1073,983,956,-1,958,1074,957,-1,1074,1073,957,-1,959,1075,958,-1,1075,1074,958,-1,960,1075,959,-1,961,1076,960,-1,960,1077,1075,-1,1076,1077,960,-1,1078,1079,961,-1,962,1078,961,-1,1079,1076,961,-1,963,1078,962,-1,963,964,1080,-1,963,1080,1078,-1,964,966,1080,-1,965,967,1081,-1,966,965,1082,-1,965,1081,1082,-1,1080,966,1083,-1,966,1082,1083,-1,967,970,1081,-1,968,971,1084,-1,969,968,1085,-1,1085,968,1084,-1,970,969,1086,-1,969,1085,1086,-1,1081,970,1087,-1,970,1086,1087,-1,971,972,1088,-1,1084,971,1088,-1,1088,972,975,-1,973,976,1089,-1,974,973,1090,-1,1090,973,1089,-1,975,974,1091,-1,1091,974,1090,-1,1088,975,1092,-1,1092,975,1091,-1,1089,976,1093,-1,1093,976,1094,-1,976,977,1094,-1,1094,977,978,-1,1095,978,979,-1,1095,1094,978,-1,1096,979,980,-1,1096,1095,979,-1,1097,980,1098,-1,1098,980,981,-1,1097,1096,980,-1,1098,981,982,-1,983,1099,982,-1,1099,1098,982,-1,1073,1100,983,-1,1100,1099,983,-1,985,984,1101,-1,1101,984,1102,-1,984,990,1102,-1,989,985,1103,-1,1103,985,1104,-1,1104,985,1101,-1,986,987,1072,-1,1072,987,1105,-1,1105,987,1106,-1,987,988,1106,-1,1106,988,1103,-1,988,989,1103,-1,990,991,1102,-1,1102,991,992,-1,1102,992,993,-1,1102,993,1107,-1,1107,993,994,-1,1108,994,995,-1,1107,994,1109,-1,1109,994,1108,-1,1108,995,1110,-1,1110,995,996,-1,1110,996,997,-1,1110,997,1111,-1,1111,997,999,-1,1000,998,1112,-1,1112,998,1113,-1,1113,998,1114,-1,998,1001,1114,-1,1115,999,1112,-1,1112,999,1000,-1,1111,999,1115,-1,1114,1001,1116,-1,1001,1002,1116,-1,1002,1003,1116,-1,1116,1003,1117,-1,1003,1004,1117,-1,1117,1004,1118,-1,1118,1004,1119,-1,1004,1005,1119,-1,1119,1005,1120,-1,1005,1006,1120,-1,1006,1007,1120,-1,1120,1007,1008,-1,1120,1008,1009,-1,1120,1009,1121,-1,1121,1009,1010,-1,1122,1010,1123,-1,1123,1010,1011,-1,1121,1010,1122,-1,1123,1011,1012,-1,1123,1012,1124,-1,1124,1012,1013,-1,1124,1013,1125,-1,1125,1013,1126,-1,1126,1013,1014,-1,1126,1014,1015,-1,1126,1015,1127,-1,1015,1016,1128,-1,1127,1015,1128,-1,1128,1016,1129,-1,1016,1130,1129,-1,1016,1026,1130,-1,1131,1046,1017,-1,1018,1131,1017,-1,1132,1131,1018,-1,1019,1132,1018,-1,1133,1132,1019,-1,1020,1133,1019,-1,1021,1133,1020,-1,1021,1134,1133,-1,1135,1134,1021,-1,1022,1135,1021,-1,1136,1135,1022,-1,1137,1136,1022,-1,1023,1137,1022,-1,1024,1137,1023,-1,1024,1138,1137,-1,1024,1025,1138,-1,1025,1028,1138,-1,1130,1026,1139,-1,1026,1047,1139,-1,1026,1027,1047,-1,1138,1028,1140,-1,1028,1141,1140,-1,1028,1029,1141,-1,1029,1142,1141,-1,1029,1030,1142,-1,1030,1031,1142,-1,1142,1031,1143,-1,1031,1144,1143,-1,1031,1032,1144,-1,1144,1032,1145,-1,1032,1033,1145,-1,1145,1033,1146,-1,1033,1034,1146,-1,1146,1034,1147,-1,1034,1035,1147,-1,1147,1035,1036,-1,1147,1036,1148,-1,1148,1036,1149,-1,1036,1037,1149,-1,1149,1037,1150,-1,1037,1038,1150,-1,1150,1038,1151,-1,1038,1039,1151,-1,1151,1039,1152,-1,1152,1039,1153,-1,1039,1040,1153,-1,1153,1040,1041,-1,1154,1153,1041,-1,1154,1041,1042,-1,1155,1154,1042,-1,1155,1042,1043,-1,1156,1155,1043,-1,1156,1043,1157,-1,1157,1043,1044,-1,1157,1044,1045,-1,1158,1157,1045,-1,1158,1045,1046,-1,1159,1158,1046,-1,1131,1159,1046,-1,1139,1047,1160,-1,1047,1161,1160,-1,1047,914,1161,-1,1160,914,1048,-1,1161,914,1160,-1,1160,1048,1162,-1,1048,1163,1162,-1,1048,1049,1163,-1,1163,1049,1164,-1,1164,1049,1050,-1,1050,1051,1165,-1,1164,1050,1166,-1,1166,1050,1167,-1,1050,1165,1167,-1,1165,1051,1052,-1,1052,1053,1168,-1,1167,1165,1052,-1,1167,1052,1169,-1,1169,1052,1168,-1,1168,1053,1170,-1,1170,1053,1054,-1,1171,1170,1054,-1,1171,1054,1172,-1,1172,1054,1173,-1,1054,1055,1173,-1,1173,1055,1056,-1,1056,930,1174,-1,1172,1173,1056,-1,1172,1056,1175,-1,1175,1056,1174,-1,1176,930,1177,-1,1177,930,1058,-1,1174,930,1176,-1,1178,1058,1179,-1,1058,1180,1179,-1,1058,1057,1180,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_10()
		{
			int[] value = {1177,1058,1178,-1,1180,1057,1060,-1,1179,1060,1181,-1,1060,1182,1181,-1,1060,1059,1182,-1,1180,1060,1179,-1,1183,1059,1062,-1,1182,1059,1183,-1,1183,1062,1184,-1,1184,1062,1185,-1,1062,1186,1185,-1,1062,1061,1186,-1,1186,1061,1064,-1,1187,1064,1188,-1,1064,1063,1188,-1,1185,1186,1064,-1,1185,1064,1187,-1,1188,1063,1189,-1,1189,1063,1065,-1,1190,1189,1065,-1,1190,1065,1191,-1,1065,946,1191,-1,1191,946,1192,-1,1192,946,1066,-1,1191,1192,1066,-1,1191,1066,1067,-1,1193,1191,1067,-1,1193,1067,1194,-1,1194,1067,1071,-1,1071,1067,1068,-1,1195,1071,1069,-1,1195,1069,1196,-1,1069,1070,1196,-1,1196,1070,1197,-1,1197,1070,1198,-1,1070,1072,1198,-1,1199,1194,1071,-1,1199,1071,1195,-1,1198,1072,1200,-1,1072,1105,1200,-1,1074,1201,1073,-1,1201,1100,1073,-1,1075,1202,1074,-1,1202,1201,1074,-1,1077,1202,1075,-1,1079,1203,1076,-1,1076,1204,1077,-1,1203,1204,1076,-1,1077,1205,1202,-1,1204,1205,1077,-1,1080,1206,1078,-1,1078,1206,1079,-1,1206,1207,1079,-1,1207,1203,1079,-1,1080,1083,1206,-1,1082,1081,1208,-1,1081,1087,1208,-1,1083,1082,1209,-1,1082,1208,1209,-1,1206,1083,1210,-1,1083,1209,1210,-1,1084,1088,1211,-1,1085,1084,1212,-1,1212,1084,1211,-1,1086,1085,1213,-1,1085,1212,1213,-1,1087,1086,1214,-1,1086,1213,1214,-1,1208,1087,1215,-1,1087,1214,1215,-1,1211,1088,1092,-1,1216,1151,1093,-1,1151,1152,1093,-1,1216,1093,1094,-1,1216,1094,1095,-1,1217,1095,1096,-1,1217,1216,1095,-1,1096,1097,1218,-1,1218,1217,1096,-1,1097,1219,1220,-1,1219,1097,1098,-1,1220,1218,1097,-1,1219,1098,1099,-1,1100,1221,1099,-1,1221,1219,1099,-1,1201,1222,1100,-1,1222,1221,1100,-1,1223,1101,1224,-1,1101,1102,1224,-1,1104,1101,1223,-1,1224,1102,1107,-1,1106,1103,1225,-1,1225,1103,1226,-1,1226,1103,1223,-1,1103,1104,1223,-1,1105,1106,1200,-1,1200,1106,1225,-1,1227,1107,1109,-1,1224,1107,1227,-1,1227,1109,1108,-1,1227,1108,1228,-1,1228,1108,1110,-1,1228,1110,1229,-1,1229,1110,1230,-1,1230,1110,1111,-1,1230,1111,1115,-1,1231,1115,1112,-1,1231,1112,1232,-1,1232,1112,1233,-1,1112,1113,1233,-1,1233,1113,1234,-1,1113,1114,1234,-1,1114,1116,1234,-1,1230,1115,1231,-1,1234,1116,1235,-1,1235,1116,1236,-1,1116,1117,1236,-1,1236,1117,1237,-1,1117,1118,1237,-1,1118,1119,1237,-1,1119,1120,1238,-1,1237,1119,1238,-1,1238,1120,1121,-1,1238,1121,1239,-1,1239,1121,1122,-1,1239,1122,1123,-1,1239,1123,1240,-1,1240,1123,1241,-1,1241,1123,1124,-1,1241,1124,1242,-1,1242,1124,1125,-1,1242,1125,1126,-1,1242,1126,1243,-1,1243,1126,1127,-1,1127,1128,1244,-1,1245,1127,1244,-1,1243,1127,1245,-1,1128,1129,1246,-1,1244,1128,1246,-1,1246,1129,1247,-1,1129,1248,1247,-1,1129,1139,1248,-1,1130,1139,1129,-1,1249,1159,1131,-1,1132,1249,1131,-1,1250,1249,1132,-1,1133,1250,1132,-1,1134,1250,1133,-1,1134,1251,1250,-1,1252,1251,1134,-1,1135,1252,1134,-1,1253,1252,1135,-1,1136,1253,1135,-1,1254,1253,1136,-1,1255,1254,1136,-1,1137,1255,1136,-1,1138,1255,1137,-1,1138,1140,1255,-1,1248,1139,1256,-1,1139,1160,1256,-1,1255,1140,1257,-1,1140,1258,1257,-1,1140,1141,1258,-1,1141,1259,1258,-1,1141,1142,1259,-1,1142,1143,1259,-1,1259,1143,1260,-1,1143,1261,1260,-1,1143,1144,1261,-1,1144,1262,1261,-1,1144,1145,1262,-1,1262,1145,1263,-1,1145,1146,1263,-1,1263,1146,1264,-1,1146,1147,1264,-1,1264,1147,1148,-1,1152,1265,1089,-1,1152,1089,1093,-1,1265,1152,1153,-1,1265,1153,1154,-1,1266,1265,1154,-1,1266,1154,1155,-1,1267,1266,1155,-1,1267,1155,1156,-1,1268,1267,1156,-1,1268,1156,1269,-1,1269,1156,1157,-1,1269,1157,1158,-1,1270,1269,1158,-1,1270,1158,1159,-1,1271,1270,1159,-1,1249,1271,1159,-1,1256,1160,1162,-1,1256,1162,1272,-1,1272,1162,1273,-1,1273,1162,1166,-1,1162,1164,1166,-1,1162,1163,1164,-1,1273,1166,1274,-1,1166,1169,1274,-1,1166,1167,1169,-1,1169,1168,1171,-1,1168,1170,1171,-1,1274,1169,1275,-1,1275,1169,1276,-1,1169,1171,1276,-1,1276,1171,1172,-1,1276,1172,1277,-1,1277,1172,1278,-1,1278,1172,1175,-1,1279,1174,1176,-1,1175,1174,1280,-1,1280,1174,1279,-1,1278,1175,1280,-1,1176,1177,1279,-1,1279,1177,1281,-1,1281,1177,1178,-1,1178,1179,1282,-1,1281,1178,1282,-1,1283,1179,1284,-1,1179,1181,1284,-1,1282,1179,1283,-1,1284,1181,1184,-1,1181,1183,1184,-1,1181,1182,1183,-1,1284,1184,1285,-1,1285,1184,1286,-1,1286,1184,1187,-1,1184,1185,1187,-1,1187,1190,1287,-1,1187,1188,1190,-1,1286,1187,1287,-1,1188,1189,1190,-1,1287,1190,1288,-1,1288,1190,1193,-1,1190,1191,1193,-1,1288,1193,1199,-1,1199,1193,1194,-1,1289,1195,1290,-1,1290,1195,1291,-1,1291,1195,1196,-1,1289,1199,1195,-1,1291,1196,1197,-1,1292,1291,1197,-1,1197,1198,1292,-1,1292,1198,1293,-1,1293,1198,1294,-1,1198,1200,1294,-1,1295,1288,1199,-1,1295,1199,1289,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_11()
		{
			int[] value = {1294,1200,1296,-1,1200,1225,1296,-1,1202,1297,1201,-1,1297,1222,1201,-1,1205,1297,1202,-1,1298,1203,1207,-1,1299,1204,1203,-1,1298,1299,1203,-1,1300,1205,1204,-1,1299,1300,1204,-1,1301,1297,1205,-1,1300,1301,1205,-1,1206,1210,1207,-1,1210,1302,1207,-1,1302,1298,1207,-1,1209,1208,1303,-1,1208,1215,1303,-1,1210,1209,1304,-1,1209,1303,1304,-1,1304,1302,1210,-1,1089,1266,1090,-1,1265,1266,1089,-1,1090,1267,1091,-1,1266,1267,1090,-1,1091,1268,1092,-1,1267,1268,1091,-1,1092,1305,1211,-1,1268,1305,1092,-1,1216,1217,1150,-1,1151,1216,1150,-1,1217,1218,1149,-1,1150,1217,1149,-1,1220,1148,1218,-1,1218,1148,1149,-1,1306,1264,1220,-1,1220,1264,1148,-1,1307,1263,1306,-1,1306,1263,1264,-1,1308,1262,1307,-1,1307,1262,1263,-1,1301,1261,1308,-1,1308,1261,1262,-1,1300,1260,1301,-1,1301,1260,1261,-1,1299,1309,1300,-1,1300,1309,1260,-1,1298,1310,1299,-1,1299,1310,1309,-1,1298,1302,1311,-1,1298,1311,1310,-1,1301,1308,1297,-1,1308,1222,1297,-1,1308,1307,1222,-1,1307,1221,1222,-1,1307,1306,1221,-1,1219,1221,1306,-1,1306,1220,1219,-1,1226,1223,1312,-1,1223,1227,1312,-1,1223,1224,1227,-1,1225,1226,1296,-1,1296,1226,1313,-1,1313,1226,1312,-1,1312,1227,1314,-1,1314,1227,1228,-1,1314,1228,1229,-1,1314,1229,1315,-1,1315,1229,1316,-1,1316,1229,1230,-1,1316,1230,1317,-1,1317,1230,1231,-1,1317,1231,1232,-1,1232,1233,1318,-1,1317,1232,1319,-1,1319,1232,1318,-1,1233,1234,1318,-1,1318,1234,1320,-1,1234,1235,1320,-1,1320,1235,1321,-1,1321,1235,1322,-1,1235,1236,1322,-1,1236,1237,1322,-1,1322,1237,1323,-1,1323,1237,1239,-1,1237,1238,1239,-1,1323,1239,1240,-1,1323,1240,1324,-1,1324,1240,1325,-1,1325,1240,1241,-1,1325,1241,1242,-1,1325,1242,1326,-1,1326,1242,1243,-1,1326,1243,1327,-1,1327,1243,1328,-1,1328,1243,1245,-1,1245,1244,1329,-1,1328,1245,1329,-1,1244,1246,1329,-1,1329,1246,1330,-1,1330,1246,1331,-1,1246,1247,1331,-1,1247,1272,1332,-1,1247,1256,1272,-1,1248,1256,1247,-1,1331,1247,1332,-1,1333,1271,1249,-1,1250,1333,1249,-1,1251,1333,1250,-1,1251,1334,1333,-1,1335,1334,1251,-1,1335,1251,1252,-1,1336,1335,1252,-1,1336,1252,1253,-1,1337,1336,1253,-1,1337,1253,1254,-1,1311,1337,1254,-1,1257,1311,1254,-1,1255,1257,1254,-1,1310,1311,1257,-1,1257,1258,1310,-1,1258,1309,1310,-1,1258,1259,1309,-1,1259,1260,1309,-1,1338,1212,1211,-1,1211,1305,1338,-1,1339,1213,1212,-1,1338,1339,1212,-1,1334,1214,1213,-1,1213,1339,1334,-1,1335,1215,1214,-1,1214,1334,1335,-1,1303,1215,1336,-1,1336,1215,1335,-1,1304,1303,1337,-1,1337,1303,1336,-1,1311,1302,1304,-1,1311,1304,1337,-1,1334,1339,1333,-1,1333,1339,1271,-1,1339,1338,1271,-1,1338,1270,1271,-1,1338,1305,1270,-1,1305,1269,1270,-1,1305,1268,1269,-1,1272,1273,1332,-1,1332,1273,1340,-1,1340,1273,1274,-1,1341,1274,1275,-1,1340,1274,1341,-1,1275,1276,1277,-1,1341,1275,1342,-1,1342,1275,1343,-1,1275,1277,1343,-1,1343,1277,1344,-1,1344,1277,1278,-1,1344,1278,1345,-1,1345,1278,1346,-1,1278,1280,1346,-1,1346,1280,1279,-1,1346,1279,1347,-1,1347,1279,1348,-1,1279,1281,1348,-1,1348,1281,1282,-1,1349,1282,1350,-1,1282,1283,1350,-1,1348,1282,1349,-1,1283,1284,1285,-1,1350,1283,1351,-1,1351,1283,1285,-1,1351,1285,1352,-1,1352,1285,1353,-1,1285,1286,1353,-1,1286,1287,1354,-1,1353,1286,1354,-1,1354,1287,1295,-1,1295,1287,1288,-1,1355,1295,1289,-1,1355,1289,1356,-1,1356,1289,1290,-1,1356,1290,1291,-1,1356,1291,1357,-1,1357,1291,1292,-1,1358,1357,1292,-1,1358,1292,1359,-1,1292,1293,1359,-1,1293,1294,1359,-1,1359,1294,1360,-1,1294,1296,1360,-1,1353,1354,1295,-1,1353,1295,1361,-1,1361,1295,1355,-1,1296,1313,1362,-1,1360,1296,1363,-1,1363,1296,1362,-1,1313,1312,1362,-1,1362,1312,1314,-1,1362,1314,1364,-1,1364,1314,1315,-1,1364,1315,1316,-1,1364,1316,1365,-1,1365,1316,1366,-1,1366,1316,1317,-1,1366,1317,1367,-1,1367,1317,1319,-1,1319,1318,1367,-1,1367,1318,1368,-1,1318,1320,1368,-1,1368,1320,1369,-1,1369,1320,1370,-1,1320,1321,1370,-1,1321,1322,1370,-1,1370,1322,1371,-1,1322,1323,1371,-1,1371,1323,1324,-1,1371,1324,1325,-1,1371,1325,1372,-1,1372,1325,1373,-1,1373,1325,1326,-1,1373,1326,1374,-1,1374,1326,1327,-1,1374,1327,1328,-1,1374,1328,1375,-1,1328,1329,1376,-1,1375,1328,1376,-1,1329,1330,1377,-1,1376,1329,1377,-1,1330,1331,1377,-1,1377,1331,1378,-1,1331,1332,1378,-1,1378,1332,1379,-1,1379,1332,1341,-1,1332,1340,1341,-1,1379,1341,1342,-1,1380,1342,1381,-1,1342,1344,1381,-1,1342,1343,1344,-1,1379,1342,1382,-1,1382,1342,1380,-1,1381,1344,1383,-1,1383,1344,1345,-1,1383,1345,1384,-1,1384,1345,1385,-1,1345,1347,1385,-1,1345,1346,1347,-1,1347,1348,1349,-1,1385,1347,1349,-1,1385,1349,1384,-1,1384,1349,1386,-1,1349,1350,1386,-1,1350,1351,1352,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_coordIndex_12()
		{
			int[] value = {1386,1350,1387,-1,1387,1350,1352,-1,1387,1352,1388,-1,1388,1352,1389,-1,1389,1352,1361,-1,1352,1353,1361,-1,1390,1355,1356,-1,1389,1361,1355,-1,1389,1355,1391,-1,1391,1355,1390,-1,1390,1356,1392,-1,1392,1356,1357,-1,1392,1357,1358,-1,1393,1392,1358,-1,1358,1359,1393,-1,1393,1359,1394,-1,1359,1360,1394,-1,1394,1360,1395,-1,1395,1360,1396,-1,1360,1363,1396,-1,1363,1362,1364,-1,1363,1364,1396,-1,1396,1364,1397,-1,1397,1364,1365,-1,1397,1365,1366,-1,1397,1366,1398,-1,1398,1366,1399,-1,1399,1366,1367,-1,1367,1368,1399,-1,1399,1368,1400,-1,1400,1368,1401,-1,1368,1369,1401,-1,1369,1370,1401,-1,1401,1370,1402,-1,1402,1370,1372,-1,1370,1371,1372,-1,1402,1372,1373,-1,1402,1373,1403,-1,1403,1373,1404,-1,1404,1373,1374,-1,1404,1374,1405,-1,1405,1374,1375,-1,1375,1376,1406,-1,1405,1375,1406,-1,1376,1377,1406,-1,1406,1377,1407,-1,1377,1378,1407,-1,1407,1378,1408,-1,1408,1378,1382,-1,1378,1379,1382,-1,1380,1383,1409,-1,1380,1381,1383,-1,1410,1382,1380,-1,1410,1380,1411,-1,1411,1380,1409,-1,1408,1382,1410,-1,1409,1383,1412,-1,1412,1383,1384,-1,1384,1386,1412,-1,1412,1386,1413,-1,1413,1386,1388,-1,1386,1387,1388,-1,1413,1388,1414,-1,1414,1388,1415,-1,1388,1389,1415,-1,1415,1389,1391,-1,1415,1391,1390,-1,1415,1390,1416,-1,1416,1390,1417,-1,1417,1390,1392,-1,1417,1392,1393,-1,1418,1417,1393,-1,1393,1394,1418,-1,1418,1394,1419,-1,1419,1394,1420,-1,1394,1395,1420,-1,1395,1396,1420,-1,1420,1396,1397,-1,1420,1397,1421,-1,1421,1397,1398,-1,1421,1398,1399,-1,1421,1399,1422,-1,1422,1399,1423,-1,1399,1400,1423,-1,1400,1401,1423,-1,1423,1401,1424,-1,1401,1402,1424,-1,1424,1402,1403,-1,1424,1403,1404,-1,1425,1404,1426,-1,1426,1404,1405,-1,1424,1404,1425,-1,1405,1406,1427,-1,1426,1405,1427,-1,1406,1407,1427,-1,1427,1407,1428,-1,1428,1407,1410,-1,1407,1408,1410,-1,1411,1409,1412,-1,1428,1410,1429,-1,1429,1410,1411,-1,1430,1411,1431,-1,1411,1412,1431,-1,1429,1411,1430,-1,1412,1413,1414,-1,1431,1412,1414,-1,1431,1414,1430,-1,1430,1414,1432,-1,1414,1415,1432,-1,1432,1415,1416,-1,1432,1416,1417,-1,1432,1417,1433,-1,1433,1417,1418,-1,1434,1433,1418,-1,1434,1418,1435,-1,1418,1419,1435,-1,1419,1420,1435,-1,1435,1420,1421,-1,1436,1421,1422,-1,1435,1421,1436,-1,1422,1423,1436,-1,1436,1423,1437,-1,1423,1424,1437,-1,1437,1424,1425,-1,1437,1425,1426,-1,1437,1426,1438,-1,1426,1427,1439,-1,1438,1426,1439,-1,1427,1428,1429,-1,1439,1427,1429,-1,1439,1429,1430,-1,1439,1430,1440,-1,1440,1430,1433,-1,1430,1432,1433,-1,1440,1433,1434,-1,1441,1440,1434,-1,1434,1435,1436,-1,1434,1436,1441,-1,1441,1436,1438,-1,1436,1437,1438,-1,1438,1439,1440,-1,1441,1438,1440,-1};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getIndexedFaceSet_10_28_normalIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,2,3,4,-1,1,5,3,-1,3,5,6,-1,5,1,0,-1,7,0,8,-1,0,2,8,-1,9,5,0,-1,9,0,10,-1,10,0,11,-1,11,0,7,-1,2,4,12,-1,12,4,13,-1,8,2,12,-1,14,4,15,-1,4,3,15,-1,13,4,14,-1,15,3,6,-1,15,6,16,-1,16,6,17,-1,5,18,6,-1,6,18,17,-1,18,5,9,-1,19,7,20,-1,7,8,20,-1,21,11,7,-1,21,7,22,-1,22,7,19,-1,20,8,23,-1,23,8,12,-1,24,9,25,-1,25,9,10,-1,18,9,24,-1,25,10,26,-1,26,10,27,-1,27,10,21,-1,10,11,21,-1,23,12,28,-1,28,12,29,-1,12,13,29,-1,29,13,30,-1,31,13,32,-1,13,14,32,-1,30,13,31,-1,14,15,33,-1,32,14,34,-1,34,14,33,-1,33,15,35,-1,35,15,36,-1,36,15,16,-1,36,16,37,-1,37,16,38,-1,38,16,17,-1,39,17,40,-1,18,41,17,-1,17,41,40,-1,38,17,39,-1,41,18,42,-1,42,18,24,-1,43,22,19,-1,43,19,44,-1,44,19,45,-1,45,19,46,-1,19,20,46,-1,46,20,47,-1,47,20,28,-1,20,23,28,-1,48,21,43,-1,43,21,22,-1,27,21,49,-1,49,21,48,-1,42,24,25,-1,42,25,50,-1,50,25,51,-1,51,25,26,-1,51,26,52,-1,52,26,53,-1,53,26,49,-1,26,27,49,-1,47,28,54,-1,54,28,55,-1,28,29,55,-1,55,29,56,-1,29,30,56,-1,56,30,57,-1,57,30,58,-1,58,30,31,-1,58,31,59,-1,59,31,60,-1,31,34,60,-1,31,32,34,-1,34,33,61,-1,61,33,62,-1,62,33,63,-1,33,35,63,-1,60,34,64,-1,64,34,61,-1,63,35,36,-1,63,36,65,-1,65,36,66,-1,66,36,37,-1,67,37,68,-1,68,37,39,-1,37,38,39,-1,66,37,67,-1,39,40,69,-1,68,39,70,-1,70,39,69,-1,69,40,71,-1,41,72,40,-1,40,72,71,-1,72,41,73,-1,73,41,42,-1,73,42,74,-1,74,42,50,-1,75,48,43,-1,75,43,76,-1,76,43,44,-1,76,44,45,-1,45,46,77,-1,76,45,78,-1,78,45,79,-1,79,45,80,-1,45,77,80,-1,77,46,54,-1,46,47,54,-1,49,48,81,-1,81,48,82,-1,82,48,75,-1,53,49,83,-1,83,49,81,-1,74,50,51,-1,84,51,52,-1,74,51,84,-1,85,84,52,-1,85,52,86,-1,86,52,87,-1,87,52,83,-1,52,53,83,-1,77,54,88,-1,88,54,89,-1,54,55,89,-1,89,55,90,-1,90,55,91,-1,55,56,91,-1,56,57,91,-1,91,57,92,-1,92,57,58,-1,92,58,93,-1,93,58,94,-1,94,58,59,-1,94,59,95,-1,95,59,96,-1,59,64,96,-1,59,60,64,-1,97,61,98,-1,61,62,98,-1,64,61,99,-1,99,61,97,-1,62,63,98,-1,98,63,100,-1,100,63,101,-1,101,63,65,-1,96,64,99,-1,101,65,66,-1,101,66,102,-1,102,66,103,-1,103,66,67,-1,67,68,70,-1,103,67,104,-1,104,67,70,-1,70,69,105,-1,105,69,106,-1,106,69,107,-1,69,71,107,-1,104,70,108,-1,108,70,105,-1,72,109,71,-1,71,109,107,-1,109,72,73,-1,109,73,110,-1,110,73,111,-1,111,73,74,-1,111,74,112,-1,112,74,84,-1,113,75,114,-1,114,75,115,-1,115,75,76,-1,113,82,75,-1,115,76,116,-1,116,76,78,-1,80,77,88,-1,116,78,79,-1,116,79,117,-1,117,79,118,-1,118,79,119,-1,79,80,119,-1,120,80,88,-1,119,80,120,-1,121,81,122,-1,122,81,113,-1,81,82,113,-1,83,81,121,-1,87,83,123,-1,123,83,121,-1,112,84,85,-1,112,85,124,-1,124,85,125,-1,125,85,86,-1,125,86,126,-1,126,86,127,-1,127,86,123,-1,86,87,123,-1,120,88,128,-1,128,88,129,-1,129,88,130,-1,88,89,130,-1,130,89,131,-1,89,90,131,-1,90,91,131,-1,131,91,132,-1,91,92,132,-1,132,92,133,-1,133,92,134,-1,134,92,93,-1,134,93,94,-1,134,94,135,-1,135,94,95,-1,135,95,136,-1,136,95,137,-1,137,95,138,-1,95,139,138,-1,95,96,139,-1,139,96,99,-1,99,97,140,-1,97,98,140,-1,140,98,141,-1,98,100,141,-1,139,99,142,-1,142,99,143,-1,143,99,140,-1,144,100,101,-1,141,100,145,-1,145,100,144,-1,144,101,146,-1,146,101,102,-1,146,102,103,-1,146,103,147,-1,147,103,148,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_2()
		{
			int[] value = {148,103,149,-1,103,104,149,-1,149,104,108,-1,108,105,150,-1,150,105,151,-1,105,106,151,-1,106,107,151,-1,151,107,152,-1,109,153,107,-1,107,153,152,-1,154,149,108,-1,154,108,155,-1,155,108,156,-1,156,108,150,-1,153,109,157,-1,157,109,110,-1,157,110,111,-1,157,111,158,-1,158,111,112,-1,158,112,159,-1,159,112,160,-1,160,112,124,-1,122,113,161,-1,161,113,114,-1,161,114,162,-1,162,114,115,-1,163,115,116,-1,162,115,164,-1,164,115,163,-1,163,116,117,-1,163,117,165,-1,165,117,118,-1,118,119,166,-1,165,118,167,-1,167,118,168,-1,168,118,169,-1,118,166,169,-1,166,119,128,-1,119,120,128,-1,123,121,170,-1,170,121,171,-1,171,121,172,-1,121,122,172,-1,172,122,161,-1,127,123,170,-1,160,124,125,-1,160,125,173,-1,173,125,126,-1,174,173,126,-1,174,126,175,-1,175,126,176,-1,176,126,177,-1,126,127,177,-1,177,127,170,-1,128,129,178,-1,166,128,178,-1,178,129,179,-1,129,130,179,-1,130,131,180,-1,179,130,181,-1,181,130,180,-1,131,132,182,-1,180,131,182,-1,132,133,182,-1,182,133,183,-1,183,133,134,-1,184,134,135,-1,183,134,184,-1,184,135,185,-1,185,135,186,-1,186,135,136,-1,186,136,187,-1,187,136,137,-1,137,138,188,-1,187,137,189,-1,137,188,189,-1,138,139,188,-1,188,139,142,-1,143,140,190,-1,190,140,191,-1,140,141,191,-1,191,141,192,-1,192,141,193,-1,141,145,193,-1,142,143,190,-1,188,142,194,-1,194,142,195,-1,195,142,190,-1,193,145,144,-1,193,144,196,-1,196,144,197,-1,197,144,146,-1,197,146,198,-1,198,146,147,-1,198,147,148,-1,148,149,199,-1,198,148,200,-1,200,148,201,-1,201,148,199,-1,199,149,154,-1,202,150,203,-1,150,151,203,-1,156,150,204,-1,204,150,202,-1,203,151,205,-1,151,152,205,-1,152,153,206,-1,205,152,206,-1,206,153,157,-1,199,154,155,-1,207,199,155,-1,207,155,208,-1,155,156,208,-1,208,156,204,-1,206,157,209,-1,209,157,158,-1,210,158,211,-1,211,158,159,-1,209,158,210,-1,212,159,160,-1,211,159,212,-1,212,160,173,-1,172,161,213,-1,213,161,214,-1,214,161,215,-1,215,161,162,-1,215,162,164,-1,216,164,163,-1,216,163,217,-1,217,163,218,-1,218,163,165,-1,215,164,216,-1,218,165,219,-1,219,165,167,-1,169,166,220,-1,220,166,221,-1,221,166,178,-1,222,167,168,-1,219,167,222,-1,168,169,223,-1,168,224,225,-1,168,225,226,-1,168,226,222,-1,226,227,222,-1,224,168,223,-1,223,169,220,-1,177,170,228,-1,228,170,229,-1,229,170,230,-1,170,171,230,-1,230,171,213,-1,171,172,213,-1,231,173,232,-1,232,173,174,-1,212,173,231,-1,233,174,175,-1,232,174,233,-1,233,175,234,-1,175,235,236,-1,175,236,237,-1,175,237,234,-1,237,238,234,-1,175,176,235,-1,235,176,239,-1,176,177,239,-1,239,177,228,-1,221,178,240,-1,240,178,241,-1,241,178,242,-1,178,179,242,-1,242,179,243,-1,179,181,243,-1,181,180,243,-1,243,180,244,-1,244,180,245,-1,180,182,245,-1,182,183,245,-1,245,183,246,-1,246,183,184,-1,246,184,247,-1,247,184,248,-1,248,184,185,-1,248,185,186,-1,248,186,249,-1,249,186,187,-1,250,187,251,-1,187,189,251,-1,249,187,252,-1,252,187,250,-1,189,188,194,-1,251,189,253,-1,253,189,254,-1,254,189,194,-1,195,190,255,-1,190,191,255,-1,255,191,256,-1,256,191,257,-1,191,192,257,-1,257,192,258,-1,192,193,258,-1,258,193,196,-1,254,194,259,-1,259,194,260,-1,260,194,261,-1,194,195,261,-1,261,195,255,-1,258,196,262,-1,262,196,197,-1,263,197,264,-1,264,197,198,-1,262,197,263,-1,264,198,200,-1,201,199,207,-1,265,200,201,-1,264,200,265,-1,265,201,266,-1,266,201,267,-1,267,201,268,-1,201,207,268,-1,204,202,269,-1,202,203,269,-1,269,203,270,-1,270,203,271,-1,203,205,271,-1,208,204,272,-1,272,204,269,-1,205,206,273,-1,271,205,273,-1,273,206,209,-1,274,207,275,-1,275,207,208,-1,268,207,274,-1,275,208,276,-1,276,208,277,-1,277,208,272,-1,273,209,278,-1,278,209,279,-1,279,209,210,-1,279,210,211,-1,279,211,280,-1,280,211,212,-1,280,212,281,-1,281,212,282,-1,282,212,231,-1,213,214,283,-1,230,213,283,-1,283,214,215,-1,283,215,216,-1,216,284,285,-1,216,285,286,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_3()
		{
			int[] value = {216,286,283,-1,284,216,217,-1,284,217,218,-1,218,222,287,-1,218,287,288,-1,218,288,289,-1,218,289,284,-1,290,284,289,-1,222,218,219,-1,223,220,224,-1,220,291,292,-1,220,292,293,-1,220,293,294,-1,220,294,224,-1,295,224,294,-1,220,221,291,-1,291,221,240,-1,227,287,222,-1,296,297,298,-1,298,297,299,-1,298,299,300,-1,300,301,298,-1,298,301,302,-1,302,301,303,-1,302,303,304,-1,304,305,302,-1,295,225,224,-1,239,228,235,-1,228,306,307,-1,228,307,308,-1,228,308,309,-1,228,309,235,-1,310,235,309,-1,228,229,306,-1,229,230,306,-1,230,283,311,-1,230,311,306,-1,311,312,306,-1,313,231,232,-1,282,231,313,-1,232,234,314,-1,232,314,315,-1,232,315,316,-1,232,316,313,-1,317,313,316,-1,234,232,233,-1,234,238,314,-1,318,319,320,-1,321,318,320,-1,322,323,320,-1,323,321,320,-1,324,319,325,-1,326,319,318,-1,327,319,326,-1,325,319,327,-1,235,310,236,-1,240,241,291,-1,241,328,329,-1,241,329,291,-1,329,330,291,-1,241,242,331,-1,331,242,332,-1,332,242,333,-1,242,243,333,-1,333,243,334,-1,243,244,334,-1,244,245,334,-1,334,245,335,-1,245,246,335,-1,335,246,336,-1,336,246,337,-1,337,246,247,-1,337,247,248,-1,337,248,338,-1,338,248,249,-1,338,249,339,-1,339,249,340,-1,340,249,252,-1,340,252,250,-1,340,250,341,-1,341,250,342,-1,250,253,342,-1,250,251,253,-1,253,254,343,-1,342,253,343,-1,343,254,259,-1,261,255,344,-1,344,255,345,-1,345,255,346,-1,255,256,346,-1,346,256,347,-1,256,257,347,-1,257,258,347,-1,347,258,348,-1,348,258,349,-1,349,258,262,-1,350,259,351,-1,259,260,351,-1,343,259,350,-1,260,261,351,-1,351,261,344,-1,349,262,263,-1,352,263,264,-1,349,263,352,-1,353,264,354,-1,354,264,265,-1,352,264,353,-1,354,265,355,-1,355,265,266,-1,355,266,267,-1,355,267,356,-1,356,267,357,-1,267,268,357,-1,357,268,274,-1,272,269,358,-1,358,269,359,-1,269,270,359,-1,270,271,359,-1,359,271,360,-1,271,273,361,-1,360,271,361,-1,277,272,362,-1,362,272,363,-1,363,272,358,-1,361,273,364,-1,364,273,278,-1,357,274,365,-1,365,274,276,-1,274,275,276,-1,365,276,366,-1,366,276,362,-1,276,277,362,-1,364,278,279,-1,364,279,367,-1,367,279,280,-1,367,280,368,-1,368,280,369,-1,369,280,281,-1,281,313,370,-1,281,370,371,-1,281,371,372,-1,313,281,282,-1,373,374,375,-1,375,374,376,-1,377,376,378,-1,378,376,379,-1,378,379,380,-1,380,381,378,-1,290,285,284,-1,378,381,296,-1,296,381,297,-1,302,305,382,-1,382,305,383,-1,382,383,384,-1,384,383,385,-1,384,385,386,-1,386,387,384,-1,330,292,291,-1,298,388,296,-1,389,388,298,-1,302,389,298,-1,296,390,378,-1,388,390,296,-1,391,389,302,-1,382,391,302,-1,392,324,393,-1,393,324,325,-1,394,392,395,-1,396,392,393,-1,397,392,396,-1,395,392,397,-1,306,312,307,-1,398,399,374,-1,374,399,395,-1,313,317,370,-1,400,401,402,-1,403,400,402,-1,404,405,402,-1,405,403,402,-1,322,320,401,-1,400,322,401,-1,320,406,401,-1,320,407,406,-1,319,407,320,-1,319,408,407,-1,324,408,319,-1,324,409,408,-1,392,409,324,-1,384,387,410,-1,410,387,411,-1,333,412,413,-1,333,413,414,-1,333,414,331,-1,332,333,331,-1,333,334,412,-1,334,335,412,-1,335,415,412,-1,335,416,415,-1,417,412,415,-1,335,336,416,-1,418,336,419,-1,420,419,421,-1,422,336,418,-1,423,416,424,-1,425,336,422,-1,426,336,425,-1,427,336,426,-1,428,336,427,-1,429,336,428,-1,430,336,429,-1,416,336,430,-1,416,430,424,-1,431,416,423,-1,432,416,433,-1,416,431,433,-1,434,416,435,-1,416,432,435,-1,416,434,436,-1,436,437,416,-1,416,437,438,-1,438,439,416,-1,416,439,440,-1,441,440,442,-1,443,440,441,-1,416,440,443,-1,418,419,420,-1,419,336,444,-1,445,336,337,-1,446,337,338,-1,446,338,339,-1,446,339,340,-1,447,340,341,-1,448,341,449,-1,449,341,450,-1,341,342,450,-1,450,342,451,-1,451,342,452,-1,342,343,452,-1,452,343,453,-1,453,343,454,-1,454,343,350,-1,344,345,455,-1,351,344,456,-1,456,344,455,-1,455,345,457,-1,457,345,458,-1,345,346,458,-1,458,346,459,-1,346,347,459,-1,459,347,460,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_4()
		{
			int[] value = {347,348,460,-1,460,348,349,-1,461,349,352,-1,460,349,461,-1,454,350,462,-1,462,350,456,-1,350,351,456,-1,461,352,463,-1,463,352,353,-1,464,353,465,-1,465,353,354,-1,463,353,464,-1,465,354,466,-1,466,354,355,-1,466,355,356,-1,466,356,467,-1,467,356,468,-1,356,357,468,-1,469,357,470,-1,470,357,365,-1,468,357,469,-1,363,358,471,-1,358,359,471,-1,359,360,472,-1,473,360,474,-1,360,361,475,-1,476,360,477,-1,477,360,475,-1,478,477,479,-1,476,477,478,-1,480,360,476,-1,481,360,480,-1,482,360,481,-1,483,360,482,-1,484,360,483,-1,485,360,484,-1,486,360,485,-1,487,360,486,-1,488,360,487,-1,489,360,488,-1,490,360,489,-1,491,360,490,-1,492,360,491,-1,493,360,492,-1,494,360,493,-1,495,360,494,-1,496,360,495,-1,497,360,496,-1,498,360,497,-1,499,360,498,-1,500,360,499,-1,474,360,500,-1,501,361,502,-1,475,361,501,-1,503,501,502,-1,502,361,364,-1,366,362,504,-1,362,363,471,-1,502,364,367,-1,505,365,366,-1,470,365,506,-1,506,365,505,-1,505,366,507,-1,507,366,508,-1,509,367,369,-1,502,367,509,-1,502,509,510,-1,369,367,368,-1,404,402,511,-1,512,404,511,-1,513,514,515,-1,516,514,513,-1,378,516,517,-1,518,519,520,-1,518,514,519,-1,390,516,378,-1,521,391,382,-1,384,521,382,-1,522,521,384,-1,410,522,384,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,523,523,523,-1,392,524,409,-1,525,524,392,-1,525,519,524,-1,511,402,526,-1,402,527,526,-1,401,527,402,-1,401,406,527,-1,528,522,410,-1,529,528,410,-1,410,411,529,-1,529,411,414,-1,529,414,530,-1,530,414,413,-1,530,413,417,-1,417,415,530,-1,530,415,531,-1,523,523,523,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,533,534,535,-1,441,534,443,-1,536,534,441,-1,535,534,536,-1,535,537,538,-1,535,538,539,-1,537,535,536,-1,536,441,442,-1,523,523,523,-1,442,440,537,-1,538,440,540,-1,541,542,543,-1,544,542,541,-1,537,440,538,-1,538,540,545,-1,538,545,546,-1,538,546,547,-1,538,547,548,-1,549,542,544,-1,548,549,544,-1,538,548,544,-1,439,550,440,-1,440,550,540,-1,438,551,439,-1,439,551,550,-1,438,437,551,-1,436,552,437,-1,437,552,551,-1,436,434,552,-1,435,553,434,-1,434,553,552,-1,435,432,553,-1,433,554,432,-1,432,554,553,-1,433,431,554,-1,431,423,554,-1,424,555,423,-1,423,555,554,-1,430,556,424,-1,424,556,555,-1,430,429,556,-1,556,429,557,-1,557,429,428,-1,557,428,427,-1,427,426,557,-1,557,426,558,-1,558,426,425,-1,558,425,559,-1,559,425,422,-1,559,422,418,-1,559,418,560,-1,560,418,420,-1,420,421,560,-1,560,421,561,-1,421,419,561,-1,561,419,562,-1,563,562,564,-1,565,562,563,-1,566,562,565,-1,567,562,566,-1,568,562,567,-1,561,562,568,-1,569,570,571,-1,572,569,573,-1,573,569,571,-1,574,569,572,-1,507,569,574,-1,575,569,507,-1,532,569,575,-1,532,532,569,-1,532,532,532,-1,532,532,576,-1,532,569,577,-1,532,569,532,-1,578,569,532,-1,449,569,578,-1,579,569,449,-1,580,569,579,-1,581,569,580,-1,532,569,532,-1,532,532,582,-1,532,532,532,-1,532,569,532,-1,532,532,532,-1,532,569,532,-1,532,532,583,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_5()
		{
			int[] value = {577,569,532,-1,577,532,583,-1,532,532,583,-1,583,532,584,-1,532,532,577,-1,532,532,584,-1,532,576,584,-1,532,532,576,-1,532,532,532,-1,532,532,585,-1,532,532,532,-1,532,532,532,-1,586,532,587,-1,532,532,587,-1,588,532,582,-1,532,532,582,-1,582,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,585,-1,532,532,575,-1,532,532,575,-1,532,532,569,-1,532,532,575,-1,532,532,575,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,589,-1,532,532,532,-1,532,585,590,-1,532,532,532,-1,532,532,590,-1,532,532,532,-1,532,532,532,-1,532,532,569,-1,532,532,591,-1,532,532,532,-1,532,532,592,-1,576,532,532,-1,576,532,592,-1,576,532,532,-1,532,532,592,-1,592,532,591,-1,532,532,591,-1,591,532,590,-1,532,532,590,-1,532,532,586,-1,590,532,532,-1,585,532,589,-1,532,532,532,-1,532,532,589,-1,532,532,589,-1,589,532,586,-1,532,532,569,-1,532,532,586,-1,532,532,532,-1,532,532,586,-1,532,532,586,-1,532,532,586,-1,532,532,532,-1,532,532,586,-1,532,532,592,-1,532,532,532,-1,532,532,569,-1,532,532,532,-1,532,532,588,-1,532,588,587,-1,532,532,569,-1,532,532,532,-1,532,532,569,-1,449,593,579,-1,594,593,449,-1,449,595,594,-1,449,451,595,-1,449,450,451,-1,451,452,595,-1,595,452,453,-1,595,453,594,-1,594,453,593,-1,453,454,593,-1,593,454,596,-1,596,454,462,-1,456,455,581,-1,581,455,569,-1,455,457,569,-1,462,456,581,-1,457,458,569,-1,569,458,570,-1,458,459,570,-1,459,460,570,-1,570,460,461,-1,570,461,463,-1,580,462,581,-1,596,462,580,-1,570,463,571,-1,571,463,464,-1,571,464,465,-1,571,465,573,-1,573,465,466,-1,573,466,467,-1,573,467,572,-1,572,467,597,-1,467,468,597,-1,597,468,598,-1,598,468,469,-1,599,469,600,-1,469,470,600,-1,598,469,599,-1,600,470,506,-1,601,602,474,-1,474,500,603,-1,604,605,474,-1,606,474,603,-1,606,601,474,-1,605,607,474,-1,602,604,474,-1,607,608,474,-1,500,499,609,-1,603,500,609,-1,499,498,610,-1,609,499,610,-1,498,497,610,-1,497,496,611,-1,610,497,611,-1,496,495,611,-1,495,494,612,-1,611,495,612,-1,494,493,612,-1,493,492,613,-1,612,493,613,-1,492,491,613,-1,491,490,613,-1,490,489,614,-1,613,490,614,-1,489,488,615,-1,614,489,615,-1,615,488,487,-1,616,615,487,-1,616,487,486,-1,616,486,485,-1,616,485,484,-1,617,616,484,-1,617,484,483,-1,618,617,483,-1,482,618,483,-1,618,482,481,-1,619,618,481,-1,480,619,481,-1,619,480,476,-1,620,619,476,-1,476,478,621,-1,620,476,622,-1,622,476,621,-1,623,624,625,-1,626,624,623,-1,626,627,624,-1,627,628,624,-1,628,629,624,-1,629,630,624,-1,624,631,622,-1,631,620,622,-1,630,631,624,-1,523,523,523,-1,478,479,632,-1,633,634,635,-1,632,633,635,-1,636,622,635,-1,622,621,635,-1,621,632,635,-1,479,633,632,-1,479,477,633,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,509,637,638,-1,510,509,638,-1,639,503,638,-1,503,510,638,-1,501,503,639,-1,523,523,523,-1,506,505,507,-1,600,506,507,-1,599,600,507,-1,507,598,599,-1,574,598,507,-1,512,511,637,-1,509,512,637,-1,637,511,640,-1,511,526,640,-1,637,640,641,-1,638,637,641,-1,638,641,642,-1,634,638,642,-1,634,642,643,-1,635,634,643,-1,635,643,644,-1,645,635,644,-1,646,645,644,-1,647,645,646,-1,648,647,646,-1,649,647,648,-1,650,649,648,-1,651,649,650,-1,652,651,650,-1,653,651,652,-1,654,653,652,-1,655,653,654,-1,656,655,654,-1,657,655,656,-1,658,657,656,-1,659,657,658,-1,660,659,658,-1,661,659,660,-1,662,661,660,-1,663,661,662,-1,664,663,662,-1,665,663,664,-1,666,667,664,-1,668,667,666,-1,669,670,666,-1,669,671,670,-1,672,673,669,-1,672,674,673,-1,675,674,672,-1,675,676,674,-1,677,676,675,-1,677,678,676,-1,679,678,677,-1,679,680,678,-1,681,680,679,-1,681,682,680,-1,683,682,681,-1,683,684,682,-1,683,685,684,-1,685,686,684,-1,685,687,686,-1,687,688,686,-1,687,689,688,-1,689,690,688,-1,689,691,690,-1,691,692,690,-1,691,693,692,-1,693,535,692,-1,693,694,535,-1,535,694,533,-1,694,695,533,-1,533,695,530,-1,695,696,530,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_6()
		{
			int[] value = {530,696,529,-1,696,528,529,-1,697,698,699,-1,700,697,699,-1,700,700,697,-1,700,701,697,-1,702,702,702,-1,702,702,702,-1,702,702,702,-1,702,702,702,-1,703,704,705,-1,704,703,705,-1,704,704,703,-1,704,706,703,-1,707,708,708,-1,708,708,708,-1,708,708,707,-1,709,709,709,-1,709,709,709,-1,709,709,709,-1,710,711,712,-1,712,711,710,-1,712,710,712,-1,710,713,712,-1,714,715,716,-1,717,715,714,-1,717,714,717,-1,714,718,717,-1,702,702,702,-1,702,702,702,-1,702,702,702,-1,702,702,702,-1,719,720,721,-1,701,719,721,-1,701,701,719,-1,701,701,719,-1,705,722,703,-1,706,705,703,-1,706,706,705,-1,706,723,705,-1,724,725,726,-1,726,725,725,-1,726,725,708,-1,727,728,729,-1,727,729,727,-1,729,730,727,-1,711,710,731,-1,713,710,711,-1,713,711,713,-1,711,732,713,-1,733,734,735,-1,718,734,733,-1,718,733,718,-1,733,718,718,-1,530,531,533,-1,533,531,534,-1,535,539,692,-1,541,539,544,-1,692,539,541,-1,692,736,737,-1,737,738,692,-1,692,738,739,-1,736,692,541,-1,532,532,532,-1,523,523,523,-1,736,543,737,-1,543,542,737,-1,738,542,740,-1,741,741,741,-1,742,743,744,-1,742,745,746,-1,747,748,749,-1,744,750,751,-1,744,751,752,-1,744,745,742,-1,752,745,744,-1,753,745,752,-1,754,562,755,-1,756,756,757,-1,758,562,754,-1,757,759,759,-1,760,564,562,-1,760,562,758,-1,755,562,745,-1,755,745,753,-1,761,745,762,-1,737,542,738,-1,738,740,763,-1,738,763,764,-1,738,764,765,-1,738,765,746,-1,738,746,745,-1,738,745,761,-1,549,766,542,-1,542,766,740,-1,767,766,548,-1,548,766,549,-1,548,547,767,-1,768,767,546,-1,546,767,547,-1,546,545,768,-1,540,550,545,-1,545,550,768,-1,550,551,769,-1,768,550,770,-1,770,550,769,-1,551,552,771,-1,769,551,771,-1,552,553,772,-1,771,552,772,-1,553,554,773,-1,772,553,773,-1,773,554,555,-1,555,556,774,-1,773,555,775,-1,775,555,774,-1,774,556,776,-1,776,556,777,-1,556,557,777,-1,777,557,558,-1,778,558,559,-1,777,558,778,-1,779,559,560,-1,779,778,559,-1,780,560,781,-1,560,561,781,-1,781,561,568,-1,780,779,560,-1,781,568,567,-1,781,567,782,-1,782,567,566,-1,565,782,566,-1,782,565,783,-1,783,565,563,-1,783,563,784,-1,784,563,564,-1,745,562,785,-1,579,596,580,-1,593,596,579,-1,786,787,583,-1,745,788,789,-1,789,790,791,-1,791,790,792,-1,792,790,793,-1,793,794,786,-1,786,583,795,-1,795,583,796,-1,796,583,797,-1,797,583,798,-1,798,583,799,-1,799,583,584,-1,799,584,800,-1,800,584,576,-1,800,576,801,-1,801,576,592,-1,801,592,802,-1,802,592,803,-1,803,592,591,-1,803,591,804,-1,804,591,805,-1,805,591,590,-1,806,590,807,-1,807,590,808,-1,590,585,808,-1,805,590,809,-1,809,590,806,-1,810,585,811,-1,585,589,811,-1,808,585,810,-1,811,589,812,-1,812,589,813,-1,589,586,813,-1,813,586,814,-1,586,587,814,-1,587,588,815,-1,814,587,815,-1,816,588,817,-1,817,588,818,-1,818,588,819,-1,819,588,820,-1,588,821,820,-1,815,588,816,-1,820,822,823,-1,823,824,825,-1,825,824,826,-1,826,824,827,-1,827,828,829,-1,830,608,829,-1,626,623,831,-1,832,626,833,-1,833,626,831,-1,834,626,832,-1,829,626,834,-1,835,626,829,-1,608,607,829,-1,607,836,829,-1,836,837,829,-1,837,838,829,-1,838,839,829,-1,839,840,829,-1,840,841,829,-1,841,842,829,-1,842,843,829,-1,843,844,829,-1,844,845,829,-1,845,846,829,-1,846,847,829,-1,847,848,829,-1,848,849,829,-1,849,850,829,-1,850,851,829,-1,851,852,829,-1,852,853,829,-1,853,835,829,-1,854,854,854,-1,574,597,598,-1,572,597,574,-1,855,856,857,-1,858,855,857,-1,859,856,855,-1,860,861,862,-1,863,860,864,-1,864,860,862,-1,856,860,863,-1,859,860,856,-1,865,861,860,-1,866,867,861,-1,865,866,861,-1,868,867,866,-1,869,870,871,-1,872,869,873,-1,873,869,871,-1,867,869,872,-1,868,869,867,-1,870,870,869,-1,874,870,875,-1,875,870,870,-1,876,874,875,-1,876,877,878,-1,879,876,880,-1,880,876,878,-1,881,876,879,-1,874,876,881,-1,877,882,878,-1,882,883,884,-1,878,882,884,-1,883,885,884,-1,885,886,887,-1,884,885,887,-1,886,888,887,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_7()
		{
			int[] value = {888,889,887,-1,887,889,890,-1,889,890,890,-1,890,890,891,-1,892,890,891,-1,891,893,892,-1,892,894,895,-1,893,894,892,-1,896,894,893,-1,897,896,893,-1,898,896,897,-1,897,899,898,-1,898,899,900,-1,901,898,900,-1,900,902,901,-1,901,903,904,-1,902,903,901,-1,905,903,902,-1,906,905,902,-1,907,905,906,-1,907,906,908,-1,909,907,908,-1,910,909,908,-1,909,910,911,-1,912,913,914,-1,911,912,914,-1,915,909,914,-1,909,911,914,-1,911,916,912,-1,912,916,917,-1,857,912,917,-1,918,857,917,-1,857,918,858,-1,919,920,921,-1,922,919,921,-1,920,920,919,-1,923,861,923,-1,923,923,923,-1,923,923,923,-1,920,923,923,-1,920,923,920,-1,861,861,923,-1,866,924,861,-1,861,866,861,-1,924,924,866,-1,869,870,873,-1,925,869,869,-1,869,869,873,-1,924,869,925,-1,924,869,924,-1,870,870,869,-1,874,870,875,-1,875,870,870,-1,926,874,875,-1,926,927,928,-1,929,926,930,-1,930,926,928,-1,931,926,929,-1,874,926,931,-1,927,932,928,-1,932,933,934,-1,928,932,934,-1,933,935,934,-1,935,936,937,-1,934,935,937,-1,936,938,937,-1,938,939,937,-1,937,939,940,-1,939,941,940,-1,940,941,942,-1,943,940,942,-1,942,944,943,-1,943,945,946,-1,944,945,943,-1,947,945,944,-1,897,947,944,-1,899,947,897,-1,897,948,899,-1,899,948,949,-1,950,899,949,-1,949,951,950,-1,950,952,953,-1,951,952,950,-1,952,952,951,-1,906,952,951,-1,954,952,906,-1,954,906,955,-1,956,954,955,-1,957,956,955,-1,956,957,958,-1,959,960,960,-1,958,959,960,-1,961,956,960,-1,956,958,960,-1,958,962,959,-1,959,962,963,-1,921,959,963,-1,964,921,963,-1,921,964,922,-1,607,605,965,-1,836,607,965,-1,604,966,965,-1,605,604,965,-1,604,602,966,-1,602,601,967,-1,966,602,967,-1,601,606,967,-1,606,603,609,-1,967,606,609,-1,967,609,968,-1,968,609,969,-1,609,610,969,-1,969,610,970,-1,610,611,970,-1,970,611,971,-1,611,612,971,-1,971,612,972,-1,612,613,972,-1,972,613,614,-1,972,614,973,-1,973,614,974,-1,614,615,974,-1,974,615,975,-1,975,615,976,-1,615,616,976,-1,976,616,617,-1,976,617,977,-1,977,617,618,-1,978,977,618,-1,978,618,619,-1,979,978,619,-1,979,619,980,-1,980,619,620,-1,631,980,620,-1,980,631,630,-1,981,980,630,-1,629,981,630,-1,981,629,628,-1,982,981,628,-1,627,982,628,-1,983,982,627,-1,626,983,627,-1,831,623,984,-1,523,523,523,-1,636,635,645,-1,625,636,645,-1,985,833,645,-1,833,831,645,-1,831,984,645,-1,984,625,645,-1,625,624,636,-1,532,532,532,-1,639,638,634,-1,633,639,634,-1,985,645,647,-1,986,985,647,-1,986,647,649,-1,987,986,649,-1,988,989,649,-1,989,987,649,-1,987,990,986,-1,988,649,651,-1,991,988,651,-1,991,651,653,-1,992,991,653,-1,992,653,655,-1,993,992,655,-1,994,995,655,-1,995,993,655,-1,994,655,657,-1,996,994,657,-1,996,657,659,-1,997,996,659,-1,998,999,659,-1,999,997,659,-1,998,659,661,-1,1000,998,661,-1,1001,1002,661,-1,1002,1000,661,-1,1001,661,663,-1,1003,1001,663,-1,1003,663,1004,-1,1005,1003,1004,-1,1006,1007,1004,-1,1007,1005,1004,-1,1006,1008,1009,-1,702,1006,1009,-1,1010,1011,1012,-1,702,1010,1012,-1,1013,674,1014,-1,1015,1013,1016,-1,1016,1013,1014,-1,1012,1013,1015,-1,674,676,1017,-1,1014,674,1017,-1,676,678,1018,-1,1019,676,1020,-1,1020,676,1018,-1,1017,676,1019,-1,680,1021,678,-1,678,1021,1022,-1,678,1022,1023,-1,1023,1018,678,-1,682,1024,680,-1,680,1024,1021,-1,684,1025,682,-1,682,1025,1026,-1,682,1026,1027,-1,1027,1024,682,-1,686,1028,684,-1,684,1028,1025,-1,688,1029,686,-1,686,1029,1028,-1,690,1030,688,-1,1031,1030,1032,-1,688,1030,1031,-1,688,1033,1029,-1,1033,688,1031,-1,692,739,690,-1,690,739,1030,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_8()
		{
			int[] value = {532,532,532,-1,532,532,532,-1,532,532,532,-1,761,762,1032,-1,1032,762,1034,-1,1032,1034,1031,-1,1035,1034,762,-1,1036,1035,762,-1,762,745,1036,-1,1036,745,1037,-1,745,789,1037,-1,783,784,1038,-1,1038,784,760,-1,1039,1038,760,-1,1038,1039,1040,-1,1040,1039,758,-1,754,1040,758,-1,1040,754,1041,-1,1041,754,755,-1,753,1041,755,-1,1041,753,1042,-1,1042,753,752,-1,751,1042,752,-1,1043,1042,751,-1,1044,1042,1045,-1,1045,1042,1043,-1,1044,1045,1046,-1,1046,1045,1047,-1,1046,1047,1048,-1,1048,1047,743,-1,742,1048,743,-1,1049,1048,742,-1,1050,1048,746,-1,746,1048,1049,-1,746,765,1050,-1,1051,1050,764,-1,764,1050,765,-1,764,763,1051,-1,766,1051,740,-1,740,1051,763,-1,766,767,1052,-1,1051,766,1053,-1,766,1052,1053,-1,767,768,1054,-1,767,1054,1052,-1,768,770,1054,-1,769,771,1055,-1,770,769,1056,-1,1056,769,1055,-1,1054,770,1057,-1,770,1056,1057,-1,771,772,1058,-1,1055,771,1058,-1,772,773,1059,-1,1058,772,1059,-1,1059,773,775,-1,774,776,1060,-1,775,774,1061,-1,1061,774,1060,-1,1059,775,1062,-1,1062,775,1061,-1,1060,776,1063,-1,1063,776,1064,-1,776,777,1064,-1,1064,777,778,-1,1065,778,779,-1,1064,778,1065,-1,1066,779,780,-1,1066,1065,779,-1,1067,780,1068,-1,1068,780,781,-1,1067,1066,780,-1,1068,781,782,-1,783,1069,782,-1,1069,1068,782,-1,1038,1070,783,-1,1070,1069,783,-1,786,795,1071,-1,793,786,1072,-1,1072,786,1071,-1,1037,789,1073,-1,1073,789,1074,-1,789,791,1074,-1,1074,791,1075,-1,791,792,1075,-1,792,793,1075,-1,1075,793,1076,-1,1076,793,1072,-1,795,796,1071,-1,796,797,1077,-1,1071,796,1077,-1,1077,797,1078,-1,797,798,1078,-1,1078,798,799,-1,1078,799,1079,-1,1079,799,800,-1,1079,800,801,-1,1079,801,1080,-1,1080,801,802,-1,1081,802,1082,-1,1082,802,803,-1,1080,802,1081,-1,1082,803,1083,-1,1083,803,804,-1,1083,804,805,-1,1083,805,1084,-1,1084,805,809,-1,806,807,1085,-1,1086,809,806,-1,1086,806,1087,-1,1087,806,1085,-1,1085,807,1088,-1,807,808,1088,-1,808,810,1089,-1,1088,808,1089,-1,1084,809,1086,-1,810,811,1089,-1,1089,811,1090,-1,811,812,1090,-1,1091,812,1092,-1,812,813,1092,-1,1090,812,1091,-1,1092,813,1093,-1,813,814,1093,-1,814,815,1093,-1,815,816,1094,-1,1093,815,1094,-1,1094,816,817,-1,1094,817,1095,-1,1095,817,818,-1,1096,818,819,-1,1095,818,1096,-1,1096,819,820,-1,1096,820,1097,-1,1097,820,823,-1,1098,823,1099,-1,1099,823,825,-1,1097,823,1098,-1,1099,825,826,-1,1099,826,1100,-1,1100,826,827,-1,1100,827,1101,-1,1101,827,1102,-1,1102,827,829,-1,829,834,1103,-1,1102,829,1103,-1,1104,982,983,-1,835,1104,983,-1,853,1104,835,-1,1105,1104,853,-1,852,1105,853,-1,851,1105,852,-1,1106,1105,851,-1,850,1106,851,-1,849,1106,850,-1,1107,1106,849,-1,848,1107,849,-1,847,1107,848,-1,846,1107,847,-1,845,1108,1107,-1,846,845,1107,-1,1109,1108,845,-1,844,1109,845,-1,1110,1109,844,-1,843,1110,844,-1,842,1110,843,-1,841,1110,842,-1,840,1111,1110,-1,841,840,1110,-1,840,839,1111,-1,838,1112,1111,-1,839,838,1111,-1,838,837,1112,-1,836,965,1112,-1,837,836,1112,-1,834,1113,1103,-1,834,1114,1113,-1,834,832,990,-1,987,834,990,-1,987,1114,834,-1,532,532,532,-1,532,532,532,-1,532,532,532,-1,1112,965,1115,-1,965,1116,1115,-1,965,966,1116,-1,966,1117,1116,-1,966,967,1117,-1,1117,967,968,-1,1117,968,1118,-1,1118,968,1119,-1,968,969,1119,-1,1119,969,1120,-1,969,970,1120,-1,1120,970,1121,-1,970,971,1121,-1,1121,971,1122,-1,971,972,1122,-1,1122,972,973,-1,1122,973,1123,-1,1123,973,1124,-1,973,974,1124,-1,1124,974,1125,-1,974,975,1125,-1,1125,975,1126,-1,1126,975,1127,-1,975,976,1127,-1,1127,976,977,-1,1127,977,1128,-1,1128,977,978,-1,1129,1128,978,-1,1129,978,979,-1,1130,1129,979,-1,1130,979,1131,-1,1131,979,980,-1,1131,980,981,-1,1132,1131,981,-1,1132,981,982,-1,1133,1132,982,-1,1104,1133,982,-1,523,523,523,-1,1134,1114,989,-1,1135,1134,988,-1,988,1134,989,-1,1136,1137,1138,-1,1136,1138,1139,-1,1136,1139,1140,-1,1140,1139,1141,-1,1140,1141,1142,-1,1142,1141,1143,-1,1142,1143,1144,-1,1144,1145,1142,-1,1142,1145,1146,-1,1146,1145,1147,-1,1146,1147,1148,-1,1148,1147,1149,-1,1148,1149,1147,-1,1148,1147,1150,-1,1150,1147,1151,-1,1150,1151,1152,-1,1152,1151,1153,-1,1152,1153,1154,-1,1154,1155,1152,-1,1152,1155,1156,-1,1156,1155,1157,-1,1156,1157,1158,-1,1158,1157,1159,-1,1158,1159,1160,-1,1161,1162,1163,-1,1164,1162,1160,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_9()
		{
			int[] value = {1163,1162,1164,-1,1163,1165,1161,-1,1166,1167,1168,-1,1165,1167,1161,-1,1169,1167,1165,-1,1170,1167,1169,-1,1168,1167,1170,-1,1168,1171,1166,-1,1172,1173,1171,-1,1171,1173,1166,-1,1174,1173,1171,-1,1171,1173,1174,-1,1171,1175,1172,-1,1176,1177,1178,-1,1175,1177,1172,-1,1179,1177,1175,-1,1180,1177,1179,-1,1178,1177,1180,-1,1178,1181,1176,-1,1181,1182,1176,-1,1183,1182,1181,-1,1184,1182,1183,-1,1034,1185,1033,-1,1029,1185,1186,-1,1033,1185,1029,-1,523,523,523,-1,1185,1034,1035,-1,1187,1035,1188,-1,1188,1035,1036,-1,1187,1185,1035,-1,1036,1037,1189,-1,1189,1037,1190,-1,1191,1188,1036,-1,1191,1036,1189,-1,1190,1037,1192,-1,1037,1073,1192,-1,1040,1193,1038,-1,1193,1070,1038,-1,1041,1194,1040,-1,1194,1193,1040,-1,1042,1195,1041,-1,1195,1194,1041,-1,1044,1195,1042,-1,1046,1196,1044,-1,1044,1197,1195,-1,1196,1197,1044,-1,1198,1199,1046,-1,1048,1198,1046,-1,1199,1196,1046,-1,1050,1198,1048,-1,1050,1051,1200,-1,1050,1200,1198,-1,1051,1053,1200,-1,1052,1054,1201,-1,1053,1052,1202,-1,1052,1201,1202,-1,1200,1053,1203,-1,1053,1202,1203,-1,1054,1057,1201,-1,1055,1058,1204,-1,1056,1055,1205,-1,1205,1055,1204,-1,1057,1056,1206,-1,1056,1205,1206,-1,1201,1057,1207,-1,1057,1206,1207,-1,1058,1059,1208,-1,1204,1058,1208,-1,1208,1059,1062,-1,1060,1063,1209,-1,1061,1060,1210,-1,1210,1060,1209,-1,1062,1061,1211,-1,1211,1061,1210,-1,1208,1062,1212,-1,1212,1062,1211,-1,1209,1063,1213,-1,1213,1063,1214,-1,1063,1064,1214,-1,1214,1064,1065,-1,1215,1065,1066,-1,1215,1214,1065,-1,1216,1066,1067,-1,1216,1215,1066,-1,1217,1067,1218,-1,1218,1067,1068,-1,1217,1216,1067,-1,1218,1068,1069,-1,1070,1219,1069,-1,1219,1218,1069,-1,1193,1220,1070,-1,1220,1219,1070,-1,1072,1071,1221,-1,1221,1071,1222,-1,1071,1077,1222,-1,1076,1072,1223,-1,1223,1072,1224,-1,1224,1072,1221,-1,1073,1074,1192,-1,1192,1074,1225,-1,1225,1074,1226,-1,1074,1075,1226,-1,1226,1075,1223,-1,1075,1076,1223,-1,1077,1078,1222,-1,1222,1078,1079,-1,1222,1079,1080,-1,1222,1080,1227,-1,1227,1080,1081,-1,1228,1081,1082,-1,1227,1081,1229,-1,1229,1081,1228,-1,1228,1082,1230,-1,1230,1082,1083,-1,1230,1083,1084,-1,1230,1084,1231,-1,1231,1084,1086,-1,1087,1085,1232,-1,1232,1085,1233,-1,1233,1085,1234,-1,1085,1088,1234,-1,1235,1086,1232,-1,1232,1086,1087,-1,1231,1086,1235,-1,1234,1088,1236,-1,1088,1089,1236,-1,1089,1090,1236,-1,1236,1090,1237,-1,1090,1091,1237,-1,1237,1091,1238,-1,1238,1091,1239,-1,1091,1092,1239,-1,1239,1092,1240,-1,1092,1093,1240,-1,1093,1094,1240,-1,1240,1094,1095,-1,1240,1095,1096,-1,1240,1096,1241,-1,1241,1096,1097,-1,1242,1097,1243,-1,1243,1097,1098,-1,1241,1097,1242,-1,1243,1098,1099,-1,1243,1099,1244,-1,1244,1099,1100,-1,1244,1100,1245,-1,1245,1100,1246,-1,1246,1100,1101,-1,1246,1101,1102,-1,1246,1102,1247,-1,1102,1103,1248,-1,1247,1102,1248,-1,1248,1103,1249,-1,1103,1250,1249,-1,1103,1113,1250,-1,1251,1133,1104,-1,1105,1251,1104,-1,1252,1251,1105,-1,1106,1252,1105,-1,1253,1252,1106,-1,1107,1253,1106,-1,1108,1253,1107,-1,1108,1254,1253,-1,1255,1254,1108,-1,1109,1255,1108,-1,1256,1255,1109,-1,1257,1256,1109,-1,1110,1257,1109,-1,1111,1257,1110,-1,1111,1258,1257,-1,1111,1112,1258,-1,1112,1115,1258,-1,1250,1113,1259,-1,1113,1134,1259,-1,1113,1114,1134,-1,1258,1115,1260,-1,1115,1261,1260,-1,1115,1116,1261,-1,1116,1262,1261,-1,1116,1117,1262,-1,1117,1118,1262,-1,1262,1118,1263,-1,1118,1264,1263,-1,1118,1119,1264,-1,1264,1119,1265,-1,1119,1120,1265,-1,1265,1120,1266,-1,1120,1121,1266,-1,1266,1121,1267,-1,1121,1122,1267,-1,1267,1122,1123,-1,1267,1123,1268,-1,1268,1123,1269,-1,1123,1124,1269,-1,1269,1124,1270,-1,1124,1125,1270,-1,1270,1125,1271,-1,1125,1126,1271,-1,1271,1126,1272,-1,1272,1126,1273,-1,1126,1127,1273,-1,1273,1127,1128,-1,1274,1273,1128,-1,1274,1128,1129,-1,1275,1274,1129,-1,1275,1129,1130,-1,1276,1275,1130,-1,1276,1130,1277,-1,1277,1130,1131,-1,1277,1131,1132,-1,1278,1277,1132,-1,1278,1132,1133,-1,1279,1278,1133,-1,1251,1279,1133,-1,1259,1134,1280,-1,1134,1281,1280,-1,1134,1135,1281,-1,1280,1135,1136,-1,1281,1135,1280,-1,1280,1136,1282,-1,1136,1283,1282,-1,1136,1140,1283,-1,1283,1140,1284,-1,1284,1140,1142,-1,1142,1146,1285,-1,1284,1142,1286,-1,1286,1142,1287,-1,1142,1285,1287,-1,1285,1146,1148,-1,1148,1150,1288,-1,1287,1285,1148,-1,1287,1148,1289,-1,1289,1148,1288,-1,1288,1150,1290,-1,1290,1150,1152,-1,1291,1290,1152,-1,1291,1152,1292,-1,1292,1152,1293,-1,1152,1156,1293,-1,1293,1156,1158,-1,1158,1160,1294,-1,1292,1293,1158,-1,1292,1158,1295,-1,1295,1158,1294,-1,1296,1160,1297,-1,1297,1160,1162,-1,1294,1160,1296,-1,1298,1162,1299,-1,1162,1300,1299,-1,1162,1161,1300,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_10()
		{
			int[] value = {1297,1162,1298,-1,1300,1161,1167,-1,1299,1167,1301,-1,1167,1302,1301,-1,1167,1166,1302,-1,1300,1167,1299,-1,1303,1166,1173,-1,1302,1166,1303,-1,1303,1173,1304,-1,1304,1173,1305,-1,1173,1306,1305,-1,1173,1172,1306,-1,1306,1172,1177,-1,1307,1177,1308,-1,1177,1176,1308,-1,1305,1306,1177,-1,1305,1177,1307,-1,1308,1176,1309,-1,1309,1176,1182,-1,1310,1309,1182,-1,1310,1182,1311,-1,1182,1186,1311,-1,1311,1186,1312,-1,1312,1186,1185,-1,1311,1312,1185,-1,1311,1185,1187,-1,1313,1311,1187,-1,1313,1187,1314,-1,1314,1187,1191,-1,1191,1187,1188,-1,1315,1191,1189,-1,1315,1189,1316,-1,1189,1190,1316,-1,1316,1190,1317,-1,1317,1190,1318,-1,1190,1192,1318,-1,1319,1314,1191,-1,1319,1191,1315,-1,1318,1192,1320,-1,1192,1225,1320,-1,1194,1321,1193,-1,1321,1220,1193,-1,1195,1322,1194,-1,1322,1321,1194,-1,1197,1322,1195,-1,1199,1323,1196,-1,1196,1324,1197,-1,1323,1324,1196,-1,1197,1325,1322,-1,1324,1325,1197,-1,1200,1326,1198,-1,1198,1326,1199,-1,1326,1327,1199,-1,1327,1323,1199,-1,1200,1203,1326,-1,1202,1201,1328,-1,1201,1207,1328,-1,1203,1202,1329,-1,1202,1328,1329,-1,1326,1203,1330,-1,1203,1329,1330,-1,1204,1208,1331,-1,1205,1204,1332,-1,1332,1204,1331,-1,1206,1205,1333,-1,1205,1332,1333,-1,1207,1206,1334,-1,1206,1333,1334,-1,1328,1207,1335,-1,1207,1334,1335,-1,1331,1208,1212,-1,1336,1271,1213,-1,1271,1272,1213,-1,1336,1213,1214,-1,1336,1214,1215,-1,1337,1215,1216,-1,1337,1336,1215,-1,1216,1217,1338,-1,1338,1337,1216,-1,1217,1339,1340,-1,1339,1217,1218,-1,1340,1338,1217,-1,1339,1218,1219,-1,1220,1341,1219,-1,1341,1339,1219,-1,1321,1342,1220,-1,1342,1341,1220,-1,1343,1221,1344,-1,1221,1222,1344,-1,1224,1221,1343,-1,1344,1222,1227,-1,1226,1223,1345,-1,1345,1223,1346,-1,1346,1223,1343,-1,1223,1224,1343,-1,1225,1226,1320,-1,1320,1226,1345,-1,1347,1227,1229,-1,1344,1227,1347,-1,1347,1229,1228,-1,1347,1228,1348,-1,1348,1228,1230,-1,1348,1230,1349,-1,1349,1230,1350,-1,1350,1230,1231,-1,1350,1231,1235,-1,1351,1235,1232,-1,1351,1232,1352,-1,1352,1232,1353,-1,1232,1233,1353,-1,1353,1233,1354,-1,1233,1234,1354,-1,1234,1236,1354,-1,1350,1235,1351,-1,1354,1236,1355,-1,1355,1236,1356,-1,1236,1237,1356,-1,1356,1237,1357,-1,1237,1238,1357,-1,1238,1239,1357,-1,1239,1240,1358,-1,1357,1239,1358,-1,1358,1240,1241,-1,1358,1241,1359,-1,1359,1241,1242,-1,1359,1242,1243,-1,1359,1243,1360,-1,1360,1243,1361,-1,1361,1243,1244,-1,1361,1244,1362,-1,1362,1244,1245,-1,1362,1245,1246,-1,1362,1246,1363,-1,1363,1246,1247,-1,1247,1248,1364,-1,1365,1247,1364,-1,1363,1247,1365,-1,1248,1249,1366,-1,1364,1248,1366,-1,1366,1249,1367,-1,1249,1368,1367,-1,1249,1259,1368,-1,1250,1259,1249,-1,1369,1279,1251,-1,1252,1369,1251,-1,1370,1369,1252,-1,1253,1370,1252,-1,1254,1370,1253,-1,1254,1371,1370,-1,1372,1371,1254,-1,1255,1372,1254,-1,1373,1372,1255,-1,1256,1373,1255,-1,1374,1373,1256,-1,1375,1374,1256,-1,1257,1375,1256,-1,1258,1375,1257,-1,1258,1260,1375,-1,1368,1259,1376,-1,1259,1280,1376,-1,1375,1260,1377,-1,1260,1378,1377,-1,1260,1261,1378,-1,1261,1379,1378,-1,1261,1262,1379,-1,1262,1263,1379,-1,1379,1263,1380,-1,1263,1381,1380,-1,1263,1264,1381,-1,1264,1382,1381,-1,1264,1265,1382,-1,1382,1265,1383,-1,1265,1266,1383,-1,1383,1266,1384,-1,1266,1267,1384,-1,1384,1267,1268,-1,1272,1385,1209,-1,1272,1209,1213,-1,1385,1272,1273,-1,1385,1273,1274,-1,1386,1385,1274,-1,1386,1274,1275,-1,1387,1386,1275,-1,1387,1275,1276,-1,1388,1387,1276,-1,1388,1276,1389,-1,1389,1276,1277,-1,1389,1277,1278,-1,1390,1389,1278,-1,1390,1278,1279,-1,1391,1390,1279,-1,1369,1391,1279,-1,1376,1280,1282,-1,1376,1282,1392,-1,1392,1282,1393,-1,1393,1282,1286,-1,1282,1284,1286,-1,1282,1283,1284,-1,1393,1286,1394,-1,1286,1289,1394,-1,1286,1287,1289,-1,1289,1288,1291,-1,1288,1290,1291,-1,1394,1289,1395,-1,1395,1289,1396,-1,1289,1291,1396,-1,1396,1291,1292,-1,1396,1292,1397,-1,1397,1292,1398,-1,1398,1292,1295,-1,1399,1294,1296,-1,1295,1294,1400,-1,1400,1294,1399,-1,1398,1295,1400,-1,1296,1297,1399,-1,1399,1297,1401,-1,1401,1297,1298,-1,1298,1299,1402,-1,1401,1298,1402,-1,1403,1299,1404,-1,1299,1301,1404,-1,1402,1299,1403,-1,1404,1301,1304,-1,1301,1303,1304,-1,1301,1302,1303,-1,1404,1304,1405,-1,1405,1304,1406,-1,1406,1304,1307,-1,1304,1305,1307,-1,1307,1310,1407,-1,1307,1308,1310,-1,1406,1307,1407,-1,1308,1309,1310,-1,1407,1310,1408,-1,1408,1310,1313,-1,1310,1311,1313,-1,1408,1313,1319,-1,1319,1313,1314,-1,1409,1315,1410,-1,1410,1315,1411,-1,1411,1315,1316,-1,1409,1319,1315,-1,1411,1316,1317,-1,1412,1411,1317,-1,1317,1318,1412,-1,1412,1318,1413,-1,1413,1318,1414,-1,1318,1320,1414,-1,1415,1408,1319,-1,1415,1319,1409,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_11()
		{
			int[] value = {1414,1320,1416,-1,1320,1345,1416,-1,1322,1417,1321,-1,1417,1342,1321,-1,1325,1417,1322,-1,1418,1323,1327,-1,1419,1324,1323,-1,1418,1419,1323,-1,1420,1325,1324,-1,1419,1420,1324,-1,1421,1417,1325,-1,1420,1421,1325,-1,1326,1330,1327,-1,1330,1422,1327,-1,1422,1418,1327,-1,1329,1328,1423,-1,1328,1335,1423,-1,1330,1329,1424,-1,1329,1423,1424,-1,1424,1422,1330,-1,1209,1386,1210,-1,1385,1386,1209,-1,1210,1387,1211,-1,1386,1387,1210,-1,1211,1388,1212,-1,1387,1388,1211,-1,1212,1425,1331,-1,1388,1425,1212,-1,1336,1337,1270,-1,1271,1336,1270,-1,1337,1338,1269,-1,1270,1337,1269,-1,1340,1268,1338,-1,1338,1268,1269,-1,1426,1384,1340,-1,1340,1384,1268,-1,1427,1383,1426,-1,1426,1383,1384,-1,1428,1382,1427,-1,1427,1382,1383,-1,1421,1381,1428,-1,1428,1381,1382,-1,1420,1380,1421,-1,1421,1380,1381,-1,1419,1429,1420,-1,1420,1429,1380,-1,1418,1430,1419,-1,1419,1430,1429,-1,1418,1422,1431,-1,1418,1431,1430,-1,1421,1428,1417,-1,1428,1342,1417,-1,1428,1427,1342,-1,1427,1341,1342,-1,1427,1426,1341,-1,1339,1341,1426,-1,1426,1340,1339,-1,1346,1343,1432,-1,1343,1347,1432,-1,1343,1344,1347,-1,1345,1346,1416,-1,1416,1346,1433,-1,1433,1346,1432,-1,1432,1347,1434,-1,1434,1347,1348,-1,1434,1348,1349,-1,1434,1349,1435,-1,1435,1349,1436,-1,1436,1349,1350,-1,1436,1350,1437,-1,1437,1350,1351,-1,1437,1351,1352,-1,1352,1353,1438,-1,1437,1352,1439,-1,1439,1352,1438,-1,1353,1354,1438,-1,1438,1354,1440,-1,1354,1355,1440,-1,1440,1355,1441,-1,1441,1355,1442,-1,1355,1356,1442,-1,1356,1357,1442,-1,1442,1357,1443,-1,1443,1357,1359,-1,1357,1358,1359,-1,1443,1359,1360,-1,1443,1360,1444,-1,1444,1360,1445,-1,1445,1360,1361,-1,1445,1361,1362,-1,1445,1362,1446,-1,1446,1362,1363,-1,1446,1363,1447,-1,1447,1363,1448,-1,1448,1363,1365,-1,1365,1364,1449,-1,1448,1365,1449,-1,1364,1366,1449,-1,1449,1366,1450,-1,1450,1366,1451,-1,1366,1367,1451,-1,1367,1392,1452,-1,1367,1376,1392,-1,1368,1376,1367,-1,1451,1367,1452,-1,1453,1391,1369,-1,1370,1453,1369,-1,1371,1453,1370,-1,1371,1454,1453,-1,1455,1454,1371,-1,1455,1371,1372,-1,1456,1455,1372,-1,1456,1372,1373,-1,1457,1456,1373,-1,1457,1373,1374,-1,1431,1457,1374,-1,1377,1431,1374,-1,1375,1377,1374,-1,1430,1431,1377,-1,1377,1378,1430,-1,1378,1429,1430,-1,1378,1379,1429,-1,1379,1380,1429,-1,1458,1332,1331,-1,1331,1425,1458,-1,1459,1333,1332,-1,1458,1459,1332,-1,1454,1334,1333,-1,1333,1459,1454,-1,1455,1335,1334,-1,1334,1454,1455,-1,1423,1335,1456,-1,1456,1335,1455,-1,1424,1423,1457,-1,1457,1423,1456,-1,1431,1422,1424,-1,1431,1424,1457,-1,1454,1459,1453,-1,1453,1459,1391,-1,1459,1458,1391,-1,1458,1390,1391,-1,1458,1425,1390,-1,1425,1389,1390,-1,1425,1388,1389,-1,1392,1393,1452,-1,1452,1393,1460,-1,1460,1393,1394,-1,1461,1394,1395,-1,1460,1394,1461,-1,1395,1396,1397,-1,1461,1395,1462,-1,1462,1395,1463,-1,1395,1397,1463,-1,1463,1397,1464,-1,1464,1397,1398,-1,1464,1398,1465,-1,1465,1398,1466,-1,1398,1400,1466,-1,1466,1400,1399,-1,1466,1399,1467,-1,1467,1399,1468,-1,1399,1401,1468,-1,1468,1401,1402,-1,1469,1402,1470,-1,1402,1403,1470,-1,1468,1402,1469,-1,1403,1404,1405,-1,1470,1403,1471,-1,1471,1403,1405,-1,1471,1405,1472,-1,1472,1405,1473,-1,1405,1406,1473,-1,1406,1407,1474,-1,1473,1406,1474,-1,1474,1407,1415,-1,1415,1407,1408,-1,1475,1415,1409,-1,1475,1409,1476,-1,1476,1409,1410,-1,1476,1410,1411,-1,1476,1411,1477,-1,1477,1411,1412,-1,1478,1477,1412,-1,1478,1412,1479,-1,1412,1413,1479,-1,1413,1414,1479,-1,1479,1414,1480,-1,1414,1416,1480,-1,1473,1474,1415,-1,1473,1415,1481,-1,1481,1415,1475,-1,1416,1433,1482,-1,1480,1416,1483,-1,1483,1416,1482,-1,1433,1432,1482,-1,1482,1432,1434,-1,1482,1434,1484,-1,1484,1434,1435,-1,1484,1435,1436,-1,1484,1436,1485,-1,1485,1436,1486,-1,1486,1436,1437,-1,1486,1437,1487,-1,1487,1437,1439,-1,1439,1438,1487,-1,1487,1438,1488,-1,1438,1440,1488,-1,1488,1440,1489,-1,1489,1440,1490,-1,1440,1441,1490,-1,1441,1442,1490,-1,1490,1442,1491,-1,1442,1443,1491,-1,1491,1443,1444,-1,1491,1444,1445,-1,1491,1445,1492,-1,1492,1445,1493,-1,1493,1445,1446,-1,1493,1446,1494,-1,1494,1446,1447,-1,1494,1447,1448,-1,1494,1448,1495,-1,1448,1449,1496,-1,1495,1448,1496,-1,1449,1450,1497,-1,1496,1449,1497,-1,1450,1451,1497,-1,1497,1451,1498,-1,1451,1452,1498,-1,1498,1452,1499,-1,1499,1452,1461,-1,1452,1460,1461,-1,1499,1461,1462,-1,1500,1462,1501,-1,1462,1464,1501,-1,1462,1463,1464,-1,1499,1462,1502,-1,1502,1462,1500,-1,1501,1464,1503,-1,1503,1464,1465,-1,1503,1465,1504,-1,1504,1465,1505,-1,1465,1467,1505,-1,1465,1466,1467,-1,1467,1468,1469,-1,1505,1467,1469,-1,1505,1469,1504,-1,1504,1469,1506,-1,1469,1470,1506,-1,1470,1471,1472,-1};
			return value;
		}
		private int[] getIndexedFaceSet_10_28_normalIndex_12()
		{
			int[] value = {1506,1470,1507,-1,1507,1470,1472,-1,1507,1472,1508,-1,1508,1472,1509,-1,1509,1472,1481,-1,1472,1473,1481,-1,1510,1475,1476,-1,1509,1481,1475,-1,1509,1475,1511,-1,1511,1475,1510,-1,1510,1476,1512,-1,1512,1476,1477,-1,1512,1477,1478,-1,1513,1512,1478,-1,1478,1479,1513,-1,1513,1479,1514,-1,1479,1480,1514,-1,1514,1480,1515,-1,1515,1480,1516,-1,1480,1483,1516,-1,1483,1482,1484,-1,1483,1484,1516,-1,1516,1484,1517,-1,1517,1484,1485,-1,1517,1485,1486,-1,1517,1486,1518,-1,1518,1486,1519,-1,1519,1486,1487,-1,1487,1488,1519,-1,1519,1488,1520,-1,1520,1488,1521,-1,1488,1489,1521,-1,1489,1490,1521,-1,1521,1490,1522,-1,1522,1490,1492,-1,1490,1491,1492,-1,1522,1492,1493,-1,1522,1493,1523,-1,1523,1493,1524,-1,1524,1493,1494,-1,1524,1494,1525,-1,1525,1494,1495,-1,1495,1496,1526,-1,1525,1495,1526,-1,1496,1497,1526,-1,1526,1497,1527,-1,1497,1498,1527,-1,1527,1498,1528,-1,1528,1498,1502,-1,1498,1499,1502,-1,1500,1503,1529,-1,1500,1501,1503,-1,1530,1502,1500,-1,1530,1500,1531,-1,1531,1500,1529,-1,1528,1502,1530,-1,1529,1503,1532,-1,1532,1503,1504,-1,1504,1506,1532,-1,1532,1506,1533,-1,1533,1506,1508,-1,1506,1507,1508,-1,1533,1508,1534,-1,1534,1508,1535,-1,1508,1509,1535,-1,1535,1509,1511,-1,1535,1511,1510,-1,1535,1510,1536,-1,1536,1510,1537,-1,1537,1510,1512,-1,1537,1512,1513,-1,1538,1537,1513,-1,1513,1514,1538,-1,1538,1514,1539,-1,1539,1514,1540,-1,1514,1515,1540,-1,1515,1516,1540,-1,1540,1516,1517,-1,1540,1517,1541,-1,1541,1517,1518,-1,1541,1518,1519,-1,1541,1519,1542,-1,1542,1519,1543,-1,1519,1520,1543,-1,1520,1521,1543,-1,1543,1521,1544,-1,1521,1522,1544,-1,1544,1522,1523,-1,1544,1523,1524,-1,1545,1524,1546,-1,1546,1524,1525,-1,1544,1524,1545,-1,1525,1526,1547,-1,1546,1525,1547,-1,1526,1527,1547,-1,1547,1527,1548,-1,1548,1527,1530,-1,1527,1528,1530,-1,1531,1529,1532,-1,1548,1530,1549,-1,1549,1530,1531,-1,1550,1531,1551,-1,1531,1532,1551,-1,1549,1531,1550,-1,1532,1533,1534,-1,1551,1532,1534,-1,1551,1534,1550,-1,1550,1534,1552,-1,1534,1535,1552,-1,1552,1535,1536,-1,1552,1536,1537,-1,1552,1537,1553,-1,1553,1537,1538,-1,1554,1553,1538,-1,1554,1538,1555,-1,1538,1539,1555,-1,1539,1540,1555,-1,1555,1540,1541,-1,1556,1541,1542,-1,1555,1541,1556,-1,1542,1543,1556,-1,1556,1543,1557,-1,1543,1544,1557,-1,1557,1544,1545,-1,1557,1545,1546,-1,1557,1546,1558,-1,1546,1547,1559,-1,1558,1546,1559,-1,1547,1548,1549,-1,1559,1547,1549,-1,1559,1549,1550,-1,1559,1550,1560,-1,1560,1550,1553,-1,1550,1552,1553,-1,1560,1553,1554,-1,1561,1560,1554,-1,1554,1555,1556,-1,1554,1556,1561,-1,1561,1556,1558,-1,1556,1557,1558,-1,1558,1559,1560,-1,1561,1558,1560,-1};
			return value;
		}


		/** Define subarrays using type float[] */
		private float[] getCoordinate_11_28_point_1()
		{
			float[] value = {-44.6674f,-1.12054f,0.0f,-44.7852f,-0.376604f,0.0f,-44.7263f,-0.376604f,-0.935713f,-44.7852f,0.376604f,0.0f,-44.7263f,0.376604f,-0.935713f,-44.7263f,-0.376604f,0.935713f,-44.7263f,0.376604f,0.935713f,-44.38f,-1.83688f,-0.86716f,-44.6099f,-1.12054f,-0.912673f,-44.6099f,-1.12054f,0.912673f,-44.38f,-1.83688f,0.86716f,-44.4346f,-1.83688f,0.0f,-44.551f,-0.376604f,-1.84839f,-44.551f,0.376604f,-1.84839f,-44.6099f,1.12054f,-0.912673f,-44.6674f,1.12054f,0.0f,-44.6099f,1.12054f,0.912673f,-44.551f,0.376604f,1.84839f,-44.551f,-0.376604f,1.84839f,-43.8924f,-2.50799f,-1.58088f,-44.2176f,-1.83688f,-1.71297f,-44.0927f,-2.50799f,0.0f,-44.0423f,-2.50799f,-0.800294f,-44.4389f,-1.12054f,-1.80287f,-44.4389f,-1.12054f,1.80287f,-44.2176f,-1.83688f,1.71297f,-43.8924f,-2.50799f,1.58088f,-44.0423f,-2.50799f,0.800294f,-44.1587f,-1.12054f,-2.64868f,-44.2636f,-0.376604f,-2.71555f,-44.2636f,0.376604f,-2.71555f,-44.1587f,1.12054f,-2.64868f,-44.4389f,1.12054f,-1.80287f,-44.38f,1.83688f,-0.86716f,-44.2176f,1.83688f,-1.71297f,-44.4346f,1.83688f,0.0f,-44.38f,1.83688f,0.86716f,-44.2176f,1.83688f,1.71297f,-44.4389f,1.12054f,1.80287f,-44.1587f,1.12054f,2.64868f,-44.2636f,0.376604f,2.71555f,-44.2636f,-0.376604f,2.71555f,-44.1587f,-1.12054f,2.64868f,-43.605f,-3.11735f,-0.713722f,-43.4713f,-3.11735f,-1.40987f,-43.2521f,-3.11735f,-2.0713f,-43.6466f,-2.50799f,-2.32254f,-43.9513f,-1.83688f,-2.51659f,-43.6499f,-3.11735f,0.0f,-43.605f,-3.11735f,0.713722f,-43.9513f,-1.83688f,2.51659f,-43.6466f,-2.50799f,2.32254f,-43.2521f,-3.11735f,2.0713f,-43.4713f,-3.11735f,1.40987f,-43.5877f,-1.83688f,-3.25826f,-43.776f,-1.12054f,-3.42927f,-43.8713f,-0.376604f,-3.51584f,-43.8713f,0.376604f,-3.51584f,-43.776f,1.12054f,-3.42927f,-43.5877f,1.83688f,-3.25826f,-43.9513f,1.83688f,-2.51659f,-43.8924f,2.50799f,-1.58088f,-44.0423f,2.50799f,-0.800294f,-44.0927f,2.50799f,0.0f,-43.6466f,2.50799f,-2.32254f,-44.0423f,2.50799f,0.800294f,-43.8924f,2.50799f,1.58088f,-43.6466f,2.50799f,2.32254f,-43.9513f,1.83688f,2.51659f,-43.776f,1.12054f,3.42927f,-43.5877f,1.83688f,3.25826f,-43.8713f,0.376604f,3.51584f,-43.8713f,-0.376604f,3.51584f,-43.776f,-1.12054f,3.42927f,-43.5877f,-1.83688f,3.25826f,-43.079f,-3.64995f,-0.609576f,-42.9648f,-3.64995f,-1.20414f,-43.311f,-2.50799f,-3.00702f,-42.7776f,-3.64995f,-1.76906f,-42.522f,-3.64995f,-2.29042f,-42.9529f,-3.11735f,-2.68173f,-43.079f,-3.64995f,0.609576f,-43.1174f,-3.64995f,0.0f,-42.9648f,-3.64995f,1.20414f,-43.311f,-2.50799f,3.00702f,-42.9529f,-3.11735f,2.68173f,-42.522f,-3.64995f,2.29042f,-42.7776f,-3.64995f,1.76906f,-42.894f,-2.50799f,-3.61745f,-43.1358f,-1.83688f,-3.91969f,-43.3003f,-1.12054f,-4.12542f,-43.3836f,-0.376604f,-4.22956f,-43.3836f,0.376604f,-4.22956f,-43.3003f,1.12054f,-4.12542f,-43.1358f,1.83688f,-3.91969f,-42.894f,2.50799f,-3.61745f,-43.311f,2.50799f,-3.00702f,-43.4713f,3.11735f,-1.40987f,-43.605f,3.11735f,-0.713722f,-43.2521f,3.11735f,-2.0713f};
			return value;
		}
		private float[] getCoordinate_11_28_point_2()
		{
			float[] value = {-43.6499f,3.11735f,0.0f,-43.605f,3.11735f,0.713722f,-43.4713f,3.11735f,1.40987f,-43.2521f,3.11735f,2.0713f,-43.311f,2.50799f,3.00702f,-43.1358f,1.83688f,3.91969f,-43.3003f,1.12054f,4.12542f,-43.3836f,0.376604f,4.22956f,-42.894f,2.50799f,3.61745f,-43.3836f,-0.376604f,4.22956f,-43.3003f,-1.12054f,4.12542f,-43.1358f,-1.83688f,3.91969f,-42.894f,-2.50799f,3.61745f,-42.508f,-4.09267f,0.0f,-42.4771f,-4.09267f,-0.490421f,-42.3852f,-4.09267f,-0.968766f,-42.2346f,-4.09267f,-1.42326f,-42.029f,-4.09267f,-1.8427f,-41.7734f,-4.09267f,-2.21677f,-42.2043f,-3.64995f,-2.75537f,-42.5809f,-3.11735f,-3.22613f,-42.3852f,-4.09267f,0.968766f,-42.4771f,-4.09267f,0.490421f,-42.2346f,-4.09267f,1.42326f,-42.5809f,-3.11735f,3.22613f,-42.2043f,-3.64995f,2.75537f,-41.7734f,-4.09267f,2.21677f,-42.029f,-4.09267f,1.8427f,-42.1454f,-3.11735f,-3.69109f,-42.4056f,-2.50799f,-4.1388f,-42.6066f,-1.83688f,-4.48461f,-42.7434f,-1.12054f,-4.71998f,-42.8127f,-0.376604f,-4.83914f,-42.8127f,0.376604f,-4.83914f,-42.7434f,1.12054f,-4.71998f,-42.6066f,1.83688f,-4.48461f,-42.4056f,2.50799f,-4.1388f,-42.1454f,3.11735f,-3.69109f,-42.5809f,3.11735f,-3.22613f,-42.9529f,3.11735f,-2.68173f,-42.9648f,3.64995f,-1.20414f,-43.079f,3.64995f,-0.609576f,-42.522f,3.64995f,-2.29042f,-42.7776f,3.64995f,-1.76906f,-43.079f,3.64995f,0.609576f,-43.1174f,3.64995f,0.0f,-42.9648f,3.64995f,1.20414f,-42.7776f,3.64995f,1.76906f,-42.522f,3.64995f,2.29042f,-42.9529f,3.11735f,2.68173f,-42.6066f,1.83688f,4.48461f,-42.7434f,1.12054f,4.71998f,-42.8127f,0.376604f,4.83914f,-42.8127f,-0.376604f,4.83914f,-42.5809f,3.11735f,3.22613f,-42.1454f,3.11735f,3.69109f,-42.4056f,2.50799f,4.1388f,-42.7434f,-1.12054f,4.71998f,-42.6066f,-1.83688f,4.48461f,-42.4056f,-2.50799f,4.1388f,-42.1454f,-3.11735f,3.69109f,-41.8369f,-4.43462f,0.0f,-41.8143f,-4.43462f,-0.359189f,-41.6367f,-4.43462f,-1.04241f,-41.747f,-4.43462f,-0.709534f,-41.4861f,-4.43462f,-1.34961f,-41.8323f,-3.64995f,-3.15249f,-41.2989f,-4.43462f,-1.62359f,-41.0797f,-4.43462f,-1.85758f,-41.4742f,-4.09267f,-2.53626f,-41.6367f,-4.43462f,1.04241f,-41.747f,-4.43462f,0.709534f,-41.8143f,-4.43462f,0.359189f,-41.8323f,-3.64995f,3.15249f,-41.4742f,-4.09267f,2.53626f,-41.0797f,-4.43462f,1.85758f,-41.2989f,-4.43462f,1.62359f,-41.4861f,-4.43462f,1.34961f,-41.657f,-3.11735f,-4.06516f,-41.858f,-2.50799f,-4.55825f,-42.1189f,-1.12054f,-5.19833f,-42.0133f,-1.83688f,-4.9391f,-42.1724f,-0.376604f,-5.32956f,-42.1724f,0.376604f,-5.32956f,-42.1189f,1.12054f,-5.19833f,-42.0133f,1.83688f,-4.9391f,-41.858f,2.50799f,-4.55825f,-41.657f,3.11735f,-4.06516f,-42.2043f,3.64995f,-2.75537f,-41.8323f,3.64995f,-3.15249f,-42.2346f,4.09267f,-1.42326f,-42.3852f,4.09267f,-0.968766f,-42.4771f,4.09267f,-0.490421f,-42.508f,4.09267f,0.0f,-41.7734f,4.09267f,-2.21677f,-42.029f,4.09267f,-1.8427f,-42.4771f,4.09267f,0.490421f,-42.3852f,4.09267f,0.968766f,-42.2346f,4.09267f,1.42326f,-42.2043f,3.64995f,2.75537f};
			return value;
		}
		private float[] getCoordinate_11_28_point_3()
		{
			float[] value = {-42.029f,4.09267f,1.8427f,-41.7734f,4.09267f,2.21677f,-42.0133f,1.83688f,4.9391f,-42.1189f,1.12054f,5.19833f,-41.858f,2.50799f,4.55825f,-42.1724f,0.376604f,5.32956f,-42.1724f,-0.376604f,5.32956f,-41.8323f,3.64995f,3.15249f,-41.657f,3.11735f,4.06516f,-42.1189f,-1.12054f,5.19833f,-42.0133f,-1.83688f,4.9391f,-41.858f,-2.50799f,4.55825f,-41.657f,-3.11735f,4.06516f,-41.1067f,-4.66738f,0.219113f,-41.1205f,-4.66738f,0.0f,-41.1067f,-4.66738f,-0.219113f,-41.0657f,-4.66738f,-0.432832f,-40.9984f,-4.66738f,-0.635892f,-40.9065f,-4.66738f,-0.823294f,-40.7923f,-4.66738f,-0.990425f,-41.1386f,-4.09267f,-2.7933f,-41.4152f,-3.64995f,-3.47198f,-18.2709f,-9.6f,-4.06737f,-40.8339f,-4.43462f,-2.04584f,-16.1803f,-9.6f,-5.87785f,-16.3898f,-9.6f,-5.69642f,-17.3205f,-9.56774f,-5.0f,-18.0614f,-9.6f,-4.24879f,-40.9065f,-4.66738f,0.823294f,-40.9984f,-4.66738f,0.635892f,-41.0657f,-4.66738f,0.432832f,-41.4152f,-3.64995f,3.47198f,-41.1386f,-4.09267f,2.7933f,-40.8339f,-4.43462f,2.04584f,-16.1803f,-9.6f,5.87785f,-18.2709f,-9.6f,4.06737f,-18.0614f,-9.6f,4.24879f,-17.3205f,-9.56774f,5.0f,-16.3898f,-9.6f,5.69642f,-40.7923f,-4.66738f,0.990425f,-40.9633f,-3.64995f,-3.70597f,-41.1279f,-3.11735f,-4.33913f,-41.2647f,-2.50799f,-4.86545f,-41.3704f,-1.83688f,-5.27197f,-41.4423f,-1.12054f,-5.54867f,-41.4787f,-0.376604f,-5.68875f,-41.4787f,0.376604f,-5.68875f,-41.4423f,1.12054f,-5.54867f,-41.3704f,1.83688f,-5.27197f,-41.2647f,2.50799f,-4.86545f,-40.9633f,3.64995f,-3.70597f,-41.4152f,3.64995f,-3.47198f,-41.1279f,3.11735f,-4.33913f,-41.1386f,4.09267f,-2.7933f,-41.4742f,4.09267f,-2.53626f,-41.6367f,4.43462f,-1.04241f,-41.747f,4.43462f,-0.709534f,-41.8143f,4.43462f,-0.359189f,-41.8369f,4.43462f,0.0f,-41.0797f,4.43462f,-1.85758f,-41.2989f,4.43462f,-1.62359f,-41.4861f,4.43462f,-1.34961f,-41.8143f,4.43462f,0.359189f,-41.747f,4.43462f,0.709534f,-41.6367f,4.43462f,1.04241f,-41.4861f,4.43462f,1.34961f,-41.2989f,4.43462f,1.62359f,-41.0797f,4.43462f,1.85758f,-41.4742f,4.09267f,2.53626f,-41.3704f,1.83688f,5.27197f,-41.4423f,1.12054f,5.54867f,-41.4787f,0.376604f,5.68875f,-41.2647f,2.50799f,4.86545f,-41.4787f,-0.376604f,5.68875f,-41.1386f,4.09267f,2.7933f,-41.4152f,3.64995f,3.47198f,-40.9633f,3.64995f,3.70597f,-41.1279f,3.11735f,4.33913f,-41.4423f,-1.12054f,5.54867f,-41.3704f,-1.83688f,5.27197f,-41.2647f,-2.50799f,4.86545f,-41.1279f,-3.11735f,4.33913f,-40.9633f,-3.64995f,3.70597f,-20.0f,-9.6f,0.0f,-19.563f,-9.6f,-2.07912f,-19.6099f,-9.6f,-1.85572f,-19.8289f,-9.57592f,-1.30526f,-18.3299f,-9.6f,-3.97655f,-18.4776f,-9.5879f,-3.82683f,-19.3185f,-9.57924f,-2.58819f,-19.4549f,-9.6f,-2.24543f,-13.3826f,-9.6f,-7.43145f,-13.6166f,-9.6f,-7.30149f,-14.1421f,-9.56862f,-7.07107f,-15.8671f,-9.5817f,-6.08761f,-16.0526f,-9.6f,-5.94881f,-18.4776f,-18.0f,-3.82683f,-17.3205f,-18.0f,-5.0f,-15.8671f,-18.0f,-6.08761f,-19.563f,-9.6f,2.07912f};
			return value;
		}
		private float[] getCoordinate_11_28_point_4()
		{
			float[] value = {-19.4549f,-9.6f,2.24543f,-19.3185f,-9.57924f,2.58819f,-18.4776f,-9.5879f,3.82683f,-18.3299f,-9.6f,3.97655f,-19.8289f,-9.57592f,1.30526f,-19.6099f,-9.6f,1.85572f,-13.3826f,-9.6f,7.43145f,-16.0526f,-9.6f,5.94881f,-15.8671f,-9.5817f,6.08761f,-14.1421f,-9.56862f,7.07107f,-13.6166f,-9.6f,7.30149f,-17.3205f,-18.0f,5.0f,-15.8671f,-18.0f,6.08761f,-18.4776f,-18.0f,3.82683f,-10.0f,-9.6f,-8.66025f,-12.1752f,-9.5411f,-7.93353f,-13.0192f,-9.6f,-7.56348f,-40.6402f,-2.50799f,-5.05286f,-40.6937f,-1.83688f,-5.47503f,-40.7301f,-1.12054f,-5.76239f,-40.7486f,-0.376604f,-5.90786f,-40.7486f,0.376604f,-5.90786f,-40.7301f,1.12054f,-5.76239f,-40.6937f,1.83688f,-5.47503f,-40.6402f,2.50799f,-5.05286f,-40.571f,3.11735f,-4.50626f,-40.4877f,3.64995f,-3.84871f,-40.775f,4.09267f,-2.98155f,-40.8339f,4.43462f,-2.04584f,-40.9065f,4.66738f,-0.823294f,-40.9984f,4.66738f,-0.635892f,-41.0657f,4.66738f,-0.432832f,-41.1067f,4.66738f,-0.219113f,-41.1205f,4.66738f,0.0f,-41.1067f,4.66738f,0.219113f,-40.6586f,4.66738f,-1.13317f,-40.7923f,4.66738f,-0.990425f,-41.0657f,4.66738f,0.432832f,-40.9984f,4.66738f,0.635892f,-40.9065f,4.66738f,0.823294f,-40.7923f,4.66738f,0.990425f,-40.6586f,4.66738f,1.13317f,-40.8339f,4.43462f,2.04584f,-40.6937f,1.83688f,5.47503f,-40.7301f,1.12054f,5.76239f,-40.7486f,0.376604f,5.90786f,-40.7486f,-0.376604f,5.90786f,-40.571f,3.11735f,4.50626f,-40.6402f,2.50799f,5.05286f,-40.7301f,-1.12054f,5.76239f,-40.775f,4.09267f,2.98155f,-40.4877f,3.64995f,3.84871f,-40.6937f,-1.83688f,5.47503f,-40.6402f,-2.50799f,5.05286f,-10.0f,-9.6f,8.66025f,-13.0192f,-9.6f,7.56348f,-12.1752f,-9.5411f,7.93353f,-20.0f,-18.0f,0.0f,-19.8289f,-18.0f,-1.30526f,-19.3185f,-18.0f,-2.58819f,-14.1421f,-18.0f,-7.07107f,-12.1752f,-18.0f,-7.93353f,-22.1731f,-22.0f,-4.5922f,-20.7846f,-22.0f,-6.0f,-23.1822f,-22.0f,-3.10583f,-19.0405f,-22.0f,-7.30514f,-19.3185f,-18.0f,2.58819f,-19.8289f,-18.0f,1.30526f,-14.1421f,-18.0f,7.07107f,-12.1752f,-18.0f,7.93353f,-16.9706f,-22.0f,8.48528f,-19.0405f,-22.0f,7.30514f,-20.7846f,-22.0f,6.0f,-22.1731f,-22.0f,4.5922f,-10.0f,-18.0f,-8.66025f,-6.18034f,-9.6f,-9.51056f,-6.59077f,-9.6f,-9.4192f,-7.65367f,-9.48036f,-9.23879f,-5.76528f,-9.0f,-9.5593f,-4.60535f,-9.0f,-9.68258f,-5.83823f,-9.6f,-9.54692f,-2.86618f,0.925595f,-9.86422f,-2.09057f,4.8f,-9.94522f,-2.49708f,1.32507f,-9.90276f,-2.09057f,1.60341f,-9.94522f,-3.37495f,0.374952f,-9.81108f,-4.45771f,-3.32122f,-9.698f,-4.49401f,-3.00798f,-9.69421f,-3.85444f,-0.446756f,-9.761f,-3.99755f,-0.69201f,-9.74606f,-4.35313f,-1.78262f,-9.70892f,-4.36841f,-1.82949f,-9.70733f,-4.45771f,-2.67878f,-9.698f,-4.49494f,-3.0f,-9.69411f,-4.37265f,-4.1302f,-9.70688f,-4.05727f,-5.12483f,-9.73982f,-4.36841f,-4.17051f,-9.70733f,-3.58823f,-6.00945f,-9.78881f,-3.99755f,-5.30799f,-9.74606f,-3.37495f,-6.37495f,-9.81108f};
			return value;
		}
		private float[] getCoordinate_11_28_point_5()
		{
			float[] value = {-2.98852f,-6.79319f,-9.85144f,-2.49708f,-7.32507f,-9.90276f,-2.26798f,-7.48194f,-9.92669f,-2.09057f,-7.60341f,-9.94522f,-2.28216f,-9.55429f,-9.92521f,-2.09057f,-9.6f,-9.94522f,-2.28216f,-9.0f,-9.92521f,-6.18034f,4.8f,-9.51056f,-10.0f,4.8f,-8.66025f,-40.3923f,4.09267f,-3.09639f,-40.2874f,4.43462f,-2.26783f,-40.5676f,4.43462f,-2.18372f,-40.3463f,4.66738f,-1.33212f,-40.5087f,4.66738f,-1.24801f,-40.3047f,4.7852f,-0.276703f,-40.2663f,4.7852f,-0.332874f,-40.3356f,4.7852f,-0.213718f,-40.3582f,4.7852f,-0.145471f,-40.372f,4.7852f,-0.073642f,-40.3766f,4.7852f,0.0f,-40.372f,4.7852f,0.073642f,-40.2214f,4.7852f,-0.380848f,-40.3582f,4.7852f,0.145471f,-40.3356f,4.7852f,0.213718f,-40.3047f,4.7852f,0.276703f,-40.2663f,4.7852f,0.332874f,-40.2214f,4.7852f,0.380848f,-40.5087f,4.66738f,1.24801f,-40.3463f,4.66738f,1.33212f,-40.5676f,4.43462f,2.18372f,-6.18034f,4.8f,9.51056f,-2.09057f,4.8f,9.94522f,-4.60535f,-9.0f,9.68258f,-2.09057f,-7.60341f,9.94522f,-2.28216f,-9.0f,9.92521f,-2.09057f,-9.6f,9.94522f,-2.28216f,-9.55429f,9.92521f,-2.49708f,-7.32507f,9.90276f,-2.86618f,-6.9256f,9.86422f,-3.37495f,-6.37495f,9.81108f,-3.85444f,-5.55324f,9.761f,-3.99755f,-5.30799f,9.74606f,-4.35313f,-4.21738f,9.70892f,-4.36841f,-4.17051f,9.70733f,-4.45771f,-3.32122f,9.698f,-4.49494f,-3.0f,9.69411f,-4.49401f,-2.99202f,9.69421f,-4.45771f,-2.67878f,9.698f,-4.37265f,-1.8698f,9.70688f,-4.36841f,-1.82949f,9.70733f,-4.05727f,-0.875174f,9.73982f,-3.99755f,-0.69201f,9.74606f,-3.58823f,0.00945417f,9.78881f,-3.37495f,0.374952f,9.81108f,-2.98852f,0.793191f,9.85144f,-2.49708f,1.32507f,9.90276f,-2.26798f,1.48194f,9.92669f,-2.09057f,1.60341f,9.94522f,-5.76528f,-9.0f,9.5593f,-6.18034f,-9.6f,9.51056f,-5.83823f,-9.6f,9.54692f,-40.3923f,4.09267f,3.09639f,-40.2874f,4.43462f,2.26783f,-10.0f,4.8f,8.66025f,-7.65367f,-9.48036f,9.23879f,-6.59077f,-9.6f,9.4192f,-10.0f,-18.0f,8.66025f,-24.0f,-22.0f,0.0f,-23.7947f,-22.0f,-1.56631f,-23.7947f,-22.0f,1.56631f,-16.9706f,-22.0f,-8.48528f,-14.6103f,-22.0f,-9.52024f,-12.0f,-22.0f,-10.3923f,-9.1844f,-22.0f,-11.0866f,-6.21166f,-22.0f,-11.5911f,-3.13263f,-22.0f,-11.8973f,0.0f,-22.0f,-12.0f,3.13263f,-22.0f,-11.8973f,6.21166f,-22.0f,-11.5911f,9.1844f,-22.0f,-11.0866f,12.0f,-22.0f,-10.3923f,14.6103f,-22.0f,-9.52024f,-10.445f,-22.0f,-1.94986f,16.9706f,-22.0f,-8.48528f,-8.75302f,-22.0f,-1.56366f,19.0405f,-22.0f,-7.30514f,9.55496f,-22.0f,-1.94986f,23.1822f,-22.0f,-3.10583f,11.247f,-22.0f,-1.56366f,22.1731f,-22.0f,-4.5922f,12.0f,-22.0f,0.0f,23.7947f,-22.0f,-1.56631f,24.0f,-22.0f,0.0f,9.55496f,-22.0f,1.94986f,23.7947f,-22.0f,1.56631f,23.1822f,-22.0f,3.10583f,22.1731f,-22.0f,4.5922f,20.7846f,-22.0f,6.0f,19.0405f,-22.0f,7.30514f,16.9706f,-22.0f,8.48528f};
			return value;
		}
		private float[] getCoordinate_11_28_point_6()
		{
			float[] value = {14.6103f,-22.0f,9.52024f,12.0f,-22.0f,10.3923f,9.1844f,-22.0f,11.0866f,6.21166f,-22.0f,11.5911f,3.13263f,-22.0f,11.8973f,0.0f,-22.0f,12.0f,-3.13263f,-22.0f,11.8973f,-6.21166f,-22.0f,11.5911f,-9.1844f,-22.0f,11.0866f,-12.0f,-22.0f,10.3923f,-14.6103f,-22.0f,9.52024f,-23.1822f,-22.0f,3.10583f,-11.8019f,-22.0f,0.867767f,-11.8019f,-22.0f,-0.867767f,-10.445f,-22.0f,1.94986f,11.247f,-22.0f,1.56366f,-8.75302f,-22.0f,1.56366f,8.19806f,-22.0f,0.867767f,-8.0f,-22.0f,0.0f,20.7846f,-22.0f,-6.0f,8.19806f,-22.0f,-0.867767f,-7.65367f,-18.0f,-9.23879f,-5.17638f,-18.0f,-9.65926f,-5.17638f,-9.0f,-9.65926f,-2.61052f,-9.0f,-9.91445f,-2.61052f,-18.0f,-9.91445f,0.0f,-18.0f,-10.0f,-2.27736f,-9.6f,-9.92537f,-1.6716f,-9.6f,-9.94522f,-1.6716f,-9.0f,-9.94522f,0.0f,-9.0f,-10.0f,-1.3191f,-7.92296f,-9.94522f,1.6716f,-9.6f,-9.94522f,2.09057f,-7.60341f,-9.94522f,2.09057f,-9.6f,-9.94522f,1.6716f,-9.0f,-9.94522f,-1.11419f,-7.94994f,-9.94522f,0.0f,-8.09662f,-9.94522f,0.204911f,-8.06964f,-9.94522f,1.3191f,-7.92296f,-9.94522f,1.51005f,-7.84387f,-9.94522f,-1.16469f,-7.34667f,-9.698f,-2.25f,-6.89711f,-9.698f,-3.18198f,-6.18198f,-9.698f,-3.89711f,-5.25f,-9.698f,-4.34667f,-4.16469f,-9.698f,-3.74683f,-4.00396f,-9.221f,-3.879f,-3.0f,-9.221f,-4.34667f,-1.83531f,-9.698f,-3.89711f,-0.75f,-9.698f,-3.18198f,0.181981f,-9.698f,-2.25f,0.897114f,-9.698f,-1.51005f,1.84387f,-9.94522f,2.09057f,4.8f,-9.94522f,1.3191f,1.92296f,-9.94522f,2.09057f,1.60341f,-9.94522f,1.11419f,1.94994f,-9.94522f,0.0f,2.09662f,-9.94522f,-0.204911f,2.06964f,-9.94522f,-1.3191f,1.92296f,-9.94522f,-19.563f,4.8f,-2.07912f,-20.0f,4.8f,0.0f,-19.563f,4.8f,2.07912f,-16.1803f,4.8f,5.87785f,-18.2709f,4.8f,4.06737f,-13.3826f,4.8f,7.43145f,-13.0406f,4.8f,3.04056f,-13.9727f,4.8f,-1.64554f,-13.1417f,4.8f,-2.88916f,-5.7f,4.8f,0.0f,7.11084f,4.8f,3.14172f,6.95944f,4.8f,3.04056f,-8.35446f,4.8f,-3.97268f,-7.11084f,4.8f,-3.14172f,16.1803f,4.8f,-5.87785f,6.18034f,4.8f,-9.51056f,-13.3826f,4.8f,-7.43145f,-16.1803f,4.8f,-5.87785f,-18.2709f,4.8f,-4.06737f,-14.3f,4.8f,0.0f,-14.2645f,4.8f,0.178586f,-6.95944f,4.8f,3.04056f,-8.20306f,4.8f,3.87152f,6.18034f,4.8f,9.51056f,-6.95944f,4.8f,-3.04056f,6.85828f,4.8f,-2.88916f,6.95944f,4.8f,-3.04056f,-13.0406f,4.8f,-3.04056f,-6.02732f,4.8f,-1.64554f,5.73552f,4.8f,0.178586f,5.7f,4.8f,0.0f,-11.6455f,4.8f,-3.97268f,-11.7969f,4.8f,-3.87152f,-10.0f,4.8f,-4.3f,-8.53305f,4.8f,-4.00821f,10.0f,4.8f,-8.66025f,-10.1786f,4.8f,-4.26448f,13.3826f,4.8f,-7.43145f,8.35446f,4.8f,-3.97268f,9.82141f,4.8f,-4.26448f};
			return value;
		}
		private float[] getCoordinate_11_28_point_7()
		{
			float[] value = {14.3f,4.8f,0.0f,14.0082f,4.8f,1.46695f,19.563f,4.8f,2.07912f,-6.12848f,4.8f,-1.79694f,6.02732f,4.8f,-1.64554f,16.1803f,4.8f,5.87785f,-5.99179f,4.8f,1.46695f,13.3826f,4.8f,7.43145f,-6.02732f,4.8f,1.64554f,10.0f,4.8f,8.66025f,-6.85828f,4.8f,2.88916f,2.09057f,4.8f,9.94522f,-8.35446f,4.8f,3.97268f,-9.82141f,4.8f,4.26448f,-10.0f,4.8f,4.3f,13.9727f,4.8f,1.64554f,-11.467f,4.8f,4.00821f,-11.6455f,4.8f,3.97268f,-13.8715f,4.8f,1.79694f,-13.9727f,4.8f,1.64554f,-12.8892f,4.8f,3.14172f,6.02732f,4.8f,1.64554f,-5.73552f,4.8f,-0.178586f,6.12848f,4.8f,1.79694f,13.0406f,4.8f,3.04056f,11.7969f,4.8f,3.87152f,18.2709f,4.8f,4.06737f,20.0f,4.8f,0.0f,5.99179f,4.8f,-1.46695f,13.9727f,4.8f,-1.64554f,14.2645f,4.8f,-0.178586f,8.20306f,4.8f,-3.87152f,8.35446f,4.8f,3.97268f,13.0406f,4.8f,-3.04056f,13.8715f,4.8f,-1.79694f,19.563f,4.8f,-2.07912f,10.0f,4.8f,-4.3f,11.467f,4.8f,-4.00821f,18.2709f,4.8f,-4.06737f,11.6455f,4.8f,-3.97268f,12.8892f,4.8f,-3.14172f,13.1417f,4.8f,2.88916f,-14.0082f,4.8f,-1.46695f,11.6455f,4.8f,3.97268f,10.1786f,4.8f,4.26448f,10.0f,4.8f,4.3f,8.53305f,4.8f,4.00821f,-40.1164f,4.7852f,-0.447714f,-40.0589f,4.7852f,-0.464959f,-40.1753f,4.66738f,-1.38343f,-40.171f,4.7852f,-0.419445f,-40.171f,4.7852f,0.419445f,-40.1164f,4.7852f,0.447714f,-40.0589f,4.7852f,0.464959f,-40.1753f,4.66738f,1.38343f,0.0f,2.09662f,9.94522f,0.204911f,2.06964f,9.94522f,-1.3191f,1.92296f,9.94522f,1.3191f,1.92296f,9.94522f,1.51005f,1.84387f,9.94522f,-1.11419f,1.94994f,9.94522f,2.09057f,1.60341f,9.94522f,-1.16469f,1.34667f,9.698f,-2.25f,0.897114f,9.698f,-3.18198f,0.181981f,9.698f,-3.89711f,-0.75f,9.698f,-4.34667f,-1.83531f,9.698f,-3.74683f,-1.99604f,9.221f,-3.879f,-3.0f,9.221f,-4.34667f,-4.16469f,9.698f,-3.89711f,-5.25f,9.698f,-3.18198f,-6.18198f,9.698f,-2.25f,-6.89711f,9.698f,-1.51005f,-7.84387f,9.94522f,-1.6716f,-9.6f,9.94522f,-1.6716f,-9.0f,9.94522f,2.09057f,-9.6f,9.94522f,1.6716f,-9.0f,9.94522f,1.6716f,-9.6f,9.94522f,2.09057f,-7.60341f,9.94522f,1.3191f,-7.92296f,9.94522f,1.11419f,-7.94994f,9.94522f,0.0f,-8.09662f,9.94522f,-0.204911f,-8.06964f,9.94522f,-1.3191f,-7.92296f,9.94522f,-2.27736f,-9.6f,9.92537f,-2.61052f,-9.0f,9.91445f,-2.61052f,-18.0f,9.91445f,0.0f,-18.0f,10.0f,0.0f,-9.0f,10.0f,-5.17638f,-9.0f,9.65926f,-7.65367f,-18.0f,9.23879f,-5.17638f,-18.0f,9.65926f,2.61052f,-18.0f,9.91445f,5.17638f,-18.0f,9.65926f,7.65367f,-18.0f,9.23879f,10.0f,-18.0f,8.66025f,12.1752f,-18.0f,7.93353f,14.1421f,-18.0f,7.07107f,15.8671f,-18.0f,6.08761f};
			return value;
		}
		private float[] getCoordinate_11_28_point_8()
		{
			float[] value = {17.3205f,-18.0f,5.0f,18.4776f,-18.0f,3.82683f,19.3185f,-18.0f,2.58819f,19.8289f,-18.0f,1.30526f,20.0f,-18.0f,0.0f,19.8289f,-18.0f,-1.30526f,19.3185f,-18.0f,-2.58819f,18.4776f,-18.0f,-3.82683f,17.3205f,-18.0f,-5.0f,15.8671f,-18.0f,-6.08761f,14.1421f,-18.0f,-7.07107f,12.1752f,-18.0f,-7.93353f,10.0f,-18.0f,-8.66025f,7.65367f,-18.0f,-9.23879f,5.17638f,-18.0f,-9.65926f,2.61052f,-18.0f,-9.91445f,-10.445f,2.53838f,-1.94986f,-10.5092f,2.5f,-1.89872f,-11.7536f,2.5f,-0.906349f,-11.8019f,2.51916f,-0.867767f,-11.8019f,2.5f,-0.833943f,-11.8019f,2.5f,0.833943f,-11.8019f,2.51916f,0.867767f,-8.75302f,2.53197f,-1.56366f,-8.83873f,2.5f,-1.58323f,-10.3552f,2.5f,-1.92935f,-8.0f,2.5f,0.0f,-8.72625f,2.5f,-1.50807f,-8.72625f,2.5f,1.50807f,-8.75302f,2.53197f,1.56366f,-8.83873f,2.5f,1.58323f,-10.3552f,2.5f,1.92935f,-10.445f,2.53838f,1.94986f,-10.5092f,2.5f,1.89872f,-11.7536f,2.5f,0.906349f,8.19806f,2.51916f,-0.867767f,8.19806f,2.5f,-0.833943f,8.19806f,2.5f,0.833943f,8.19806f,2.51916f,0.867767f,9.55496f,2.53838f,-1.94986f,9.49084f,2.5f,-1.89872f,8.24644f,2.5f,-0.906349f,11.247f,2.53197f,-1.56366f,11.1613f,2.5f,-1.58323f,9.64481f,2.5f,-1.92935f,12.0f,2.5f,0.0f,11.2738f,2.5f,-1.50807f,11.2738f,2.5f,1.50807f,11.247f,2.53197f,1.56366f,11.1613f,2.5f,1.58323f,9.64481f,2.5f,1.92935f,9.55496f,2.53838f,1.94986f,9.49084f,2.5f,1.89872f,8.24644f,2.5f,0.906349f,2.27736f,-9.6f,-9.92537f,2.28216f,-9.55429f,-9.92521f,2.28216f,-9.0f,-9.92521f,2.61052f,-9.0f,-9.91445f,2.49708f,-7.32507f,-9.90276f,3.99755f,-5.30799f,-9.74606f,4.35313f,-4.21738f,-9.70892f,4.36841f,-4.17051f,-9.70733f,4.45771f,-3.32122f,-9.698f,4.49494f,-3.0f,-9.69411f,40.7486f,0.376604f,-5.90786f,4.49401f,-2.99202f,-9.69421f,4.45771f,-2.67878f,-9.698f,4.37265f,-1.8698f,-9.70688f,4.36841f,-1.82949f,-9.70733f,4.05727f,-0.875174f,-9.73982f,3.58823f,0.00945417f,-9.78881f,3.99755f,-0.69201f,-9.74606f,3.37495f,0.374952f,-9.81108f,2.98852f,0.793191f,-9.85144f,2.49708f,1.32507f,-9.90276f,2.26798f,1.48194f,-9.92669f,4.60535f,-9.0f,-9.68258f,40.7486f,-0.376604f,-5.90786f,2.86618f,-6.9256f,-9.86422f,3.37495f,-6.37495f,-9.81108f,3.85444f,-5.55324f,-9.761f,2.25f,-6.89711f,-9.698f,1.16469f,-7.34667f,-9.698f,0.0f,-7.5f,-9.698f,-1.00396f,-6.74683f,-9.221f,0.0f,-6.879f,-9.221f,-1.9395f,-6.35931f,-9.221f,-2.74287f,-5.74287f,-9.221f,-3.35931f,-4.9395f,-9.221f,-3.28608f,-3.8805f,-8.6f,-2.94622f,-4.701f,-8.6f,-3.402f,-3.0f,-8.6f,-3.74683f,-1.99604f,-9.221f,-3.35931f,-1.0605f,-9.221f,-2.74287f,-0.257133f,-9.221f,-1.9395f,0.359313f,-9.221f,-1.16469f,1.34667f,-9.698f,0.0f,1.5f,-9.698f,1.16469f,1.34667f,-9.698f,40.4877f,3.64995f,-3.84871f};
			return value;
		}
		private float[] getCoordinate_11_28_point_9()
		{
			float[] value = {40.7301f,1.12054f,-5.76239f,40.6937f,1.83688f,-5.47503f,40.6402f,2.50799f,-5.05286f,40.571f,3.11735f,-4.50626f,40.3923f,4.09267f,-3.09639f,40.2874f,4.43462f,-2.26783f,40.1753f,4.66738f,-1.38343f,40.0589f,4.7852f,-0.464959f,40.1164f,4.7852f,-0.447714f,40.171f,4.7852f,-0.419445f,40.2214f,4.7852f,-0.380848f,40.2663f,4.7852f,-0.332874f,40.3047f,4.7852f,-0.276703f,40.3356f,4.7852f,-0.213718f,40.3582f,4.7852f,-0.145471f,40.3766f,4.7852f,0.0f,40.372f,4.7852f,0.073642f,40.3582f,4.7852f,0.145471f,40.372f,4.7852f,-0.073642f,40.3356f,4.7852f,0.213718f,40.3047f,4.7852f,0.276703f,40.2663f,4.7852f,0.332874f,40.2214f,4.7852f,0.380848f,40.171f,4.7852f,0.419445f,40.1164f,4.7852f,0.447714f,40.0589f,4.7852f,0.464959f,40.1753f,4.66738f,1.38343f,40.2874f,4.43462f,2.26783f,40.3923f,4.09267f,3.09639f,40.4877f,3.64995f,3.84871f,40.571f,3.11735f,4.50626f,40.6402f,2.50799f,5.05286f,40.6937f,1.83688f,5.47503f,40.7301f,1.12054f,5.76239f,40.7486f,0.376604f,5.90786f,2.28216f,-9.55429f,9.92521f,4.60535f,-9.0f,9.68258f,2.28216f,-9.0f,9.92521f,40.7486f,-0.376604f,5.90786f,2.49708f,-7.32507f,9.90276f,2.49708f,1.32507f,9.90276f,2.86618f,0.925595f,9.86422f,3.37495f,0.374952f,9.81108f,3.85444f,-0.446756f,9.761f,3.99755f,-0.69201f,9.74606f,4.35313f,-1.78262f,9.70892f,4.36841f,-1.82949f,9.70733f,4.45771f,-2.67878f,9.698f,4.49494f,-3.0f,9.69411f,4.49401f,-3.00798f,9.69421f,4.45771f,-3.32122f,9.698f,4.37265f,-4.1302f,9.70688f,4.36841f,-4.17051f,9.70733f,4.05727f,-5.12483f,9.73982f,3.99755f,-5.30799f,9.74606f,3.58823f,-6.00945f,9.78881f,3.37495f,-6.37495f,9.81108f,2.98852f,-6.79319f,9.85144f,2.26798f,-7.48194f,9.92669f,-11.8478f,2.5f,0.765367f,-12.0f,2.5f,0.0f,-11.4142f,2.5f,1.41421f,-10.7654f,2.5f,1.84776f,-10.0f,2.5f,2.0f,-9.23463f,2.5f,1.84776f,-8.58579f,2.5f,1.41421f,-8.15224f,2.5f,0.765367f,-8.15224f,2.5f,-0.765367f,-8.58579f,2.5f,-1.41421f,-9.23463f,2.5f,-1.84776f,-10.0f,2.5f,-2.0f,-10.7654f,2.5f,-1.84776f,-11.4142f,2.5f,-1.41421f,-11.8478f,2.5f,-0.765367f,8.15224f,2.5f,0.765367f,8.0f,2.5f,0.0f,8.58579f,2.5f,1.41421f,9.23463f,2.5f,1.84776f,10.0f,2.5f,2.0f,10.7654f,2.5f,1.84776f,11.4142f,2.5f,1.41421f,11.8478f,2.5f,0.765367f,11.8478f,2.5f,-0.765367f,11.4142f,2.5f,-1.41421f,10.7654f,2.5f,-1.84776f,10.0f,2.5f,-2.0f,9.23463f,2.5f,-1.84776f,8.58579f,2.5f,-1.41421f,8.15224f,2.5f,-0.765367f,2.25f,0.897114f,9.698f,1.16469f,1.34667f,9.698f,0.0f,1.5f,9.698f,0.0f,0.879f,9.221f,-1.00396f,0.746826f,9.221f,-1.9395f,0.359313f,9.221f,-2.74287f,-0.257133f,9.221f,-3.35931f,-1.0605f,9.221f,-2.94622f,-1.299f,8.6f,-3.28608f,-2.1195f,8.6f,-3.402f,-3.0f,8.6f};
			return value;
		}
		private float[] getCoordinate_11_28_point_10()
		{
			float[] value = {-3.74683f,-4.00396f,9.221f,-3.35931f,-4.9395f,9.221f,-2.74287f,-5.74287f,9.221f,-1.9395f,-6.35931f,9.221f,-1.16469f,-7.34667f,9.698f,0.0f,-7.5f,9.698f,1.16469f,-7.34667f,9.698f,2.27736f,-9.6f,9.92537f,2.61052f,-9.0f,9.91445f,5.17638f,-9.0f,9.65926f,5.83823f,-9.6f,9.54692f,7.65367f,-9.48036f,9.23879f,6.59077f,-9.6f,9.4192f,5.76528f,-9.0f,9.5593f,10.0f,-9.6f,8.66025f,12.1752f,-9.5411f,7.93353f,13.0192f,-9.6f,7.56348f,14.1421f,-9.56862f,7.07107f,13.6166f,-9.6f,7.30149f,15.8671f,-9.5817f,6.08761f,16.0526f,-9.6f,5.94881f,17.3205f,-9.56774f,5.0f,16.3898f,-9.6f,5.69642f,18.0614f,-9.6f,4.24879f,18.4776f,-9.5879f,3.82683f,18.3299f,-9.6f,3.97655f,19.3185f,-9.57924f,2.58819f,19.4549f,-9.6f,2.24543f,19.8289f,-9.57592f,1.30526f,19.6099f,-9.6f,1.85572f,20.0f,-9.6f,0.0f,19.8289f,-9.57592f,-1.30526f,19.3185f,-9.57924f,-2.58819f,19.6099f,-9.6f,-1.85572f,19.4549f,-9.6f,-2.24543f,18.4776f,-9.5879f,-3.82683f,17.3205f,-9.56774f,-5.0f,18.3299f,-9.6f,-3.97655f,18.0614f,-9.6f,-4.24879f,15.8671f,-9.5817f,-6.08761f,16.0526f,-9.6f,-5.94881f,16.3898f,-9.6f,-5.69642f,14.1421f,-9.56862f,-7.07107f,12.1752f,-9.5411f,-7.93353f,13.0192f,-9.6f,-7.56348f,13.6166f,-9.6f,-7.30149f,10.0f,-9.6f,-8.66025f,7.65367f,-9.48036f,-9.23879f,5.17638f,-9.0f,-9.65926f,5.83823f,-9.6f,-9.54692f,5.76528f,-9.0f,-9.5593f,6.59077f,-9.6f,-9.4192f,6.18034f,-9.6f,-9.51056f,40.7301f,-1.12054f,-5.76239f,41.4787f,-0.376604f,-5.68875f,41.4787f,0.376604f,-5.68875f,2.25f,0.897114f,-9.698f,3.18198f,0.181981f,-9.698f,3.89711f,-0.75f,-9.698f,4.34667f,-1.83531f,-9.698f,3.74683f,-1.99604f,-9.221f,3.879f,-3.0f,-9.221f,4.34667f,-4.16469f,-9.698f,3.89711f,-5.25f,-9.698f,3.18198f,-6.18198f,-9.698f,1.9395f,-6.35931f,-9.221f,2.74287f,-5.74287f,-9.221f,1.00396f,-6.74683f,-9.221f,-0.880502f,-6.28608f,-8.6f,0.0f,-6.402f,-8.6f,0.880502f,-6.28608f,-8.6f,-1.701f,-5.94622f,-8.6f,-2.40558f,-5.40558f,-8.6f,-2.9963f,-3.80286f,-7.876f,-2.68641f,-4.551f,-7.876f,-2.19345f,-5.19344f,-7.876f,-3.102f,-3.0f,-7.876f,-3.28608f,-2.1195f,-8.6f,-2.94622f,-1.299f,-8.6f,-2.40558f,-0.594423f,-8.6f,-1.701f,-0.053782f,-8.6f,-1.00396f,0.746826f,-9.221f,0.0f,0.879f,-9.221f,1.00396f,0.746826f,-9.221f,40.775f,4.09267f,-2.98155f,40.9633f,3.64995f,-3.70597f,41.4423f,1.12054f,-5.54867f,41.3704f,1.83688f,-5.27197f,41.2647f,2.50799f,-4.86545f,41.1279f,3.11735f,-4.33913f,40.5676f,4.43462f,-2.18372f,40.3463f,4.66738f,-1.33212f,40.5087f,4.66738f,-1.24801f,40.6586f,4.66738f,-1.13317f,40.7923f,4.66738f,-0.990425f,40.9065f,4.66738f,-0.823294f,40.9984f,4.66738f,-0.635892f,41.0657f,4.66738f,-0.432832f,41.1067f,4.66738f,0.219113f,41.1067f,4.66738f,-0.219113f};
			return value;
		}
		private float[] getCoordinate_11_28_point_11()
		{
			float[] value = {41.1205f,4.66738f,0.0f,41.0657f,4.66738f,0.432832f,40.9984f,4.66738f,0.635892f,40.9065f,4.66738f,0.823294f,40.7923f,4.66738f,0.990425f,40.6586f,4.66738f,1.13317f,40.5087f,4.66738f,1.24801f,40.3463f,4.66738f,1.33212f,40.5676f,4.43462f,2.18372f,40.775f,4.09267f,2.98155f,40.9633f,3.64995f,3.70597f,41.1279f,3.11735f,4.33913f,41.2647f,2.50799f,4.86545f,41.3704f,1.83688f,5.27197f,41.4423f,1.12054f,5.54867f,41.4787f,0.376604f,5.68875f,41.4787f,-0.376604f,5.68875f,2.25f,-6.89711f,9.698f,3.18198f,-6.18198f,9.698f,3.89711f,-5.25f,9.698f,4.34667f,-4.16469f,9.698f,3.74683f,-4.00396f,9.221f,3.879f,-3.0f,9.221f,4.34667f,-1.83531f,9.698f,3.89711f,-0.75f,9.698f,3.18198f,0.181981f,9.698f,40.7301f,-1.12054f,5.76239f,6.18034f,-9.6f,9.51056f,2.74287f,-0.257133f,9.221f,1.9395f,0.359313f,9.221f,1.00396f,0.746826f,9.221f,0.880502f,0.28608f,8.6f,0.0f,0.402f,8.6f,-0.880502f,0.28608f,8.6f,-1.701f,-0.053782f,8.6f,-2.40558f,-0.594423f,8.6f,-2.19345f,-0.806555f,7.876f,-2.68641f,-1.449f,7.876f,-2.9963f,-2.19714f,7.876f,-3.102f,-3.0f,7.876f,-3.28608f,-3.8805f,8.6f,-2.94622f,-4.701f,8.6f,-2.40558f,-5.40558f,8.6f,-1.701f,-5.94622f,8.6f,-1.00396f,-6.74683f,9.221f,0.0f,-6.879f,9.221f,1.00396f,-6.74683f,9.221f,40.6937f,-1.83688f,5.47503f,41.1279f,-3.11735f,4.33913f,13.3826f,-9.6f,7.43145f,41.1386f,-4.09267f,2.7933f,16.1803f,-9.6f,5.87785f,41.0797f,-4.43462f,1.85758f,18.2709f,-9.6f,4.06737f,40.9065f,-4.66738f,0.823294f,19.563f,-9.6f,2.07912f,41.0657f,-4.66738f,0.432832f,19.563f,-9.6f,-2.07912f,41.0657f,-4.66738f,-0.432832f,18.2709f,-9.6f,-4.06737f,40.9065f,-4.66738f,-0.823294f,16.1803f,-9.6f,-5.87785f,41.0797f,-4.43462f,-1.85758f,13.3826f,-9.6f,-7.43145f,41.1386f,-4.09267f,-2.7933f,41.1279f,-3.11735f,-4.33913f,40.6937f,-1.83688f,-5.47503f,41.3704f,-1.83688f,-5.27197f,41.4423f,-1.12054f,-5.54867f,42.1724f,-0.376604f,-5.32956f,42.1724f,0.376604f,-5.32956f,42.1189f,-1.12054f,-5.19833f,42.1189f,1.12054f,-5.19833f,1.9395f,0.359313f,-9.221f,2.74287f,-0.257133f,-9.221f,3.35931f,-1.0605f,-9.221f,3.28608f,-2.1195f,-8.6f,2.94622f,-1.299f,-8.6f,3.74683f,-4.00396f,-9.221f,3.402f,-3.0f,-8.6f,3.35931f,-4.9395f,-9.221f,1.701f,-5.94622f,-8.6f,2.40558f,-5.40558f,-8.6f,2.94622f,-4.701f,-8.6f,-0.802857f,-5.9963f,-7.876f,0.0f,-6.102f,-7.876f,0.802857f,-5.9963f,-7.876f,1.551f,-5.68641f,-7.876f,-1.551f,-5.68641f,-7.876f,-2.89778f,-3.77646f,-7.1f,-2.59808f,-4.5f,-7.1f,-2.12132f,-5.12132f,-7.1f,-1.5f,-5.59808f,-7.1f,-3.0f,-3.0f,-7.1f,-2.9963f,-2.19714f,-7.876f,-2.68641f,-1.449f,-7.876f,-2.19345f,-0.806555f,-7.876f,-1.551f,-0.313589f,-7.876f,-0.880502f,0.28608f,-8.6f,0.0f,0.402f,-8.6f};
			return value;
		}
		private float[] getCoordinate_11_28_point_12()
		{
			float[] value = {0.880502f,0.28608f,-8.6f,41.1386f,4.09267f,-2.7933f,40.8339f,4.43462f,-2.04584f,41.657f,3.11735f,-4.06516f,41.4152f,3.64995f,-3.47198f,42.0133f,1.83688f,-4.9391f,41.858f,2.50799f,-4.55825f,41.0797f,4.43462f,-1.85758f,41.4861f,4.43462f,-1.34961f,41.2989f,4.43462f,-1.62359f,41.6367f,4.43462f,-1.04241f,41.747f,4.43462f,-0.709534f,41.8369f,4.43462f,0.0f,41.8143f,4.43462f,0.359189f,41.747f,4.43462f,0.709534f,41.8143f,4.43462f,-0.359189f,41.6367f,4.43462f,1.04241f,41.4861f,4.43462f,1.34961f,41.2989f,4.43462f,1.62359f,41.0797f,4.43462f,1.85758f,40.8339f,4.43462f,2.04584f,41.1386f,4.09267f,2.7933f,41.4152f,3.64995f,3.47198f,41.657f,3.11735f,4.06516f,41.858f,2.50799f,4.55825f,42.0133f,1.83688f,4.9391f,42.1189f,1.12054f,5.19833f,42.1724f,0.376604f,5.32956f,42.1724f,-0.376604f,5.32956f,42.1189f,-1.12054f,5.19833f,41.4423f,-1.12054f,5.54867f,1.9395f,-6.35931f,9.221f,2.74287f,-5.74287f,9.221f,3.35931f,-4.9395f,9.221f,2.94622f,-4.701f,8.6f,3.28608f,-3.8805f,8.6f,3.402f,-3.0f,8.6f,3.74683f,-1.99604f,9.221f,3.35931f,-1.0605f,9.221f,41.3704f,-1.83688f,5.27197f,2.94622f,-1.299f,8.6f,2.40558f,-0.594423f,8.6f,1.701f,-0.053782f,8.6f,1.551f,-0.313589f,7.876f,0.802857f,-0.003698f,7.876f,0.0f,0.102f,7.876f,-0.802857f,-0.003698f,7.876f,-1.551f,-0.313589f,7.876f,-1.5f,-0.401924f,7.1f,-2.12132f,-0.87868f,7.1f,-2.59808f,-1.5f,7.1f,-2.89778f,-2.22354f,7.1f,-3.0f,-3.0f,7.1f,-2.9963f,-3.80286f,7.876f,-2.68641f,-4.551f,7.876f,-2.19345f,-5.19344f,7.876f,-1.551f,-5.68641f,7.876f,-0.880502f,-6.28608f,8.6f,0.0f,-6.402f,8.6f,0.880502f,-6.28608f,8.6f,41.2647f,-2.50799f,4.86545f,40.6402f,-2.50799f,5.05286f,41.657f,-3.11735f,4.06516f,40.9633f,-3.64995f,3.70597f,41.4152f,-3.64995f,3.47198f,40.8339f,-4.43462f,2.04584f,41.8323f,-3.64995f,3.15249f,41.4742f,-4.09267f,2.53626f,41.2989f,-4.43462f,1.62359f,41.7734f,-4.09267f,2.21677f,40.7923f,-4.66738f,0.990425f,41.4861f,-4.43462f,1.34961f,41.6367f,-4.43462f,1.04241f,40.9984f,-4.66738f,0.635892f,41.1067f,-4.66738f,0.219113f,41.747f,-4.43462f,0.709534f,41.1205f,-4.66738f,0.0f,41.1067f,-4.66738f,-0.219113f,41.747f,-4.43462f,-0.709534f,41.6367f,-4.43462f,-1.04241f,40.9984f,-4.66738f,-0.635892f,41.4861f,-4.43462f,-1.34961f,40.7923f,-4.66738f,-0.990425f,41.2989f,-4.43462f,-1.62359f,41.7734f,-4.09267f,-2.21677f,41.4742f,-4.09267f,-2.53626f,40.8339f,-4.43462f,-2.04584f,41.8323f,-3.64995f,-3.15249f,41.4152f,-3.64995f,-3.47198f,40.9633f,-3.64995f,-3.70597f,41.657f,-3.11735f,-4.06516f,41.2647f,-2.50799f,-4.86545f,40.6402f,-2.50799f,-5.05286f,41.858f,-2.50799f,-4.55825f,42.0133f,-1.83688f,-4.9391f,42.7434f,-1.12054f,-4.71998f,42.8127f,-0.376604f,-4.83914f,42.8127f,0.376604f,-4.83914f,42.7434f,1.12054f,-4.71998f,42.6066f,-1.83688f,-4.48461f};
			return value;
		}
		private float[] getCoordinate_11_28_point_13()
		{
			float[] value = {42.6066f,1.83688f,-4.48461f,1.701f,-0.053782f,-8.6f,2.40558f,-0.594423f,-8.6f,2.9963f,-2.19714f,-7.876f,2.68641f,-1.449f,-7.876f,2.19345f,-0.806555f,-7.876f,3.28608f,-3.8805f,-8.6f,3.102f,-3.0f,-7.876f,2.19345f,-5.19344f,-7.876f,2.68641f,-4.551f,-7.876f,2.9963f,-3.80286f,-7.876f,-0.776457f,-5.89778f,-7.1f,0.0f,-6.0f,-7.1f,0.776457f,-5.89778f,-7.1f,1.5f,-5.59808f,-7.1f,2.12132f,-5.12132f,-7.1f,-2.89778f,-2.22354f,-7.1f,-2.59808f,-1.5f,-7.1f,-2.12132f,-0.87868f,-7.1f,-0.802857f,-0.003698f,-7.876f,-1.5f,-0.401924f,-7.1f,0.0f,0.102f,-7.876f,0.802857f,-0.003698f,-7.876f,41.8323f,3.64995f,-3.15249f,41.4742f,4.09267f,-2.53626f,42.4056f,2.50799f,-4.1388f,42.1454f,3.11735f,-3.69109f,41.7734f,4.09267f,-2.21677f,42.029f,4.09267f,-1.8427f,42.2346f,4.09267f,-1.42326f,42.3852f,4.09267f,-0.968766f,42.4771f,4.09267f,-0.490421f,42.508f,4.09267f,0.0f,42.4771f,4.09267f,0.490421f,42.3852f,4.09267f,0.968766f,42.2346f,4.09267f,1.42326f,42.029f,4.09267f,1.8427f,41.7734f,4.09267f,2.21677f,41.4742f,4.09267f,2.53626f,41.8323f,3.64995f,3.15249f,42.1454f,3.11735f,3.69109f,42.4056f,2.50799f,4.1388f,42.6066f,1.83688f,4.48461f,42.7434f,1.12054f,4.71998f,42.8127f,-0.376604f,4.83914f,42.8127f,0.376604f,4.83914f,42.7434f,-1.12054f,4.71998f,42.6066f,-1.83688f,4.48461f,42.0133f,-1.83688f,4.9391f,1.701f,-5.94622f,8.6f,2.40558f,-5.40558f,8.6f,2.19345f,-5.19344f,7.876f,2.68641f,-4.551f,7.876f,2.9963f,-3.80286f,7.876f,3.102f,-3.0f,7.876f,3.28608f,-2.1195f,8.6f,41.858f,-2.50799f,4.55825f,2.9963f,-2.19714f,7.876f,2.68641f,-1.449f,7.876f,2.19345f,-0.806555f,7.876f,2.12132f,-0.87868f,7.1f,1.5f,-0.401924f,7.1f,0.776457f,-0.102223f,7.1f,0.0f,0.0f,7.1f,-0.776457f,-0.102223f,7.1f,-2.89778f,-3.77646f,7.1f,-2.59808f,-4.5f,7.1f,-2.12132f,-5.12132f,7.1f,-1.5f,-5.59808f,7.1f,-0.802857f,-5.9963f,7.876f,0.0f,-6.102f,7.876f,0.802857f,-5.9963f,7.876f,42.4056f,-2.50799f,4.1388f,42.1454f,-3.11735f,3.69109f,42.2043f,-3.64995f,2.75537f,42.522f,-3.64995f,2.29042f,42.029f,-4.09267f,1.8427f,42.2346f,-4.09267f,1.42326f,42.3852f,-4.09267f,0.968766f,41.8369f,-4.43462f,0.0f,41.8143f,-4.43462f,0.359189f,41.8143f,-4.43462f,-0.359189f,42.3852f,-4.09267f,-0.968766f,42.2346f,-4.09267f,-1.42326f,42.029f,-4.09267f,-1.8427f,42.522f,-3.64995f,-2.29042f,42.2043f,-3.64995f,-2.75537f,42.1454f,-3.11735f,-3.69109f,42.4056f,-2.50799f,-4.1388f,43.1358f,-1.83688f,-3.91969f,43.3003f,-1.12054f,-4.12542f,43.3836f,-0.376604f,-4.22956f,43.3836f,0.376604f,-4.22956f,43.3003f,1.12054f,-4.12542f,43.1358f,1.83688f,-3.91969f,42.894f,-2.50799f,-3.61745f,42.894f,2.50799f,-3.61745f,1.551f,-0.313589f,-7.876f,2.89778f,-2.22354f,-7.1f,2.59808f,-1.5f,-7.1f};
			return value;
		}
		private float[] getCoordinate_11_28_point_14()
		{
			float[] value = {2.12132f,-0.87868f,-7.1f,1.5f,-0.401924f,-7.1f,3.0f,-3.0f,-7.1f,2.59808f,-4.5f,-7.1f,2.89778f,-3.77646f,-7.1f,-0.776457f,-5.89778f,7.1f,-0.776457f,-0.102223f,-7.1f,0.0f,0.0f,-7.1f,0.776457f,-0.102223f,-7.1f,2.59808f,-1.5f,7.1f,2.89778f,-2.22354f,7.1f,3.0f,-3.0f,7.1f,42.2043f,3.64995f,-2.75537f,42.5809f,3.11735f,-3.22613f,42.522f,3.64995f,-2.29042f,42.7776f,3.64995f,-1.76906f,42.9648f,3.64995f,-1.20414f,43.079f,3.64995f,-0.609576f,43.079f,3.64995f,0.609576f,43.1174f,3.64995f,0.0f,42.9648f,3.64995f,1.20414f,42.7776f,3.64995f,1.76906f,42.522f,3.64995f,2.29042f,42.2043f,3.64995f,2.75537f,42.5809f,3.11735f,3.22613f,42.894f,2.50799f,3.61745f,43.1358f,1.83688f,3.91969f,43.3003f,1.12054f,4.12542f,43.3836f,0.376604f,4.22956f,43.3836f,-0.376604f,4.22956f,43.3003f,-1.12054f,4.12542f,43.1358f,-1.83688f,3.91969f,42.894f,-2.50799f,3.61745f,1.551f,-5.68641f,7.876f,1.5f,-5.59808f,7.1f,2.12132f,-5.12132f,7.1f,2.59808f,-4.5f,7.1f,2.89778f,-3.77646f,7.1f,0.0f,-6.0f,7.1f,0.776457f,-5.89778f,7.1f,42.5809f,-3.11735f,3.22613f,42.9529f,-3.11735f,2.68173f,43.2521f,-3.11735f,2.0713f,42.7776f,-3.64995f,1.76906f,42.9648f,-3.64995f,1.20414f,43.079f,-3.64995f,0.609576f,42.4771f,-4.09267f,0.490421f,42.508f,-4.09267f,0.0f,42.4771f,-4.09267f,-0.490421f,43.079f,-3.64995f,-0.609576f,42.9648f,-3.64995f,-1.20414f,42.7776f,-3.64995f,-1.76906f,43.2521f,-3.11735f,-2.0713f,42.9529f,-3.11735f,-2.68173f,42.5809f,-3.11735f,-3.22613f,43.5877f,-1.83688f,-3.25826f,43.776f,-1.12054f,-3.42927f,43.8713f,-0.376604f,-3.51584f,43.8713f,0.376604f,-3.51584f,43.776f,1.12054f,-3.42927f,43.5877f,1.83688f,-3.25826f,43.311f,-2.50799f,-3.00702f,42.9529f,3.11735f,-2.68173f,43.311f,2.50799f,-3.00702f,43.2521f,3.11735f,-2.0713f,43.4713f,3.11735f,-1.40987f,43.605f,3.11735f,-0.713722f,43.6499f,3.11735f,0.0f,43.605f,3.11735f,0.713722f,43.4713f,3.11735f,1.40987f,43.2521f,3.11735f,2.0713f,42.9529f,3.11735f,2.68173f,43.311f,2.50799f,3.00702f,43.5877f,1.83688f,3.25826f,43.776f,1.12054f,3.42927f,43.8713f,0.376604f,3.51584f,43.8713f,-0.376604f,3.51584f,43.776f,-1.12054f,3.42927f,43.5877f,-1.83688f,3.25826f,43.311f,-2.50799f,3.00702f,43.8924f,-2.50799f,1.58088f,43.4713f,-3.11735f,1.40987f,43.6466f,-2.50799f,2.32254f,43.605f,-3.11735f,0.713722f,43.6499f,-3.11735f,0.0f,43.1174f,-3.64995f,0.0f,43.605f,-3.11735f,-0.713722f,43.4713f,-3.11735f,-1.40987f,43.8924f,-2.50799f,-1.58088f,43.6466f,-2.50799f,-2.32254f,44.1587f,-1.12054f,-2.64868f,43.9513f,-1.83688f,-2.51659f,44.2636f,-0.376604f,-2.71555f,44.2636f,0.376604f,-2.71555f,44.1587f,1.12054f,-2.64868f,43.9513f,1.83688f,-2.51659f,43.6466f,2.50799f,-2.32254f,43.8924f,2.50799f,-1.58088f,44.0423f,2.50799f,-0.800294f,44.0927f,2.50799f,0.0f};
			return value;
		}
		private float[] getCoordinate_11_28_point_15()
		{
			float[] value = {44.0423f,2.50799f,0.800294f,43.8924f,2.50799f,1.58088f,43.6466f,2.50799f,2.32254f,43.9513f,1.83688f,2.51659f,44.1587f,1.12054f,2.64868f,44.2636f,0.376604f,2.71555f,44.2636f,-0.376604f,2.71555f,44.1587f,-1.12054f,2.64868f,43.9513f,-1.83688f,2.51659f,44.0423f,-2.50799f,0.800294f,44.2176f,-1.83688f,1.71297f,44.38f,-1.83688f,0.86716f,44.0927f,-2.50799f,0.0f,44.0423f,-2.50799f,-0.800294f,44.38f,-1.83688f,-0.86716f,44.2176f,-1.83688f,-1.71297f,44.4389f,-1.12054f,-1.80287f,44.551f,-0.376604f,-1.84839f,44.551f,0.376604f,-1.84839f,44.4389f,1.12054f,-1.80287f,44.2176f,1.83688f,-1.71297f,44.38f,1.83688f,-0.86716f,44.4346f,1.83688f,0.0f,44.38f,1.83688f,0.86716f,44.2176f,1.83688f,1.71297f,44.4389f,1.12054f,1.80287f,44.551f,0.376604f,1.84839f,44.551f,-0.376604f,1.84839f,44.4389f,-1.12054f,1.80287f,44.6099f,-1.12054f,0.912673f,44.6674f,-1.12054f,0.0f,44.4346f,-1.83688f,0.0f,44.6099f,-1.12054f,-0.912673f,44.7263f,-0.376604f,-0.935713f,44.7263f,0.376604f,-0.935713f,44.6099f,1.12054f,-0.912673f,44.6674f,1.12054f,0.0f,44.6099f,1.12054f,0.912673f,44.7263f,0.376604f,0.935713f,44.7263f,-0.376604f,0.935713f,44.7852f,-0.376604f,0.0f,44.7852f,0.376604f,0.0f};
			return value;
		}


		/** Define subarrays using type float[] */
		private float[] getNormal_11_29_vector_1()
		{
			float[] value = {-0.972365f,-0.233467f,0.0f,-0.996919f,-0.0784414f,0.0f,-0.991395f,-0.0786756f,-0.104624f,-0.998633f,0.0522767f,0.0f,-0.98894f,0.0786931f,-0.125722f,-0.991395f,-0.0786756f,0.104624f,-0.98894f,0.0786931f,0.125722f,-0.912707f,-0.39432f,-0.107134f,-0.961514f,-0.234702f,-0.142848f,-0.961514f,-0.234702f,0.142848f,-0.912707f,-0.39432f,0.107134f,-0.923876f,-0.382692f,0.0f,-0.965974f,-0.0912218f,-0.242016f,-0.961261f,0.0912218f,-0.260106f,-0.961514f,0.234702f,-0.142848f,-0.972365f,0.233467f,0.0f,-0.961514f,0.234702f,0.142848f,-0.961261f,0.0912218f,0.260106f,-0.965974f,-0.0912218f,0.242016f,-0.817645f,-0.53825f,-0.204312f,-0.893675f,-0.378304f,-0.241312f,-0.852633f,-0.52251f,0.0f,-0.844839f,-0.524167f,-0.107218f,-0.940072f,-0.237292f,-0.244861f,-0.940072f,-0.237292f,0.244861f,-0.893675f,-0.378304f,0.241312f,-0.817645f,-0.53825f,0.204312f,-0.844839f,-0.524167f,0.107218f,-0.899212f,-0.25298f,-0.356958f,-0.92266f,-0.081786f,-0.376841f,-0.913828f,0.0817652f,-0.397784f,-0.899212f,0.25298f,-0.356958f,-0.940072f,0.237292f,-0.244861f,-0.912707f,0.39432f,-0.107134f,-0.893675f,0.378304f,-0.241312f,-0.923876f,0.382692f,0.0f,-0.912707f,0.39432f,0.107134f,-0.893675f,0.378304f,0.241312f,-0.940072f,0.237292f,0.244861f,-0.899212f,0.25298f,0.356958f,-0.913828f,0.0817652f,0.397784f,-0.92266f,-0.081786f,0.376841f,-0.899212f,-0.25298f,0.356958f,-0.759144f,-0.642757f,-0.102779f,-0.730465f,-0.65595f,-0.190133f,-0.69253f,-0.6637f,-0.282674f,-0.793908f,-0.514388f,-0.324213f,-0.850347f,-0.395319f,-0.347323f,-0.743119f,-0.669159f,0.0f,-0.759144f,-0.642757f,0.102779f,-0.850347f,-0.395319f,0.347323f,-0.793908f,-0.514388f,0.324213f,-0.69253f,-0.6637f,0.282674f,-0.730465f,-0.65595f,0.190133f,-0.791174f,-0.414677f,-0.449541f,-0.834391f,-0.237413f,-0.497421f,-0.869258f,-0.0669789f,-0.489801f,-0.854719f,0.0669789f,-0.514751f,-0.834391f,0.237413f,-0.497421f,-0.791174f,0.414677f,-0.449541f,-0.850347f,0.395319f,-0.347323f,-0.817645f,0.53825f,-0.204312f,-0.844839f,0.524167f,-0.107218f,-0.852633f,0.52251f,0.0f,-0.793908f,0.514388f,-0.324213f,-0.844839f,0.524167f,0.107218f,-0.817645f,0.53825f,0.204312f,-0.793908f,0.514388f,0.324213f,-0.850347f,0.395319f,0.347323f,-0.834391f,0.237413f,0.497421f,-0.791174f,0.414677f,0.449541f,-0.854719f,0.0669789f,0.514751f,-0.869258f,-0.0669789f,0.489801f,-0.834391f,-0.237413f,0.497421f,-0.791174f,-0.414677f,0.449541f,-0.635149f,-0.768828f,-0.0740914f,-0.628672f,-0.759043f,-0.169191f,-0.721763f,-0.559812f,-0.407025f,-0.587983f,-0.772474f,-0.239918f,-0.536593f,-0.787162f,-0.304046f,-0.628081f,-0.675638f,-0.386042f,-0.635149f,-0.768828f,0.0740914f,-0.649461f,-0.760395f,0.0f,-0.628672f,-0.759042f,0.169191f,-0.721763f,-0.559812f,0.407025f,-0.628081f,-0.675638f,0.386042f,-0.536593f,-0.787162f,0.304046f,-0.587983f,-0.772474f,0.239918f,-0.646442f,-0.560065f,-0.518113f,-0.718418f,-0.389905f,-0.576064f,-0.754101f,-0.255976f,-0.60482f,-0.78308f,-0.098834f,-0.614018f,-0.76931f,0.0988341f,-0.631184f,-0.754101f,0.255976f,-0.60482f,-0.718418f,0.389905f,-0.576064f,-0.646442f,0.560065f,-0.518113f,-0.721763f,0.559812f,-0.407025f,-0.730465f,0.65595f,-0.190133f,-0.759144f,0.642757f,-0.102779f,-0.69253f,0.6637f,-0.282674f};
			return value;
		}
		private float[] getNormal_11_29_vector_2()
		{
			float[] value = {-0.743119f,0.669159f,0.0f,-0.759144f,0.642757f,0.102779f,-0.730465f,0.65595f,0.190133f,-0.69253f,0.6637f,0.282674f,-0.721763f,0.559812f,0.407025f,-0.718418f,0.389905f,0.576064f,-0.754101f,0.255976f,0.60482f,-0.76931f,0.0988341f,0.631184f,-0.646442f,0.560065f,0.518113f,-0.78308f,-0.098834f,0.614018f,-0.754101f,-0.255976f,0.60482f,-0.718418f,-0.389905f,0.576064f,-0.646442f,-0.560065f,0.518113f,-0.544651f,-0.838663f,0.0f,-0.504345f,-0.861542f,-0.0581484f,-0.491882f,-0.862024f,-0.122337f,-0.490807f,-0.847957f,-0.200194f,-0.422781f,-0.87423f,-0.2387f,-0.379103f,-0.874173f,-0.303483f,-0.493516f,-0.774729f,-0.395267f,-0.568005f,-0.685769f,-0.455072f,-0.491882f,-0.862024f,0.122337f,-0.504345f,-0.861542f,0.0581485f,-0.490807f,-0.847957f,0.200194f,-0.568005f,-0.685769f,0.455072f,-0.493516f,-0.774729f,0.395267f,-0.379103f,-0.874173f,0.303483f,-0.422781f,-0.87423f,0.2387f,-0.496666f,-0.696064f,-0.518476f,-0.533586f,-0.588263f,-0.607645f,-0.594882f,-0.439417f,-0.673073f,-0.657913f,-0.251388f,-0.709898f,-0.681709f,-0.0716093f,-0.72811f,-0.657172f,0.0716094f,-0.750331f,-0.657913f,0.251388f,-0.709898f,-0.594882f,0.439417f,-0.673073f,-0.533586f,0.588263f,-0.607645f,-0.496666f,0.696064f,-0.518476f,-0.568005f,0.685769f,-0.455072f,-0.628081f,0.675638f,-0.386042f,-0.628672f,0.759043f,-0.169191f,-0.635149f,0.768828f,-0.0740914f,-0.536593f,0.787162f,-0.304046f,-0.587983f,0.772474f,-0.239918f,-0.635149f,0.768828f,0.0740914f,-0.649461f,0.760395f,0.0f,-0.628672f,0.759043f,0.169191f,-0.587983f,0.772474f,0.239918f,-0.536593f,0.787162f,0.304046f,-0.628081f,0.675638f,0.386042f,-0.594882f,0.439417f,0.673073f,-0.657913f,0.251388f,0.709898f,-0.657172f,0.0716094f,0.750331f,-0.681709f,-0.0716093f,0.72811f,-0.568005f,0.685769f,0.455072f,-0.496666f,0.696064f,0.518476f,-0.533586f,0.588263f,0.607645f,-0.657913f,-0.251388f,0.709898f,-0.594882f,-0.439417f,0.673073f,-0.533586f,-0.588263f,0.607645f,-0.496666f,-0.696064f,0.518476f,-0.382677f,-0.923882f,0.0f,-0.391518f,-0.918499f,-0.0554398f,-0.342956f,-0.928883f,-0.139848f,-0.352407f,-0.931746f,-0.0875134f,-0.306878f,-0.932903f,-0.188462f,-0.390053f,-0.808041f,-0.441507f,-0.272563f,-0.937802f,-0.215028f,-0.255045f,-0.92527f,-0.280762f,-0.303238f,-0.888614f,-0.34411f,-0.342956f,-0.928883f,0.139848f,-0.352407f,-0.931746f,0.0875134f,-0.391518f,-0.918499f,0.0554398f,-0.390053f,-0.808041f,0.441507f,-0.303238f,-0.888614f,0.34411f,-0.255045f,-0.92527f,0.280764f,-0.272563f,-0.937802f,0.215028f,-0.306878f,-0.932903f,0.188462f,-0.377791f,-0.710152f,-0.594103f,-0.443165f,-0.56338f,-0.697286f,-0.503261f,-0.285594f,-0.815576f,-0.481719f,-0.439375f,-0.758219f,-0.558209f,-0.0920175f,-0.824582f,-0.533539f,0.092057f,-0.84075f,-0.503261f,0.285594f,-0.815576f,-0.481719f,0.439375f,-0.758219f,-0.443165f,0.56338f,-0.697286f,-0.377791f,0.710152f,-0.594103f,-0.493516f,0.774729f,-0.395267f,-0.390053f,0.808041f,-0.441508f,-0.490807f,0.847957f,-0.200194f,-0.491882f,0.862024f,-0.122337f,-0.504345f,0.861542f,-0.0581485f,-0.544651f,0.838663f,0.0f,-0.379103f,0.874173f,-0.303483f,-0.422781f,0.87423f,-0.2387f,-0.504345f,0.861542f,0.0581484f,-0.491882f,0.862024f,0.122337f,-0.490807f,0.847957f,0.200194f,-0.493516f,0.774729f,0.395267f};
			return value;
		}
		private float[] getNormal_11_29_vector_3()
		{
			float[] value = {-0.422781f,0.87423f,0.2387f,-0.379103f,0.874173f,0.303483f,-0.481719f,0.439375f,0.758219f,-0.503261f,0.285594f,0.815576f,-0.443165f,0.56338f,0.697286f,-0.533539f,0.092057f,0.84075f,-0.558209f,-0.0920175f,0.824582f,-0.390053f,0.808041f,0.441507f,-0.377791f,0.710152f,0.594103f,-0.503261f,-0.285594f,0.815576f,-0.481719f,-0.439375f,0.758219f,-0.443165f,-0.56338f,0.697286f,-0.377791f,-0.710152f,0.594103f,-0.279489f,-0.959494f,0.0354556f,-0.268453f,-0.963293f,0f,-0.279489f,-0.959494f,-0.0354556f,-0.251618f,-0.965719f,-0.0638366f,-0.252871f,-0.961947f,-0.103509f,-0.239401f,-0.960208f,-0.143835f,-0.234791f,-0.95841f,-0.162244f,-0.262522f,-0.872322f,-0.412476f,-0.30251f,-0.817408f,-0.490236f,-0.202395f,-0.962795f,-0.179059f,-0.242992f,-0.916255f,-0.318482f,-0.205204f,-0.930384f,-0.303772f,-0.160858f,-0.969341f,-0.185748f,-0.237563f,-0.931831f,-0.274325f,-0.120816f,-0.982822f,-0.139517f,-0.239401f,-0.960207f,0.143839f,-0.252871f,-0.961947f,0.103509f,-0.255148f,-0.964637f,0.0661486f,-0.30251f,-0.817408f,0.490236f,-0.262522f,-0.87233f,0.412459f,-0.242992f,-0.916255f,0.318482f,-0.203341f,-0.939797f,0.274651f,-0.201242f,-0.966215f,0.161031f,-0.160858f,-0.969341f,0.185749f,-0.237592f,-0.931817f,0.27435f,-0.120862f,-0.98281f,0.139561f,-0.234791f,-0.95841f,0.162244f,-0.27086f,-0.78936f,-0.55095f,-0.26812f,-0.716288f,-0.644239f,-0.293002f,-0.597802f,-0.746179f,-0.348171f,-0.437229f,-0.829221f,-0.360328f,-0.279904f,-0.889841f,-0.385429f,-0.108715f,-0.916311f,-0.360593f,0.108715f,-0.926366f,-0.360328f,0.279904f,-0.889841f,-0.348171f,0.437229f,-0.829221f,-0.287842f,0.607359f,-0.740448f,-0.226056f,0.811427f,-0.538966f,-0.314546f,0.810325f,-0.494404f,-0.26078f,0.720031f,-0.643078f,-0.258642f,0.876316f,-0.406417f,-0.303238f,0.888614f,-0.34411f,-0.342956f,0.928883f,-0.139848f,-0.352407f,0.931746f,-0.0875134f,-0.391518f,0.918499f,-0.0554398f,-0.382677f,0.923882f,0f,-0.237254f,0.939411f,-0.247421f,-0.27445f,0.936178f,-0.219654f,-0.306878f,0.932903f,-0.188462f,-0.391518f,0.918499f,0.0554398f,-0.352407f,0.931746f,0.0875134f,-0.342956f,0.928883f,0.139848f,-0.306878f,0.932903f,0.188462f,-0.27445f,0.936178f,0.219654f,-0.237254f,0.939411f,0.247421f,-0.303238f,0.888614f,0.34411f,-0.348171f,0.437229f,0.829221f,-0.360328f,0.279904f,0.889841f,-0.360593f,0.108715f,0.926366f,-0.287842f,0.607359f,0.740448f,-0.385429f,-0.108715f,0.916311f,-0.258642f,0.876316f,0.406417f,-0.314546f,0.810325f,0.494404f,-0.226056f,0.811427f,0.538966f,-0.26078f,0.720031f,0.643078f,-0.360328f,-0.279904f,0.889841f,-0.348171f,-0.437229f,0.829221f,-0.293002f,-0.597802f,0.746179f,-0.264092f,-0.715676f,0.646577f,-0.27086f,-0.78936f,0.55095f,-0.227208f,-0.973846f,0f,-0.192223f,-0.977227f,-0.0898771f,-0.152122f,-0.987845f,-0.0319572f,-0.226799f,-0.972774f,-0.0476768f,-0.15534f,-0.982689f,-0.100957f,-0.230999f,-0.961299f,-0.150147f,-0.231002f,-0.9613f,-0.150134f,-0.116641f,-0.990276f,-0.075815f,-0.215591f,-0.848387f,-0.483488f,-0.16855f,-0.937804f,-0.303504f,-0.245027f,-0.863283f,-0.441253f,-0.245221f,-0.863112f,-0.441479f,-0.127249f,-0.965074f,-0.228997f,-0.742907f,0.344608f,-0.573877f,-0.753178f,6.71937e-006f,-0.657817f,-0.665536f,0.240623f,-0.706514f,-0.711936f,9.81022e-006f,-0.702244f};
			return value;
		}
		private float[] getNormal_11_29_vector_4()
		{
			float[] value = {-0.711977f,0f,-0.702203f,-0.638336f,2.12197e-006f,-0.769758f,-0.559732f,0.224603f,-0.797655f,-0.599171f,0f,-0.800621f,-0.599163f,-2.20451e-006f,-0.800627f,-0.530798f,0f,-0.847498f,-0.191396f,-0.978819f,0.072667f,-0.15534f,-0.982687f,0.10097f,-0.230996f,-0.961303f,0.150124f,-0.230885f,-0.961345f,0.150029f,-0.116459f,-0.99031f,0.0756561f,-0.226693f,-0.972801f,0.0476271f,-0.114016f,-0.993191f,0.0239361f,-0.215389f,-0.867089f,0.449183f,-0.168549f,-0.937826f,0.303435f,-0.245028f,-0.863271f,0.441276f,-0.244998f,-0.863333f,0.44117f,-0.12688f,-0.965252f,0.228454f,-0.638336f,2.12197e-006f,0.769758f,-0.654814f,0.235268f,0.718239f,-0.549308f,0.219721f,0.806215f,-0.599171f,0f,0.800621f,-0.530798f,0f,0.847498f,-0.599163f,-2.20451e-006f,0.800627f,-0.729462f,0.337335f,0.595055f,-0.753178f,6.71937e-006f,0.657817f,-0.711977f,0f,0.702203f,-0.711936f,9.81022e-006f,0.702244f,-0.226587f,-0.590722f,-0.774407f,-0.239927f,-0.711519f,-0.660436f,-0.129751f,-0.925f,-0.357128f,-0.252975f,-0.386021f,-0.887125f,-0.231057f,-0.555362f,-0.798865f,-0.220288f,-0.449905f,-0.865482f,-0.241566f,-0.283253f,-0.928124f,-0.190697f,-0.0575071f,-0.979963f,-0.132015f,0.0287245f,-0.990831f,-0.228843f,0.28372f,-0.9312f,-0.208535f,0.470753f,-0.857266f,-0.185958f,0.603012f,-0.775755f,-0.177072f,0.724342f,-0.666314f,-0.137634f,0.834935f,-0.532861f,-0.15932f,0.897723f,-0.410744f,-0.177719f,0.94366f,-0.279146f,-0.190773f,0.975573f,-0.108915f,-0.185567f,0.979714f,-0.075667f,-0.221666f,0.973317f,-0.0593094f,-0.241694f,0.969914f,-0.0291741f,-0.233431f,0.972373f,0f,-0.241694f,0.969914f,0.0291741f,-0.136661f,0.978689f,-0.153268f,-0.184288f,0.971748f,-0.147461f,-0.221666f,0.973317f,0.0593094f,-0.185567f,0.979714f,0.075667f,-0.190773f,0.975573f,0.108915f,-0.184288f,0.971748f,0.147461f,-0.136661f,0.978689f,0.153268f,-0.177719f,0.94366f,0.279146f,-0.208535f,0.470753f,0.857266f,-0.228843f,0.28372f,0.9312f,-0.117454f,0.0138093f,0.992982f,-0.190697f,-0.0575071f,0.979963f,-0.177072f,0.724342f,0.666314f,-0.185958f,0.603012f,0.775755f,-0.241566f,-0.283253f,0.928124f,-0.15932f,0.897723f,0.410744f,-0.137634f,0.834935f,0.532861f,-0.223516f,-0.454564f,0.862214f,-0.231057f,-0.555362f,0.798865f,-0.252975f,-0.386021f,0.887125f,-0.171265f,-0.865109f,0.47144f,-0.23987f,-0.711641f,0.660325f,-0.226587f,-0.590722f,0.774407f,-0.966811f,0.253327f,-0.0332075f,-1f,0f,0f,-0.935867f,0.305036f,-0.176367f,-0.956491f,0f,-0.291762f,-0.953739f,0.182636f,-0.238801f,-0.874013f,0.272351f,-0.4024f,-0.929184f,-3.39652e-006f,-0.369619f,-0.929168f,-4.13414e-006f,-0.369658f,-0.865833f,0f,-0.500334f,-0.44565f,0.281325f,-0.849855f,-0.43334f,0f,-0.901231f,-0.373401f,0.198465f,-0.906192f,-0.401598f,-3.63521e-006f,-0.915816f,-0.401587f,-4.73107e-006f,-0.915821f,-0.345416f,0f,-0.93845f,-0.581339f,0.634539f,-0.509318f,-0.511261f,0.597259f,-0.617976f,-0.642783f,0.669141f,-0.372934f,-0.43866f,0.561564f,-0.701587f,-0.865831f,0.267961f,0.422533f,-0.865833f,0f,0.500334f,-0.921033f,0.296869f,0.252126f,-0.956491f,0f,0.291762f,-0.929168f,-4.13414e-006f,0.369658f,-0.929184f,-3.39652e-006f,0.369619f,-0.922378f,0.383012f,0.0502046f,-0.963251f,0.187545f,0.192289f};
			return value;
		}
		private float[] getNormal_11_29_vector_5()
		{
			float[] value = {-0.43334f,0f,0.901231f,-0.432675f,0.275685f,0.858365f,-0.364251f,0.195062f,0.910644f,-0.401598f,-3.63521e-006f,0.915816f,-0.345416f,0f,0.93845f,-0.401587f,-4.73107e-006f,0.915821f,-0.390701f,0.539874f,0.745579f,-0.462885f,0.573072f,0.676259f,-0.535186f,0.609662f,0.584713f,-0.603236f,0.646645f,0.466858f,-0.281734f,0.25242f,-0.925694f,-0.25152f,-0.332018f,-0.909121f,-0.152945f,-0.203328f,-0.967091f,-0.186779f,-0.213419f,-0.95894f,-0.19829f,-0.170608f,-0.965181f,-0.130406f,-0.00460707f,-0.99145f,-0.10423f,-0.000472785f,-0.994553f,-0.146843f,-0.00255656f,-0.989156f,0.0672622f,-0.157219f,-0.985271f,-0.0696318f,0.00267026f,-0.997569f,0.0448207f,-0.170002f,-0.984424f,0.04891f,-0.182225f,-0.98204f,0.0856565f,-0.139114f,-0.986565f,0.295044f,0.044648f,-0.95444f,0.346121f,0.0516862f,-0.936765f,0.146067f,-0.144862f,-0.978611f,0.166987f,-0.109139f,-0.9799f,0.130168f,-0.0760368f,-0.988572f,0.137039f,-0.0510128f,-0.989251f,0.295096f,-0.044663f,-0.954423f,0.193449f,0.000163849f,-0.98111f,0.14338f,0.026032f,-0.989325f,0.177388f,0.0912084f,-0.979905f,0.13673f,0.0511372f,-0.989288f,0.146074f,0.144873f,-0.978608f,0.117114f,0.0985425f,-0.988217f,0.085662f,0.139107f,-0.986565f,0.101945f,0.188446f,-0.976778f,0.0448146f,0.170002f,-0.984424f,0.0481297f,0.218955f,-0.974547f,-0.0135959f,0.0804846f,-0.996663f,-0.0758069f,-0.00150765f,-0.997121f,-0.0699349f,-0.00254016f,-0.997548f,-0.0802128f,0.0f,-0.996778f,-0.135088f,0.369945f,-0.91918f,-0.136328f,0.448305f,-0.883424f,-0.135344f,0.519832f,-0.843479f,-0.110413f,0.759577f,-0.640977f,-0.103681f,0.819161f,-0.564115f,-0.0473293f,0.978691f,-0.19981f,-0.114378f,0.895145f,-0.430852f,-0.0895925f,0.943188f,-0.319952f,-0.111839f,0.950995f,-0.288271f,-0.0748715f,0.98099f,-0.179033f,-0.0951154f,0.9842f,-0.149342f,-0.0651159f,0.997234f,-0.0358416f,-0.0743324f,0.995459f,-0.0594679f,-0.0703196f,0.997112f,-0.0286702f,-0.0743714f,0.997008f,-0.0210568f,-0.0928957f,0.995581f,-0.0137503f,-0.104821f,0.994491f,0.0f,-0.0928957f,0.995581f,0.0137503f,-0.0449743f,0.997616f,-0.0523334f,-0.0743714f,0.997008f,0.0210568f,-0.0703196f,0.997112f,0.0286702f,-0.0651159f,0.997234f,0.0358416f,-0.0743325f,0.995459f,0.0594679f,-0.0449743f,0.997616f,0.0523334f,-0.0951154f,0.9842f,0.149343f,-0.0748715f,0.98099f,0.179033f,-0.111839f,0.950995f,0.288271f,-0.135344f,0.519832f,0.843479f,-0.136328f,0.448305f,0.883424f,-0.135088f,0.369945f,0.91918f,-0.0209731f,0.00160201f,0.999779f,-0.104477f,-0.00256268f,0.994524f,-0.00209734f,0.090638f,0.995882f,-0.0896869f,0.0f,0.99597f,-0.0784368f,-0.00190474f,0.996917f,-0.0687754f,-0.00188462f,0.99763f,0.044816f,0.170001f,0.984424f,0.101945f,0.188444f,0.976778f,0.0856583f,0.139114f,0.986565f,0.146067f,0.144863f,0.978611f,0.166986f,0.109139f,0.9799f,0.130163f,0.0760348f,0.988573f,0.137034f,0.0510108f,0.989252f,0.295097f,0.0446631f,0.954423f,0.271366f,-0.000292105f,0.962476f,0.34661f,-0.0517411f,0.936581f,0.295032f,-0.0446468f,0.954444f,0.143658f,-0.0260607f,0.989284f,0.137014f,-0.0511641f,0.989247f,0.177395f,-0.0912103f,0.979904f,0.117126f,-0.0985453f,0.988216f,0.146072f,-0.144872f,0.978609f,0.0856595f,-0.139106f,0.986566f,0.101945f,-0.188446f,0.976778f,0.044816f,-0.170005f,0.984424f,0.0481327f,-0.21896f,0.974546f};
			return value;
		}
		private float[] getNormal_11_29_vector_6()
		{
			float[] value = {0.0178804f,-0.145791f,0.989154f,-0.121143f,-0.00575773f,0.992618f,-0.161093f,-0.240328f,0.957231f,-0.15198f,-0.00191677f,0.988382f,-0.074981f,0.897165f,0.435285f,-0.114378f,0.895145f,0.430852f,-0.0895925f,0.943188f,0.319952f,-0.0473293f,0.978691f,0.19981f,-0.0666027f,0.92965f,0.362375f,-0.199094f,-0.213407f,0.956462f,-0.181141f,-0.141839f,0.973175f,-0.27034f,0.24886f,0.930046f,-0.25152f,-0.332018f,0.909121f,-0.878336f,0.452546f,-0.154039f,-0.706769f,0.70677f,-0.0308823f,-0.826675f,0.562591f,-0.0100378f,-0.687303f,0.69517f,-0.210604f,-0.80108f,0.557129f,-0.218811f,-0.825271f,0.561636f,0.0590971f,-0.696962f,0.700897f,0.151616f,-0.872563f,0.449088f,0.192232f,-0.367111f,0.529883f,-0.764496f,-0.298216f,0.503267f,-0.811042f,0f,-1f,0f,-0.660034f,0.67911f,0.321195f,-0.791258f,0.551084f,0.264987f,-0.253968f,0.488467f,0.834806f,-0.320824f,0.511515f,0.797135f,-0.232369f,0.481996f,-0.844798f,-0.209011f,0.242622f,-0.947338f,-0.150588f,0.156594f,-0.976116f,-0.121825f,0f,-0.992552f,0f,1f,0f,-0.0748265f,0.231429f,-0.96997f,-0.045989f,1.46407e-005f,-0.998942f,-0.0182546f,0.152681f,-0.988107f,-0.0509786f,-0.00188531f,-0.998698f,-0.0163783f,0f,-0.999866f,-0.00727921f,0f,-0.999974f,0.0163834f,0f,-0.999866f,0.0504792f,0.188386f,-0.980797f,0.0196541f,0f,-0.999807f,0.0021001f,0.0906347f,-0.995882f,0.0699349f,-0.00254016f,-0.997548f,0.00655125f,0f,-0.999979f,0.0307772f,0.233772f,-0.971804f,-0.0102646f,0.233873f,-0.972213f,-0.0256689f,0.19497f,-0.980473f,-0.0587407f,0.186162f,-0.980762f,-0.0752505f,0.181676f,-0.980475f,0.118388f,0.456275f,-0.881928f,0.231873f,0.424695f,-0.875139f,0.333895f,0.350214f,-0.875137f,0.41316f,0.251868f,-0.875135f,0.464276f,0.136378f,-0.875128f,0.672075f,0.171689f,-0.720304f,0.683453f,0.00311502f,-0.729988f,0.466544f,-0.128089f,-0.875174f,0.435645f,-0.245755f,-0.86592f,0.35021f,-0.333892f,-0.87514f,0.238922f,-0.406346f,-0.881929f,0.0752535f,-0.18168f,-0.980474f,0.0481431f,0.00123196f,-0.99884f,-0.0704462f,-0.223251f,-0.972212f,-0.0148652f,-0.121218f,-0.992515f,-0.0307771f,-0.233772f,-0.971804f,1.98398e-006f,-0.195031f,-0.980797f,0.0307773f,-0.233773f,-0.971804f,0.0504757f,-0.188387f,-0.980797f,-0.00010213f,1f,-4.32023e-005f,-0.000622345f,1.0f,0.0f,-0.000493629f,1.0f,0.000208811f,-0.000551846f,1.0f,0.000798787f,-0.000525655f,1.0f,0.000454406f,-0.00082668f,0.999998f,0.00189312f,-0.0309263f,0.989047f,0.144323f,0.000306581f,1.0f,-0.000443771f,0.041522f,0.980168f,-0.19377f,-0.0626509f,0.95425f,-0.292372f,-0.00082668f,0.999998f,-0.00189312f,-0.000551846f,1.0f,-0.000798787f,-0.000630786f,1.0f,-0.000545287f,0.041522f,0.980168f,0.19377f,0.0386829f,0.985817f,-0.163308f,0.0006889f,0.999999f,-0.0015776f,0.000370222f,1.0f,0.000156608f,0.000250839f,1.0f,0.000363085f,0.0006889f,0.999999f,0.0015776f,0.0425792f,0.982789f,0.179757f,0.000350436f,1.0f,0.000302937f,0.000396037f,1.0f,0.0f,0.000370222f,1.0f,-0.000156608f,0.000350436f,1.0f,-0.000302937f,-0.027688f,0.99759f,-0.0636225f,-0.02827f,0.994918f,-0.096637f,-0.0564309f,0.978813f,-0.196828f,-0.029169f,0.998521f,-0.0458897f,-0.029169f,0.998521f,0.0458897f,-0.027688f,0.99759f,0.0636225f,-0.02827f,0.994918f,0.096637f};
			return value;
		}
		private float[] getNormal_11_29_vector_7()
		{
			float[] value = {-0.0564309f,0.978813f,0.196828f,-1.98398e-006f,-0.195031f,0.980797f,-0.0307773f,-0.233773f,0.971804f,0.050479f,-0.188386f,0.980797f,-0.0704414f,-0.223244f,0.972214f,-0.0752511f,-0.181677f,0.980475f,0.0307771f,-0.233772f,0.971804f,-0.0148653f,-0.121212f,0.992515f,0.0699356f,0.00534196f,0.997537f,0.118388f,-0.456274f,0.881929f,0.231873f,-0.424695f,0.875139f,0.333894f,-0.350213f,0.875138f,0.41316f,-0.251868f,0.875135f,0.464276f,-0.136378f,0.875128f,0.672075f,-0.171689f,0.720304f,0.683453f,-0.00311503f,0.729988f,0.466544f,0.128089f,0.875174f,0.435645f,0.245756f,0.86592f,0.350211f,0.333892f,0.875139f,0.238921f,0.406346f,0.88193f,0.0902316f,0.21784f,0.971804f,-0.0163783f,0f,0.999866f,-0.0109191f,0f,0.99994f,0.0524592f,-0.00190541f,0.998621f,0.00363946f,0f,0.999993f,0.0245669f,0f,0.999698f,0.0533849f,0.0399904f,0.997773f,-0.0704464f,0.223251f,0.972212f,-0.0307772f,0.233772f,0.971804f,1.70748e-006f,0.195031f,0.980797f,0.030777f,0.233773f,0.971804f,0.0403433f,0.150571f,0.987776f,-0.0509786f,-0.00188531f,0.998698f,-0.045989f,1.46407e-005f,0.998942f,-0.0647081f,0.230604f,0.970894f,-0.0115817f,0.152696f,0.988205f,0.0163834f,0f,0.999866f,-0.198205f,0.240026f,0.950317f,-0.140395f,0.175172f,0.974476f,-0.133235f,0f,0.991084f,-0.190019f,0.470721f,0.861577f,-0.128477f,0.458062f,0.879587f,-0.0686607f,0.450271f,0.890248f,-0.0097701f,0.44719f,0.894386f,0.0489863f,0.448732f,0.892323f,0.0513715f,0.138232f,0.989067f,0.108403f,0.454943f,0.883898f,0.128786f,0.235695f,0.963256f,0.169294f,0.465967f,0.868455f,0.190249f,0.181618f,0.96479f,0.232369f,0.481996f,0.844798f,0.268403f,0.252441f,0.929642f,0.298216f,0.503267f,0.811042f,0.345538f,0.265307f,0.90012f,0.367111f,0.529883f,0.764496f,0.425639f,0.210442f,0.880083f,0.43866f,0.561564f,0.701587f,0.520999f,0.300521f,0.798904f,0.511261f,0.597259f,0.617976f,0.621209f,0.240728f,0.745754f,0.581339f,0.634539f,0.509318f,0.729032f,0.257432f,0.634224f,0.642783f,0.669141f,0.372934f,0.81968f,0.365265f,0.441256f,0.687303f,0.69517f,0.210604f,0.897511f,0.324206f,0.298938f,0.706769f,0.70677f,0.0308823f,0.816432f,0.556293f,0.154843f,0.88816f,0.458094f,0.0363611f,0.696962f,0.700897f,-0.151616f,0.886162f,0.457064f,-0.0762181f,0.809091f,0.551969f,-0.201747f,0.660034f,0.67911f,-0.321195f,0.88978f,0.320382f,-0.325034f,0.807852f,0.358771f,-0.467609f,0.603236f,0.646645f,-0.466858f,0.717938f,0.251779f,-0.648978f,0.535186f,0.609662f,-0.584713f,0.610001f,0.235152f,-0.756705f,0.462885f,0.573072f,-0.676259f,0.507098f,0.293793f,-0.81027f,0.390701f,0.539874f,-0.745579f,0.415681f,0.206169f,-0.885835f,0.320824f,0.511515f,-0.797135f,0.333341f,0.260661f,-0.906057f,0.253968f,0.488467f,-0.834806f,0.256977f,0.248839f,-0.933832f,0.190019f,0.470721f,-0.861577f,0.182114f,0.179649f,-0.966727f,0.128477f,0.458062f,-0.879587f,0.118401f,0.233977f,-0.965006f,0.0686607f,0.450271f,-0.890248f,0.0453212f,0.137722f,-0.989433f,0.0097701f,0.44719f,-0.894386f,-0.0489863f,0.448732f,-0.892323f,-0.108403f,0.454943f,-0.883898f,-0.169294f,0.465967f,-0.868455f,0.623544f,1.51498e-005f,0.781789f,0.623057f,0.0f,0.782177f,0.623272f,0.0f,0.782005f};
			return value;
		}
		private float[] getNormal_11_29_vector_8()
		{
			float[] value = {0.623815f,2.93756e-005f,0.781572f,0.62349f,0f,0.781831f,1f,0f,0f,-0.222579f,-2.39949e-006f,0.974915f,-0.222598f,-4.95e-006f,0.97491f,-0.222559f,0f,0.974919f,-0.222534f,0f,0.974925f,-0.900969f,0f,0.433884f,-0.900973f,0f,0.433875f,-0.900969f,0f,-0.433884f,-0.222579f,-2.39949e-006f,-0.974915f,-0.222559f,0f,-0.974919f,-0.222598f,-4.95e-006f,-0.97491f,-0.222534f,0f,-0.974925f,0.623544f,1.51498e-005f,-0.781789f,0.623272f,0f,-0.782005f,0.623057f,0f,-0.782177f,0.623814f,3.02995e-005f,-0.781573f,0.62349f,0f,-0.781831f,0.623501f,0f,0.781823f,0.623532f,0f,0.781797f,0.62351f,0f,0.781815f,-0.222624f,0f,0.974904f,-0.222523f,0f,0.974928f,-0.90098f,0f,0.43386f,-0.900878f,1.61206e-005f,0.434073f,-0.900909f,1.07471e-005f,0.434007f,-0.900874f,1.61206e-005f,-0.43408f,-0.90098f,0f,-0.43386f,-0.900909f,1.07471e-005f,-0.434007f,-0.900973f,0f,-0.433875f,-0.222624f,0f,-0.974904f,-0.222523f,0f,-0.974928f,0.623501f,0f,-0.781823f,0.62351f,0f,-0.781815f,0.623532f,0f,-0.781797f,0.0572395f,-0.00253293f,-0.998357f,0.0759214f,-0.00151972f,-0.997113f,0.0896653f,9.55108e-006f,-0.995972f,0.0769335f,0.0f,-0.997036f,-0.0840227f,0.198718f,-0.976448f,-0.937434f,0.299599f,0.177365f,-0.0880397f,0.0407768f,-0.995282f,-0.310766f,0.0457091f,-0.949387f,-0.0955826f,0.015845f,-0.995295f,0.1453f,0.0287366f,-0.98897f,-0.121498f,0.0910723f,-0.988405f,0.176454f,0.00861075f,-0.984271f,0.578f,0.0571333f,-0.814034f,0.353063f,0.0295961f,-0.935131f,-0.0866389f,-0.0206399f,-0.996026f,-0.158404f,-0.0275865f,-0.986989f,-0.100247f,-0.0421008f,-0.994071f,-0.177395f,-0.0912103f,-0.979904f,-0.146079f,-0.144876f,-0.978607f,-0.0721852f,-0.0787284f,-0.994279f,0.45265f,0.490109f,0.744917f,0.254899f,0.360968f,0.897067f,-0.0856713f,-0.139111f,-0.986564f,0.0370281f,0.203334f,0.978409f,-0.0448141f,-0.170002f,-0.984424f,0.104477f,-0.00256268f,-0.994524f,0.174206f,-0.0670895f,-0.982421f,-0.0672664f,0.157221f,-0.98527f,-0.131382f,0.159478f,-0.97842f,-0.104091f,0.12089f,-0.987193f,-0.227904f,0.412687f,-0.881901f,-0.122319f,0.468059f,-0.875191f,-0.00498828f,0.500155f,-0.865921f,0.179088f,0.683951f,-0.707205f,-0.00403551f,0.706998f,-0.707204f,0.350005f,0.614297f,-0.707203f,0.497071f,0.502777f,-0.707203f,0.610262f,0.356995f,-0.707203f,0.83556f,0.226845f,-0.50038f,0.748378f,0.435375f,-0.500379f,0.865802f,0.00285873f,-0.500379f,0.683951f,-0.179088f,-0.707205f,0.614297f,-0.350005f,-0.707203f,0.502778f,-0.49707f,-0.707203f,0.356993f,-0.61026f,-0.707204f,0.136346f,-0.464267f,-0.875138f,0.0115413f,-0.483737f,-0.875138f,-0.114053f,-0.470239f,-0.875138f,-0.14757f,-0.356269f,-0.922657f,0.135088f,0.369945f,-0.91918f,0.137634f,0.834935f,-0.532861f,0.0816345f,0.89222f,-0.444161f,0.136328f,0.448305f,-0.883424f,0.228843f,0.28372f,-0.9312f,0.135344f,0.519832f,-0.843479f,0.208535f,0.470753f,-0.857266f,0.185958f,0.603012f,-0.775755f,0.177072f,0.724342f,-0.666314f,0.0899911f,0.847925f,-0.522422f,0.114378f,0.895145f,-0.430852f,0.0895925f,0.943188f,-0.319952f,0.0564309f,0.978813f,-0.196828f,0.02827f,0.994918f,-0.096637f,0.027688f,0.99759f,-0.0636225f};
			return value;
		}
		private float[] getNormal_11_29_vector_9()
		{
			float[] value = {0.029169f,0.998521f,-0.0458897f,0.0449743f,0.997616f,-0.0523334f,0.0743324f,0.995459f,-0.0594679f,0.0651159f,0.997234f,-0.0358416f,0.0703196f,0.997112f,-0.0286702f,0.0743714f,0.997008f,-0.0210568f,0.104821f,0.994491f,0f,0.0928957f,0.995581f,0.0137503f,0.0743714f,0.997008f,0.0210568f,0.0928957f,0.995581f,-0.0137503f,0.0703196f,0.997112f,0.0286702f,0.0651159f,0.997234f,0.0358416f,0.0743324f,0.995459f,0.0594679f,0.0449743f,0.997616f,0.0523334f,0.029169f,0.998521f,0.0458897f,0.027688f,0.99759f,0.0636225f,0.02827f,0.994918f,0.096637f,0.0564309f,0.978813f,0.196828f,0.0895925f,0.943188f,0.319952f,0.114378f,0.895145f,0.430852f,0.137634f,0.834935f,0.532861f,0.0816345f,0.89222f,0.444161f,0.0899911f,0.847925f,0.522422f,0.177072f,0.724342f,0.666314f,0.135344f,0.519832f,0.843479f,0.185958f,0.603012f,0.775755f,0.208535f,0.470753f,0.857266f,0.228843f,0.28372f,0.9312f,0.136328f,0.448305f,0.883424f,0.125338f,0.0148953f,0.992002f,0.135088f,0.369945f,0.91918f,0.0759214f,-0.00151972f,0.997113f,0.104477f,-0.00256248f,0.994524f,0.0683571f,0f,0.997661f,0.156884f,-0.0512316f,0.986287f,-0.0448159f,0.170004f,0.984424f,-0.0840226f,-0.198719f,0.976448f,-0.0672654f,-0.15722f,0.98527f,-0.131387f,-0.159483f,0.978418f,-0.104039f,-0.120859f,0.987203f,-0.166987f,-0.109139f,0.9799f,-0.130168f,-0.0760368f,0.988572f,-0.137039f,-0.0510128f,0.989251f,-0.206672f,-0.0344341f,0.977804f,-0.347166f,-0.0169679f,0.93765f,-0.395254f,0.057098f,0.916796f,-0.206378f,0.0343896f,0.977868f,-0.143666f,0.0260616f,0.989283f,-0.137023f,0.0511649f,0.989246f,-0.177395f,0.0912105f,0.979904f,-0.117126f,0.0985466f,0.988216f,-0.146072f,0.144872f,0.978609f,-0.08566f,0.139106f,0.986566f,-0.101944f,0.188445f,0.976778f,0.0389189f,-0.205999f,-0.977778f,0.700219f,0.700218f,-0.139241f,0.653214f,0.707111f,-0.27075f,0.706835f,0.706819f,0.0281201f,0.707107f,0.707107f,4.49777e-005f,0.65326f,0.707104f,-0.270658f,0.593623f,0.700216f,-0.396621f,0.499997f,0.707108f,-0.500002f,0.593811f,0.700245f,-0.396289f,0.593468f,0.700195f,-0.396892f,0.593818f,0.700253f,-0.396265f,0.500002f,0.707113f,-0.499989f,0.39664f,0.700215f,-0.593613f,0.27062f,0.707107f,-0.653272f,0.270634f,0.707102f,-0.653272f,0.139287f,0.700215f,-0.700212f,0f,0.707107f,-0.707107f,0.139314f,0.700221f,-0.700201f,0.139237f,0.70021f,-0.700227f,0.13927f,0.700213f,-0.700218f,-0.227034f,0.706328f,-0.670489f,-0.139277f,0.700215f,-0.700215f,-0.355662f,0.70402f,-0.614704f,-0.396636f,0.700216f,-0.593614f,-0.449166f,0.705364f,-0.548372f,-0.39661f,0.700222f,-0.593624f,-0.396588f,0.700227f,-0.593633f,-0.396674f,0.700206f,-0.5936f,-0.532567f,0.706331f,-0.466335f,-0.593616f,0.700213f,-0.396637f,-0.624826f,0.705364f,-0.334744f,-0.670483f,0.706332f,-0.227041f,-0.700209f,0.700218f,-0.139292f,-0.706825f,0.706829f,-0.0281258f,-0.707107f,0.707107f,-4.54444e-006f,-0.700215f,0.700215f,0.139278f,-0.653283f,0.707106f,0.270596f,-0.593613f,0.700215f,0.396639f,-0.500018f,0.70708f,0.500019f,-0.449178f,0.705367f,0.548357f,-0.39669f,0.700185f,0.593615f,-0.396719f,0.700109f,0.593684f,-0.396662f,0.700219f,0.593593f,-0.396638f,0.700213f,0.593616f,-0.270603f,0.707106f,0.65328f,-0.270614f,0.707105f,0.653277f};
			return value;
		}
		private float[] getNormal_11_29_vector_10()
		{
			float[] value = {-0.139288f,0.700215f,0.700212f,4.52564e-006f,0.707087f,0.707126f,0.0701171f,0.70537f,0.705363f,0.139244f,0.700197f,0.70024f,0.139289f,0.700136f,0.700292f,0.13923f,0.700225f,0.700215f,0.139274f,0.700216f,0.700214f,0.227044f,0.706328f,0.670486f,0.313579f,0.706327f,0.634642f,0.480143f,0.706557f,0.519847f,0.396627f,0.700216f,0.59362f,0.548316f,0.705383f,0.449204f,0.61862f,0.704706f,0.347417f,0.592953f,0.700635f,0.396884f,0.593629f,0.700012f,0.396974f,0.594694f,0.698847f,0.397431f,0.59369f,0.700185f,0.396578f,0.670507f,0.706323f,0.226999f,0.700234f,0.700203f,0.139239f,0.700215f,0.700215f,-0.139278f,0.653283f,0.707106f,-0.270596f,0.706825f,0.706829f,0.0281258f,0.707107f,0.707107f,4.54444e-006f,0.593613f,0.700214f,-0.39664f,0.270603f,0.707107f,-0.653279f,0.1393f,0.700218f,-0.700208f,-0.355646f,0.704018f,-0.614714f,-0.396627f,0.700216f,-0.59362f,-0.449187f,0.705353f,-0.548368f,-0.396491f,0.700246f,-0.593676f,-0.39652f,0.700237f,-0.593667f,-0.396694f,0.700197f,-0.593598f,-0.532606f,0.706322f,-0.466305f,-0.59369f,0.700185f,-0.396578f,-0.624859f,0.705351f,-0.334712f,-0.670507f,0.706323f,-0.226999f,-0.700234f,0.700203f,-0.139239f,-0.706835f,0.706819f,-0.0281201f,-0.707107f,0.707107f,-4.49777e-005f,-0.700219f,0.700218f,0.139241f,-0.653269f,0.707106f,0.27063f,-0.65326f,0.707104f,0.270658f,-0.593592f,0.700208f,0.396683f,-0.500096f,0.707f,0.500054f,-0.4492f,0.705373f,0.548332f,-0.39681f,0.700089f,0.593647f,-0.397004f,0.699802f,0.593856f,-0.396675f,0.700223f,0.59358f,-0.270634f,0.707102f,0.653272f,-0.139307f,0.700217f,0.700207f,0f,0.707111f,0.707103f,0.0701675f,0.705362f,0.705365f,0.139297f,0.700211f,0.700214f,0.139275f,0.700231f,0.700199f,0.227033f,0.706332f,0.670486f,0.31357f,0.706331f,0.634642f,0.47992f,0.706823f,0.51969f,0.396636f,0.700216f,0.593614f,0.548374f,0.705365f,0.449162f,0.618791f,0.704599f,0.347329f,0.593624f,0.700205f,0.39664f,0.593626f,0.700193f,0.396658f,0.593616f,0.700213f,0.396637f,0.670483f,0.706332f,0.227041f,0.700209f,0.700218f,0.139292f,-0.227904f,-0.412687f,0.881901f,-0.134268f,-0.481821f,0.865922f,-0.0115413f,-0.483737f,0.875138f,-0.00403561f,-0.706998f,0.707204f,0.179087f,-0.683951f,0.707205f,0.350004f,-0.614296f,0.707204f,0.497071f,-0.502776f,0.707204f,0.610261f,-0.356995f,0.707203f,0.748378f,-0.435375f,0.500378f,0.83556f,-0.226845f,0.50038f,0.865802f,-0.00285873f,0.500379f,0.683951f,0.179088f,0.707205f,0.614297f,0.350005f,0.707203f,0.502778f,0.497071f,0.707203f,0.356995f,0.610262f,0.707203f,0.136347f,0.464267f,0.875137f,0.0115409f,0.483737f,0.875137f,-0.114054f,0.470239f,0.875138f,-0.14757f,0.356268f,0.922657f,0.0572395f,-0.00253293f,0.998357f,0.0769335f,0f,0.997036f,0.150316f,1.37289e-006f,0.988638f,0.142743f,-0.00307092f,0.989755f,0.213018f,-0.170594f,0.96204f,0.186779f,-0.213419f,0.95894f,0.126291f,-0.00511957f,0.99198f,0.263144f,-0.33204f,0.905817f,0.373676f,-2.81168e-006f,0.927559f,0.401587f,-2.09341e-006f,0.915821f,0.464613f,0f,0.885514f,0.401598f,2.12026e-006f,0.915816f,0.565476f,-3.7303e-006f,0.824765f,0.599162f,3.97995e-006f,0.800628f,0.676039f,0f,0.736865f,0.599171f,9.56581e-006f,0.800621f};
			return value;
		}
		private float[] getNormal_11_29_vector_11()
		{
			float[] value = {0.711977f,2.85005e-006f,0.702203f,0.791784f,0f,0.610801f,0.711937f,1.48864e-006f,0.702244f,0.899952f,-5.18222e-006f,0.435989f,0.937457f,0.119627f,0.3269f,0.929168f,-4.07335e-006f,0.369658f,0.977418f,0f,0.211316f,0.929184f,3.65909e-006f,0.369619f,0.937013f,0.215729f,0.274714f,0.988637f,0.14905f,0.0195383f,0.966811f,0.253327f,-0.0332057f,0.946735f,0.123161f,-0.29753f,0.977418f,0f,-0.211316f,0.921797f,0.209039f,-0.326488f,0.899952f,-5.18222e-006f,-0.435989f,0.929184f,3.65909e-006f,-0.369619f,0.929168f,-4.07335e-006f,-0.369658f,0.791784f,0f,-0.610801f,0.676039f,0f,-0.736865f,0.711937f,1.48864e-006f,-0.702244f,0.711977f,2.85005e-006f,-0.702203f,0.565476f,-3.7303e-006f,-0.824765f,0.599162f,3.97995e-006f,-0.800628f,0.599171f,9.56581e-006f,-0.800621f,0.464613f,0f,-0.885514f,0.373676f,-2.81168e-006f,-0.927559f,0.401587f,-2.09341e-006f,-0.915821f,0.401598f,2.12026e-006f,-0.915816f,0.263144f,-0.33204f,-0.905817f,0.213018f,-0.170594f,-0.96204f,0.150316f,1.37289e-006f,-0.988638f,0.151981f,-0.00191703f,-0.988382f,0.121143f,-0.00575773f,-0.992618f,0.186779f,-0.213419f,-0.95894f,0.152945f,-0.203328f,-0.967091f,0.241566f,-0.283253f,-0.928124f,0.360593f,-0.108715f,-0.926366f,0.385429f,0.108715f,-0.916311f,-0.231873f,-0.424695f,-0.875139f,-0.234747f,-0.305928f,-0.92266f,-0.333894f,-0.350213f,-0.875138f,-0.41316f,-0.251868f,-0.875135f,-0.483099f,-0.129474f,-0.86594f,-0.310125f,-0.0456289f,-0.9496f,-0.681863f,-0.186882f,-0.707204f,-0.607147f,-0.0801121f,-0.790541f,-0.693555f,-0.0151247f,-0.720245f,-0.182218f,0.00974212f,-0.98321f,-0.485144f,0.122222f,-0.865851f,-0.356318f,0.147526f,-0.922645f,-0.417459f,0.244473f,-0.875192f,-0.339962f,0.344191f,-0.875191f,-0.356995f,0.610262f,-0.707203f,-0.502778f,0.497071f,-0.707203f,-0.186882f,0.681863f,-0.707205f,0.221326f,0.837039f,-0.50038f,-0.00285876f,0.865802f,-0.500379f,-0.226845f,0.83556f,-0.500381f,0.430424f,0.751237f,-0.500378f,0.610194f,0.614234f,-0.50038f,0.932622f,0.251422f,-0.25885f,0.835771f,0.484234f,-0.258851f,0.681965f,0.684046f,-0.258853f,0.965916f,0.00147303f,-0.258851f,0.83704f,-0.221326f,-0.500379f,0.751236f,-0.430425f,-0.500378f,0.614236f,-0.610193f,-0.500378f,0.435375f,-0.748378f,-0.500378f,0.186882f,-0.681863f,-0.707205f,0.0040356f,-0.706998f,-0.707204f,-0.179087f,-0.683951f,-0.707205f,0.15932f,0.897723f,-0.410744f,0.226056f,0.811427f,-0.538966f,0.360328f,0.279904f,-0.889841f,0.348171f,0.437229f,-0.829221f,0.287842f,0.607359f,-0.740448f,0.26078f,0.720031f,-0.643078f,0.111839f,0.950995f,-0.288271f,0.0748715f,0.98099f,-0.179033f,0.0951154f,0.9842f,-0.149343f,0.136661f,0.978689f,-0.153269f,0.184288f,0.971748f,-0.147461f,0.190773f,0.975573f,-0.108915f,0.185567f,0.979714f,-0.075667f,0.221666f,0.973317f,-0.0593094f,0.241694f,0.969914f,0.0291741f,0.241694f,0.969914f,-0.0291741f,0.233431f,0.972373f,0.0f,0.221666f,0.973317f,0.0593094f,0.185567f,0.979714f,0.075667f,0.190773f,0.975573f,0.108915f,0.184288f,0.971748f,0.147461f,0.136661f,0.978689f,0.153268f,0.0951154f,0.9842f,0.149343f,0.0748715f,0.98099f,0.179033f,0.111839f,0.950995f,0.288271f,0.15932f,0.897723f,0.410744f,0.226056f,0.811427f,0.538966f,0.26078f,0.720031f,0.643078f,0.287842f,0.607359f,0.740448f};
			return value;
		}
		private float[] getNormal_11_29_vector_12()
		{
			float[] value = {0.348171f,0.437229f,0.829221f,0.360328f,0.279904f,0.889841f,0.385429f,0.108715f,0.916311f,0.360593f,-0.108715f,0.926366f,-0.231873f,0.424695f,0.875139f,-0.333895f,0.350214f,0.875137f,-0.41316f,0.251868f,0.875135f,-0.483099f,0.129473f,0.86594f,-0.681863f,0.186882f,0.707204f,-0.693555f,0.0151247f,0.720245f,-0.485144f,-0.122222f,0.865851f,-0.417458f,-0.244472f,0.875193f,-0.339963f,-0.344192f,0.87519f,0.241566f,-0.283253f,0.928124f,0.163937f,-0.251652f,0.953832f,-0.502778f,-0.49707f,0.707203f,-0.356993f,-0.61026f,0.707204f,-0.186882f,-0.681863f,0.707205f,-0.226847f,-0.835561f,0.500378f,-0.00285784f,-0.865802f,0.500378f,0.221326f,-0.83704f,0.500379f,0.430425f,-0.751236f,0.500378f,0.610194f,-0.614236f,0.500378f,0.681964f,-0.684047f,0.258853f,0.835772f,-0.484233f,0.258852f,0.932622f,-0.251422f,0.25885f,0.965916f,-0.00147303f,0.258851f,0.83704f,0.221326f,0.500379f,0.751237f,0.430424f,0.500378f,0.614234f,0.610194f,0.50038f,0.435375f,0.748377f,0.50038f,0.186882f,0.681863f,0.707205f,0.00403551f,0.706998f,0.707204f,-0.179088f,0.683951f,0.707205f,0.220288f,-0.449905f,0.865482f,0.263185f,-0.386015f,0.884152f,0.264092f,-0.715676f,0.646577f,0.226587f,-0.590722f,0.774407f,0.23987f,-0.711641f,0.660325f,0.171265f,-0.865109f,0.47144f,0.210286f,-0.86764f,0.450534f,0.16855f,-0.937804f,0.303504f,0.260783f,-0.871474f,0.415361f,0.245027f,-0.863283f,0.441253f,0.245028f,-0.863271f,0.441276f,0.168549f,-0.937826f,0.303435f,0.19635f,-0.941276f,0.274675f,0.160858f,-0.969341f,0.185748f,0.25311f,-0.926015f,0.280058f,0.237603f,-0.93181f,0.274364f,0.19628f,-0.966925f,0.16288f,0.15534f,-0.982689f,0.100957f,0.238562f,-0.960322f,0.144467f,0.230999f,-0.961299f,0.150147f,0.230996f,-0.961303f,0.150124f,0.15534f,-0.982687f,0.10097f,0.184295f,-0.979795f,0.0776938f,0.152122f,-0.987845f,0.0319572f,0.251618f,-0.965719f,0.0638366f,0.226799f,-0.972774f,0.0476768f,0.227208f,-0.973846f,0.0f,0.184295f,-0.979795f,-0.0776938f,0.251618f,-0.965719f,-0.0638366f,0.152122f,-0.987845f,-0.0319572f,0.226799f,-0.972774f,-0.0476768f,0.15534f,-0.982687f,-0.10097f,0.19628f,-0.966925f,-0.16288f,0.238562f,-0.960322f,-0.144467f,0.15534f,-0.982689f,-0.100957f,0.230996f,-0.961303f,-0.150124f,0.230999f,-0.961299f,-0.150147f,0.160858f,-0.969341f,-0.185749f,0.19635f,-0.941276f,-0.274675f,0.25311f,-0.926015f,-0.280058f,0.237603f,-0.93181f,-0.274364f,0.168549f,-0.937826f,-0.303435f,0.210286f,-0.86764f,-0.450534f,0.260783f,-0.871474f,-0.415361f,0.16855f,-0.937804f,-0.303504f,0.245028f,-0.863271f,-0.441276f,0.245027f,-0.863283f,-0.441253f,0.171265f,-0.865109f,-0.47144f,0.264092f,-0.715676f,-0.646577f,0.23987f,-0.711641f,-0.660325f,0.226587f,-0.590722f,-0.774407f,0.220288f,-0.449905f,-0.865482f,0.263185f,-0.386015f,-0.884152f,0.348171f,-0.437229f,-0.829221f,0.360328f,-0.279904f,-0.889841f,0.533539f,-0.092057f,-0.840751f,0.558209f,0.0920175f,-0.824582f,0.503261f,-0.285594f,-0.815576f,0.503261f,0.285594f,-0.815576f,-0.350004f,-0.614296f,-0.707204f,-0.497071f,-0.502776f,-0.707204f,-0.610261f,-0.356995f,-0.707203f,-0.83556f,-0.226845f,-0.50038f,-0.748378f,-0.435375f,-0.500379f,-0.683951f,0.179088f,-0.707205f,-0.865802f,-0.00285873f,-0.500379f};
			return value;
		}
		private float[] getNormal_11_29_vector_13()
		{
			float[] value = {-0.614297f,0.350005f,-0.707203f,-0.435375f,0.748377f,-0.50038f,-0.614234f,0.610194f,-0.50038f,-0.751237f,0.430424f,-0.500378f,0.248574f,0.933385f,-0.258851f,-0.00147316f,0.965916f,-0.258852f,-0.251421f,0.932622f,-0.25885f,-0.484235f,0.835771f,-0.258851f,0.481681f,0.837245f,-0.258851f,0.969079f,0.240319f,-0.0559628f,0.864084f,0.499094f,-0.0653028f,0.705468f,0.705727f,-0.0653046f,0.498774f,0.864269f,-0.0653034f,0.99691f,-0.0437483f,-0.0652418f,0.933385f,-0.248574f,-0.258851f,0.837246f,-0.48168f,-0.25885f,0.684047f,-0.681964f,-0.258852f,0.484233f,-0.835771f,-0.258853f,0.226847f,-0.835561f,-0.500378f,0.00285784f,-0.865802f,-0.500378f,-0.221326f,-0.83704f,-0.500379f,0.258642f,0.876316f,-0.406417f,0.177719f,0.94366f,-0.279146f,0.377791f,0.710152f,-0.594103f,0.314546f,0.810325f,-0.494404f,0.481719f,0.439375f,-0.758219f,0.443165f,0.56338f,-0.697286f,0.237254f,0.939411f,-0.247421f,0.306878f,0.932903f,-0.188462f,0.27445f,0.936178f,-0.219654f,0.342956f,0.928883f,-0.139848f,0.352407f,0.931746f,-0.0875134f,0.382677f,0.923882f,0.0f,0.391518f,0.918499f,0.0554398f,0.352407f,0.931746f,0.0875134f,0.391518f,0.918499f,-0.0554398f,0.342956f,0.928883f,0.139848f,0.306878f,0.932903f,0.188462f,0.27445f,0.936178f,0.219654f,0.237254f,0.939411f,0.247421f,0.177719f,0.94366f,0.279146f,0.258642f,0.876316f,0.406417f,0.314546f,0.810325f,0.494404f,0.377791f,0.710152f,0.594103f,0.443165f,0.56338f,0.697286f,0.481719f,0.439375f,0.758219f,0.503261f,0.285594f,0.815576f,0.558209f,0.0920175f,0.824582f,0.533539f,-0.092057f,0.840751f,0.503261f,-0.285594f,0.815576f,0.360328f,-0.279904f,0.889841f,-0.350005f,0.614297f,0.707203f,-0.497071f,0.502777f,0.707203f,-0.610262f,0.356995f,0.707203f,-0.748378f,0.435375f,0.500379f,-0.83556f,0.226845f,0.50038f,-0.865802f,0.00285873f,0.500379f,-0.683951f,-0.179088f,0.707205f,-0.614297f,-0.350005f,0.707203f,0.348171f,-0.437229f,0.829221f,-0.751236f,-0.430425f,0.500378f,-0.614236f,-0.610193f,0.500378f,-0.435375f,-0.748378f,0.500378f,-0.484233f,-0.835771f,0.258853f,-0.251421f,-0.932622f,0.258852f,-0.00147376f,-0.965916f,0.258852f,0.248574f,-0.933384f,0.258852f,0.481681f,-0.837245f,0.258852f,0.536342f,-0.841475f,0.0652436f,0.735856f,-0.673988f,0.0652435f,0.885223f,-0.460569f,0.0652402f,0.974264f,-0.21576f,0.065241f,0.99691f,0.0437483f,0.0652418f,0.933385f,0.248574f,0.258851f,0.837245f,0.481681f,0.258851f,0.684047f,0.681964f,0.258853f,0.484235f,0.835771f,0.258851f,0.226845f,0.83556f,0.500381f,0.00285876f,0.865802f,0.500379f,-0.221326f,0.83704f,0.50038f,0.293002f,-0.597802f,0.746179f,0.231057f,-0.555362f,0.798865f,0.377791f,-0.710152f,0.594103f,0.27086f,-0.78936f,0.55095f,0.30251f,-0.817408f,0.490236f,0.242992f,-0.916255f,0.318482f,0.390053f,-0.808041f,0.441508f,0.303238f,-0.888614f,0.34411f,0.272563f,-0.937802f,0.215028f,0.379103f,-0.874173f,0.303483f,0.234791f,-0.95841f,0.162244f,0.306878f,-0.932903f,0.188462f,0.342956f,-0.928883f,0.139848f,0.252871f,-0.961947f,0.103509f,0.279489f,-0.959494f,0.0354556f,0.352407f,-0.931746f,0.0875134f,0.268453f,-0.963293f,0.0f,0.279489f,-0.959494f,-0.0354556f,0.352407f,-0.931746f,-0.0875134f,0.342956f,-0.928883f,-0.139848f};
			return value;
		}
		private float[] getNormal_11_29_vector_14()
		{
			float[] value = {0.252871f,-0.961947f,-0.103509f,0.306878f,-0.932903f,-0.188462f,0.234791f,-0.95841f,-0.162244f,0.272563f,-0.937802f,-0.215028f,0.379103f,-0.874173f,-0.303483f,0.303238f,-0.888614f,-0.34411f,0.242992f,-0.916255f,-0.318482f,0.390053f,-0.808041f,-0.441508f,0.30251f,-0.817408f,-0.490236f,0.27086f,-0.78936f,-0.55095f,0.377791f,-0.710152f,-0.594103f,0.293002f,-0.597802f,-0.746179f,0.231057f,-0.555362f,-0.798865f,0.443165f,-0.56338f,-0.697286f,0.481719f,-0.439375f,-0.758219f,0.657913f,-0.251388f,-0.709898f,0.657172f,-0.0716094f,-0.750331f,0.681709f,0.0716094f,-0.72811f,0.657913f,0.251388f,-0.709898f,0.594882f,-0.439417f,-0.673073f,0.594882f,0.439417f,-0.673073f,-0.430425f,-0.751236f,-0.500378f,-0.610194f,-0.614236f,-0.500378f,-0.932622f,-0.251422f,-0.25885f,-0.835772f,-0.484233f,-0.258852f,-0.681964f,-0.684047f,-0.258853f,-0.83704f,0.221326f,-0.500379f,-0.965916f,-0.00147304f,-0.258851f,-0.684047f,0.681964f,-0.258853f,-0.837245f,0.481681f,-0.258851f,-0.933385f,0.248574f,-0.258851f,0.258086f,0.963912f,-0.0653027f,-0.000183448f,0.997865f,-0.0653045f,-0.258443f,0.963817f,-0.0653037f,-0.499094f,0.864084f,-0.0653027f,-0.705727f,0.705467f,-0.0653045f,0.951619f,-0.300276f,-0.0652401f,0.841474f,-0.536343f,-0.065242f,0.673985f,-0.735858f,-0.0652443f,0.251421f,-0.932622f,-0.258852f,0.460568f,-0.885224f,-0.065243f,0.00147376f,-0.965916f,-0.258852f,-0.248574f,-0.933384f,-0.258852f,0.390053f,0.808041f,-0.441508f,0.303238f,0.888614f,-0.34411f,0.533586f,0.588263f,-0.607645f,0.496666f,0.696064f,-0.518476f,0.379103f,0.874173f,-0.303483f,0.422781f,0.87423f,-0.2387f,0.490807f,0.847957f,-0.200194f,0.491882f,0.862024f,-0.122337f,0.504345f,0.861542f,-0.0581485f,0.544651f,0.838663f,0.0f,0.504345f,0.861542f,0.0581485f,0.491882f,0.862024f,0.122337f,0.490807f,0.847957f,0.200194f,0.422781f,0.87423f,0.2387f,0.379103f,0.874173f,0.303483f,0.303238f,0.888614f,0.34411f,0.390053f,0.808041f,0.441508f,0.496666f,0.696064f,0.518476f,0.533586f,0.588263f,0.607645f,0.594882f,0.439417f,0.673073f,0.657913f,0.251388f,0.709898f,0.657172f,-0.0716094f,0.750331f,0.681709f,0.0716094f,0.72811f,0.657913f,-0.251388f,0.709898f,0.594882f,-0.439417f,0.673073f,0.481719f,-0.439375f,0.758219f,-0.430424f,0.751237f,0.500378f,-0.610194f,0.614234f,0.50038f,-0.681965f,0.684046f,0.258853f,-0.835771f,0.484234f,0.258851f,-0.932622f,0.251422f,0.25885f,-0.965916f,0.00147303f,0.258851f,-0.83704f,-0.221326f,0.500379f,0.443165f,-0.56338f,0.697286f,-0.933385f,-0.248574f,0.258851f,-0.837246f,-0.48168f,0.25885f,-0.684047f,-0.681964f,0.258852f,-0.673986f,-0.735858f,0.0652443f,-0.460568f,-0.885224f,0.065243f,-0.215762f,-0.974264f,0.065243f,0.0437486f,-0.99691f,0.0652429f,0.300277f,-0.951618f,0.0652431f,0.955858f,0.283195f,0.0783285f,0.864268f,0.498774f,0.0653039f,0.705727f,0.705467f,0.0653045f,0.499094f,0.864084f,0.0653027f,0.251421f,0.932622f,0.25885f,0.00147316f,0.965916f,0.258851f,-0.248574f,0.933385f,0.258851f,0.533586f,-0.588263f,0.607645f,0.496666f,-0.696064f,0.518476f,0.493516f,-0.774729f,0.395267f,0.536593f,-0.787162f,0.304046f,0.422781f,-0.87423f,0.2387f,0.490807f,-0.847957f,0.200194f,0.491882f,-0.862024f,0.122337f,0.382677f,-0.923882f,0.0f};
			return value;
		}
		private float[] getNormal_11_29_vector_15()
		{
			float[] value = {0.391518f,-0.918499f,0.0554398f,0.391518f,-0.918499f,-0.0554398f,0.491882f,-0.862024f,-0.122337f,0.490807f,-0.847957f,-0.200194f,0.422781f,-0.87423f,-0.2387f,0.536593f,-0.787162f,-0.304046f,0.493516f,-0.774729f,-0.395267f,0.496666f,-0.696064f,-0.518476f,0.533586f,-0.588263f,-0.607645f,0.718418f,-0.389905f,-0.576064f,0.754101f,-0.255976f,-0.60482f,0.76931f,-0.0988341f,-0.631184f,0.78308f,0.098834f,-0.614017f,0.754101f,0.255976f,-0.60482f,0.718418f,0.389905f,-0.576064f,0.646442f,-0.560065f,-0.518113f,0.646442f,0.560065f,-0.518113f,-0.481681f,-0.837245f,-0.258852f,-0.974264f,-0.21576f,-0.065241f,-0.885223f,-0.460569f,-0.0652402f,-0.735856f,-0.673988f,-0.0652435f,-0.536342f,-0.841475f,-0.0652436f,-0.996584f,0.0261525f,-0.0783305f,-0.864268f,0.498774f,-0.0653039f,-0.963912f,0.258087f,-0.0653026f,0.258443f,0.963817f,0.0653037f,0.215762f,-0.974264f,-0.065243f,-0.0437486f,-0.99691f,-0.0652429f,-0.300277f,-0.951618f,-0.0652431f,-0.841474f,-0.536343f,0.065242f,-0.951619f,-0.300276f,0.0652401f,-0.998258f,-0.0186847f,0.0559635f,0.493516f,0.774729f,-0.395267f,0.568005f,0.685769f,-0.455072f,0.536593f,0.787162f,-0.304046f,0.587983f,0.772474f,-0.239918f,0.628672f,0.759043f,-0.169191f,0.635149f,0.768828f,-0.0740914f,0.635149f,0.768828f,0.0740914f,0.649461f,0.760395f,0.0f,0.628672f,0.759043f,0.169191f,0.587983f,0.772474f,0.239918f,0.536593f,0.787162f,0.304046f,0.493516f,0.774729f,0.395267f,0.568005f,0.685769f,0.455072f,0.646442f,0.560065f,0.518113f,0.718418f,0.389905f,0.576064f,0.754101f,0.255976f,0.60482f,0.78308f,0.098834f,0.614017f,0.76931f,-0.0988341f,0.631184f,0.754101f,-0.255976f,0.60482f,0.718418f,-0.389905f,0.576064f,0.646442f,-0.560065f,0.518113f,-0.481681f,0.837245f,0.258851f,-0.498774f,0.864269f,0.0653034f,-0.705468f,0.705727f,0.0653046f,-0.864084f,0.499094f,0.0653028f,-0.963817f,0.258444f,0.0653035f,0.000183446f,0.997865f,0.0653045f,-0.258086f,0.963912f,0.0653027f,0.568005f,-0.685769f,0.455072f,0.628081f,-0.675638f,0.386042f,0.69253f,-0.6637f,0.282674f,0.587983f,-0.772474f,0.239918f,0.628672f,-0.759043f,0.169191f,0.635149f,-0.768828f,0.0740914f,0.504345f,-0.861542f,0.0581485f,0.544651f,-0.838663f,0.0f,0.504345f,-0.861542f,-0.0581485f,0.635149f,-0.768828f,-0.0740914f,0.628672f,-0.759043f,-0.169191f,0.587983f,-0.772474f,-0.239918f,0.69253f,-0.6637f,-0.282674f,0.628081f,-0.675638f,-0.386042f,0.568005f,-0.685769f,-0.455072f,0.791174f,-0.414677f,-0.449541f,0.834391f,-0.237413f,-0.497421f,0.854719f,-0.0669789f,-0.514751f,0.869258f,0.0669789f,-0.489801f,0.834391f,0.237413f,-0.497421f,0.791174f,0.414677f,-0.449541f,0.721763f,-0.559812f,-0.407025f,0.628081f,0.675638f,-0.386042f,0.721763f,0.559812f,-0.407025f,0.69253f,0.6637f,-0.282674f,0.730465f,0.65595f,-0.190133f,0.759144f,0.642757f,-0.102779f,0.743119f,0.66916f,0.0f,0.759144f,0.642757f,0.102779f,0.730465f,0.65595f,0.190133f,0.69253f,0.6637f,0.282674f,0.628081f,0.675638f,0.386042f,0.721763f,0.559812f,0.407025f,0.791174f,0.414677f,0.449541f,0.834391f,0.237413f,0.497421f,0.869258f,0.0669789f,0.489801f,0.854719f,-0.0669789f,0.514751f,0.834391f,-0.237413f,0.497421f,0.791174f,-0.414677f,0.449541f,0.721763f,-0.559812f,0.407025f};
			return value;
		}
		private float[] getNormal_11_29_vector_16()
		{
			float[] value = {0.817645f,-0.53825f,0.204312f,0.730465f,-0.65595f,0.190133f,0.793908f,-0.514388f,0.324213f,0.759144f,-0.642757f,0.102779f,0.743119f,-0.66916f,0.0f,0.649461f,-0.760395f,0.0f,0.759144f,-0.642757f,-0.102779f,0.730465f,-0.65595f,-0.190133f,0.817645f,-0.53825f,-0.204312f,0.793908f,-0.514388f,-0.324213f,0.899212f,-0.25298f,-0.356958f,0.850347f,-0.395319f,-0.347323f,0.913828f,-0.0817652f,-0.397784f,0.92266f,0.081786f,-0.376841f,0.899212f,0.25298f,-0.356958f,0.850347f,0.395319f,-0.347323f,0.793908f,0.514388f,-0.324213f,0.817645f,0.53825f,-0.204312f,0.844839f,0.524167f,-0.107218f,0.852633f,0.52251f,0.0f,0.844839f,0.524167f,0.107218f,0.817645f,0.53825f,0.204312f,0.793908f,0.514388f,0.324213f,0.850347f,0.395319f,0.347323f,0.899212f,0.25298f,0.356958f,0.92266f,0.081786f,0.376841f,0.913828f,-0.0817652f,0.397784f,0.899212f,-0.25298f,0.356958f,0.850347f,-0.395319f,0.347323f,0.844839f,-0.524167f,0.107218f,0.893675f,-0.378304f,0.241312f,0.912707f,-0.39432f,0.107134f,0.852633f,-0.52251f,0.0f,0.844839f,-0.524167f,-0.107218f,0.912707f,-0.39432f,-0.107134f,0.893675f,-0.378304f,-0.241312f,0.940072f,-0.237292f,-0.244861f,0.961261f,-0.0912218f,-0.260106f,0.965974f,0.0912218f,-0.242016f,0.940072f,0.237292f,-0.244861f,0.893675f,0.378304f,-0.241312f,0.912707f,0.39432f,-0.107134f,0.923876f,0.382692f,0.0f,0.912707f,0.39432f,0.107134f,0.893675f,0.378304f,0.241312f,0.940072f,0.237292f,0.244861f,0.965974f,0.0912218f,0.242016f,0.961261f,-0.0912218f,0.260106f,0.940072f,-0.237292f,0.244861f,0.961514f,-0.234702f,0.142848f,0.972365f,-0.233467f,0.0f,0.923876f,-0.382692f,0.0f,0.961514f,-0.234702f,-0.142848f,0.98894f,-0.0786931f,-0.125722f,0.991395f,0.0786756f,-0.104624f,0.961514f,0.234702f,-0.142848f,0.972365f,0.233467f,0.0f,0.961514f,0.234702f,0.142848f,0.991395f,0.0786756f,0.104624f,0.98894f,-0.0786931f,0.125722f,0.998633f,-0.0522767f,0.0f,0.996919f,0.0784413f,0.0f};
			return value;
		}

		/** Large attribute array: IndexedFaceSet coordIndex field, scene-graph level=10, element #28, 11568 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32Object getIndexedFaceSet_10_28_coordIndex()
		{
			MFInt32Object IndexedFaceSet_10_28_coordIndex = new MFInt32Object()/*2.finalize*/
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_1()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_2()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_3()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_4()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_5()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_6()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_7()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_8()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_9()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_10()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_11()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_coordIndex_12()));
			return IndexedFaceSet_10_28_coordIndex;
		}
		/** Large attribute array: IndexedFaceSet normalIndex field, scene-graph level=10, element #28, 11568 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32Object getIndexedFaceSet_10_28_normalIndex()
		{
			MFInt32Object IndexedFaceSet_10_28_normalIndex = new MFInt32Object()/*2.finalize*/
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_1()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_2()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_3()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_4()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_5()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_6()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_7()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_8()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_9()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_10()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_11()))
				.append(new MFInt32Object(getIndexedFaceSet_10_28_normalIndex_12()));
			return IndexedFaceSet_10_28_normalIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=11, element #28, 4326 total numbers made up of 1442 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3fObject getCoordinate_11_28_point()
		{
			MFVec3fObject Coordinate_11_28_point = new MFVec3fObject()/*2.finalize*/
				.append(new MFVec3fObject(getCoordinate_11_28_point_1()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_2()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_3()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_4()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_5()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_6()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_7()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_8()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_9()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_10()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_11()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_12()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_13()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_14()))
				.append(new MFVec3fObject(getCoordinate_11_28_point_15()));
			return Coordinate_11_28_point;
		}
		/** Large attribute array: Normal vector field, scene-graph level=11, element #29, 4686 total numbers made up of 1562 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3fObject getNormal_11_29_vector()
		{
			MFVec3fObject Normal_11_29_vector = new MFVec3fObject()/*2.finalize*/
				.append(new MFVec3fObject(getNormal_11_29_vector_1()))
				.append(new MFVec3fObject(getNormal_11_29_vector_2()))
				.append(new MFVec3fObject(getNormal_11_29_vector_3()))
				.append(new MFVec3fObject(getNormal_11_29_vector_4()))
				.append(new MFVec3fObject(getNormal_11_29_vector_5()))
				.append(new MFVec3fObject(getNormal_11_29_vector_6()))
				.append(new MFVec3fObject(getNormal_11_29_vector_7()))
				.append(new MFVec3fObject(getNormal_11_29_vector_8()))
				.append(new MFVec3fObject(getNormal_11_29_vector_9()))
				.append(new MFVec3fObject(getNormal_11_29_vector_10()))
				.append(new MFVec3fObject(getNormal_11_29_vector_11()))
				.append(new MFVec3fObject(getNormal_11_29_vector_12()))
				.append(new MFVec3fObject(getNormal_11_29_vector_13()))
				.append(new MFVec3fObject(getNormal_11_29_vector_14()))
				.append(new MFVec3fObject(getNormal_11_29_vector_15()))
				.append(new MFVec3fObject(getNormal_11_29_vector_16()));
			return Normal_11_29_vector;
		}

	/** The initialized model object, created within initialize() method. */
	private X3DObject x3dModel;

	/** Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3DObject.html">X3DObject</a>
	 * @return CleatClamp model
	 */
	public X3DObject getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3DObject.html#handleArguments-java.lang.String:A-">X3DObject.handleArguments(args)</a>
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3DObject.html#validationReport--">X3DObject.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        X3DObject thisExampleX3dObject = new CleatClamp().getX3dModel();

		boolean hasArguments = (args != null) && (args.length > 0);
		boolean validate = true; // default
		boolean argumentsLoadNewModel = false;
		String  fileName = new String();

		if (args != null)
		{
			for (String arg : args)
			{
				if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
				{
					validate = true; // making sure
				}
				if (arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_X3D) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_CLASSICVRML) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_X3DB) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_VRML97) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_EXI) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_GZIP) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_ZIP) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_HTML) ||
					arg.toLowerCase().endsWith(X3DObject.FILE_EXTENSION_XHTML))
				{
					argumentsLoadNewModel = true;
					fileName = arg;
				}
			}
		}
		if      (argumentsLoadNewModel)
			System.out.println("WARNING: \"CleatClamp\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
		else if (hasArguments) // if no arguments provided, this method produces usage warning
			thisExampleX3dObject.handleArguments(args);

		if (validate)
		{
			System.out.print("Java program \"CleatClamp\" self-validation test results: ");
			String validationResults = thisExampleX3dObject.validationReport();
			System.out.println(validationResults);
		}
    }
}
